/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsif.jca.screenable;

import com.ibm.connector2.screen.BuildFieldException;
import com.ibm.connector2.screen.FieldProtectedException;
import com.ibm.connector2.screen.FieldTextOverflowException;
import com.ibm.connector2.screen.IFieldAttrInfo;
import com.ibm.connector2.screen.IFieldInfo;
import com.ibm.connector2.screen.ITextAttrInfo;
import com.ibm.connector2.screen.ScreenException;
import com.ibm.wsif.jca.screenable.IFieldRecord;
import java.io.Serializable;

public class FieldRecord
implements IFieldRecord,
IFieldInfo,
Serializable {
    private static String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private static final long serialVersionUID = 5L;
    String text_;
    protected IFieldAttrInfo fieldAttributes_;
    protected ITextAttrInfo textAttributes_;
    protected int maxLength_;
    private String name_;
    protected int fieldPos_;
    private int textColumn_ = -1;
    private int textRow_ = -1;
    private int screenWidth;
    private int screenDepth;
    private int screenSize;
    protected boolean modified;

    protected FieldRecord() {
    }

    public FieldRecord(String string, int n, int n2, int n3, String string2, int n4, IFieldAttrInfo iFieldAttrInfo, ITextAttrInfo iTextAttrInfo) throws BuildFieldException {
        if (string2.length() > n4) {
            throw new BuildFieldException("Text exceeds maximum length");
        }
        this.name_ = string;
        this.fieldPos_ = n;
        this.text_ = string2;
        this.maxLength_ = n4;
        this.fieldAttributes_ = iFieldAttrInfo;
        this.textAttributes_ = iTextAttrInfo;
        this.screenWidth = n3;
        this.screenDepth = n2;
        this.screenSize = n2 * n3;
        this.modified = false;
    }

    public void appendText(String string) throws ScreenException {
        if (this.isProtected()) {
            throw new FieldProtectedException("You cannot modify that field");
        }
        if (string.length() + this.text_.length() > this.maxLength_) {
            throw new FieldTextOverflowException();
        }
        this.text_.concat(string);
        if (this.fieldAttributes_ != null) {
            this.fieldAttributes_.setModified(true);
        } else {
            this.modified = true;
        }
    }

    private void calculateTextRowCol() {
        int n = this.getTextPos();
        this.textColumn_ = n % this.screenWidth + 1;
        this.textRow_ = n / this.screenWidth + 1;
    }

    public Object clone() throws CloneNotSupportedException {
        FieldRecord fieldRecord = (FieldRecord)super.clone();
        if (this.fieldAttributes_ != null) {
            fieldRecord.fieldAttributes_ = (IFieldAttrInfo)this.fieldAttributes_.clone();
        }
        if (this.textAttributes_ != null) {
            fieldRecord.textAttributes_ = (ITextAttrInfo)this.textAttributes_.clone();
        }
        return fieldRecord;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof FieldRecord)) {
            return false;
        }
        FieldRecord fieldRecord = (FieldRecord)object;
        if (this.fieldPos_ != fieldRecord.fieldPos_) {
            return false;
        }
        if (this.textColumn_ != fieldRecord.textColumn_) {
            return false;
        }
        if (this.textRow_ != fieldRecord.textRow_) {
            return false;
        }
        if (this.maxLength_ != fieldRecord.maxLength_) {
            return false;
        }
        if (this.screenWidth != fieldRecord.screenWidth) {
            return false;
        }
        if (this.screenDepth != fieldRecord.screenDepth) {
            return false;
        }
        if (this.screenSize != fieldRecord.screenSize) {
            return false;
        }
        if (this.modified != fieldRecord.modified) {
            return false;
        }
        if (this.name_ == null ^ fieldRecord.name_ == null) {
            return false;
        }
        if (this.name_ != null && !this.name_.equals(fieldRecord.name_)) {
            return false;
        }
        if (this.text_ == null ^ fieldRecord.text_ == null) {
            return false;
        }
        if (this.text_ != null && !this.text_.equals(fieldRecord.text_)) {
            return false;
        }
        if (this.fieldAttributes_ == null ^ fieldRecord.fieldAttributes_ == null) {
            return false;
        }
        if (this.fieldAttributes_ != null && this.fieldAttributes_.equals((Object)fieldRecord.fieldAttributes_)) {
            return false;
        }
        if (this.textAttributes_ == null ^ fieldRecord.textAttributes_ == null) {
            return false;
        }
        return this.textAttributes_ == null || this.textAttributes_.equals((Object)fieldRecord.textAttributes_);
    }

    public int getBackGroundColor() {
        if (this.fieldAttributes_ != null) {
            return this.fieldAttributes_.getBackGroundColor();
        }
        return 0;
    }

    public int getForeGroundColor() {
        if (this.fieldAttributes_ != null) {
            return this.fieldAttributes_.getForeGroundColor();
        }
        return 0;
    }

    public int getHighlight() {
        if (this.fieldAttributes_ != null) {
            return this.fieldAttributes_.getHighLight();
        }
        return 0;
    }

    public int getMaxLength() {
        return this.maxLength_;
    }

    public int getMaxTextLength() {
        if (this.hasAttribute()) {
            return this.maxLength_ - 1;
        }
        return this.maxLength_;
    }

    public String getName() {
        return this.name_;
    }

    public int getStartCol() {
        return this.fieldPos_ % this.screenWidth + 1;
    }

    public int getStartPos() {
        return this.fieldPos_;
    }

    public int getStartRow() {
        return this.fieldPos_ / this.screenWidth + 1;
    }

    public String getText() {
        return this.text_;
    }

    public int getTextCol() {
        if (this.textColumn_ == -1) {
            this.calculateTextRowCol();
        }
        return this.textColumn_;
    }

    public char[] getTextColors() {
        return this.textAttributes_.getTextColors();
    }

    public char[] getTextExtAttrs() {
        return this.textAttributes_.getTextExtAttrs();
    }

    public int getTextPos() {
        if (this.hasAttribute()) {
            int n = this.fieldPos_ + 1;
            return n >= this.screenSize ? n - this.screenSize : n;
        }
        return this.fieldPos_;
    }

    public int getTextRow() {
        if (this.textRow_ == -1) {
            this.calculateTextRowCol();
        }
        return this.textRow_;
    }

    public int getTransparency() {
        return this.fieldAttributes_.getTransparency();
    }

    public boolean hasAttribute() {
        return this.fieldAttributes_ != null;
    }

    public boolean isDisplay() {
        if (this.fieldAttributes_ != null) {
            return this.fieldAttributes_.isDisplay();
        }
        return true;
    }

    public boolean isHighIntensity() {
        if (this.fieldAttributes_ != null) {
            return this.fieldAttributes_.isHighIntensity();
        }
        return false;
    }

    public boolean isModified() {
        if (this.fieldAttributes_ != null) {
            return this.fieldAttributes_.isModified();
        }
        return this.modified;
    }

    public boolean isNumeric() {
        if (this.fieldAttributes_ != null) {
            return this.fieldAttributes_.isNumeric();
        }
        return false;
    }

    public boolean isPenDetectable() {
        if (this.fieldAttributes_ != null) {
            return this.fieldAttributes_.isPenDetectable();
        }
        return false;
    }

    public boolean isProtected() {
        if (this.fieldAttributes_ != null) {
            return this.fieldAttributes_.isProtected();
        }
        return false;
    }

    public void setText(String string) throws ScreenException {
        if (this.isProtected()) {
            throw new FieldProtectedException();
        }
        if (string.length() > this.maxLength_) {
            throw new FieldTextOverflowException();
        }
        this.text_ = string;
        if (this.fieldAttributes_ != null) {
            this.fieldAttributes_.setModified(true);
        } else {
            this.modified = true;
        }
    }

    void setTextPriv(String string) throws ScreenException {
        if (string.length() > this.maxLength_) {
            throw new FieldTextOverflowException();
        }
        this.text_ = string;
    }

    protected void updateField(String string, IFieldAttrInfo iFieldAttrInfo, ITextAttrInfo iTextAttrInfo) throws ScreenException {
        if (string.length() > this.maxLength_) {
            throw new FieldTextOverflowException();
        }
        this.text_ = string;
        this.fieldAttributes_ = iFieldAttrInfo;
        this.textAttributes_ = iTextAttrInfo;
    }
}

