/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsif.jca;

import com.ibm.wsif.WSIFException;
import com.ibm.wsif.WSIFOperation;
import com.ibm.wsif.jca.JCAOperation;
import com.ibm.wsif.jca.WSIFDynamicProviderJCAExtensions;
import com.ibm.wsif.logging.Trc;
import com.ibm.wsif.util.WSIFDefaultPort;
import java.util.HashMap;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;

public class WSIFPort_JCA
extends WSIFDefaultPort {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private static final long serialVersionUID = 5L;
    private Connection fieldConnection;
    private Port fieldPort;
    private Definition fieldDefinition;
    private Service fieldService;
    private WSIFDynamicProviderJCAExtensions fieldFactory;
    private static final String crlf = System.getProperty("line.separator");
    protected Map operationInstances = new HashMap();

    public WSIFPort_JCA(Definition definition, Service service, Port port, Connection connection, WSIFDynamicProviderJCAExtensions wSIFDynamicProviderJCAExtensions) {
        this.fieldDefinition = definition;
        this.fieldService = service;
        this.fieldPort = port;
        this.fieldConnection = connection;
        this.fieldFactory = wSIFDynamicProviderJCAExtensions;
    }

    private void addOperation(String string, String string2, String string3, WSIFOperation wSIFOperation) {
        this.operationInstances.put(this.getKey(string, string2, string3), wSIFOperation);
    }

    public WSIFOperation createOperation(String string, String string2, String string3) {
        Trc.entry((Object)string, (Object)string2, (Object)string3, (Object)((Object)this));
        JCAOperation jCAOperation = this.getOperation(string, string2, string3);
        if (jCAOperation == null) {
            jCAOperation = this.fieldFactory.createOperation(this.fieldDefinition, this.fieldPort.getBinding(), string, string2, string3, this.fieldConnection);
            this.addOperation(string, string2, string3, jCAOperation);
        }
        Trc.exit((Object)jCAOperation);
        return jCAOperation;
    }

    public WSIFOperation createOperation(String string) throws WSIFException {
        Trc.entry((Object)string);
        JCAOperation jCAOperation = this.getOperation(string, null, null);
        if (jCAOperation == null) {
            jCAOperation = this.fieldFactory.createOperation(this.fieldDefinition, this.fieldPort.getBinding(), string, null, null, this.fieldConnection);
            this.addOperation(string, null, null, jCAOperation);
        }
        Trc.exit((Object)jCAOperation);
        return jCAOperation;
    }

    public void close() {
        try {
            this.fieldConnection.close();
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
    }

    private JCAOperation getOperation(String string, String string2, String string3) {
        return (JCAOperation)this.operationInstances.get(this.getKey(string, string2, string3));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(crlf + "[WSIFPort_JCA" + crlf);
        try {
            if (this.fieldConnection != null) {
                stringBuffer.append("\tConnection: " + this.fieldConnection.toString() + crlf);
            } else {
                stringBuffer.append("\tConnection: null" + crlf);
            }
            if (this.fieldPort != null) {
                stringBuffer.append("\tPort:       " + this.fieldPort.toString() + crlf);
            } else {
                stringBuffer.append("\tPort:       null" + crlf);
            }
            if (this.fieldDefinition != null) {
                stringBuffer.append("\tDefinition: " + this.fieldDefinition.toString() + crlf);
            } else {
                stringBuffer.append("\tDefinition  null" + crlf);
            }
            if (this.fieldService != null) {
                stringBuffer.append("\tService:    " + this.fieldService.toString() + crlf);
            } else {
                stringBuffer.append("\tService:    null" + crlf);
            }
            if (this.fieldFactory != null) {
                stringBuffer.append("\tFactory:    " + this.fieldFactory.toString() + crlf);
            } else {
                stringBuffer.append("\tFactory:    null" + crlf);
            }
            stringBuffer.append("]" + crlf);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stringBuffer.toString();
    }
}

