/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.xsltypeconverter;

import java.math.BigDecimal;
import java.math.BigInteger;

public class XSLPrimitiveTypeConverter {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2003, 2004 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private static final long serialVersionUID = 5L;
    private static final BigInteger MAX_UNSIGNEDLONG = new BigInteger("18446744073709551615");

    public static String decimal2String(String string) {
        return new BigDecimal(string).toString();
    }

    public static String integer2String(String string) {
        return new BigInteger(string).toString();
    }

    public static String long2String(long l) {
        return Long.toString(l);
    }

    public static String double2String(double d) {
        return Double.toString(d);
    }

    public static String boolean2String(String string) {
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("t") ? "true" : "false";
    }

    public static String string2Decimal(String string) {
        return new BigDecimal(string).toString();
    }

    public static String integer2Decimal(String string) {
        return new BigInteger(string).toString();
    }

    public static String boolean2Decimal(String string) {
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("t") ? "1" : "0";
    }

    public static String double2Decimal(double d) {
        return new BigDecimal(d).toString();
    }

    public static String string2Integer(String string) {
        return new BigInteger(string).toString();
    }

    public static String decimal2Integer(String string) {
        return new BigDecimal(string).toBigInteger().toString();
    }

    public static String double2Integer(double d) {
        return new BigDecimal(d).toBigInteger().toString();
    }

    public static String string2NonPositiveInteger(String string) {
        BigInteger bigInteger = new BigDecimal(string).toBigInteger();
        if (bigInteger.signum() > 0) {
            throw new RuntimeException("string2NonPositiveInteger: invalid non-positive integer: " + string);
        }
        return bigInteger.toString();
    }

    public static String string2NegativeInteger(String string) {
        BigInteger bigInteger = new BigDecimal(string).toBigInteger();
        if (bigInteger.signum() >= 0) {
            throw new RuntimeException("string2NegativeInteger: invalid negative integer: " + string);
        }
        return bigInteger.toString();
    }

    public static String string2NonNegativeInteger(String string) {
        BigInteger bigInteger = new BigDecimal(string).toBigInteger();
        if (bigInteger.signum() < 0) {
            throw new RuntimeException("string2NonNegativeInteger: invalid non-negative integer: " + string);
        }
        return bigInteger.toString();
    }

    public static String string2PositiveInteger(String string) {
        BigInteger bigInteger = new BigDecimal(string).toBigInteger();
        if (bigInteger.signum() <= 0) {
            throw new RuntimeException("string2PositiveInteger: invalid positive integer: " + string);
        }
        return bigInteger.toString();
    }

    public static long string2Long(String string) {
        try {
            return new BigDecimal(string).longValue();
        }
        catch (Exception exception) {
            throw new RuntimeException("string2Long: invalid long: " + string);
        }
    }

    public static long boolean2Long(String string) {
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("t") ? 1L : 0L;
    }

    public static int string2Int(String string) {
        try {
            return new BigDecimal(string).intValue();
        }
        catch (Exception exception) {
            throw new RuntimeException("string2Int: invalid int: " + string);
        }
    }

    public static short string2Short(String string) {
        try {
            return new BigDecimal(string).shortValue();
        }
        catch (Exception exception) {
            throw new RuntimeException("string2Short: invalid short: " + string);
        }
    }

    public static byte string2Byte(String string) {
        try {
            return new BigDecimal(string).byteValue();
        }
        catch (Exception exception) {
            throw new RuntimeException("string2Byte: invalid byte: " + string);
        }
    }

    public static String string2UnsignedLong(String string) {
        BigInteger bigInteger = new BigDecimal(string).toBigInteger();
        if (bigInteger.signum() <= 0) {
            throw new RuntimeException("string2UnsignedLong: invalid unsigned long: " + string);
        }
        if (bigInteger.compareTo(MAX_UNSIGNEDLONG) > 0) {
            throw new RuntimeException("string2UnsignedLong: unsigned long too big: " + string);
        }
        return bigInteger.toString();
    }

    public static long string2UnsignedInt(String string) {
        long l;
        try {
            l = new BigDecimal(string).longValue();
        }
        catch (Exception exception) {
            throw new RuntimeException("string2UnsignedInt: invalid unsigned int: " + string);
        }
        if (l < 0L) {
            throw new RuntimeException("string2UnsignedInt: invalid unsigned int: " + string);
        }
        if (l > 0xFFFFFFFFL) {
            throw new RuntimeException("string2UnsignedInt: unsigned int too big: " + string);
        }
        return l;
    }

    public static long string2UnsignedShort(String string) {
        long l;
        try {
            l = new BigDecimal(string).longValue();
        }
        catch (Exception exception) {
            throw new RuntimeException("string2UnsignedShort: invalid unsigned short: " + string);
        }
        if (l < 0L) {
            throw new RuntimeException("string2UnsignedShort: invalid unsigned short: " + string);
        }
        if (l > 65535L) {
            throw new RuntimeException("string2UnsignedShort: unsigned short too big: " + string);
        }
        return l;
    }

    public static long string2UnsignedByte(String string) {
        long l;
        try {
            l = new BigDecimal(string).longValue();
        }
        catch (Exception exception) {
            throw new RuntimeException("string2UnsignedByte: invalid unsigned byte: " + string);
        }
        if (l < 0L) {
            throw new RuntimeException("string2UnsignedByte: invalid unsigned byte: " + string);
        }
        if (l > 255L) {
            throw new RuntimeException("string2UnsignedByte: unsigned byte too big: " + string);
        }
        return l;
    }

    public static double string2Double(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            throw new RuntimeException("string2Double: invalid unsigned double: " + string);
        }
    }

    public static float string2Float(String string) {
        try {
            return Float.parseFloat(string);
        }
        catch (Exception exception) {
            throw new RuntimeException("string2Float: invalid unsigned float: " + string);
        }
    }

    public static boolean string2Boolean(String string) {
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("t");
    }

    public static boolean decimal2Boolean(String string) {
        BigDecimal bigDecimal = new BigDecimal(string);
        return bigDecimal.signum() != 0;
    }

    public static boolean integer2Boolean(String string) {
        BigInteger bigInteger = new BigDecimal(string).toBigInteger();
        return bigInteger.signum() != 0;
    }

    public static boolean long2Boolean(long l) {
        return l != 0L;
    }
}

