/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.Border;
import sun.plugin.panel.ActivatorSubPanel;
import sun.plugin.panel.ConfigurationInfo;
import sun.plugin.panel.MessageHandler;
import sun.plugin.util.DialogFactory;
import sun.plugin.util.JTextLabel;

public class BrowserPanel
extends ActivatorSubPanel
implements ActionListener {
    private static MessageHandler mh = new MessageHandler("browser");
    JCheckBox iexplorerCheckBox = new JCheckBox(mh.getMessage("ie.text"));
    JCheckBox netscape6CheckBox = new JCheckBox(mh.getMessage("ns6.text"));
    JCheckBox mozillaCheckBox = new JCheckBox(mh.getMessage("moz.text"));

    public BrowserPanel(ConfigurationInfo configurationInfo) {
        super(configurationInfo);
        this.setLayout(new BoxLayout(this, 1));
        Border border = BorderFactory.createEtchedBorder();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createTitledBorder(border, mh.getMessage("settings"))));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 30, 4, 30));
        jPanel2.add(Box.createRigidArea(new Dimension(1, 5)));
        JTextLabel jTextLabel = new JTextLabel(jPanel2, mh.getMessage("desc.text"));
        jTextLabel.setAlignmentX(0.0f);
        jPanel2.add(jTextLabel);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 15)));
        jPanel2.add(this.iexplorerCheckBox);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 5)));
        jPanel2.add(this.netscape6CheckBox);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 5)));
        jPanel2.add(this.mozillaCheckBox);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 5)));
        this.iexplorerCheckBox.addActionListener(this);
        this.netscape6CheckBox.addActionListener(this);
        this.mozillaCheckBox.addActionListener(this);
        jPanel2.add(Box.createRigidArea(new Dimension(1, 40)));
        jPanel2.add(Box.createGlue());
        jPanel.add(jPanel2);
        this.add(jPanel);
        this.reset();
    }

    public void reset() {
        this.iexplorerCheckBox.setSelected(this.model.isIExplorerDefault());
        this.netscape6CheckBox.setSelected(this.model.isNetscape6Default());
        this.mozillaCheckBox.setSelected(this.model.isMozillaDefault());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.iexplorerCheckBox) {
            this.model.setIExplorerDefault(this.iexplorerCheckBox.isSelected());
        }
        if (actionEvent.getSource() == this.netscape6CheckBox) {
            this.model.setNetscape6Default(this.netscape6CheckBox.isSelected());
        }
        if (actionEvent.getSource() == this.mozillaCheckBox) {
            this.model.setMozillaDefault(this.mozillaCheckBox.isSelected());
        }
    }

    private static void showIExplorerErrorDialog() {
        DialogFactory.showErrorDialog(mh.getMessage("settings.fail.ie.text"), mh.getMessage("settings.fail.caption"));
    }

    private static void showNetscape6ErrorDialog() {
        DialogFactory.showErrorDialog(mh.getMessage("settings.fail.ns6.text"), mh.getMessage("settings.fail.caption"));
    }

    private static void showMozillaErrorDialog() {
        DialogFactory.showErrorDialog(mh.getMessage("settings.fail.moz.text"), mh.getMessage("settings.fail.caption"));
    }

    private static void showSuccessDialog() {
        DialogFactory.showInformationDialog(mh.getMessage("settings.success.text"), mh.getMessage("settings.success.caption"));
    }

    private static boolean showAlertDialog() {
        int n = DialogFactory.showConfirmDialog(mh.getMessage("settings.alert.text"));
        return n == 0;
    }
}

