/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import sun.plugin.panel.ActivatorSubPanel;
import sun.plugin.panel.ConfigurationInfo;
import sun.plugin.panel.MessageHandler;
import sun.plugin.util.DialogFactory;

public class AdvancedPanel
extends ActivatorSubPanel
implements ItemListener,
KeyListener,
ActionListener,
DocumentListener {
    private static boolean hideJITBox;
    private MessageHandler mh = new MessageHandler("advanced");
    private JCheckBox jitButton;
    private JTextField javaParms;
    private JTextField jdkPath;
    private JComboBox jdkInstalled;
    private final String otherJDK = this.mh.getMessage("other_jdk");
    private final String defaultJRE = this.mh.getMessage("default_jdk");
    private JLabel pathLabel;
    private int jreNb;
    private int jdkNb;

    AdvancedPanel(ConfigurationInfo configurationInfo) {
        super(configurationInfo);
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        Border border = BorderFactory.createEtchedBorder();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createTitledBorder(border, this.mh.getMessage("jre_name"))));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.add(jPanel2);
        this.jdkInstalled = new JComboBox();
        this.jdkInstalled.setMaximumRowCount(3);
        this.jdkInstalled.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Object object;
                if (itemEvent.getStateChange() == 1 && (object = AdvancedPanel.this.jdkInstalled.getSelectedItem()) != null) {
                    AdvancedPanel.this.jdkInstalled.getAccessibleContext().setAccessibleName(object.toString());
                }
            }
        });
        this.jdkInstalled.getAccessibleContext().setAccessibleDescription(this.mh.getMessage("jre_name"));
        jPanel2.add(Box.createGlue());
        if (this.setInstalledJavaList()) {
            this.jdkInstalled.addItemListener(this);
            this.jdkInstalled.addActionListener(this);
            jPanel2.add(this.jdkInstalled);
        }
        jPanel2.add(Box.createGlue());
        this.add(jPanel);
        this.add(Box.createGlue());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(3, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(15, 8, 4, 4));
        jPanel3.add(Box.createGlue());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        this.pathLabel = new JLabel(this.mh.getMessage("path"));
        jPanel4.add(this.pathLabel);
        this.jdkPath = new JTextField();
        this.pathLabel.setLabelFor(this.jdkPath);
        this.jdkPath.setEnabled(false);
        this.jdkPath.getDocument().addDocumentListener(this);
        jPanel4.add(this.jdkPath);
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createGlue());
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jPanel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        this.jitButton = new JCheckBox(this.mh.getMessage("enable_jit"));
        this.jitButton.addActionListener(this);
        jPanel5.add(this.jitButton);
        jPanel5.add(Box.createGlue());
        this.add(jPanel5);
        this.add(Box.createGlue());
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        GridLayout gridLayout = new GridLayout(2, 1);
        jPanel6.setLayout(gridLayout);
        JLabel jLabel = new JLabel(this.mh.getMessage("java_parms"), 2);
        jPanel6.add(jLabel);
        this.javaParms = new JTextField();
        jLabel.setLabelFor(this.javaParms);
        jPanel6.add(this.javaParms);
        this.javaParms.addKeyListener(this);
        this.add(jPanel6);
    }

    public void setJavaParmsText() {
        this.javaParms.setText(this.model.getJavaParms());
        this.reset();
    }

    private boolean setInstalledJavaList() {
        Object[] objectArray;
        String string;
        if (this.jdkInstalled.getItemCount() > 0) {
            this.jdkInstalled.removeAllItems();
        }
        this.jdkInstalled.addItem(this.defaultJRE);
        String[][] stringArray = this.model.getInstalledJREList();
        this.jreNb = stringArray == null ? 0 : stringArray.length;
        for (int i = 0; i < this.jreNb; ++i) {
            String string2 = stringArray[i][0];
            string = stringArray[i][1];
            if (string2 == null || string == null) continue;
            objectArray = new Object[]{string2, string};
            this.jdkInstalled.addItem(MessageFormat.format(this.mh.getMessage("jre_format"), objectArray));
        }
        String[][] stringArray2 = this.model.getInstalledJDKList();
        this.jdkNb = stringArray2 == null ? 0 : stringArray2.length;
        for (int i = 0; i < this.jdkNb; ++i) {
            string = stringArray2[i][0];
            objectArray = stringArray2[i][1];
            if (string == null || objectArray == null) continue;
            Object[] objectArray2 = new Object[]{string, objectArray};
            this.jdkInstalled.addItem(MessageFormat.format(this.mh.getMessage("jdk_format"), objectArray2));
        }
        this.jdkInstalled.addItem(this.otherJDK);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (actionEvent.getSource() == this.jitButton) {
            boolean bl = this.jitButton.isSelected();
            this.model.setJITEnabled(bl);
        } else if (actionEvent.getSource() == this.jdkInstalled && (n = this.jdkInstalled.getSelectedIndex()) == this.jdkInstalled.getItemCount() - 1 && (this.jdkPath.getText() == null || this.jdkPath.getText().length() < 1)) {
            this.selectedOther();
            this.reset();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.jdkInstalled && itemEvent.getStateChange() == 1) {
            String[][] stringArray;
            int n = this.jdkInstalled.getSelectedIndex();
            if (n == 0) {
                this.model.setJavaRuntimeType("Default");
                this.model.setJavaRuntimeVersion(null);
                this.jdkPath.setText("");
            }
            if (n > 0 && n <= this.jreNb) {
                this.model.setJavaRuntimeType("JRE");
                stringArray = this.model.getInstalledJREList();
                this.model.setJavaRuntimeVersion(stringArray[n - 1][0]);
                this.jdkPath.setText("");
            }
            if (n > this.jreNb && n <= this.jreNb + this.jdkNb) {
                this.model.setJavaRuntimeType("JDK");
                stringArray = this.model.getInstalledJDKList();
                this.model.setJavaRuntimeVersion(stringArray[n - this.jreNb - 1][0]);
                this.jdkPath.setText("");
            }
            if (n == this.jdkInstalled.getItemCount() - 1) {
                return;
            }
            this.reset();
        }
    }

    private void selectedOther() {
        Object[] objectArray = new Object[]{this.mh.getMessage("OK"), this.mh.getMessage("Cancel")};
        int n = DialogFactory.showOptionDialog(this.mh.getMessage("jre_selection_warning.info"), this.mh.getMessage("Warning"), objectArray, objectArray[0]);
        if (n == 0) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            boolean bl = false;
            while (!bl) {
                int n2 = jFileChooser.showOpenDialog(this);
                if (n2 == 0) {
                    if (jFileChooser.getSelectedFile().isDirectory()) {
                        this.jdkPath.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                        this.jdkPath.setEnabled(true);
                        this.model.setJavaRuntimeType(this.jdkPath.getText());
                        this.jdkInstalled.setSelectedIndex(this.jdkInstalled.getItemCount() - 1);
                        bl = true;
                        continue;
                    }
                    DialogFactory.showErrorDialog(this, this.mh.getMessage("error.text"), this.mh.getMessage("error.caption"));
                    bl = false;
                    continue;
                }
                this.model.setJavaRuntimeType("Default");
                this.jdkInstalled.setSelectedIndex(0);
                bl = true;
            }
        } else {
            this.model.setJavaRuntimeType("Default");
            this.jdkInstalled.setSelectedIndex(0);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.javaParms) {
            this.model.setJavaParms(this.javaParms.getText());
        } else if (keyEvent.getSource() == this.jdkPath) {
            this.model.setJavaRuntimeType(this.jdkPath.getText());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.keyTyped(keyEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void reset() {
        boolean bl = this.model.isJITEnabled();
        this.jitButton.setSelected(bl);
        this.javaParms.setText(this.model.getJavaParms());
        boolean bl2 = true;
        String string = this.model.getJavaRuntimeType();
        this.pathLabel.setEnabled(false);
        this.jdkPath.setEnabled(false);
        try {
            if (string.equalsIgnoreCase("Default")) {
                this.jdkInstalled.setSelectedIndex(0);
            } else if (string.equalsIgnoreCase("JDK")) {
                String[][] stringArray = this.model.getInstalledJDKList();
                String string2 = this.model.getJavaRuntimeVersion();
                int n = 0;
                while (!stringArray[n][0].equalsIgnoreCase(string2)) {
                    ++n;
                }
                this.jdkInstalled.setSelectedIndex(this.jreNb + n + 1);
            } else if (string.equalsIgnoreCase("JRE")) {
                String[][] stringArray = this.model.getInstalledJREList();
                String string3 = this.model.getJavaRuntimeVersion();
                int n = 0;
                while (!stringArray[n][0].equalsIgnoreCase(string3)) {
                    ++n;
                }
                this.jdkInstalled.setSelectedIndex(n + 1);
            } else {
                this.jdkPath.setText(string);
                this.jdkPath.setEnabled(true);
                this.pathLabel.setEnabled(true);
                this.jdkInstalled.setSelectedIndex(this.jdkInstalled.getItemCount() - 1);
            }
        }
        catch (Exception exception) {
            this.jdkInstalled.setSelectedIndex(0);
            this.model.firePropertyChange();
        }
    }

    public static void setHideJITBox(boolean bl) {
        hideJITBox = bl;
    }

    public void setTextSize(int n) {
        this.jdkPath.setMaximumSize(new Dimension(n, 25));
        this.jdkPath.revalidate();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.jdkPath.getText().length() > 1) {
            this.model.setJavaRuntimeType(this.jdkPath.getText());
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.jdkPath.getText().length() > 1) {
            this.model.setJavaRuntimeType(this.jdkPath.getText());
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.jdkPath.getText().length() > 1) {
            this.model.setJavaRuntimeType(this.jdkPath.getText());
        }
    }
}

