/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sun.plugin.panel.ActivatorSubPanel;
import sun.plugin.panel.AdvancedPanel;
import sun.plugin.panel.BasicPanel;
import sun.plugin.panel.BrowserPanel;
import sun.plugin.panel.CachePanel;
import sun.plugin.panel.CertificatePanel;
import sun.plugin.panel.ConfigurationInfo;
import sun.plugin.panel.DefaultPanel;
import sun.plugin.panel.MessageHandler;
import sun.plugin.panel.PlatformDependentInterface;
import sun.plugin.panel.ProxyPanel;
import sun.plugin.util.Trace;

public class ActivatorPanel
extends ActivatorSubPanel
implements ActionListener,
PropertyChangeListener {
    private DefaultPanel defaultPanel;
    private BasicPanel basicPanel;
    private AdvancedPanel advancedPanel;
    private BrowserPanel browserPanel;
    private ProxyPanel proxyPanel;
    private CertificatePanel certPanel;
    private CachePanel cachePanel;
    JButton cancel;
    JButton apply;
    JButton help;
    String currentTab = "";
    boolean showWindowPanels = false;
    private ResourceBundle rb = null;
    String helpFile = "";
    private MessageHandler mh = new MessageHandler("panel");

    ActivatorPanel(ConfigurationInfo configurationInfo) {
        super(configurationInfo);
        PlatformDependentInterface platformDependentInterface = ActivatorPanel.getPlatformObject();
        if (platformDependentInterface != null) {
            platformDependentInterface.onLoad(configurationInfo);
        }
        configurationInfo.addPropertyChangeListener(this);
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.basicPanel = new BasicPanel(configurationInfo);
        jTabbedPane.addTab(this.mh.getMessage("basic"), this.basicPanel);
        this.advancedPanel = new AdvancedPanel(configurationInfo);
        jTabbedPane.addTab(this.mh.getMessage("advanced"), this.advancedPanel);
        if (configurationInfo.isShowBrowserPanel()) {
            this.browserPanel = new BrowserPanel(configurationInfo);
            jTabbedPane.addTab(this.mh.getMessage("browser"), this.browserPanel);
            this.showWindowPanels = true;
        }
        this.proxyPanel = new ProxyPanel(configurationInfo);
        jTabbedPane.addTab(this.mh.getMessage("proxies"), this.proxyPanel);
        this.cachePanel = new CachePanel(configurationInfo);
        jTabbedPane.addTab(this.mh.getMessage("cache"), this.cachePanel);
        this.certPanel = new CertificatePanel(configurationInfo);
        jTabbedPane.addTab(this.mh.getMessage("cert"), this.certPanel);
        this.defaultPanel = new DefaultPanel(configurationInfo);
        jTabbedPane.addTab(this.mh.getMessage("about"), this.defaultPanel);
        this.setLayout(new BorderLayout());
        this.add("Center", jTabbedPane);
        JPanel jPanel = new JPanel();
        this.apply = this.addButton(jPanel, this.mh.getMessage("apply"));
        this.apply.setMnemonic(this.mh.getAcceleratorKey("apply"));
        this.cancel = this.addButton(jPanel, this.mh.getMessage("cancel"));
        this.cancel.setMnemonic(this.mh.getAcceleratorKey("cancel"));
        this.help = this.addButton(jPanel, this.mh.getMessage("help"));
        this.help.setMnemonic(this.mh.getAcceleratorKey("help"));
        this.apply.setEnabled(false);
        this.add("South", jPanel);
        jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                ActivatorPanel.this.currentTab = ActivatorPanel.this.showWindowPanels ? (jTabbedPane.getSelectedIndex() == 0 ? "#basic" : (jTabbedPane.getSelectedIndex() == 1 ? "#advanced" : (jTabbedPane.getSelectedIndex() == 2 ? "#browser" : (jTabbedPane.getSelectedIndex() == 3 ? "#proxies" : (jTabbedPane.getSelectedIndex() == 4 ? "#cache" : (jTabbedPane.getSelectedIndex() == 5 ? "#certificates" : (jTabbedPane.getSelectedIndex() == 6 ? "#update" : ""))))))) : (jTabbedPane.getSelectedIndex() == 0 ? "#basic" : (jTabbedPane.getSelectedIndex() == 1 ? "#advanced" : (jTabbedPane.getSelectedIndex() == 2 ? "#proxies" : (jTabbedPane.getSelectedIndex() == 3 ? "#cache" : (jTabbedPane.getSelectedIndex() == 4 ? "#certificates" : "")))));
            }
        });
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.apply != null) {
            this.apply.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PlatformDependentInterface platformDependentInterface;
        if (actionEvent.getSource() == this.cancel) {
            try {
                this.model.reset();
                platformDependentInterface = ActivatorPanel.getPlatformObject();
                if (platformDependentInterface != null) {
                    platformDependentInterface.onLoad(this.model);
                }
                this.basicPanel.reset();
                this.advancedPanel.reset();
                if (this.browserPanel != null) {
                    this.browserPanel.reset();
                }
                this.proxyPanel.reset();
                this.certPanel.reset();
                this.cachePanel.reset();
                this.apply.setEnabled(false);
            }
            catch (Exception exception) {
                Trace.printException(this, exception);
            }
        }
        if (actionEvent.getSource() == this.apply) {
            try {
                this.model.applyChanges();
                this.apply.setEnabled(false);
                platformDependentInterface = ActivatorPanel.getPlatformObject();
                if (platformDependentInterface != null) {
                    platformDependentInterface.onSave(this.model);
                }
            }
            catch (Exception exception) {
                Trace.printException(this, exception, this.mh.getMessage("apply_failed") + ": " + exception.getMessage(), this.mh.getMessage("apply_failed_title"));
            }
        }
        if (actionEvent.getSource() == this.help) {
            try {
                if (this.help.isEnabled()) {
                    this.help.setEnabled(false);
                    this.showControlPanelHelp();
                }
            }
            catch (Exception exception) {
                Trace.printException(this, exception);
            }
        }
    }

    public ConfigurationInfo getModel() {
        return this.model;
    }

    private JButton addButton(JPanel jPanel, String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        jPanel.add(jButton);
        return jButton;
    }

    public void setAdvancedPanelText() {
        this.advancedPanel.setJavaParmsText();
    }

    public void setCertificatePanelText() {
        this.certPanel.reset();
    }

    public void setAdvancedPanel(int n) {
        this.advancedPanel.setTextSize(n);
    }

    public void showControlPanelHelp() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setFont(new JEditorPane().getFont());
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        try {
            this.rb = ResourceBundle.getBundle("sun.plugin.resources.ControlPanelHelp");
        }
        catch (Exception exception) {
            Trace.printException(this, exception, this.mh.getMessage("help.error.text"), this.mh.getMessage("help.error.caption"));
        }
        Enumeration<String> enumeration = this.rb.getKeys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ++n;
            enumeration.nextElement();
        }
        try {
            if (this.rb != null) {
                this.helpFile = "";
                for (int i = 0; i < n; ++i) {
                    this.helpFile = this.helpFile + this.rb.getString("help.txt" + i) + "\n";
                }
            }
        }
        catch (Exception exception) {
            Trace.printException(this, exception, this.mh.getMessage("help.error.text"), this.mh.getMessage("help.error.caption"));
        }
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.setPreferredSize(new Dimension(700, 500));
        jTextArea.setText(this.helpFile);
        jTextArea.setCaretPosition(0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        JButton jButton = this.addButton(jPanel, this.mh.getMessage("help_close"));
        jButton.setMnemonic(this.mh.getAcceleratorKey("help_close"));
        jPanel.add(jButton);
        final JFrame jFrame = new JFrame(this.mh.getMessage("help_title"));
        jFrame.setDefaultCloseOperation(2);
        jFrame.setResizable(true);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jFrame.dispose();
                ActivatorPanel.this.help.setEnabled(true);
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.dispose();
                ActivatorPanel.this.help.setEnabled(true);
            }
        };
        jButton.addActionListener(actionListener);
        jFrame.getContentPane().add((Component)jScrollPane, "Center");
        jFrame.getContentPane().add((Component)jPanel, "South");
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

