/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import sun.plugin.cache.JarCacheTable;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.util.UserProfile;

public class JarCacheViewer
extends JDialog {
    private JarCacheTable viewerTable;
    private static String cacheLocation;
    private AbstractAction close_key;

    public JarCacheViewer(String string) {
        if (string != null) {
            cacheLocation = string;
        }
        Container container = this.getContentPane();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(5);
        container.setLayout(borderLayout);
        this.setTitle(ResourceHandler.getMessage("cache_viewer.caption"));
        this.setModal(true);
        this.viewerTable = new JarCacheTable();
        JScrollPane jScrollPane = new JScrollPane(this.viewerTable);
        container.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        final JButton jButton = new JButton(ResourceHandler.getMessage("cache_viewer.refresh"));
        JButton jButton2 = new JButton(ResourceHandler.getMessage("cache_viewer.remove"));
        JButton jButton3 = new JButton(ResourceHandler.getMessage("cache_viewer.close"));
        this.close_key = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarCacheViewer.this.setVisible(false);
                JarCacheViewer.this.dispose();
            }
        };
        this.getRootPane().registerKeyboardAction(this.close_key, KeyStroke.getKeyStroke(27, 0), 2);
        jButton.setMnemonic(ResourceHandler.getAcceleratorKey("cache_viewer.refresh"));
        jButton2.setMnemonic(ResourceHandler.getAcceleratorKey("cache_viewer.remove"));
        jButton3.setMnemonic(ResourceHandler.getAcceleratorKey("cache_viewer.close"));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalStrut(30));
        jPanel.add(jButton2);
        jPanel.add(Box.createHorizontalStrut(30));
        jPanel.add(jButton3);
        jPanel.add(Box.createHorizontalGlue());
        container.add((Component)jPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JarCacheViewer.this.dispose();
            }

            public void windowOpened(WindowEvent windowEvent) {
                jButton.requestFocus();
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarCacheViewer.this.viewerTable.refresh();
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarCacheViewer.this.viewerTable.removeRows();
            }
        };
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarCacheViewer.this.dispose();
            }
        };
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(actionListener2);
        jButton3.addActionListener(actionListener3);
        this.getRootPane().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                JarCacheViewer.this.viewerTable.adjustColumnSize((Container)componentEvent.getComponent());
            }
        });
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = new Dimension(dimension.width * 4 / 5, 400);
        jScrollPane.setPreferredSize(dimension2);
        this.pack();
        UIManager.getDefaults().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        7.access$100(this.this$1).pack();
                    }
                });
            }

            static /* synthetic */ JarCacheViewer access$100(7 var0) {
                return var0.JarCacheViewer.this;
            }
        });
        this.setVisible(true);
        jButton.requestFocus();
    }

    public static String getPluginCacheLocation() {
        if (cacheLocation != null) {
            return cacheLocation;
        }
        return UserProfile.getPluginCacheDirectory();
    }

    public static void main(String[] stringArray) {
        JarCacheViewer jarCacheViewer = new JarCacheViewer(stringArray[0]);
    }
}

