/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.util.bidi;

import com.ibm.record.util.bidi.BidiFlag;
import com.ibm.record.util.bidi.BidiText;

class BidiOrder {
    private static final int UBAT_B = 0;
    private static final int UBAT_S = 1;
    private static final int UBAT_L = 2;
    private static final int UBAT_R = 3;
    private static final int UBAT_EN = 4;
    private static final int UBAT_AN = 5;
    private static final int UBAT_ET = 6;
    private static final int UBAT_ES = 7;
    private static final int UBAT_CS = 8;
    private static final int UBAT_W = 9;
    private static final int UBAT_N = 10;
    private static final int UBAT_BD = 11;
    private static final int ITIL = 11;
    private static final int ITCOND = 12;
    private static final char[][] notSpacing = new char[][]{{'\u0300', '\u0385'}, {'\u0483', '\u0486'}, {'\u05b0', '\u05bd'}, {'\u05bf', '\u05bf'}, {'\u05c1', '\u05c2'}, {'\u05f5', '\u05f5'}, {'\u064b', '\u0652'}, {'\u0670', '\u0670'}, {'\u06d6', '\u06e4'}, {'\u06e7', '\u06e8'}, {'\u06ea', '\u06ed'}, {'\u0901', '\u0902'}, {'\u093c', '\u093c'}, {'\u0941', '\u0948'}, {'\u094d', '\u094d'}, {'\u0951', '\u0954'}, {'\u0962', '\u0963'}, {'\u0981', '\u0981'}, {'\u09bc', '\u09bc'}, {'\u09c1', '\u09c4'}, {'\u09cd', '\u09cd'}, {'\u09e2', '\u09e3'}, {'\u0a02', '\u0a02'}, {'\u0a3c', '\u0a3c'}, {'\u0a41', '\u0a4c'}, {'\u0a70', '\u0a71'}, {'\u0a81', '\u0a82'}, {'\u0abc', '\u0abc'}, {'\u0ac1', '\u0ac8'}, {'\u0acd', '\u0acd'}, {'\u0b01', '\u0b01'}, {'\u0b3c', '\u0b3c'}, {'\u0b3f', '\u0b3f'}, {'\u0b41', '\u0b43'}, {'\u0b4d', '\u0b4d'}, {'\u0bc0', '\u0bc0'}, {'\u0bcd', '\u0bcd'}, {'\u0c3e', '\u0c40'}, {'\u0c46', '\u0c56'}, {'\u0cbf', '\u0cbf'}, {'\u0cc6', '\u0cc6'}, {'\u0ccc', '\u0ccd'}, {'\u0d41', '\u0d43'}, {'\u0d4d', '\u0d4d'}, {'\u0e31', '\u0e31'}, {'\u0e34', '\u0e3a'}, {'\u0e47', '\u0e4d'}, {'\u0eb1', '\u0eb1'}, {'\u0eb4', '\u0ebc'}, {'\u0ec8', '\u0ecd'}, {'\u1026', '\u102a'}, {'\u102e', '\u102e'}, {'\u1030', '\u1030'}, {'\u1036', '\u1037'}, {'\u103b', '\u103b'}, {'\u103d', '\u103e'}, {'\u104b', '\u104c'}, {'\u20d0', '\u20ff'}, {'\u302a', '\u302f'}, {'\u3099', '\u309a'}};
    private static final char[][] symPairs = new char[][]{{'(', ')'}, {')', '('}, {'<', '>'}, {'>', '<'}, {'[', ']'}, {']', '['}, {'{', '}'}, {'}', '{'}, {'\u00ab', '\u00bb'}, {'\u00bb', '\u00ab'}, {'\u207d', '\u207e'}, {'\u207e', '\u207d'}, {'\u208d', '\u208e'}, {'\u208e', '\u208d'}, {'\u2329', '\u232a'}, {'\u232a', '\u2329'}, {'\ufe59', '\ufe5a'}, {'\ufe5a', '\ufe59'}, {'\ufe5b', '\ufe5c'}, {'\ufe5c', '\ufe5b'}, {'\ufe5d', '\ufe5e'}, {'\ufe5e', '\ufe5d'}, {'\ufe64', '\ufe65'}, {'\ufe65', '\ufe64'}};
    private static final short[][] impTab;
    int ucb_ix;
    int ucb_outLev;
    int ucb_basLev;
    int ucb_curLev;
    int ucb_impLev;
    int ucb_impSta;
    int ucb_araLet;
    int ucb_lineSepPos;
    int ucb_condPos;
    int ucb_Compac;
    int ucb_Shaping;
    int ucb_xType;
    int ucb_wTarget;
    int ucb_pType;
    BidiFlag ics_num_flag;
    int ics_formShp;
    boolean ics_symmetric;
    BidiFlag ics_orient_in;
    BidiFlag ics_orient_out;
    BidiFlag ics_type_in;
    BidiFlag ics_type_out;
    BidiFlag ics_txtShp_flag;
    int ics_boc_flag;
    int ics_size;
    int ics_size_out;
    int ics_orient;
    int ics_wordbreak;
    int ics_flip_flag;
    int ics_num;
    boolean ics_compc;
    char[] ics_buffer_in;
    char[] ics_buffer_out;
    byte[] ics_A_level;
    int[] ics_SrcToTrgMap;
    int[] ics_TrgToSrcMap;
    boolean notImpToImp;
    boolean visToVis;

    static {
        short[][] sArrayArray = new short[19][];
        short[] sArray = new short[13];
        sArray[3] = 3;
        sArray[5] = 1;
        sArrayArray[0] = sArray;
        short[] sArray2 = new short[13];
        sArray2[3] = 3;
        sArray2[5] = 1;
        sArray2[6] = 4;
        sArray2[7] = 4;
        sArray2[8] = 2;
        sArray2[9] = 4;
        sArray2[10] = 4;
        sArray2[11] = 2;
        sArrayArray[1] = sArray2;
        short[] sArray3 = new short[13];
        sArray3[3] = 3;
        sArray3[5] = 1;
        sArray3[6] = 4;
        sArray3[7] = 4;
        sArray3[8] = 4;
        sArray3[9] = 4;
        sArray3[10] = 4;
        sArray3[11] = 2;
        sArray3[12] = 1;
        sArrayArray[2] = sArray3;
        short[] sArray4 = new short[13];
        sArray4[3] = 3;
        sArray4[4] = 6;
        sArray4[5] = 1;
        sArray4[6] = 5;
        sArray4[7] = 4;
        sArray4[8] = 4;
        sArray4[9] = 4;
        sArray4[10] = 4;
        sArray4[11] = 1;
        sArrayArray[3] = sArray4;
        short[] sArray5 = new short[13];
        sArray5[3] = 3;
        sArray5[4] = 102;
        sArray5[5] = 97;
        sArray5[6] = 5;
        sArray5[7] = 4;
        sArray5[8] = 4;
        sArray5[9] = 4;
        sArray5[10] = 4;
        sArray5[11] = 1;
        sArray5[12] = 1;
        sArrayArray[4] = sArray5;
        short[] sArray6 = new short[13];
        sArray6[3] = 3;
        sArray6[4] = 102;
        sArray6[5] = 65;
        sArray6[6] = 5;
        sArray6[7] = 4;
        sArray6[8] = 4;
        sArray6[9] = 4;
        sArray6[10] = 4;
        sArray6[11] = 1;
        sArray6[12] = 1;
        sArrayArray[5] = sArray6;
        short[] sArray7 = new short[13];
        sArray7[3] = 3;
        sArray7[4] = 6;
        sArray7[5] = 1;
        sArray7[6] = 8;
        sArray7[7] = 7;
        sArray7[8] = 7;
        sArray7[9] = 4;
        sArray7[10] = 4;
        sArray7[11] = 2;
        sArrayArray[6] = sArray7;
        short[] sArray8 = new short[13];
        sArray8[3] = 3;
        sArray8[4] = 6;
        sArray8[5] = 65;
        sArray8[6] = 5;
        sArray8[7] = 4;
        sArray8[8] = 4;
        sArray8[9] = 4;
        sArray8[10] = 4;
        sArray8[11] = 2;
        sArray8[12] = 1;
        sArrayArray[7] = sArray8;
        short[] sArray9 = new short[13];
        sArray9[3] = 3;
        sArray9[4] = 6;
        sArray9[5] = 1;
        sArray9[6] = 5;
        sArray9[7] = 4;
        sArray9[8] = 4;
        sArray9[9] = 4;
        sArray9[10] = 4;
        sArray9[11] = 2;
        sArrayArray[8] = sArray9;
        short[] sArray10 = new short[13];
        sArray10[0] = 9;
        sArray10[1] = 9;
        sArray10[2] = 16;
        sArray10[3] = 9;
        sArray10[4] = 11;
        sArray10[5] = 14;
        sArray10[6] = 10;
        sArray10[7] = 9;
        sArray10[8] = 9;
        sArray10[9] = 9;
        sArray10[10] = 9;
        sArrayArray[9] = sArray10;
        short[] sArray11 = new short[13];
        sArray11[0] = 9;
        sArray11[1] = 9;
        sArray11[2] = 176;
        sArray11[3] = 9;
        sArray11[4] = 11;
        sArray11[5] = 174;
        sArray11[6] = 138;
        sArray11[7] = 9;
        sArray11[8] = 9;
        sArray11[9] = 9;
        sArray11[10] = 9;
        sArray11[12] = 1;
        sArrayArray[10] = sArray11;
        short[] sArray12 = new short[13];
        sArray12[0] = 9;
        sArray12[1] = 9;
        sArray12[2] = 16;
        sArray12[3] = 9;
        sArray12[4] = 11;
        sArray12[5] = 14;
        sArray12[6] = 13;
        sArray12[7] = 12;
        sArray12[8] = 12;
        sArray12[9] = 9;
        sArray12[10] = 9;
        sArray12[11] = 1;
        sArrayArray[11] = sArray12;
        sArrayArray[12] = new short[]{9, 9, 48, 9, 11, 46, 42, 9, 9, 9, 9, 1, 1};
        short[] sArray13 = new short[13];
        sArray13[0] = 9;
        sArray13[1] = 9;
        sArray13[2] = 16;
        sArray13[3] = 9;
        sArray13[4] = 11;
        sArray13[5] = 14;
        sArray13[6] = 10;
        sArray13[7] = 9;
        sArray13[8] = 9;
        sArray13[9] = 9;
        sArray13[10] = 9;
        sArray13[11] = 1;
        sArrayArray[13] = sArray13;
        short[] sArray14 = new short[13];
        sArray14[0] = 9;
        sArray14[1] = 9;
        sArray14[2] = 16;
        sArray14[3] = 9;
        sArray14[4] = 11;
        sArray14[5] = 14;
        sArray14[6] = 10;
        sArray14[7] = 9;
        sArray14[8] = 15;
        sArray14[9] = 9;
        sArray14[10] = 9;
        sArray14[11] = 1;
        sArrayArray[14] = sArray14;
        sArrayArray[15] = new short[]{9, 9, 48, 9, 43, 14, 42, 9, 9, 9, 9, 1, 1};
        short[] sArray15 = new short[13];
        sArray15[0] = 9;
        sArray15[1] = 9;
        sArray15[2] = 16;
        sArray15[3] = 9;
        sArray15[4] = 18;
        sArray15[5] = 14;
        sArray15[6] = 17;
        sArray15[7] = 17;
        sArray15[8] = 17;
        sArray15[9] = 17;
        sArray15[10] = 17;
        sArray15[11] = 1;
        sArrayArray[16] = sArray15;
        sArrayArray[17] = new short[]{9, 9, 16, 9, 18, 46, 17, 17, 17, 17, 17, 1, 1};
        short[] sArray16 = new short[13];
        sArray16[0] = 9;
        sArray16[1] = 9;
        sArray16[2] = 16;
        sArray16[3] = 9;
        sArray16[4] = 18;
        sArray16[5] = 14;
        sArray16[6] = 16;
        sArray16[7] = 17;
        sArray16[8] = 17;
        sArray16[9] = 17;
        sArray16[10] = 17;
        sArray16[11] = 1;
        sArrayArray[18] = sArray16;
        impTab = sArrayArray;
    }

    BidiOrder() {
    }

    private void BaseLvl() {
        int type1;
        if (this.ics_orient_in == BidiFlag.ORIENTATION_CONTEXT_LTR || this.ics_orient_in == BidiFlag.ORIENTATION_CONTEXT_RTL) {
            type1 = this.firstStrong(this.ics_buffer_in, this.ics_size);
            switch (type1) {
                case 2: {
                    this.ics_orient_in = BidiFlag.ORIENTATION_LTR;
                    break;
                }
                case 3: {
                    this.ics_orient_in = BidiFlag.ORIENTATION_RTL;
                    break;
                }
                case 10: {
                    this.ics_orient_in = this.ics_orient_in == BidiFlag.ORIENTATION_CONTEXT_RTL ? BidiFlag.ORIENTATION_RTL : BidiFlag.ORIENTATION_LTR;
                }
            }
        }
        if (this.ics_orient_out == BidiFlag.ORIENTATION_CONTEXT_LTR || this.ics_orient_out == BidiFlag.ORIENTATION_CONTEXT_RTL) {
            type1 = this.firstStrong(this.ics_buffer_in, this.ics_size);
            switch (type1) {
                case 2: {
                    type1 = this.lastStrong(this.ics_buffer_in, this.ics_size);
                    if (type1 == 3) {
                        this.ics_orient_out = BidiFlag.ORIENTATION_RTL;
                        break;
                    }
                    this.ics_orient_out = BidiFlag.ORIENTATION_LTR;
                    break;
                }
                case 3: {
                    this.ics_orient_out = BidiFlag.ORIENTATION_RTL;
                    break;
                }
                case 10: {
                    this.ics_orient_out = this.ics_orient_out == BidiFlag.ORIENTATION_CONTEXT_RTL ? BidiFlag.ORIENTATION_RTL : BidiFlag.ORIENTATION_LTR;
                }
            }
        }
        this.visToVis = false;
        if (this.ics_type_in == BidiFlag.TYPE_VISUAL && this.ics_type_out == BidiFlag.TYPE_IMPLICIT) {
            this.ucb_basLev = this.ics_orient_out == BidiFlag.ORIENTATION_RTL ? 1 : 0;
            this.ucb_outLev = 0;
            this.ucb_curLev = this.ucb_basLev;
            if (this.ucb_basLev == 0) {
                this.ucb_curLev = 2;
            }
        } else {
            this.ucb_basLev = this.ics_orient_in == BidiFlag.ORIENTATION_RTL ? 1 : 0;
            this.ucb_outLev = this.ics_orient_out == BidiFlag.ORIENTATION_RTL ? 1 : 0;
            this.ucb_curLev = this.ucb_basLev;
            if (this.ucb_basLev == 0 && this.ucb_outLev == 1) {
                this.ucb_curLev = 2;
            }
            if (this.ics_type_in == BidiFlag.TYPE_VISUAL) {
                this.visToVis = true;
            }
        }
        this.ucb_lineSepPos = -1;
        this.ucb_impSta = (this.ucb_curLev & 1) * 9;
        this.ucb_impLev = 0;
        this.ucb_condPos = -1;
    }

    private static boolean even(int n) {
        return (n & 1) == 0;
    }

    private int firstStrong(char[] data, int length) {
        int i = 0;
        while (i < length) {
            int type = this.getChType(data[i]);
            if (type == 2 || type == 3) {
                return type;
            }
            ++i;
        }
        return 10;
    }

    private int getChType(char x) {
        if (x == '\u2029') {
            return 0;
        }
        if (x == '\t') {
            return 1;
        }
        if (x > '@' && x <= 'Z' || x >= 'a' && x <= 'z' || x >= '\u00c0' && x <= '\u00d6' || x >= '\u00d8' && x <= '\u00f6' || x >= '\u00f8' && x <= '\u058f' || x >= '\u0900' && x <= '\u10ff' || x == '\u200e' || x >= '\u20d0' && x <= '\u20ff' || x >= '\u2160' && x <= '\u2182' || x >= '\u3040' && x <= '\u9fff' || x >= '\uf900' && x <= '\ufb17' || x == '\ufe60' || x == '\ufe6b' || x == '\uff06' || x >= '\uff20' && x <= '\uff3a' || x >= '\uff41' && x <= '\uff5a' || x >= '\uff60' && x <= '\uffdf') {
            return 2;
        }
        if (x >= '\u05d0' && x <= '\u065f' || x >= '\u066e' && x <= '\u06ef' || x >= '\u06fa' && x >= '\u08ff' || x == '\u200f' || x >= '\ufb20' && x <= '\ufdff' || x >= '\ufe70' && x <= '\ufefc') {
            return 3;
        }
        if (x >= '0' && x <= '9' || x >= '\u00b2' && x <= '\u00b3' || x == '\u00b9' || x >= '\u00bc' && x <= '\u00be' || x == '\u2070' || x >= '\u2074' && x <= '\u2079' || x >= '\u2080' && x <= '\u2089' || x >= '\u2153' && x <= '\u2182' || x >= '\uff10' && x <= '\uff19') {
            return 4;
        }
        if (x >= '\u0660' && x <= '\u0669' || x >= '\u066b' && x <= '\u066c' || x >= '\u06f0' && x <= '\u06f9') {
            return 5;
        }
        if (x >= '#' && x <= '%' || x == '+' || x == '-' || x >= '\u00a2' && x <= '\u00a5' || x >= '\u00b0' && x <= '\u00b1' || x == '\u066a' || x >= '\u2030' && x <= '\u2033' || x >= '\u207a' && x <= '\u207b' || x >= '\u208a' && x <= '\u208b' || x >= '\u20a0' && x <= '\u20cf' || x >= '\u2212' && x <= '\u2213' || x == '\ufe5f' || x >= '\ufe62' && x >= '\ufe63' || x >= '\ufe69' && x <= '\ufe6a' || x >= '\uff03' && x >= '\uff05' || x == '\uff0b' || x == '\uff0d' || x >= '\uffe0' && x <= '\uffe1' || x >= '\uffe5' && x <= '\uffe6') {
            return 6;
        }
        if (x == '/' || x == '\ufe52' || x >= '\uff0e' && x <= '\uff0f') {
            return 7;
        }
        if (x == ',' || x == ':' || x == '\ufe50' || x == '\ufe55' || x == '\uff0c' || x == '\uff1a' || x == '.' || x == '\u2007') {
            return 8;
        }
        if (x == ' ' || x == '\u00a0' || x >= '\u2000' && x <= '\u2006' || x >= '\u2008' && x <= '\u200b' || x == '\u3000') {
            return 9;
        }
        if (x >= '\u202a' && x <= '\u202e' || x >= '\u206c' && x <= '\u206f') {
            return 11;
        }
        return 10;
    }

    private void implicitProcessing() {
        short sCond;
        int i = 0;
        int newIS = impTab[this.ucb_impSta][this.ucb_xType];
        int Special = newIS >> 5;
        int newIL = impTab[newIS &= 0x1F][11];
        if (Special > 0) {
            switch (Special) {
                case 1: {
                    i = this.ucb_condPos;
                    while (i < this.ucb_ix) {
                        this.ics_TrgToSrcMap[i] = this.ics_TrgToSrcMap[i] & 0xC000;
                        this.ics_TrgToSrcMap[i] = this.ics_TrgToSrcMap[i] | this.ucb_curLev;
                        ++i;
                    }
                    this.ucb_condPos = -1;
                    break;
                }
                case 2: {
                    i = this.ucb_condPos;
                    while (i < this.ucb_ix) {
                        this.ics_TrgToSrcMap[i] = this.ics_TrgToSrcMap[i] & 0xC000;
                        this.ics_TrgToSrcMap[i] = this.ics_TrgToSrcMap[i] | this.ucb_curLev + 1;
                        ++i;
                    }
                    this.ucb_condPos = -1;
                    break;
                }
                case 3: {
                    i = this.ucb_condPos;
                    while (i < this.ucb_ix) {
                        this.ics_TrgToSrcMap[i] = this.ics_TrgToSrcMap[i] & 0xC000;
                        this.ics_TrgToSrcMap[i] = this.ics_TrgToSrcMap[i] | this.ucb_curLev + 1;
                        ++i;
                    }
                    int n = i;
                    this.ics_TrgToSrcMap[n] = this.ics_TrgToSrcMap[n] + (this.ucb_curLev + 2);
                    this.ucb_condPos = -1;
                    break;
                }
                case 4: {
                    this.ucb_condPos = this.ucb_ix;
                    break;
                }
                case 5: {
                    this.ucb_condPos = -1;
                }
            }
        }
        if ((sCond = impTab[newIS][12]) == 0) {
            if (this.ucb_condPos > -1) {
                i = this.ucb_condPos;
                while (i < this.ucb_ix) {
                    this.ics_TrgToSrcMap[i] = this.ics_TrgToSrcMap[i] & 0xC000;
                    this.ics_TrgToSrcMap[i] = this.ics_TrgToSrcMap[i] | this.ucb_curLev + newIL;
                    if ((this.ucb_curLev + newIL) % 2 == 0 && (this.ics_buffer_in[i] != '\u206c' || this.ics_buffer_in[i] != '\u206f')) {
                        this.ics_TrgToSrcMap[i] = this.ics_TrgToSrcMap[i] & Short.MAX_VALUE;
                    }
                    ++i;
                }
            }
            this.ucb_condPos = -1;
            if (this.ucb_lineSepPos >= 0) {
                this.ics_TrgToSrcMap[this.ucb_lineSepPos] = 0;
                this.ucb_lineSepPos = -1;
            }
        } else if (this.ucb_condPos == -1) {
            this.ucb_condPos = this.ucb_ix;
        }
        this.ucb_impLev = newIL;
        this.ucb_impSta = newIS;
        this.ucb_wTarget |= this.ucb_curLev + this.ucb_impLev;
    }

    private int lastStrong(char[] data, int length) {
        int i = length - 1;
        while (i >= 0) {
            int type = this.getChType(data[i]);
            if (type == 2 || type == 3) {
                return type;
            }
            --i;
        }
        return 10;
    }

    private static boolean odd(int n) {
        return (n & 1) == 1;
    }

    synchronized void order(BidiText src, BidiText dst) {
        int i = 0;
        if (src.count < 1) {
            return;
        }
        this.ics_orient_in = src.flags.getOrientation();
        this.ics_orient_out = dst.flags.getOrientation();
        this.ics_type_in = src.flags.getType();
        this.ics_type_out = dst.flags.getType();
        this.notImpToImp = this.ics_type_in != BidiFlag.TYPE_IMPLICIT | this.ics_type_out != BidiFlag.TYPE_IMPLICIT;
        this.ics_buffer_in = new char[src.count];
        if (this.ics_orient_in == BidiFlag.ORIENTATION_RTL && this.ics_type_in == BidiFlag.TYPE_VISUAL) {
            int ofs = src.offset + src.count - 1;
            int k = 0;
            while (k < src.count) {
                this.ics_buffer_in[k] = src.data[ofs - k];
                ++k;
            }
            this.ics_orient_in = BidiFlag.ORIENTATION_LTR;
        } else {
            System.arraycopy(src.data, src.offset, this.ics_buffer_in, 0, src.count);
        }
        this.ics_size_out = 0;
        this.ics_size = src.count;
        this.ics_num_flag = dst.flags.getNumerals();
        this.ics_txtShp_flag = dst.flags.getText();
        this.ics_compc = true;
        this.ics_formShp = 0;
        this.ics_boc_flag = 0;
        this.ics_symmetric = dst.flags.getSwap() != src.flags.getSwap();
        this.ics_buffer_out = new char[this.ics_buffer_in.length];
        this.ics_A_level = new byte[src.count];
        this.ics_SrcToTrgMap = new int[src.count];
        this.ics_TrgToSrcMap = new int[src.count];
        this.ucb_ix = 0;
        this.ucb_pType = 0;
        this.ucb_Compac = 0;
        this.ucb_Shaping = 0;
        this.ucb_araLet = 0;
        this.BaseLvl();
        while (this.ucb_ix < this.ics_size) {
            this.pass1();
            ++this.ucb_ix;
        }
        this.ucb_xType = 0;
        this.implicitProcessing();
        i = 0;
        while (i < this.ics_size) {
            this.ics_A_level[i] = (byte)(this.ics_TrgToSrcMap[i] & 0xFF);
            ++i;
        }
        this.pass2();
        this.pass3();
        i = 0;
        while (i < this.ics_size) {
            this.ics_buffer_out[i] = (char)this.ics_TrgToSrcMap[i];
            ++i;
        }
        this.pass4();
        i = 0;
        while (i < this.ics_size) {
            this.ics_TrgToSrcMap[i] = this.ics_TrgToSrcMap[i] & 0xFF;
            ++i;
        }
        if (this.ics_compc) {
            i = 0;
            while (i < this.ics_size) {
                this.ics_SrcToTrgMap[this.ics_TrgToSrcMap[this.ics_TrgToSrcMap[i]]] = this.ics_TrgToSrcMap[i];
                ++i;
            }
        }
        System.arraycopy(this.ics_buffer_out, 0, dst.data, dst.offset, src.count);
        dst.count = src.count;
    }

    /*
     * Unable to fully structure code
     */
    private void pass1() {
        if (this.ucb_ix == 0) {
            this.ucb_pType = 0;
        }
        this.ucb_wTarget = 0;
        cChar = this.ics_buffer_in[this.ucb_ix];
        cType = this.getChType(cChar);
        switch (cType) {
            case 11: {
                switch (cChar) {
                    case '\u206c': {
                        if (this.ics_boc_flag == 65535) {
                            this.ucb_Compac = 1;
                        }
                        if (this.ics_boc_flag != 0) {
                            this.ucb_wTarget |= 32768;
                        }
                        this.ics_formShp = 0;
                        break;
                    }
                    case '\u206d': {
                        if (this.ics_boc_flag == 65535) {
                            this.ucb_Compac = 1;
                        }
                        if (this.ics_boc_flag != 0) {
                            this.ucb_wTarget |= 32768;
                        }
                        this.ics_formShp = 1;
                        break;
                    }
                    case '\u206e': {
                        if (this.ics_boc_flag == 65535) {
                            this.ucb_Compac = 1;
                        }
                        if (this.ics_boc_flag != 0) {
                            this.ucb_wTarget |= 32768;
                        }
                        this.ics_num_flag = BidiFlag.NUMERALS_NATIONAL;
                        break;
                    }
                    case '\u206f': {
                        if (this.ics_boc_flag == 65535) {
                            this.ucb_Compac = 1;
                        }
                        if (this.ics_boc_flag != 0) {
                            this.ucb_wTarget |= 32768;
                        }
                        this.ics_num_flag = BidiFlag.NUMERALS_NOMINAL;
                    }
                }
                break;
            }
            case 0: {
                this.ucb_wTarget = 0;
                this.BaseLvl();
                break;
            }
            case 1: {
                this.ucb_wTarget = this.ucb_basLev;
                this.ucb_xType = 1;
                this.implicitProcessing();
                break;
            }
            default: {
                if (cChar == '\u2028') {
                    this.ucb_lineSepPos = this.ucb_ix;
                    this.ucb_wTarget = 0;
                    break;
                }
                if (cChar == '\u200e' || cChar == '\u200f') {
                    if (this.ics_boc_flag == 65535) {
                        this.ucb_Compac = 1;
                    } else if (this.ics_boc_flag != 0) {
                        this.ucb_wTarget |= 32768;
                    }
                }
                if (cType == 4 && this.ics_num_flag == BidiFlag.NUMERALS_NATIONAL) {
                    this.ucb_wTarget |= 32768;
                    cType = 5;
                }
                if (cType == 5 && this.ics_num_flag == BidiFlag.NUMERALS_NOMINAL) {
                    this.ucb_wTarget |= 32768;
                    cType = 4;
                }
                if (cType != 4 || this.ics_num_flag != BidiFlag.NUMERALS_CONTEXTUAL) ** GOTO lbl86
                if (this.ucb_pType != 5) ** GOTO lbl69
                this.ucb_wTarget |= 40960;
                cType = 5;
                ** GOTO lbl86
lbl69:
                // 1 sources

                if (this.ucb_pType != 9 && this.ucb_pType != 10 && this.ucb_pType != 8 && this.ucb_pType != 7 || this.ucb_ix <= 0 || (this.ics_TrgToSrcMap[this.ucb_ix - 1] & 8192) != 0) ** GOTO lbl83
                i1 = 0;
                i1 = this.ucb_ix - 2;
                while (i1 >= 0) {
                    this.ucb_pType = this.getChType(this.ics_buffer_in[i1]);
                    if (this.ucb_pType == 3 || (this.ics_TrgToSrcMap[i1] & 8192) != 0) {
                        this.ucb_wTarget |= 40960;
                        cType = 5;
                    } else if (!(this.ucb_pType == 2 || this.ucb_pType == 4 && (this.ics_TrgToSrcMap[i1] & 8192) == 0 || this.ucb_pType == 2 || this.ucb_pType == 4 && (this.ics_TrgToSrcMap[i1] & 8192) == 0)) {
                        --i1;
                        continue;
                    }
                    ** GOTO lbl86
                }
                ** GOTO lbl86
lbl83:
                // 1 sources

                if (this.ucb_ix > 0 && (this.ics_TrgToSrcMap[this.ucb_ix - 1] & 8192) != 0 || this.ucb_pType == 3) {
                    this.ucb_wTarget |= 40960;
                    cType = 5;
                }
lbl86:
                // 8 sources

                if (cType == 2) {
                    this.ucb_araLet = 0;
                }
                if (cType == 3) {
                    if (cChar >= '\u0600' && cChar <= '\u06ef') {
                        this.ucb_araLet = 1;
                        if (this.ics_txtShp_flag != BidiFlag.TEXT_NOMINAL) {
                            this.ucb_Shaping = 1;
                        }
                    }
                    if (cChar >= '\ufb50' && cChar <= '\ufefc') {
                        this.ucb_araLet = 1;
                        if (this.ics_txtShp_flag != BidiFlag.TEXT_NOMINAL && this.ics_formShp == 1) {
                            this.ucb_Shaping = 1;
                            this.ucb_wTarget |= 32768;
                        }
                    }
                }
                if (cType == 6) {
                    iFlag = false;
                    i2 = 0;
                    if (this.ucb_pType == 4) {
                        cType = 4;
                    } else if (this.ucb_pType == 5) {
                        cType = 10;
                    }
                    while (!iFlag) {
                        if (this.ucb_ix + i2 + 1 >= this.ics_size) {
                            iFlag = true;
                            continue;
                        }
                        this.ucb_pType = this.getChType(this.ics_buffer_in[this.ucb_ix + i2 + 1]);
                        if (this.ucb_pType == 4) {
                            cType = this.ucb_araLet == 1 ? 10 : 4;
                            iFlag = true;
                        } else if (this.ucb_pType == 5) {
                            cType = 10;
                            iFlag = true;
                        }
                        if (this.ucb_pType == 6) {
                            ++i2;
                            continue;
                        }
                        iFlag = true;
                    }
                }
                if (cType == 7 || cType == 8) {
                    v0 = this.ucb_xType = this.ucb_ix + 1 < this.ics_size ? this.getChType(this.ics_buffer_in[this.ucb_ix + 1]) : 0;
                    cType = this.ucb_pType == 4 ? (this.ucb_xType == 4 ? 4 : 10) : (this.ucb_pType == 5 && cType == 8 ? (this.ucb_xType == 4 ? 5 : 10) : 10);
                }
                savIL = this.ucb_impLev;
                this.ucb_xType = cType;
                if (this.visToVis) {
                    this.ucb_xType = 10;
                }
                this.implicitProcessing();
                if (!BidiOrder.UCQSPAC(cChar)) {
                    this.ucb_wTarget = this.ucb_curLev + savIL | 16384;
                    cType = this.ucb_ix == 0 ? 10 : this.ucb_pType;
                    if (this.ucb_condPos == this.ucb_ix) {
                        this.ucb_condPos = -1;
                    }
                }
                if (cType != 10 || !this.ics_symmetric || this.ucb_condPos <= -1 && !BidiOrder.odd(this.ucb_curLev + this.ucb_impLev) || BidiOrder.UCQSYMM(cChar) == cChar) break;
                this.ucb_wTarget |= 32768;
            }
        }
        this.ucb_pType = cType;
        this.ics_TrgToSrcMap[this.ucb_ix] = this.ucb_wTarget;
    }

    private void pass2() {
        int[] lolim = new int[20];
        int[] hilim = new int[20];
        int lastLev = 0;
        int x = 0;
        while (x < 19) {
            lolim[x] = 0;
            hilim[x] = this.ics_size - 1;
            ++x;
        }
        this.ucb_ix = 0;
        while (this.ucb_ix < this.ics_size) {
            char cChar;
            int i = this.ics_TrgToSrcMap[this.ucb_ix];
            int xLev = i & 0x1FFF;
            if ((i & 0x8000) > 0 && BidiOrder.even(xLev) && BidiOrder.UCQSYMM(cChar = this.ics_buffer_in[this.ucb_ix]) != cChar) {
                int n = this.ucb_ix;
                this.ics_TrgToSrcMap[n] = this.ics_TrgToSrcMap[n] & Short.MAX_VALUE;
            }
            x = this.ucb_ix;
            if (xLev > lastLev) {
                int wLev = xLev;
                int iy = this.ucb_ix + 1;
                while (wLev > lastLev) {
                    lolim[wLev] = this.ucb_ix;
                    while (iy < this.ics_size) {
                        if ((this.ics_TrgToSrcMap[iy] & 0x3FFF) < wLev) break;
                        ++iy;
                    }
                    hilim[wLev] = iy - 1;
                    --wLev;
                }
            }
            if (this.notImpToImp) {
                i = xLev;
                while (i >= this.ucb_outLev + 1) {
                    x = lolim[i] + hilim[i] - x;
                    --i;
                }
            }
            this.ics_TrgToSrcMap[this.ucb_ix] = (this.ics_TrgToSrcMap[this.ucb_ix] & 0xA000) + x;
            lastLev = xLev;
            ++this.ucb_ix;
        }
    }

    private void pass3() {
        int visPos = 0;
        this.ucb_ix = 0;
        while (this.ucb_ix < this.ics_size) {
            int logPos = this.ucb_ix;
            int logPtr = this.ics_TrgToSrcMap[this.ucb_ix];
            while ((logPtr & 0x4000) == 0) {
                visPos = logPtr & 0x1FFF;
                int wPtr = this.ics_TrgToSrcMap[visPos];
                if ((wPtr & 0x4000) > 0) break;
                this.ics_TrgToSrcMap[visPos] = logPos + (logPtr & 0xA000) + 16384;
                logPos = visPos;
                logPtr = wPtr;
            }
            ++this.ucb_ix;
        }
    }

    private void pass4() {
        int i = 0;
        while (i < this.ics_size) {
            int xTran = this.ics_buffer_out[i] & 0x8000;
            char xchar = this.ics_buffer_in[this.ics_buffer_out[i] & 0x1FFF];
            if (xTran > 0) {
                if (xchar == '\u200e' || xchar == '\u200f' || xchar >= '\u202a' && xchar <= '\u202e' || xchar >= '\u206c' && xchar <= '\u206f') {
                    xchar = (char)this.ics_boc_flag;
                } else if (!(xchar >= '\ufe80' && xchar <= '\ufefc' || xchar >= '\ufb50' && xchar <= '\ufdff')) {
                    if (xchar >= '0' && xchar <= '9') {
                        xchar = (char)(xchar + 1584);
                    } else if (xchar >= '\u0660' && xchar <= '\u0669') {
                        xchar = (char)(xchar - 1584);
                    } else if (this.ics_symmetric) {
                        xchar = BidiOrder.UCQSYMM(xchar);
                    }
                }
            }
            this.ics_buffer_out[i] = xchar;
            ++i;
        }
    }

    private static boolean UCQSPAC(char x) {
        int low = 0;
        int high = 59;
        while (low <= high) {
            int mid = (low + high) / 2;
            if (x < notSpacing[mid][0]) {
                high = mid - 1;
                continue;
            }
            if (x > notSpacing[mid][1]) {
                low = mid + 1;
                continue;
            }
            return false;
        }
        return true;
    }

    private static char UCQSYMM(char x) {
        int low = 0;
        int high = 23;
        while (low <= high) {
            int mid = (low + high) / 2;
            char c = symPairs[mid][0];
            if (x < c) {
                high = mid - 1;
                continue;
            }
            if (x > c) {
                low = mid + 1;
                continue;
            }
            return symPairs[mid][1];
        }
        return x;
    }
}

