/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.util.bidi;

import com.ibm.record.util.bidi.BidiFlag;
import java.io.Serializable;
import java.util.StringTokenizer;

public final class BidiFlagSet
implements Serializable,
Cloneable {
    private static String copyright = "(c) Copyright IBM Corporation 2000.";
    static final long serialVersionUID = -7979244865820319709L;
    static final int TYPE_MASK = 0x3000000;
    static final int ITYPE_IMPLICIT = 0x1000000;
    static final int ITYPE_VISUAL = 0x3000000;
    static final int ORIENTATION_MASK = 0x700000;
    static final int IORIENTATION_LTR = 0x100000;
    static final int IORIENTATION_RTL = 0x300000;
    static final int IORIENTATION_CONTEXT_LTR = 0x500000;
    static final int IORIENTATION_CONTEXT_RTL = 0x700000;
    static final int SWAP_MASK = 196608;
    static final int ISWAP_YES = 65536;
    static final int ISWAP_NO = 196608;
    static final int NUMERALS_MASK = 1792;
    static final int INUMERALS_NOMINAL = 256;
    static final int INUMERALS_NATIONAL = 768;
    static final int INUMERALS_CONTEXTUAL = 1280;
    static final int TEXT_MASK = 15;
    static final int ITEXT_NOMINAL = 1;
    static final int ITEXT_SHAPED = 3;
    static final int ITEXT_INITIAL = 5;
    static final int ITEXT_MIDDLE = 7;
    static final int ITEXT_FINAL = 9;
    static final int ITEXT_ISOLATED = 11;
    static final int DEFAULT = 0x1110101;
    int value;

    public BidiFlagSet() {
        this.value = 0x1110101;
    }

    public BidiFlagSet(BidiFlag flag) {
        this.value = flag.value | 0x1110101;
    }

    public BidiFlagSet(BidiFlag flag1, BidiFlag flag2) {
        this.value = flag1.value;
        if ((this.value & flag2.value) != 0) {
            throw new IllegalArgumentException();
        }
        this.value |= flag2.value | 0x1110101;
    }

    public BidiFlagSet(BidiFlag flag1, BidiFlag flag2, BidiFlag flag3) {
        this.value = flag1.value;
        if ((this.value & flag2.value) != 0) {
            throw new IllegalArgumentException();
        }
        this.value |= flag2.value;
        if ((this.value & flag3.value) != 0) {
            throw new IllegalArgumentException();
        }
        this.value |= flag3.value | 0x1110101;
    }

    public BidiFlagSet(BidiFlag flag1, BidiFlag flag2, BidiFlag flag3, BidiFlag flag4) {
        this.value = flag1.value;
        if ((this.value & flag2.value) != 0) {
            throw new IllegalArgumentException();
        }
        this.value |= flag2.value;
        if ((this.value & flag3.value) != 0) {
            throw new IllegalArgumentException();
        }
        this.value |= flag3.value;
        if ((this.value & flag4.value) != 0) {
            throw new IllegalArgumentException();
        }
        this.value |= flag4.value | 0x1110101;
    }

    public BidiFlagSet(BidiFlag flag1, BidiFlag flag2, BidiFlag flag3, BidiFlag flag4, BidiFlag flag5) {
        this.value = flag1.value;
        if ((this.value & flag2.value) != 0) {
            throw new IllegalArgumentException();
        }
        this.value |= flag2.value;
        if ((this.value & flag3.value) != 0) {
            throw new IllegalArgumentException();
        }
        this.value |= flag3.value;
        if ((this.value & flag4.value) != 0) {
            throw new IllegalArgumentException();
        }
        this.value |= flag4.value;
        if ((this.value & flag5.value) != 0) {
            throw new IllegalArgumentException();
        }
        this.value |= flag5.value;
    }

    public BidiFlagSet(BidiFlagSet model) {
        this.value = model.value;
    }

    public BidiFlagSet(String str) throws IllegalArgumentException {
        int n = BidiFlagSet.parseBidiFlagSet(str);
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.value = n;
    }

    public Object clone() {
        try {
            BidiFlagSet newSet = (BidiFlagSet)super.clone();
            return newSet;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public boolean equals(BidiFlagSet other) {
        if (other == null) {
            return false;
        }
        return this.value == other.value;
    }

    public BidiFlag getNumerals() {
        switch (this.value & 0x700) {
            case 256: {
                return BidiFlag.NUMERALS_NOMINAL;
            }
            case 768: {
                return BidiFlag.NUMERALS_NATIONAL;
            }
            case 1280: {
                return BidiFlag.NUMERALS_CONTEXTUAL;
            }
        }
        return BidiFlag.NUMERALS_NOMINAL;
    }

    public BidiFlag getOrientation() {
        switch (this.value & 0x700000) {
            case 0x100000: {
                return BidiFlag.ORIENTATION_LTR;
            }
            case 0x300000: {
                return BidiFlag.ORIENTATION_RTL;
            }
            case 0x500000: {
                return BidiFlag.ORIENTATION_CONTEXT_LTR;
            }
            case 0x700000: {
                return BidiFlag.ORIENTATION_CONTEXT_RTL;
            }
        }
        return BidiFlag.ORIENTATION_LTR;
    }

    public BidiFlag getSwap() {
        switch (this.value & 0x30000) {
            case 65536: {
                return BidiFlag.SWAP_YES;
            }
            case 196608: {
                return BidiFlag.SWAP_NO;
            }
        }
        return BidiFlag.SWAP_YES;
    }

    public BidiFlag getText() {
        switch (this.value & 0xF) {
            case 1: {
                return BidiFlag.TEXT_NOMINAL;
            }
            case 3: {
                return BidiFlag.TEXT_SHAPED;
            }
            case 5: {
                return BidiFlag.TEXT_INITIAL;
            }
            case 7: {
                return BidiFlag.TEXT_MIDDLE;
            }
            case 9: {
                return BidiFlag.TEXT_FINAL;
            }
            case 11: {
                return BidiFlag.TEXT_ISOLATED;
            }
        }
        return BidiFlag.TEXT_NOMINAL;
    }

    public BidiFlag getType() {
        switch (this.value & 0x3000000) {
            case 0x1000000: {
                return BidiFlag.TYPE_IMPLICIT;
            }
            case 0x3000000: {
                return BidiFlag.TYPE_VISUAL;
            }
        }
        return BidiFlag.TYPE_IMPLICIT;
    }

    public int hashCode() {
        return this.value;
    }

    private static int parseBidiFlagSet(String str) {
        int newValue = 0;
        int counter = 0;
        String keyword = "";
        StringTokenizer stok = new StringTokenizer(str, "\t ,=");
        while (stok.hasMoreElements()) {
            String token = stok.nextToken();
            --counter;
            if (token.equals("@ls")) continue;
            if (token.equals("implicitalg") || token.equals("checkmode") || token.equals("shapcharset")) {
                keyword = "allowed";
                continue;
            }
            if (token.equals("typeoftext") || token.equals("orientation") || token.equals("context") || token.equals("swapping") || token.equals("numerals") || token.equals("shaping")) {
                keyword = token;
                continue;
            }
            if (token.equals("visual")) {
                if (!keyword.equals("typeoftext")) {
                    return counter;
                }
                newValue = newValue & 0xFCFFFFFF | 0x3000000;
                continue;
            }
            if (token.equals("implicit")) {
                if (!keyword.equals("typeoftext")) {
                    return counter;
                }
                newValue = newValue & 0xFCFFFFFF | 0x1000000;
                continue;
            }
            if (token.equals("ltr")) {
                if (keyword.equals("orientation")) {
                    newValue = newValue & 0xFF8FFFFF | 0x100000;
                    continue;
                }
                if (keyword.equals("context")) {
                    if ((newValue & 0x700000) == 0x100000 || (newValue & 0x700000) == 0x300000) continue;
                    newValue = newValue & 0xFF8FFFFF | 0x500000;
                    continue;
                }
                return counter;
            }
            if (token.equals("rtl")) {
                if (keyword.equals("orientation")) {
                    newValue = newValue & 0xFF8FFFFF | 0x300000;
                    continue;
                }
                if (keyword.equals("context")) {
                    if ((newValue & 0x700000) == 0x100000 || (newValue & 0x700000) == 0x300000) continue;
                    newValue = newValue & 0xFF8FFFFF | 0x700000;
                    continue;
                }
                return counter;
            }
            if (token.equals("contextual")) {
                if (keyword.equals("orientation")) {
                    if ((newValue & 0x700000) == 0x700000) continue;
                    newValue = newValue & 0xFF8FFFFF | 0x500000;
                    continue;
                }
                if (keyword.equals("numerals")) {
                    newValue = newValue & 0xFFFFF8FF | 0x500;
                    continue;
                }
                return counter;
            }
            if (token.equals("yes")) {
                if (!keyword.equals("swapping")) {
                    return counter;
                }
                newValue = newValue & 0xFFFCFFFF | 0x10000;
                continue;
            }
            if (token.equals("no")) {
                if (!keyword.equals("swapping")) {
                    return counter;
                }
                newValue = newValue & 0xFFFCFFFF | 0x30000;
                continue;
            }
            if (token.equals("nominal")) {
                if (keyword.equals("numerals")) {
                    newValue = newValue & 0xFFFFF8FF | 0x100;
                    continue;
                }
                if (keyword.equals("shaping")) {
                    newValue = newValue & 0xFFFFFFF0 | 1;
                    continue;
                }
                return counter;
            }
            if (token.equals("national")) {
                if (!keyword.equals("numerals")) {
                    return counter;
                }
                newValue = newValue & 0xFFFFF8FF | 0x300;
                continue;
            }
            if (token.equals("shaped")) {
                if (!keyword.equals("shaping")) {
                    return counter;
                }
                newValue = newValue & 0xFFFFFFF0 | 3;
                continue;
            }
            if (token.equals("shform1")) {
                if (!keyword.equals("shaping")) {
                    return counter;
                }
                newValue = newValue & 0xFFFFFFF0 | 5;
                continue;
            }
            if (token.equals("shform2")) {
                if (!keyword.equals("shaping")) {
                    return counter;
                }
                newValue = newValue & 0xFFFFFFF0 | 7;
                continue;
            }
            if (token.equals("shform3")) {
                if (!keyword.equals("shaping")) {
                    return counter;
                }
                newValue = newValue & 0xFFFFFFF0 | 9;
                continue;
            }
            if (token.equals("shform4")) {
                if (!keyword.equals("shaping")) {
                    return counter;
                }
                newValue = newValue & 0xFFFFFFF0 | 0xB;
                continue;
            }
            if (keyword.equals("allowed")) continue;
            return counter;
        }
        return newValue | 0x1110101;
    }

    public static void set2AllFlags(BidiFlagSet flags1, BidiFlagSet flags2, String str) throws IllegalArgumentException {
        int capacity = str.length();
        StringBuffer sb1 = new StringBuffer(capacity);
        StringBuffer sb2 = new StringBuffer(capacity);
        StringTokenizer stok = new StringTokenizer(str, "\t ,=:", true);
        int sb2Length = 0;
        boolean colon = false;
        while (stok.hasMoreElements()) {
            String token = stok.nextToken();
            if (token.equals(" ") || token.equals("\t")) {
                sb1.append(token);
                sb2.append(token);
                continue;
            }
            if (token.equals(",") || token.equals("=")) {
                colon = false;
                sb1.append(token);
                sb2.append(token);
                continue;
            }
            if (token.equals(":")) {
                colon = true;
                sb2.setLength(sb2Length);
                continue;
            }
            if (!colon) {
                sb1.append(token);
            }
            sb2Length = sb2.length();
            sb2.append(token);
            colon = false;
        }
        flags1.setAllFlags(sb1.toString());
        flags2.setAllFlags(sb2.toString());
    }

    public void setAllFlags(BidiFlagSet model) {
        this.value = model.value;
    }

    public void setAllFlags(String str) throws IllegalArgumentException {
        int n = BidiFlagSet.parseBidiFlagSet(str);
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.value = n;
    }

    public void setOneFlag(BidiFlag newFlag) {
        this.value = this.value & ~newFlag.mask | newFlag.value;
    }

    public String toString() {
        return BidiFlagSet.toString(this.value);
    }

    static String toString(int value) {
        String[] typeStrings = new String[]{"implicit", "visual"};
        String[] orientationStrings = new String[]{"ltr", "rtl", "contextual, context=ltr", "contextual, context=rtl"};
        String[] swapStrings = new String[]{"yes", "no"};
        String[] numeralsStrings = new String[]{"nominal", "national", "contextual", "invalid"};
        String[] textStrings = new String[]{"nominal", "shaped", "shform1", "shform2", "shform3", "shform4", "invalid", "invalid"};
        return "typeoftext=" + typeStrings[(value & 0x3000000) >> 25] + ", " + "orientation=" + orientationStrings[(value & 0x700000) >> 21] + ", " + "swapping=" + swapStrings[(value & 0x30000) >> 17] + ", " + "numerals=" + numeralsStrings[(value & 0x700) >> 9] + ", " + "shaping=" + textStrings[(value & 0xF) >> 1];
    }
}

