/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.util;

import com.ibm.record.util.IOrderedDictionaryEnumerator;
import com.ibm.record.util.LookupTable;
import com.ibm.record.util.OrderedDictionaryEnumerator;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class OrderedDictionary
extends Dictionary
implements Serializable {
    private static String copyright = "Licensed Material - Property of IBM IBM(R) VisualAge(R) for Java(TM) Version 3.0 (C) Copyright IBM Corp. 1998, 1999 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final long serialVersionUID = -2998915558080533153L;
    private Vector keys;
    private Vector values;
    private LookupTable lookupTable;

    public OrderedDictionary() {
        int d = this.defaultSize();
        this.keys = new Vector(d);
        this.values = new Vector(d);
        this.lookupTable = new LookupTable(d);
    }

    public boolean contains(Object value) {
        return this.values.contains(value);
    }

    public boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    private int defaultSize() {
        return 101;
    }

    public IOrderedDictionaryEnumerator dictionaryElements() {
        return new OrderedDictionaryEnumerator(this.values);
    }

    public IOrderedDictionaryEnumerator dictionaryKeys() {
        return new OrderedDictionaryEnumerator(this.keys);
    }

    public Object elementAt(int index) {
        return this.values.elementAt(index);
    }

    public Enumeration elements() {
        return new OrderedDictionaryEnumerator(this.values);
    }

    public Object firstElement() {
        Object firstElem = this.values.firstElement();
        if (firstElem == null) {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            int i = 1;
            while (i < this.values.size()) {
                firstElem = this.values.elementAt(i);
                if (firstElem != null) {
                    return firstElem;
                }
                ++i;
            }
        }
        return firstElem;
    }

    public Object get(Object key) {
        Integer index = (Integer)this.lookupTable.get(key);
        if (index == null) {
            return null;
        }
        return this.values.elementAt(index);
    }

    public int indexOf(Object value) {
        return this.values.indexOf(value);
    }

    public int indexOfKey(Object key) {
        return this.keys.indexOf(key);
    }

    public void insertElementAt(Object key, Object value, int index) {
        if (this.values.elementAt(index) == null) {
            this.keys.setElementAt(key, index);
            this.values.setElementAt(value, index);
            this.lookupTable.put(key, new Integer(index));
            return;
        }
        this.keys.insertElementAt(key, index);
        this.values.insertElementAt(value, index);
        int length = this.values.size();
        int j = index;
        while (j < length) {
            Object newKey = this.keys.elementAt(j);
            if (newKey != null) {
                this.lookupTable.put(newKey, new Integer(j));
            }
            ++j;
        }
    }

    public boolean isEmpty() {
        return this.lookupTable.isEmpty();
    }

    public Enumeration keys() {
        return new OrderedDictionaryEnumerator(this.keys);
    }

    public Object lastElement() {
        Object lastElem = this.values.lastElement();
        if (lastElem == null) {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            int i = this.values.size() - 2;
            while (i >= 0) {
                lastElem = this.values.elementAt(i);
                if (lastElem != null) {
                    return lastElem;
                }
                --i;
            }
        }
        return lastElem;
    }

    public Object put(Object key, Object value) {
        Integer index = (Integer)this.lookupTable.get(key);
        if (index == null) {
            this.keys.addElement(key);
            this.values.addElement(value);
            index = new Integer(this.values.size() - 1);
            this.lookupTable.put(key, index);
            return null;
        }
        Object oldValue = this.values.elementAt(index);
        this.values.setElementAt(value, index);
        return oldValue;
    }

    public Object remove(Object key) {
        Integer index = (Integer)this.lookupTable.remove(key);
        Object removed = null;
        if (index != null) {
            int k = index;
            removed = this.values.elementAt(k);
            this.keys.setElementAt(null, k);
            this.values.setElementAt(null, k);
        }
        return removed;
    }

    public void removeElementAt(int index) {
        Object key = this.keys.elementAt(index);
        if (key == null) {
            return;
        }
        this.keys.setElementAt(null, index);
        this.values.setElementAt(null, index);
        this.lookupTable.remove(key);
    }

    public void setElementAt(Object key, Object value, int index) {
        Object currentKey = this.keys.elementAt(index);
        if (currentKey != null && !key.equals(currentKey)) {
            this.lookupTable.remove(currentKey);
        }
        this.keys.setElementAt(key, index);
        this.values.setElementAt(value, index);
        this.lookupTable.put(key, new Integer(index));
    }

    public int size() {
        return this.lookupTable.size();
    }
}

