/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.util;

import com.ibm.record.util.LookupTableEnumerator;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;

class LookupTable
extends Dictionary
implements Serializable {
    private static String copyright = "Licensed Material - Property of IBM IBM(R) VisualAge(R) for Java(TM) Version 3.0 (C) Copyright IBM Corp. 1998, 1999 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final long serialVersionUID = -6875190087331339824L;
    private Object[] keys;
    private Object[] values;
    private int count = 0;
    private int threshold;
    private float loadFactor;

    public LookupTable() {
        this(101);
    }

    public LookupTable(int initialCapacity) {
        this.keys = new Object[initialCapacity];
        this.values = new Object[initialCapacity];
    }

    public synchronized Enumeration elements() {
        return new LookupTableEnumerator(this.values);
    }

    public synchronized Object get(Object key) {
        Object hashKey;
        int hashIndex;
        int elementsSize = this.keys.length;
        int keyIndex = hashIndex = (key.hashCode() & Integer.MAX_VALUE) % elementsSize;
        while (keyIndex < elementsSize) {
            hashKey = this.keys[keyIndex];
            if (hashKey == null) {
                return null;
            }
            if (key.equals(hashKey)) {
                return this.values[keyIndex];
            }
            ++keyIndex;
        }
        keyIndex = 0;
        while (keyIndex < hashIndex) {
            hashKey = this.keys[keyIndex];
            if (hashKey == null) {
                return null;
            }
            if (key.equals(hashKey)) {
                return this.values[keyIndex];
            }
            ++keyIndex;
        }
        return null;
    }

    private void grow() {
        this.rehash(2 * this.keys.length + 1);
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration keys() {
        return new LookupTableEnumerator(this.keys);
    }

    public synchronized Object put(Object key, Object value) {
        Object hashKey;
        int hashIndex;
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = key.hashCode();
        int elementsSize = this.keys.length;
        int keyIndex = hashIndex = (hash & Integer.MAX_VALUE) % elementsSize;
        while (keyIndex < elementsSize) {
            hashKey = this.keys[keyIndex];
            if (hashKey == null) {
                this.keys[keyIndex] = key;
                this.values[keyIndex] = value;
                ++this.count;
                if (this.count > elementsSize / 2) {
                    this.grow();
                }
                return null;
            }
            if (key.equals(hashKey)) {
                Object oldValue = this.values[keyIndex];
                this.values[keyIndex] = value;
                return oldValue;
            }
            ++keyIndex;
        }
        keyIndex = 0;
        while (keyIndex < hashIndex) {
            hashKey = this.keys[keyIndex];
            if (hashKey == null) {
                this.keys[keyIndex] = key;
                this.values[keyIndex] = value;
                ++this.count;
                if (this.count > elementsSize / 2) {
                    this.grow();
                }
                return null;
            }
            if (key.equals(hashKey)) {
                Object oldValue = this.values[keyIndex];
                this.values[keyIndex] = value;
                return oldValue;
            }
            ++keyIndex;
        }
        this.grow();
        return this.put(key, value);
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehash(int newCapacity) {
        int oldCapacity = this.keys.length;
        Object[] newKeys = new Object[newCapacity];
        Object[] newValues = new Object[newCapacity];
        int i = 0;
        while (i < oldCapacity) {
            if (this.keys[i] != null) {
                int hashIndex;
                int j = hashIndex = (this.keys[i].hashCode() & Integer.MAX_VALUE) % newCapacity;
                while (j < newCapacity && newKeys[j] != null) {
                    ++j;
                }
                if (j == newCapacity) {
                    j = 0;
                    while (j < hashIndex && newKeys[j] != null) {
                        ++j;
                    }
                }
                newKeys[j] = this.keys[i];
                newValues[j] = this.values[i];
            }
            ++i;
        }
        this.keys = newKeys;
        this.values = newValues;
    }

    private void rehashToIndex(int hashIndex) {
        int realIndex;
        Object hashKey;
        int elementsSize = this.keys.length;
        int targetIndex = hashIndex;
        int keyIndex = hashIndex + 1;
        while (keyIndex < elementsSize) {
            hashKey = this.keys[keyIndex];
            if (hashKey == null) {
                this.keys[targetIndex] = null;
                this.values[targetIndex] = null;
                return;
            }
            realIndex = (hashKey.hashCode() & Integer.MAX_VALUE) % elementsSize;
            if (realIndex <= targetIndex || realIndex > keyIndex) {
                this.keys[targetIndex] = hashKey;
                this.values[targetIndex] = this.values[keyIndex];
                targetIndex = keyIndex;
            }
            ++keyIndex;
        }
        keyIndex = 0;
        while (keyIndex < hashIndex) {
            hashKey = this.keys[keyIndex];
            if (hashKey == null) {
                this.keys[targetIndex] = null;
                this.values[targetIndex] = null;
                return;
            }
            realIndex = (hashKey.hashCode() & Integer.MAX_VALUE) % elementsSize;
            if (realIndex <= targetIndex && realIndex > keyIndex) {
                this.keys[targetIndex] = hashKey;
                this.values[targetIndex] = this.values[keyIndex];
                targetIndex = keyIndex;
            }
            ++keyIndex;
        }
        this.keys[targetIndex] = null;
        this.values[targetIndex] = null;
    }

    public synchronized Object remove(Object key) {
        Object hashKey;
        int hashIndex;
        int elementsSize = this.keys.length;
        int keyIndex = hashIndex = (key.hashCode() & Integer.MAX_VALUE) % elementsSize;
        while (keyIndex < elementsSize) {
            hashKey = this.keys[keyIndex];
            if (hashKey == null) {
                return null;
            }
            if (key.equals(hashKey)) {
                Object value = this.values[keyIndex];
                this.rehash();
                --this.count;
                return value;
            }
            ++keyIndex;
        }
        keyIndex = 0;
        while (keyIndex < hashIndex) {
            hashKey = this.keys[keyIndex];
            if (hashKey == null) {
                return null;
            }
            if (key.equals(hashKey)) {
                Object value = this.values[keyIndex];
                this.rehash();
                --this.count;
                return value;
            }
            ++keyIndex;
        }
        return null;
    }

    public int size() {
        return this.count;
    }
}

