/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.ctypes;

import java.io.IOException;

class Float390 {
    private static String copyright = "Licensed Material - Property of IBM IBM(R) VisualAge(TM) for Java(TM) Version 2.0 (C) Copyright IBM Corp. 1998 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long DOUBLE_SIGN_MASK = Long.MIN_VALUE;
    private static final long DOUBLE_EXPONENT_MASK = 0x7FF0000000000000L;
    private static final long DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final long DOUBLE_MANTISSA_MSB_MASK = 0x10000000000000L;
    private static final long DOUBLE_BIAS = 1022L;
    private static final int S390_DOUBLE_BIAS = 64;
    private static final long S390_DOUBLE_EXPONENT_MASK = 0x7F00000000000000L;
    private static final long S390_DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFFL;
    private static final int FLOAT_SIGN_MASK = Integer.MIN_VALUE;
    private static final int FLOAT_EXPONENT_MASK = 2139095040;
    private static final int FLOAT_MANTISSA_MASK = 0x7FFFFF;
    private static final int FLOAT_MANTISSA_MSB_MASK = 0x800000;
    private static final int FLOAT_BIAS = 126;
    private static final int S390_FLOAT_BIAS = 64;
    private static final int S390_FLOAT_EXPONENT_MASK = 0x7F000000;
    private static final int S390_FLOAT_MANTISSA_MASK = 0xFFFFFF;

    Float390() {
    }

    protected static long doubleToS390LongBits(double ieeeDouble) throws IOException {
        long quotient;
        boolean positive;
        long ieeeLongBits = Double.doubleToLongBits(ieeeDouble);
        boolean bl = positive = (ieeeLongBits & Long.MIN_VALUE) == 0L;
        if ((ieeeLongBits & Long.MAX_VALUE) == 0L) {
            return ieeeLongBits;
        }
        long exponent = ieeeLongBits & 0x7FF0000000000000L;
        exponent >>>= 52;
        long mantissa = ieeeLongBits & 0xFFFFFFFFFFFFFL;
        long remainder = Math.abs(exponent -= 1022L) % 4L;
        long s390Exponent = quotient = Math.abs(exponent) / 4L;
        if (exponent > 0L && remainder != 0L) {
            ++s390Exponent;
        }
        if (exponent < 0L) {
            s390Exponent = -s390Exponent;
        }
        s390Exponent += 64L;
        long s390Mantissa = mantissa;
        s390Mantissa = exponent > -1022L ? (s390Mantissa |= 0x10000000000000L) : (s390Mantissa <<= 1);
        s390Mantissa <<= 3;
        if (remainder > 0L) {
            if (exponent > 0L) {
                int shift_places = (int)(4L - remainder);
                s390Mantissa >>>= shift_places;
            } else {
                if (exponent == -1022L && (s390Mantissa & 0xF0000000000000L) == 0L) {
                    s390Mantissa <<= 4;
                    --s390Exponent;
                }
                s390Mantissa >>>= (int)remainder;
            }
        }
        if (exponent == -1022L) {
            while (s390Mantissa != 0L && (s390Mantissa & 0xF0000000000000L) == 0L) {
                s390Mantissa <<= 4;
                --s390Exponent;
            }
        }
        if (s390Exponent > 127L) {
            throw new IOException("Number outside of range for double precision S/390 Float");
        }
        if (s390Exponent < 0L) {
            return 0L;
        }
        long s390Double = 0L;
        long s390ExponentBits = s390Exponent & 0x7FL;
        s390Double = s390ExponentBits << 56;
        if (!positive) {
            s390Double |= Long.MIN_VALUE;
        }
        return s390Double |= s390Mantissa;
    }

    protected static int floatToS390IntBits(float ieeeFloat) throws IOException {
        int quotient;
        boolean positive;
        int ieeeIntBits = Float.floatToIntBits(ieeeFloat);
        boolean bl = positive = (ieeeIntBits & Integer.MIN_VALUE) == 0;
        if ((ieeeIntBits & Integer.MAX_VALUE) == 0) {
            return ieeeIntBits;
        }
        int exponent = ieeeIntBits & 0x7F800000;
        exponent >>>= 23;
        int mantissa = ieeeIntBits & 0x7FFFFF;
        if ((exponent -= 126) > -126) {
            mantissa |= 0x800000;
        }
        int remainder = Math.abs(exponent) % 4;
        int s390Exponent = quotient = Math.abs(exponent) / 4;
        if (exponent > 0 && remainder != 0) {
            ++s390Exponent;
        }
        if (exponent < 0) {
            s390Exponent = -s390Exponent;
        }
        s390Exponent += 64;
        int s390Mantissa = mantissa;
        if (remainder > 0) {
            int shift_places;
            if (exponent > 0) {
                shift_places = 4 - remainder;
                s390Mantissa >>>= shift_places;
            } else {
                if (exponent == -126 && (s390Mantissa & 0xF00000) == 0) {
                    s390Mantissa <<= 4;
                    --s390Exponent;
                }
                shift_places = remainder;
                s390Mantissa >>>= shift_places;
            }
        }
        if (exponent == -126) {
            s390Mantissa <<= 1;
            while (s390Mantissa != 0 && (s390Mantissa & 0xF00000) == 0) {
                s390Mantissa <<= 4;
                --s390Exponent;
            }
        }
        int s390Float = 0;
        int s390ExponentBits = s390Exponent & 0x7F;
        s390Float = s390ExponentBits << 24;
        if (!positive) {
            s390Float |= Integer.MIN_VALUE;
        }
        return s390Float |= s390Mantissa;
    }

    protected static float intS390BitsToFloat(int floatBits) throws IOException {
        boolean positive;
        boolean bl = positive = (floatBits & Integer.MIN_VALUE) == 0;
        if ((floatBits & Integer.MAX_VALUE) == 0) {
            if (positive) {
                return 0.0f;
            }
            return -0.0f;
        }
        int mantissa = floatBits & 0xFFFFFF;
        int exponent = floatBits & 0x7F000000;
        exponent >>= 24;
        int ieeeExponent = (exponent -= 64) * 4;
        int ieeeMantissa = mantissa;
        if (ieeeExponent <= -126) {
            ieeeMantissa >>= 1;
            while (ieeeExponent < -126) {
                ++ieeeExponent;
                ieeeMantissa >>= 1;
            }
        }
        while (ieeeMantissa != 0 && (ieeeMantissa & 0x800000) == 0 && ieeeExponent > -126) {
            ieeeMantissa <<= 1;
            --ieeeExponent;
        }
        if (ieeeExponent < -149) {
            return 0.0f;
        }
        if (ieeeExponent > 128) {
            if (positive) {
                return Float.POSITIVE_INFINITY;
            }
            return Float.NEGATIVE_INFINITY;
        }
        int ieeeBits = 0;
        if (!positive) {
            ieeeBits |= Integer.MIN_VALUE;
        }
        ieeeExponent += 126;
        ieeeBits |= (ieeeExponent <<= 23);
        return Float.intBitsToFloat(ieeeBits |= (ieeeMantissa &= 0x7FFFFF));
    }

    protected static double longS390BitsToDouble(long doubleBits) throws IOException {
        boolean positive;
        boolean bl = positive = (doubleBits & Long.MIN_VALUE) == 0L;
        if ((doubleBits & Long.MAX_VALUE) == 0L) {
            if (positive) {
                return 0.0;
            }
            return -0.0;
        }
        long mantissa = doubleBits & 0xFFFFFFFFFFFFFFL;
        long exponent = doubleBits & 0x7F00000000000000L;
        exponent >>= 56;
        long ieeeExponent = (exponent -= 64L) * 4L;
        long ieeeMantissa = mantissa;
        ieeeMantissa >>= 3;
        if (ieeeExponent <= -1022L) {
            ieeeMantissa >>= 1;
            while (ieeeExponent < -1022L) {
                ++ieeeExponent;
                ieeeMantissa >>= 1;
            }
        }
        while (ieeeMantissa != 0L && (ieeeMantissa & 0x10000000000000L) == 0L && ieeeExponent > -1022L) {
            ieeeMantissa <<= 1;
            --ieeeExponent;
        }
        if (ieeeExponent < -1045L) {
            return 0.0;
        }
        if (ieeeExponent > 1024L) {
            if (positive) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NEGATIVE_INFINITY;
        }
        long ieeeBits = 0L;
        if (!positive) {
            ieeeBits |= Long.MIN_VALUE;
        }
        ieeeExponent += 1022L;
        ieeeBits |= (ieeeExponent <<= 52);
        return Double.longBitsToDouble(ieeeBits |= (ieeeMantissa &= 0xFFFFFFFFFFFFFL));
    }
}

