/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.ctypes;

import com.ibm.record.FixedLengthType;
import com.ibm.record.IRecord;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordException;
import com.ibm.record.ctypes.CLanguageRecordAttributes;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

public class CString
extends FixedLengthType
implements Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 2000.";
    static final long serialVersionUID = -1816490425877990453L;
    private int length_;

    public CString() {
        this.setStringLength(1);
    }

    public CString(int stringLength) throws IllegalArgumentException {
        this.setStringLength(stringLength);
    }

    public boolean canConvertFromBigDecimal() {
        return true;
    }

    public boolean canConvertFromByte() {
        return true;
    }

    public boolean canConvertFromChar() {
        return true;
    }

    public boolean canConvertFromDouble() {
        return true;
    }

    public boolean canConvertFromFloat() {
        return true;
    }

    public boolean canConvertFromInt() {
        return true;
    }

    public boolean canConvertFromLong() {
        return true;
    }

    public boolean canConvertFromObject() {
        return true;
    }

    public boolean canConvertFromShort() {
        return true;
    }

    public boolean canConvertFromString() {
        return true;
    }

    public boolean canConvertToBigDecimal() {
        return true;
    }

    public boolean canConvertToByte() {
        return true;
    }

    public boolean canConvertToChar() {
        return true;
    }

    public boolean canConvertToDouble() {
        return true;
    }

    public boolean canConvertToFloat() {
        return true;
    }

    public boolean canConvertToInt() {
        return true;
    }

    public boolean canConvertToLong() {
        return true;
    }

    public boolean canConvertToObject() {
        return true;
    }

    public boolean canConvertToShort() {
        return true;
    }

    public boolean canConvertToString() {
        return true;
    }

    public boolean checkConstantValue(IRecord record, byte[] fieldBytes, Object constantValue) {
        return CString.testConstantValue(record, fieldBytes, constantValue, this.length_);
    }

    public boolean checkConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        return CString.testConstantValue(record, fieldOffset, constantValue, this.length_);
    }

    public static void fromInitialValue(IRecord record, int fieldOffset, Object initialValue, int length) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(initialValue instanceof String)) {
            throw new RecordConversionUnsupportedException();
        }
        CString.fromString(record, fieldOffset, (String)initialValue, length);
    }

    public static byte[] fromInitialValue(IRecord record, Object initialValue, int length) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(initialValue instanceof String)) {
            throw new RecordConversionUnsupportedException();
        }
        return CString.fromString(record, (String)initialValue, length);
    }

    public static void fromString(IRecord record, int fieldOffset, String value, int length) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
            byte[] tb = value.getBytes(recAttr.getCodePage());
            if (tb.length >= length) {
                throw new RecordConversionUnsupportedException(Integer.toString(tb.length));
            }
            System.arraycopy(tb, 0, record.getRawBytes(), fieldOffset, tb.length);
            byte[] byteArray = record.getRawBytes();
            byteArray[fieldOffset + tb.length] = 0;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RecordConversionUnsupportedException(ex.getMessage());
        }
    }

    public static byte[] fromString(IRecord record, String value, int length) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
            byte[] tb = value.getBytes(recAttr.getCodePage());
            if (tb.length >= length) {
                throw new RecordConversionUnsupportedException(Integer.toString(tb.length));
            }
            byte[] byteArray = new byte[length];
            System.arraycopy(tb, 0, byteArray, 0, tb.length);
            byteArray[tb.length] = 0;
            return byteArray;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RecordConversionUnsupportedException(ex.getMessage());
        }
    }

    public int getAlignmentHint() {
        return 1;
    }

    public BigDecimal getBigDecimal(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String s = CString.toString(record, byteArray, this.length_);
            return new BigDecimal(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public BigDecimal getBigDecimal(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String s = CString.toString(record, fieldOffset, this.length_);
            return new BigDecimal(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public byte getByte(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String s = CString.toString(record, byteArray, this.length_);
            return Byte.parseByte(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public byte getByte(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String s = CString.toString(record, fieldOffset, this.length_);
            return Byte.parseByte(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public char getChar(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        String s = CString.toString(record, byteArray, this.length_);
        if (s.length() != 1) {
            throw new RecordConversionFailureException(Integer.toString(s.length()));
        }
        return s.charAt(0);
    }

    public char getChar(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        String s = CString.toString(record, fieldOffset, this.length_);
        if (s.length() != 1) {
            throw new RecordConversionFailureException(Integer.toString(s.length()));
        }
        return s.charAt(0);
    }

    public double getDouble(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String s = CString.toString(record, byteArray, this.length_);
            return Double.parseDouble(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public double getDouble(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        try {
            String s = CString.toString(record, fieldOffset, this.length_);
            return Double.parseDouble(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public float getFloat(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String s = CString.toString(record, byteArray, this.length_);
            return Float.parseFloat(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public float getFloat(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        try {
            String s = CString.toString(record, fieldOffset, this.length_);
            return Float.parseFloat(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public int getInt(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String s = CString.toString(record, byteArray, this.length_);
            return Integer.parseInt(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public int getInt(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        try {
            String s = CString.toString(record, fieldOffset, this.length_);
            return Integer.parseInt(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public long getLong(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String s = CString.toString(record, byteArray, this.length_);
            return Long.parseLong(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public long getLong(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        try {
            String s = CString.toString(record, fieldOffset, this.length_);
            return Long.parseLong(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public Object getObject(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        String s = CString.toString(record, byteArray, this.length_);
        return s;
    }

    public Object getObject(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        String s = CString.toString(record, fieldOffset, this.length_);
        return s;
    }

    public short getShort(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String s = CString.toString(record, byteArray, this.length_);
            return Short.parseShort(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public short getShort(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        try {
            String s = CString.toString(record, fieldOffset, this.length_);
            return Short.parseShort(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public int getSize() {
        return this.length_;
    }

    public String getString(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CString.toString(record, byteArray, this.length_);
    }

    public String getString(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CString.toString(record, fieldOffset, this.length_);
    }

    public int getStringLength() {
        return this.length_;
    }

    public void setBigDecimal(IRecord record, int fieldOffset, BigDecimal value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CString.fromString(record, fieldOffset, value.toString(), this.length_);
    }

    public byte[] setBigDecimal(IRecord record, BigDecimal value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CString.fromString(record, value.toString(), this.length_);
    }

    public byte[] setByte(IRecord record, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CString.fromString(record, Byte.toString(value), this.length_);
    }

    public void setByte(IRecord record, int fieldOffset, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CString.fromString(record, fieldOffset, Byte.toString(value), this.length_);
    }

    public byte[] setChar(IRecord record, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CString.fromString(record, new Character(value).toString(), this.length_);
    }

    public void setChar(IRecord record, int fieldOffset, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CString.fromString(record, fieldOffset, new Character(value).toString(), this.length_);
    }

    public byte[] setDouble(IRecord record, double value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CString.fromString(record, Double.toString(value), this.length_);
    }

    public void setDouble(IRecord record, int fieldOffset, double value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CString.fromString(record, fieldOffset, Double.toString(value), this.length_);
    }

    public byte[] setFloat(IRecord record, float value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CString.fromString(record, Float.toString(value), this.length_);
    }

    public void setFloat(IRecord record, int fieldOffset, float value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CString.fromString(record, fieldOffset, Float.toString(value), this.length_);
    }

    public void setInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CString.fromInitialValue(record, fieldOffset, initialValue, this.length_);
    }

    public byte[] setInitialValue(IRecord record, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CString.fromInitialValue(record, initialValue, this.length_);
    }

    public byte[] setInt(IRecord record, int value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CString.fromString(record, Integer.toString(value), this.length_);
    }

    public void setInt(IRecord record, int fieldOffset, int value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CString.fromString(record, fieldOffset, Integer.toString(value), this.length_);
    }

    public void setLong(IRecord record, int fieldOffset, long value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CString.fromString(record, fieldOffset, Long.toString(value), this.length_);
    }

    public byte[] setLong(IRecord record, long value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CString.fromString(record, Long.toString(value), this.length_);
    }

    public void setObject(IRecord record, int fieldOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(value instanceof String)) {
            throw new RecordConversionUnsupportedException();
        }
        CString.fromString(record, fieldOffset, (String)value, this.length_);
    }

    public byte[] setObject(IRecord record, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(value instanceof String)) {
            throw new RecordConversionUnsupportedException();
        }
        return CString.fromString(record, (String)value, this.length_);
    }

    public void setShort(IRecord record, int fieldOffset, short value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CString.fromString(record, fieldOffset, Short.toString(value), this.length_);
    }

    public byte[] setShort(IRecord record, short value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CString.fromString(record, Short.toString(value), this.length_);
    }

    public void setString(IRecord record, int fieldOffset, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CString.fromString(record, fieldOffset, value, this.length_);
    }

    public byte[] setString(IRecord record, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CString.fromString(record, value, this.length_);
    }

    public void setStringLength(int length) throws IllegalArgumentException {
        if (length < 1) {
            throw new IllegalArgumentException(Integer.toString(length));
        }
        Integer oldLength = new Integer(this.length_);
        this.length_ = length;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("stringLength", oldLength, new Integer(this.length_));
        }
    }

    public static boolean testConstantValue(IRecord record, byte[] fieldBytes, Object constantValue, int length) {
        String s;
        if (!(constantValue instanceof String)) {
            return false;
        }
        try {
            s = CString.toString(record, fieldBytes, length);
        }
        catch (RecordException recordException) {
            return false;
        }
        return s.equals((String)constantValue);
    }

    public static boolean testConstantValue(IRecord record, int fieldOffset, Object constantValue, int length) {
        String s;
        if (!(constantValue instanceof String)) {
            return false;
        }
        try {
            s = CString.toString(record, fieldOffset, length);
        }
        catch (RecordException recordException) {
            return false;
        }
        return s.equals((String)constantValue);
    }

    public static String toString(IRecord record, byte[] byteArray, int length) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
            String newString = new String(byteArray, recAttr.getCodePage());
            String resultString = newString.substring(0, newString.indexOf(0));
            return resultString;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RecordConversionUnsupportedException(ex.getMessage());
        }
    }

    public static String toString(IRecord record, int fieldOffset, int length) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            byte[] buf = new byte[length];
            System.arraycopy(record.getRawBytes(), fieldOffset, buf, 0, length);
            CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
            String newString = new String(buf, recAttr.getCodePage());
            String resultString = newString.substring(0, newString.indexOf(0));
            return resultString;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RecordConversionUnsupportedException(ex.getMessage());
        }
    }
}

