/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.ctypes;

import com.ibm.record.FixedLengthType;
import com.ibm.record.IRecord;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordException;
import com.ibm.record.ctypes.CLanguageRecordAttributes;
import com.ibm.record.ctypes.CTypeUtil;
import java.io.Serializable;
import java.math.BigDecimal;

public class CShort
extends FixedLengthType
implements Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = 1241993289414798622L;
    private static final int size_ = 2;

    public boolean canConvertFromByte() {
        return true;
    }

    public boolean canConvertFromChar() {
        return true;
    }

    public boolean canConvertFromObject() {
        return true;
    }

    public boolean canConvertFromShort() {
        return true;
    }

    public boolean canConvertFromString() {
        return true;
    }

    public boolean canConvertToBigDecimal() {
        return true;
    }

    public boolean canConvertToDouble() {
        return true;
    }

    public boolean canConvertToFloat() {
        return true;
    }

    public boolean canConvertToInt() {
        return true;
    }

    public boolean canConvertToLong() {
        return true;
    }

    public boolean canConvertToObject() {
        return true;
    }

    public boolean canConvertToShort() {
        return true;
    }

    public boolean canConvertToString() {
        return true;
    }

    public boolean checkConstantValue(IRecord record, byte[] fieldBytes, Object constantValue) {
        return CShort.testConstantValue(record, fieldBytes, constantValue);
    }

    public boolean checkConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        return CShort.testConstantValue(record, fieldOffset, constantValue);
    }

    public static void fromInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(initialValue instanceof Short)) {
            throw new RecordConversionUnsupportedException();
        }
        short s = (Short)initialValue;
        CShort.fromShort(record, fieldOffset, s);
    }

    public static byte[] fromInitialValue(IRecord record, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(initialValue instanceof Short)) {
            throw new RecordConversionUnsupportedException();
        }
        short s = (Short)initialValue;
        return CShort.fromShort(record, s);
    }

    public static void fromShort(IRecord record, int fieldOffset, short value) throws RecordConversionFailureException {
        byte[] tb = CTypeUtil.convertToByte(value);
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(tb);
        }
        System.arraycopy(tb, 0, record.getRawBytes(), fieldOffset, 2);
    }

    public static byte[] fromShort(IRecord record, short value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte[] tb = CTypeUtil.convertToByte(value);
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(tb);
        }
        return tb;
    }

    public int getAlignmentHint() {
        return 2;
    }

    public BigDecimal getBigDecimal(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        short shortValue = CShort.toShort(record, byteArray);
        return BigDecimal.valueOf(shortValue);
    }

    public BigDecimal getBigDecimal(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        short shortValue = CShort.toShort(record, fieldOffset);
        return BigDecimal.valueOf(shortValue);
    }

    public double getDouble(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CShort.toShort(record, byteArray);
    }

    public double getDouble(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CShort.toShort(record, fieldOffset);
    }

    public float getFloat(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CShort.toShort(record, byteArray);
    }

    public float getFloat(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CShort.toShort(record, fieldOffset);
    }

    public int getInt(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CShort.toShort(record, byteArray);
    }

    public int getInt(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CShort.toShort(record, fieldOffset);
    }

    public long getLong(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CShort.toShort(record, byteArray);
    }

    public long getLong(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CShort.toShort(record, fieldOffset);
    }

    public Object getObject(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        short s = CShort.toShort(record, byteArray);
        return new Short(s);
    }

    public Object getObject(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        short s = CShort.toShort(record, fieldOffset);
        return new Short(s);
    }

    public short getShort(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CShort.toShort(record, byteArray);
    }

    public short getShort(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CShort.toShort(record, fieldOffset);
    }

    public int getSize() {
        return 2;
    }

    public String getString(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        short value = CShort.toShort(record, byteArray);
        return Short.toString(value);
    }

    public String getString(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        short value = CShort.toShort(record, fieldOffset);
        return Short.toString(value);
    }

    public byte[] setByte(IRecord record, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CShort.fromShort(record, value);
    }

    public void setByte(IRecord record, int fieldOffset, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CShort.fromShort(record, fieldOffset, value);
    }

    public byte[] setChar(IRecord record, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CShort.fromShort(record, (short)value);
    }

    public void setChar(IRecord record, int fieldOffset, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CShort.fromShort(record, fieldOffset, (short)value);
    }

    public void setInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CShort.fromInitialValue(record, fieldOffset, initialValue);
    }

    public byte[] setInitialValue(IRecord record, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CShort.fromInitialValue(record, initialValue);
    }

    public void setObject(IRecord record, int fieldOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(value instanceof Short)) {
            throw new RecordConversionUnsupportedException();
        }
        short s = (Short)value;
        CShort.fromShort(record, fieldOffset, s);
    }

    public byte[] setObject(IRecord record, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(value instanceof Short)) {
            throw new RecordConversionUnsupportedException();
        }
        short s = (Short)value;
        return CShort.fromShort(record, s);
    }

    public void setShort(IRecord record, int fieldOffset, short value) throws RecordConversionFailureException {
        CShort.fromShort(record, fieldOffset, value);
    }

    public byte[] setShort(IRecord record, short value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CShort.fromShort(record, value);
    }

    public void setString(IRecord record, int fieldOffset, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            Short shortValue = Short.valueOf(value);
            CShort.fromShort(record, fieldOffset, shortValue);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public byte[] setString(IRecord record, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            Short shortValue = Short.valueOf(value);
            return CShort.fromShort(record, shortValue);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public static boolean testConstantValue(IRecord record, byte[] fieldBytes, Object constantValue) {
        short s;
        if (!(constantValue instanceof Short)) {
            return false;
        }
        short cv = (Short)constantValue;
        try {
            s = CShort.toShort(record, fieldBytes);
        }
        catch (RecordException recordException) {
            return false;
        }
        return cv == s;
    }

    public static boolean testConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        short s;
        if (!(constantValue instanceof Short)) {
            return false;
        }
        short cv = (Short)constantValue;
        try {
            s = CShort.toShort(record, fieldOffset);
        }
        catch (RecordException recordException) {
            return false;
        }
        return cv == s;
    }

    public static short toShort(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        byte[] sb = byteArray;
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(sb);
        }
        short i = CTypeUtil.convertFromByteToShort(sb);
        return i;
    }

    public static short toShort(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        byte[] sb = new byte[2];
        System.arraycopy(record.getRawBytes(), fieldOffset, sb, 0, 2);
        CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
        if (recAttr.getEndian() == 1) {
            CTypeUtil.endianSwap(sb);
        }
        short i = CTypeUtil.convertFromByteToShort(sb);
        return i;
    }
}

