/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.ctypes;

import com.ibm.record.FixedLengthType;
import com.ibm.record.IRecord;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordException;
import com.ibm.record.ctypes.CLanguageRecordAttributes;
import com.ibm.record.ctypes.CTypeUtil;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

public class CPadString
extends FixedLengthType
implements Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 2000.";
    static final long serialVersionUID = -4929400955219488083L;
    public static final char defaultPaddingChar = ' ';
    protected int length_;
    protected char paddingCharacter_;

    public CPadString() {
        this.setStringLength(1);
        this.setPaddingCharacter(' ');
    }

    public CPadString(char paddingCharacter) throws IllegalArgumentException {
        this.setStringLength(1);
        this.setPaddingCharacter(paddingCharacter);
    }

    public CPadString(char paddingCharacter, int stringLength) throws IllegalArgumentException {
        this.setStringLength(stringLength);
        this.setPaddingCharacter(paddingCharacter);
    }

    public CPadString(int stringLength) throws IllegalArgumentException {
        this.setStringLength(stringLength);
        this.setPaddingCharacter(' ');
    }

    public boolean canConvertFromBigDecimal() {
        return true;
    }

    public boolean canConvertFromByte() {
        return true;
    }

    public boolean canConvertFromChar() {
        return true;
    }

    public boolean canConvertFromDouble() {
        return true;
    }

    public boolean canConvertFromFloat() {
        return true;
    }

    public boolean canConvertFromInt() {
        return true;
    }

    public boolean canConvertFromLong() {
        return true;
    }

    public boolean canConvertFromObject() {
        return true;
    }

    public boolean canConvertFromShort() {
        return true;
    }

    public boolean canConvertFromString() {
        return true;
    }

    public boolean canConvertToBigDecimal() {
        return true;
    }

    public boolean canConvertToByte() {
        return true;
    }

    public boolean canConvertToChar() {
        return true;
    }

    public boolean canConvertToDouble() {
        return true;
    }

    public boolean canConvertToFloat() {
        return true;
    }

    public boolean canConvertToInt() {
        return true;
    }

    public boolean canConvertToLong() {
        return true;
    }

    public boolean canConvertToObject() {
        return true;
    }

    public boolean canConvertToShort() {
        return true;
    }

    public boolean canConvertToString() {
        return true;
    }

    public boolean checkConstantValue(IRecord record, byte[] fieldBytes, Object constantValue) {
        return CPadString.testConstantValue(record, fieldBytes, constantValue, this.length_, this.paddingCharacter_);
    }

    public boolean checkConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        return CPadString.testConstantValue(record, fieldOffset, constantValue, this.length_, this.paddingCharacter_);
    }

    public static void fromInitialValue(IRecord record, int fieldOffset, Object initialValue, int length, char paddingCharacter) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(initialValue instanceof String)) {
            throw new RecordConversionUnsupportedException();
        }
        CPadString.fromString(record, fieldOffset, (String)initialValue, length, paddingCharacter);
    }

    public static byte[] fromInitialValue(IRecord record, Object initialValue, int length, char paddingCharacter) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(initialValue instanceof String)) {
            throw new RecordConversionUnsupportedException();
        }
        return CPadString.fromString(record, (String)initialValue, length, paddingCharacter);
    }

    public static void fromString(IRecord record, int fieldOffset, String value, int length, char paddingCharacter) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String codePage = ((CLanguageRecordAttributes)record.getRecordAttributes()).getCodePage();
            byte[] tb = value.getBytes(codePage);
            if (tb.length > length) {
                throw new RecordConversionUnsupportedException(Integer.toString(tb.length));
            }
            byte[] recBytes = record.getRawBytes();
            System.arraycopy(tb, 0, recBytes, fieldOffset, tb.length);
            int padLength = length - tb.length;
            if (padLength > 0) {
                String spaceString = new Character(paddingCharacter).toString();
                byte[] spaceArray = spaceString.getBytes(codePage);
                CTypeUtil.fillBytes(spaceArray[0], recBytes, fieldOffset + tb.length, padLength);
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new RecordConversionUnsupportedException(ex.getMessage());
        }
    }

    public static byte[] fromString(IRecord record, String value, int length, char paddingCharacter) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String codePage = ((CLanguageRecordAttributes)record.getRecordAttributes()).getCodePage();
            byte[] tb = value.getBytes(codePage);
            if (tb.length > length) {
                throw new RecordConversionUnsupportedException(Integer.toString(tb.length));
            }
            int padLength = length - tb.length;
            byte[] byteArray = tb;
            if (padLength > 0) {
                String spaceString = new Character(paddingCharacter).toString();
                byte[] spaceArray = spaceString.getBytes(codePage);
                byteArray = new byte[length];
                System.arraycopy(tb, 0, byteArray, 0, tb.length);
                CTypeUtil.fillBytes(spaceArray[0], byteArray, tb.length, padLength);
            }
            return byteArray;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RecordConversionUnsupportedException(ex.getMessage());
        }
    }

    public int getAlignmentHint() {
        return 1;
    }

    public BigDecimal getBigDecimal(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String s = CPadString.toString(record, byteArray, this.length_, this.paddingCharacter_);
            return new BigDecimal(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public BigDecimal getBigDecimal(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String s = CPadString.toString(record, fieldOffset, this.length_, this.paddingCharacter_);
            return new BigDecimal(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public byte getByte(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String s = CPadString.toString(record, byteArray, this.length_, this.paddingCharacter_);
            return Byte.parseByte(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public byte getByte(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String s = CPadString.toString(record, fieldOffset, this.length_, this.paddingCharacter_);
            return Byte.parseByte(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public char getChar(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        String s = CPadString.toString(record, byteArray, this.length_, this.paddingCharacter_);
        if (s.length() != 1) {
            throw new RecordConversionFailureException(Integer.toString(s.length()));
        }
        return s.charAt(0);
    }

    public char getChar(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        String s = CPadString.toString(record, fieldOffset, this.length_, this.paddingCharacter_);
        if (s.length() != 1) {
            throw new RecordConversionFailureException(Integer.toString(s.length()));
        }
        return s.charAt(0);
    }

    public double getDouble(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String s = CPadString.toString(record, byteArray, this.length_, this.paddingCharacter_);
            return Double.parseDouble(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public double getDouble(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        try {
            String s = CPadString.toString(record, fieldOffset, this.length_, this.paddingCharacter_);
            return Double.parseDouble(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public float getFloat(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String s = CPadString.toString(record, byteArray, this.length_, this.paddingCharacter_);
            return Float.parseFloat(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public float getFloat(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        try {
            String s = CPadString.toString(record, fieldOffset, this.length_, this.paddingCharacter_);
            return Float.parseFloat(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public int getInt(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String s = CPadString.toString(record, byteArray, this.length_, this.paddingCharacter_);
            return Integer.parseInt(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public int getInt(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        try {
            String s = CPadString.toString(record, fieldOffset, this.length_, this.paddingCharacter_);
            return Integer.parseInt(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public long getLong(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String s = CPadString.toString(record, byteArray, this.length_, this.paddingCharacter_);
            return Long.parseLong(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public long getLong(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        try {
            String s = CPadString.toString(record, fieldOffset, this.length_, this.paddingCharacter_);
            return Long.parseLong(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public Object getObject(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        String s = CPadString.toString(record, byteArray, this.length_, this.paddingCharacter_);
        return s;
    }

    public Object getObject(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        String s = CPadString.toString(record, fieldOffset, this.length_, this.paddingCharacter_);
        return s;
    }

    public char getPaddingCharacter() {
        return this.paddingCharacter_;
    }

    public short getShort(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            String s = CPadString.toString(record, byteArray, this.length_, this.paddingCharacter_);
            return Short.parseShort(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public short getShort(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        try {
            String s = CPadString.toString(record, fieldOffset, this.length_, this.paddingCharacter_);
            return Short.parseShort(s);
        }
        catch (NumberFormatException exc) {
            throw new RecordConversionFailureException(exc.getMessage());
        }
    }

    public int getSize() {
        return this.length_;
    }

    public String getString(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CPadString.toString(record, byteArray, this.length_, this.paddingCharacter_);
    }

    public String getString(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CPadString.toString(record, fieldOffset, this.length_, this.paddingCharacter_);
    }

    public int getStringLength() {
        return this.length_;
    }

    public void setBigDecimal(IRecord record, int fieldOffset, BigDecimal value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CPadString.fromString(record, fieldOffset, value.toString(), this.length_, this.paddingCharacter_);
    }

    public byte[] setBigDecimal(IRecord record, BigDecimal value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CPadString.fromString(record, value.toString(), this.length_, this.paddingCharacter_);
    }

    public byte[] setByte(IRecord record, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CPadString.fromString(record, Byte.toString(value), this.length_, this.paddingCharacter_);
    }

    public void setByte(IRecord record, int fieldOffset, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CPadString.fromString(record, fieldOffset, Byte.toString(value), this.length_, this.paddingCharacter_);
    }

    public byte[] setChar(IRecord record, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CPadString.fromString(record, new Character(value).toString(), this.length_, this.paddingCharacter_);
    }

    public void setChar(IRecord record, int fieldOffset, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CPadString.fromString(record, fieldOffset, new Character(value).toString(), this.length_, this.paddingCharacter_);
    }

    public byte[] setDouble(IRecord record, double value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CPadString.fromString(record, Double.toString(value), this.length_, this.paddingCharacter_);
    }

    public void setDouble(IRecord record, int fieldOffset, double value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CPadString.fromString(record, fieldOffset, Double.toString(value), this.length_, this.paddingCharacter_);
    }

    public byte[] setFloat(IRecord record, float value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CPadString.fromString(record, Float.toString(value), this.length_, this.paddingCharacter_);
    }

    public void setFloat(IRecord record, int fieldOffset, float value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CPadString.fromString(record, fieldOffset, Float.toString(value), this.length_, this.paddingCharacter_);
    }

    public void setInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CPadString.fromInitialValue(record, fieldOffset, initialValue, this.length_, this.paddingCharacter_);
    }

    public byte[] setInitialValue(IRecord record, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CPadString.fromInitialValue(record, initialValue, this.length_, this.paddingCharacter_);
    }

    public byte[] setInt(IRecord record, int value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CPadString.fromString(record, Integer.toString(value), this.length_, this.paddingCharacter_);
    }

    public void setInt(IRecord record, int fieldOffset, int value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CPadString.fromString(record, fieldOffset, Integer.toString(value), this.length_, this.paddingCharacter_);
    }

    public void setLong(IRecord record, int fieldOffset, long value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CPadString.fromString(record, fieldOffset, Long.toString(value), this.length_, this.paddingCharacter_);
    }

    public byte[] setLong(IRecord record, long value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CPadString.fromString(record, Long.toString(value), this.length_, this.paddingCharacter_);
    }

    public void setObject(IRecord record, int fieldOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(value instanceof String)) {
            throw new RecordConversionUnsupportedException();
        }
        CPadString.fromString(record, fieldOffset, (String)value, this.length_, this.paddingCharacter_);
    }

    public byte[] setObject(IRecord record, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(value instanceof String)) {
            throw new RecordConversionUnsupportedException();
        }
        return CPadString.fromString(record, (String)value, this.length_, this.paddingCharacter_);
    }

    public void setPaddingCharacter(char paddingCharacter) throws IllegalArgumentException {
        if (paddingCharacter > '\u00ff') {
            throw new IllegalArgumentException(new Character(paddingCharacter).toString());
        }
        Character oldPad = new Character(this.paddingCharacter_);
        this.paddingCharacter_ = paddingCharacter;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("paddingCharacter", oldPad, new Character(this.paddingCharacter_));
        }
    }

    public void setShort(IRecord record, int fieldOffset, short value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CPadString.fromString(record, fieldOffset, Short.toString(value), this.length_, this.paddingCharacter_);
    }

    public byte[] setShort(IRecord record, short value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CPadString.fromString(record, Short.toString(value), this.length_, this.paddingCharacter_);
    }

    public void setString(IRecord record, int fieldOffset, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CPadString.fromString(record, fieldOffset, value, this.length_, this.paddingCharacter_);
    }

    public byte[] setString(IRecord record, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CPadString.fromString(record, value, this.length_, this.paddingCharacter_);
    }

    public void setStringLength(int length) throws IllegalArgumentException {
        if (length < 1) {
            throw new IllegalArgumentException(Integer.toString(length));
        }
        Integer oldLength = new Integer(this.length_);
        this.length_ = length;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("stringLength", oldLength, new Integer(this.length_));
        }
    }

    public static boolean testConstantValue(IRecord record, byte[] fieldBytes, Object constantValue, int length, char paddingCharacter) {
        String s;
        if (!(constantValue instanceof String)) {
            return false;
        }
        try {
            s = CPadString.toString(record, fieldBytes, length, paddingCharacter);
        }
        catch (RecordException recordException) {
            return false;
        }
        return s.equals((String)constantValue);
    }

    public static boolean testConstantValue(IRecord record, int fieldOffset, Object constantValue, int length, char paddingCharacter) {
        String s;
        if (!(constantValue instanceof String)) {
            return false;
        }
        try {
            s = CPadString.toString(record, fieldOffset, length, paddingCharacter);
        }
        catch (RecordException recordException) {
            return false;
        }
        return s.equals((String)constantValue);
    }

    public static String toString(IRecord record, byte[] byteArray, int length, char paddingCharacter) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
            String resultString = new String(byteArray, recAttr.getCodePage());
            return resultString;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RecordConversionUnsupportedException(ex.getMessage());
        }
    }

    public static String toString(IRecord record, int fieldOffset, int length, char paddingCharacter) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            byte[] buf = new byte[length];
            System.arraycopy(record.getRawBytes(), fieldOffset, buf, 0, length);
            CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
            String resultString = new String(buf, recAttr.getCodePage());
            return resultString;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RecordConversionUnsupportedException(ex.getMessage());
        }
    }
}

