/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record.ctypes;

import com.ibm.record.FixedLengthType;
import com.ibm.record.IRecord;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordException;
import com.ibm.record.ctypes.CLanguageRecordAttributes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

public class CChar
extends FixedLengthType
implements Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = -7168252162263490722L;
    private static final int size_ = 1;

    public boolean canConvertFromByte() {
        return true;
    }

    public boolean canConvertFromChar() {
        return true;
    }

    public boolean canConvertFromObject() {
        return true;
    }

    public boolean canConvertFromString() {
        return true;
    }

    public boolean canConvertToBigDecimal() {
        return true;
    }

    public boolean canConvertToChar() {
        return true;
    }

    public boolean canConvertToDouble() {
        return true;
    }

    public boolean canConvertToFloat() {
        return true;
    }

    public boolean canConvertToInt() {
        return true;
    }

    public boolean canConvertToLong() {
        return true;
    }

    public boolean canConvertToObject() {
        return true;
    }

    public boolean canConvertToShort() {
        return true;
    }

    public boolean canConvertToString() {
        return true;
    }

    public boolean checkConstantValue(IRecord record, byte[] fieldBytes, Object constantValue) {
        return CChar.testConstantValue(record, fieldBytes, constantValue);
    }

    public boolean checkConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        return CChar.testConstantValue(record, fieldOffset, constantValue);
    }

    public static byte[] fromChar(IRecord record, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
            CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
            OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)outBuffer, recAttr.getCodePage());
            outWriter.write(value);
            outWriter.flush();
            byte[] tb = outBuffer.toByteArray();
            return tb;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RecordConversionUnsupportedException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new RecordConversionFailureException(ex.getMessage());
        }
    }

    public static void fromChar(IRecord record, int fieldOffset, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
            CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
            OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)outBuffer, recAttr.getCodePage());
            outWriter.write(value);
            outWriter.flush();
            byte[] tb = outBuffer.toByteArray();
            System.arraycopy(tb, 0, record.getRawBytes(), fieldOffset, 1);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RecordConversionUnsupportedException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new RecordConversionFailureException(ex.getMessage());
        }
    }

    public static void fromInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(initialValue instanceof Character)) {
            throw new RecordConversionUnsupportedException();
        }
        char c = ((Character)initialValue).charValue();
        CChar.fromChar(record, fieldOffset, c);
    }

    public static byte[] fromInitialValue(IRecord record, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(initialValue instanceof Character)) {
            throw new RecordConversionUnsupportedException();
        }
        char c = ((Character)initialValue).charValue();
        return CChar.fromChar(record, c);
    }

    public int getAlignmentHint() {
        return 1;
    }

    public BigDecimal getBigDecimal(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        char charValue = CChar.toChar(record, byteArray);
        return BigDecimal.valueOf(charValue);
    }

    public BigDecimal getBigDecimal(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        char charValue = CChar.toChar(record, fieldOffset);
        return BigDecimal.valueOf(charValue);
    }

    public char getChar(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CChar.toChar(record, byteArray);
    }

    public char getChar(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CChar.toChar(record, fieldOffset);
    }

    public double getDouble(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CChar.toChar(record, byteArray);
    }

    public double getDouble(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CChar.toChar(record, fieldOffset);
    }

    public float getFloat(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CChar.toChar(record, byteArray);
    }

    public float getFloat(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CChar.toChar(record, fieldOffset);
    }

    public int getInt(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CChar.toChar(record, byteArray);
    }

    public int getInt(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CChar.toChar(record, fieldOffset);
    }

    public long getLong(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CChar.toChar(record, byteArray);
    }

    public long getLong(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return CChar.toChar(record, fieldOffset);
    }

    public Object getObject(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        char c = CChar.toChar(record, byteArray);
        return new Character(c);
    }

    public Object getObject(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        char c = CChar.toChar(record, fieldOffset);
        return new Character(c);
    }

    public short getShort(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return (short)CChar.toChar(record, byteArray);
    }

    public short getShort(IRecord record, int fieldOffset) throws RecordConversionFailureException {
        return (short)CChar.toChar(record, fieldOffset);
    }

    public int getSize() {
        return 1;
    }

    public String getString(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        char c = CChar.toChar(record, byteArray);
        return new Character(c).toString();
    }

    public String getString(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        char c = CChar.toChar(record, fieldOffset);
        return new Character(c).toString();
    }

    public byte[] setByte(IRecord record, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CChar.fromChar(record, (char)value);
    }

    public void setByte(IRecord record, int fieldOffset, byte value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CChar.fromChar(record, fieldOffset, (char)value);
    }

    public byte[] setChar(IRecord record, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CChar.fromChar(record, value);
    }

    public void setChar(IRecord record, int fieldOffset, char value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CChar.fromChar(record, fieldOffset, value);
    }

    public void setInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        CChar.fromInitialValue(record, fieldOffset, initialValue);
    }

    public byte[] setInitialValue(IRecord record, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        return CChar.fromInitialValue(record, initialValue);
    }

    public void setObject(IRecord record, int fieldOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(value instanceof Character)) {
            throw new RecordConversionUnsupportedException();
        }
        char c = ((Character)value).charValue();
        CChar.fromChar(record, fieldOffset, c);
    }

    public byte[] setObject(IRecord record, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (!(value instanceof Character)) {
            throw new RecordConversionUnsupportedException();
        }
        char c = ((Character)value).charValue();
        return CChar.fromChar(record, c);
    }

    public void setString(IRecord record, int fieldOffset, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        int strLength = value.length();
        if (strLength != 1) {
            throw new RecordConversionFailureException(Integer.toString(strLength));
        }
        char charValue = value.charAt(0);
        CChar.fromChar(record, fieldOffset, charValue);
    }

    public byte[] setString(IRecord record, String value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        int strLength = value.length();
        if (strLength != 1) {
            throw new RecordConversionFailureException(Integer.toString(strLength));
        }
        char charValue = value.charAt(0);
        return CChar.fromChar(record, charValue);
    }

    public static boolean testConstantValue(IRecord record, byte[] fieldBytes, Object constantValue) {
        char c;
        if (!(constantValue instanceof Character)) {
            return false;
        }
        char cv = ((Character)constantValue).charValue();
        try {
            c = CChar.toChar(record, fieldBytes);
        }
        catch (RecordException recordException) {
            return false;
        }
        return cv == c;
    }

    public static boolean testConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        char c;
        if (!(constantValue instanceof Character)) {
            return false;
        }
        char cv = ((Character)constantValue).charValue();
        try {
            c = CChar.toChar(record, fieldOffset);
        }
        catch (RecordException recordException) {
            return false;
        }
        return cv == c;
    }

    public static char toChar(IRecord record, byte[] byteArray) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            ByteArrayInputStream inBuffer = new ByteArrayInputStream(byteArray, 0, 1);
            CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
            InputStreamReader inReader = new InputStreamReader((InputStream)inBuffer, recAttr.getCodePage());
            int i = inReader.read();
            if (i == -1) {
                throw new RecordConversionFailureException();
            }
            return (char)i;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RecordConversionUnsupportedException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new RecordConversionFailureException(ex.getMessage());
        }
    }

    public static char toChar(IRecord record, int fieldOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        try {
            ByteArrayInputStream inBuffer = new ByteArrayInputStream(record.getRawBytes(), fieldOffset, 1);
            CLanguageRecordAttributes recAttr = (CLanguageRecordAttributes)record.getRecordAttributes();
            InputStreamReader inReader = new InputStreamReader((InputStream)inBuffer, recAttr.getCodePage());
            int i = inReader.read();
            if (i == -1) {
                throw new RecordConversionFailureException();
            }
            return (char)i;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RecordConversionUnsupportedException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new RecordConversionFailureException(ex.getMessage());
        }
    }
}

