/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.AnyDynamicRecordType;
import com.ibm.record.IAnyComposedType;
import com.ibm.record.IAnyDynamicRecordType;
import com.ibm.record.IAnyField;
import com.ibm.record.IAnyType;
import com.ibm.record.IFieldEnumeration;
import com.ibm.record.INestedRecordField;
import com.ibm.record.IRecord;
import com.ibm.record.IRecordAttributes;
import com.ibm.record.IVariableLengthRecordType;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordFieldNameAlreadyExistsException;
import com.ibm.record.RecordFieldNameNotSetException;
import com.ibm.record.RecordFieldNotFoundException;
import com.ibm.record.RecordFieldTypeNotValidException;
import com.ibm.record.TypeData;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public abstract class VariableLengthRecordType
extends AnyDynamicRecordType
implements IVariableLengthRecordType,
Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = 8045021664854942763L;
    protected int size_;
    protected int alignmentHint_;

    public VariableLengthRecordType() {
        this.size_ = -1;
        this.alignmentHint_ = 1;
    }

    public VariableLengthRecordType(int size) {
        this.size_ = size;
        this.alignmentHint_ = 1;
    }

    public VariableLengthRecordType(int alignmentHint, int packingHint) {
        super(packingHint);
        this.alignmentHint_ = alignmentHint;
        this.size_ = -1;
    }

    public VariableLengthRecordType(int alignmentHint, int packingHint, int size) {
        super(packingHint);
        this.alignmentHint_ = alignmentHint;
        this.size_ = size;
    }

    public void addField(IAnyField field) throws RecordFieldTypeNotValidException, RecordFieldNameAlreadyExistsException, RecordFieldNameNotSetException {
        if (field.getFieldKind() == 0) {
            if (field instanceof INestedRecordField) {
                this.propagateFieldKind((INestedRecordField)field, 1);
            } else {
                field.setFieldKind(1);
            }
        }
        super.addField(field);
    }

    public void addFieldAfter(IAnyField field, String fieldName) throws RecordFieldTypeNotValidException, RecordFieldNotFoundException, RecordFieldNameAlreadyExistsException, RecordFieldNameNotSetException {
        if (field.getFieldKind() == 0) {
            field.setFieldKind(1);
            if (field instanceof INestedRecordField) {
                this.propagateFieldKind((INestedRecordField)field, 1);
            }
        }
        super.addFieldAfter(field, fieldName);
    }

    public void addFieldAsFirst(IAnyField field) throws RecordFieldTypeNotValidException, RecordFieldNameAlreadyExistsException, RecordFieldNameNotSetException {
        if (field.getFieldKind() == 0) {
            field.setFieldKind(1);
            if (field instanceof INestedRecordField) {
                this.propagateFieldKind((INestedRecordField)field, 1);
            }
        }
        super.addFieldAsFirst(field);
    }

    public boolean canConvertFromObject() {
        return true;
    }

    public boolean canConvertToObject() {
        return true;
    }

    public Object clone() {
        VariableLengthRecordType newType = (VariableLengthRecordType)super.clone();
        return newType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VariableLengthRecordType)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        VariableLengthRecordType tmpType = (VariableLengthRecordType)obj;
        if (this.size_ != tmpType.size_) {
            return false;
        }
        return this.alignmentHint_ == tmpType.alignmentHint_;
    }

    public int getAlignmentHint() {
        return this.alignmentHint_;
    }

    public Object getObject(IRecord record, byte[] byteArray) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        try {
            IRecordAttributes recAttr = (IRecordAttributes)record.getRecordAttributes().clone();
            IVariableLengthRecordType recType = (IVariableLengthRecordType)this.clone();
            IRecord returnRecord = null;
            returnRecord = recType.getClass().getName().indexOf(36) == -1 ? recType.newRecord(recAttr, 0, 0) : recType.newRecord(recAttr, 0, 0, record);
            Vector<byte[]> bufferVec = new Vector<byte[]>();
            IFieldEnumeration cursor = this.fields();
            while (cursor.hasMoreFields()) {
                IAnyField field = cursor.nextField();
                bufferVec.addElement(field.getBytes(returnRecord));
            }
            int size = 0;
            Enumeration cursor2 = bufferVec.elements();
            while (cursor2.hasMoreElements()) {
                byte[] buf = (byte[])cursor2.nextElement();
                size += buf.length;
            }
            int offset = 0;
            byte[] bytes = new byte[size];
            Enumeration cursor3 = bufferVec.elements();
            while (cursor3.hasMoreElements()) {
                byte[] buf = (byte[])cursor3.nextElement();
                System.arraycopy(buf, 0, bytes, offset, buf.length);
                offset += buf.length;
            }
            bytes = this.packageBytes(returnRecord, bytes);
            returnRecord.setBytes(bytes);
            return returnRecord;
        }
        catch (Exception exception) {
            throw new RecordConversionFailureException();
        }
    }

    public abstract Class getRecordAttributesClass();

    public int getSize() {
        return this.size_;
    }

    public boolean hasFixedSize() {
        return this.size_ >= 0;
    }

    public void pack(int startingOffset) {
        IFieldEnumeration cursor = this.fields();
        while (cursor.hasMoreFields()) {
            IAnyField field = cursor.nextField();
            IAnyType type = field.getType();
            if (!(type instanceof IAnyComposedType)) continue;
            ((IAnyComposedType)type).pack(startingOffset);
        }
    }

    public abstract byte[] packageBytes(IRecord var1, byte[] var2);

    private void propagateFieldKind(INestedRecordField field, int fieldKind) {
        IFieldEnumeration cursor = ((IAnyDynamicRecordType)field.getType()).fields();
        while (cursor.hasMoreFields()) {
            IAnyField aField = cursor.nextField();
            if (aField.getFieldKind() != 0) continue;
            if (aField instanceof INestedRecordField) {
                this.propagateFieldKind((INestedRecordField)aField, 1);
                continue;
            }
            aField.setFieldKind(1);
        }
    }

    public abstract TypeData retrieveBytes(IRecord var1, byte[] var2, int var3);

    public void setAlignmentHint(int alignmentHint) {
        int oldAlignHint = this.alignmentHint_;
        this.alignmentHint_ = alignmentHint;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("alignmentHint", new Integer(oldAlignHint), new Integer(this.alignmentHint_));
        }
    }

    public void setSize(int size) {
        int oldSize = this.size_;
        this.size_ = size;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("size", new Integer(oldSize), new Integer(this.size_));
        }
    }
}

