/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.IRangeObject;

public class ShortRange
implements IRangeObject {
    private static String copyright = "(c) Copyright IBM Corporation 1999.";
    static final long serialVersionUID = 5533999846555242362L;
    protected short lowerRange_;
    protected short upperRange_;

    public ShortRange() {
        this.lowerRange_ = 0;
        this.upperRange_ = 0;
    }

    public ShortRange(short lowerRange, short upperRange) throws IllegalArgumentException {
        if (upperRange < lowerRange) {
            throw new IllegalArgumentException(Short.toString(upperRange));
        }
        this.lowerRange_ = lowerRange;
        this.upperRange_ = upperRange;
    }

    public Object clone() {
        try {
            ShortRange newType = (ShortRange)super.clone();
            return newType;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShortRange)) {
            return false;
        }
        ShortRange tmpRange = (ShortRange)obj;
        if (this.lowerRange_ != tmpRange.lowerRange_) {
            return false;
        }
        return this.upperRange_ == tmpRange.upperRange_;
    }

    public Object getLowerRange() {
        return new Short(this.lowerRange_);
    }

    public Object getUpperRange() {
        return new Short(this.upperRange_);
    }

    public boolean isInRange(Object value) {
        if (!(value instanceof Short)) {
            return false;
        }
        short shortVal = (Short)value;
        return ShortRange.isInRange(this.lowerRange_, this.upperRange_, shortVal);
    }

    public static boolean isInRange(short lowerRange, short upperRange, short value) throws IllegalArgumentException {
        if (upperRange < lowerRange) {
            throw new IllegalArgumentException(Short.toString(upperRange));
        }
        return value >= lowerRange && value <= upperRange;
    }

    public void setLowerRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof Short)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.lowerRange_ = (Short)value;
    }

    public void setUpperRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof Short)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.upperRange_ = (Short)value;
    }
}

