/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.FixedLengthType;
import java.io.Serializable;

public class PaddingType
extends FixedLengthType
implements Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = 5466279821109010210L;
    private int size_;

    public PaddingType() {
        this.size_ = 0;
    }

    public PaddingType(int length) throws IllegalArgumentException {
        if (length <= 0) {
            throw new IllegalArgumentException(Integer.toString(length));
        }
        this.size_ = length;
    }

    public Object clone() {
        PaddingType newType = (PaddingType)super.clone();
        return newType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PaddingType)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        PaddingType tmpType = (PaddingType)obj;
        return this.size_ == tmpType.size_;
    }

    public int getAlignmentHint() {
        return 1;
    }

    public int getLength() {
        return this.size_;
    }

    public int getSize() {
        return this.size_;
    }

    public void setLength(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException(Integer.toString(length));
        }
        int oldLength = this.size_;
        this.size_ = length;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("length", new Integer(oldLength), new Integer(this.size_));
        }
    }
}

