/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.AnyField;
import com.ibm.record.IAnyDynamicRecordType;
import com.ibm.record.IAnyField;
import com.ibm.record.IAnyType;
import com.ibm.record.IFieldEnumeration;
import com.ibm.record.IFixedLengthRecordType;
import com.ibm.record.IFixedLengthType;
import com.ibm.record.INestedRecordField;
import com.ibm.record.IOverlayType;
import com.ibm.record.IRecord;
import com.ibm.record.IVariableLengthRecordType;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordFieldTypeNotValidException;
import com.ibm.record.TypeData;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class NestedRecordField
extends AnyField
implements INestedRecordField,
Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = -1356340806655987342L;
    protected IAnyDynamicRecordType fieldType_;
    protected int fieldKind_;

    private NestedRecordField() {
        this.fieldType_ = null;
    }

    public NestedRecordField(IAnyDynamicRecordType type) throws RecordFieldTypeNotValidException {
        this.setType(type);
    }

    public NestedRecordField(IAnyDynamicRecordType type, String name) throws RecordFieldTypeNotValidException {
        super(name);
        this.setType(type);
    }

    public boolean checkConstantValue(IRecord record, int parentOffset) {
        IFieldEnumeration cursor = this.fieldType_.fields();
        while (cursor.hasMoreFields()) {
            IAnyField field = cursor.nextField();
            if (field.checkConstantValue(record, parentOffset + this.relativeOffset_)) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        NestedRecordField newType = (NestedRecordField)super.clone();
        if (this.fieldType_ != null) {
            newType.fieldType_ = (IAnyDynamicRecordType)this.fieldType_.clone();
        }
        return newType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NestedRecordField)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        NestedRecordField tmpField = (NestedRecordField)obj;
        if (this.fieldKind_ != tmpField.fieldKind_) {
            return false;
        }
        if (this.fieldType_ == null ^ tmpField.fieldType_ == null) {
            return false;
        }
        if (this.fieldType_ == null) {
            return true;
        }
        return this.fieldType_.equals(tmpField.fieldType_);
    }

    public byte[] getBytes(IRecord record) {
        if (record.getRecordKind() == 1 || record.getRecordKind() == 0) {
            return null;
        }
        Vector<byte[]> bufferVec = new Vector<byte[]>();
        IFieldEnumeration cursor = ((IAnyDynamicRecordType)this.getType()).fields();
        while (cursor.hasMoreFields()) {
            IAnyField field = cursor.nextField();
            bufferVec.addElement(field.getBytes(record));
        }
        byte[] fieldBytes = null;
        if (this.getFieldKind() != 0) {
            int size = 0;
            Enumeration cursor2 = bufferVec.elements();
            while (cursor2.hasMoreElements()) {
                byte[] buf = (byte[])cursor2.nextElement();
                size += buf.length;
            }
            fieldBytes = new byte[size];
            int offset = 0;
            Enumeration cursor3 = bufferVec.elements();
            while (cursor3.hasMoreElements()) {
                byte[] buf = (byte[])cursor3.nextElement();
                System.arraycopy(buf, 0, fieldBytes, offset, buf.length);
                offset += buf.length;
            }
        } else {
            fieldBytes = new byte[this.getSize()];
            Enumeration cursor4 = bufferVec.elements();
            IFieldEnumeration fieldCursor = ((IAnyDynamicRecordType)this.getType()).fields();
            while (cursor4.hasMoreElements() && fieldCursor.hasMoreFields()) {
                byte[] buf = (byte[])cursor4.nextElement();
                IAnyField field = fieldCursor.nextField();
                if (buf == null) continue;
                System.arraycopy(buf, 0, fieldBytes, field.getRelativeOffset(), buf.length);
            }
        }
        fieldBytes = this.getType().packageBytes(record, fieldBytes);
        return fieldBytes;
    }

    public Object getObject(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.cacheValues(record)) {
            return this.fieldType_.getObject(record, this.byteCache_);
        }
        int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
        return ((IFixedLengthType)((Object)this.fieldType_)).getObject(record, offset);
    }

    public int getSize() {
        return this.fieldType_.getSize();
    }

    public IAnyType getType() {
        return this.fieldType_;
    }

    public boolean hasInitialValue() {
        IFieldEnumeration cursor = this.fieldType_.fields();
        if (cursor.hasMoreFields()) {
            IAnyField field = cursor.nextField();
            field.hasInitialValue();
            return true;
        }
        return false;
    }

    public int setBytes(IRecord record, byte[] byteArray, int currentOffset) {
        int offset = currentOffset;
        int numBytesUsed = 0;
        switch (record.getRecordKind()) {
            case 0: 
            case 1: {
                numBytesUsed = this.getSize();
                break;
            }
            case 2: {
                TypeData data = this.getType().retrieveBytes(record, byteArray, currentOffset);
                numBytesUsed = data.numBytesUsed_;
                offset = 0;
                IFieldEnumeration cursor = ((IAnyDynamicRecordType)this.getType()).fields();
                while (cursor.hasMoreFields()) {
                    IAnyField field = cursor.nextField();
                    if (this.getFieldKind() == 0) {
                        offset += field.setBytes(record, data.bytes_, field.getRelativeOffset());
                        continue;
                    }
                    offset += field.setBytes(record, data.bytes_, offset);
                }
                break;
            }
            case 3: {
                numBytesUsed = this.getSize();
                TypeData data = this.getType().retrieveBytes(record, byteArray, currentOffset);
                offset = 0;
                IFieldEnumeration cursor = ((IAnyDynamicRecordType)this.getType()).fields();
                while (cursor.hasMoreFields()) {
                    IAnyField field = cursor.nextField();
                    if (this.fieldKind_ != 0 || field instanceof INestedRecordField) {
                        offset += field.setBytes(record, data.bytes_, offset);
                        continue;
                    }
                    offset += field.getSize();
                }
                break;
            }
        }
        return numBytesUsed;
    }

    public void setInitialValue(IRecord record, int parentOffset) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        IFieldEnumeration cursor = this.fieldType_.fields();
        while (cursor.hasMoreFields()) {
            IAnyField field = cursor.nextField();
            field.setInitialValue(record, parentOffset + this.relativeOffset_);
        }
    }

    public void setObject(IRecord record, int parentOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.isReadOnly()) {
            throw new RecordConversionUnsupportedException();
        }
        if (this.cacheValues(record)) {
            this.byteCache_ = this.fieldType_.setObject(record, value);
        } else {
            int offset = this.relativeOffset_ + parentOffset + record.getStartingOffset();
            ((IFixedLengthType)((Object)this.fieldType_)).setObject(record, offset, value);
        }
    }

    public void setType(IAnyType type) throws RecordFieldTypeNotValidException {
        if (!(type instanceof IAnyDynamicRecordType) || type instanceof IOverlayType) {
            throw new RecordFieldTypeNotValidException(type.getClass().getName());
        }
        IAnyDynamicRecordType oldType = this.fieldType_;
        this.fieldType_ = (IAnyDynamicRecordType)type;
        if (this.fieldType_ instanceof IFixedLengthRecordType) {
            this.setFieldKind(0);
        } else if (((IVariableLengthRecordType)this.fieldType_).hasFixedSize()) {
            this.setFieldKind(2);
        } else {
            this.setFieldKind(1);
        }
        this.setInitialValue(null);
        this.setConstantValue(null);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("type", oldType, this.fieldType_);
        }
    }
}

