/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.IRangeObject;

public class LongRange
implements IRangeObject {
    private static String copyright = "(c) Copyright IBM Corporation 1999.";
    static final long serialVersionUID = -4163203380347322298L;
    protected long lowerRange_;
    protected long upperRange_;

    public LongRange() {
        this.lowerRange_ = 0L;
        this.upperRange_ = 0L;
    }

    public LongRange(long lowerRange, long upperRange) throws IllegalArgumentException {
        if (upperRange < lowerRange) {
            throw new IllegalArgumentException(Long.toString(upperRange));
        }
        this.lowerRange_ = lowerRange;
        this.upperRange_ = upperRange;
    }

    public Object clone() {
        try {
            LongRange newType = (LongRange)super.clone();
            return newType;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongRange)) {
            return false;
        }
        LongRange tmpRange = (LongRange)obj;
        if (this.lowerRange_ != tmpRange.lowerRange_) {
            return false;
        }
        return this.upperRange_ == tmpRange.upperRange_;
    }

    public Object getLowerRange() {
        return new Long(this.lowerRange_);
    }

    public Object getUpperRange() {
        return new Long(this.upperRange_);
    }

    public static boolean isInRange(long lowerRange, long upperRange, long value) throws IllegalArgumentException {
        if (upperRange < lowerRange) {
            throw new IllegalArgumentException(Long.toString(upperRange));
        }
        return value >= lowerRange && value <= upperRange;
    }

    public boolean isInRange(Object value) {
        if (!(value instanceof Long)) {
            return false;
        }
        long longVal = (Long)value;
        return LongRange.isInRange(this.lowerRange_, this.upperRange_, longVal);
    }

    public void setLowerRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof Long)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.lowerRange_ = (Long)value;
    }

    public void setUpperRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof Long)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.upperRange_ = (Long)value;
    }
}

