/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.FieldData;
import com.ibm.record.IAnyComposedType;
import com.ibm.record.IAnyDynamicRecordType;
import com.ibm.record.IAnyField;
import com.ibm.record.IArrayField;
import com.ibm.record.IArrayType;
import com.ibm.record.IDynamicRecord;
import com.ibm.record.IFieldEnumeration;
import com.ibm.record.IFixedLengthType;
import com.ibm.record.INestedRecordField;
import com.ibm.record.IOverlayField;
import com.ibm.record.IOverlayType;
import com.ibm.record.IRangeObject;
import com.ibm.record.IRecord;
import com.ibm.record.IRecordAttributes;
import com.ibm.record.IRecordType;
import com.ibm.record.IVariableLengthRecordType;
import com.ibm.record.IVariableSizeArrayDimensionField;
import com.ibm.record.Record;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordException;
import com.ibm.record.RecordFieldNotFoundException;
import com.ibm.record.RecordPossibleValueKeyNotFoundException;
import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigDecimal;

public class DynamicRecord
extends Record
implements IDynamicRecord,
Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = -3117498659791970220L;
    protected IAnyDynamicRecordType recordType_;
    protected int recordKind_;

    protected DynamicRecord() {
        this.recordType_ = null;
        this.recordKind_ = 1;
    }

    public DynamicRecord(IAnyDynamicRecordType recordType) {
        this.setRecordType(recordType);
        try {
            this.setRecordAttributes((IRecordAttributes)recordType.getRecordAttributesClass().newInstance());
        }
        catch (IllegalAccessException ex) {
            throw new InternalError(ex.getMessage());
        }
        catch (InstantiationException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public DynamicRecord(IAnyDynamicRecordType recordType, byte[] bytes) {
        this.setRecordType(recordType);
        try {
            this.setRecordAttributes((IRecordAttributes)recordType.getRecordAttributesClass().newInstance());
        }
        catch (IllegalAccessException ex) {
            throw new InternalError(ex.getMessage());
        }
        catch (InstantiationException ex) {
            throw new InternalError(ex.getMessage());
        }
        this.setBytes(bytes);
    }

    public DynamicRecord(IAnyDynamicRecordType recordType, byte[] bytes, IRecordAttributes attributes, int startingOffset, int alignmentOffset) throws IllegalArgumentException, RecordException {
        super(bytes, attributes, startingOffset, alignmentOffset);
        this.setRecordType(recordType);
    }

    public DynamicRecord(IAnyDynamicRecordType recordType, IRecordAttributes attributes, int startingOffset, int alignmentOffset) throws IllegalArgumentException, RecordException {
        super(attributes, startingOffset, alignmentOffset);
        this.setRecordType(recordType);
    }

    public boolean checkBytes(byte[] theBytes) {
        if (theBytes == null) {
            return false;
        }
        byte[] currBytes = this.getBytes();
        this.disableNotification();
        this.setBytes(theBytes);
        if (this.getRecordKind() != 2 && this.getSize() != theBytes.length) {
            this.setBytes(currBytes);
            this.enableNotification();
            return false;
        }
        IFieldEnumeration cursor = this.recordType_.fields();
        while (cursor.hasMoreFields()) {
            IAnyField field = cursor.nextField();
            if (field.checkConstantValue(this, 0)) continue;
            this.setBytes(currBytes);
            this.enableNotification();
            return false;
        }
        this.setBytes(currBytes);
        this.enableNotification();
        return true;
    }

    public Object clone() {
        DynamicRecord newType = (DynamicRecord)super.clone();
        if (this.recordType_ != null) {
            newType.recordType_ = (IAnyDynamicRecordType)this.recordType_.clone();
        }
        return newType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DynamicRecord)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DynamicRecord tmpRec = (DynamicRecord)obj;
        if (this.recordKind_ != tmpRec.recordKind_) {
            return false;
        }
        if (this.recordType_ == null ^ tmpRec.recordType_ == null) {
            return false;
        }
        if (this.recordType_ == null) {
            return true;
        }
        return this.recordType_.equals(tmpRec.recordType_);
    }

    public Object getArray(String[] fieldNames, Class componentType) throws RecordFieldNotFoundException, RecordConversionUnsupportedException, RecordConversionFailureException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getArray(this, data.parentOffset_, componentType);
    }

    public Object getArray(String fieldName, Class componentType) throws RecordFieldNotFoundException, RecordConversionUnsupportedException, RecordConversionFailureException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getArray(this, 0, componentType);
    }

    public BigDecimal getBigDecimal(String[] fieldNames) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return data.field_.getBigDecimal(this, data.parentOffset_);
    }

    public BigDecimal getBigDecimal(String[] fieldNames, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getBigDecimal((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public BigDecimal getBigDecimal(String[] fieldNames, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getBigDecimal((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public BigDecimal getBigDecimal(String fieldName) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        return recField.getBigDecimal(this, 0);
    }

    public BigDecimal getBigDecimal(String fieldName, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getBigDecimal((IRecord)this, 0, arrayIndex);
    }

    public BigDecimal getBigDecimal(String fieldName, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getBigDecimal((IRecord)this, 0, arrayIndex);
    }

    public boolean getBoolean(String[] fieldNames) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return data.field_.getBoolean(this, data.parentOffset_);
    }

    public boolean getBoolean(String[] fieldNames, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getBoolean((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public boolean getBoolean(String[] fieldNames, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getBoolean((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public boolean getBoolean(String fieldName) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        return recField.getBoolean(this, 0);
    }

    public boolean getBoolean(String fieldName, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getBoolean((IRecord)this, 0, arrayIndex);
    }

    public boolean getBoolean(String fieldName, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getBoolean((IRecord)this, 0, arrayIndex);
    }

    public byte getByte(String[] fieldNames) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return data.field_.getByte(this, data.parentOffset_);
    }

    public byte getByte(String[] fieldNames, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getByte((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public byte getByte(String[] fieldNames, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getByte((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public byte getByte(String fieldName) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        return recField.getByte(this, 0);
    }

    public byte getByte(String fieldName, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getByte((IRecord)this, 0, arrayIndex);
    }

    public byte getByte(String fieldName, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getByte((IRecord)this, 0, arrayIndex);
    }

    public char getChar(String[] fieldNames) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return data.field_.getChar(this, data.parentOffset_);
    }

    public char getChar(String[] fieldNames, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getChar((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public char getChar(String[] fieldNames, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getChar((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public char getChar(String fieldName) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        return recField.getChar(this, 0);
    }

    public char getChar(String fieldName, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getChar((IRecord)this, 0, arrayIndex);
    }

    public char getChar(String fieldName, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getChar((IRecord)this, 0, arrayIndex);
    }

    public double getDouble(String[] fieldNames) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return data.field_.getDouble(this, data.parentOffset_);
    }

    public double getDouble(String[] fieldNames, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getDouble((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public double getDouble(String[] fieldNames, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getDouble((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public double getDouble(String fieldName) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        return recField.getDouble(this, 0);
    }

    public double getDouble(String fieldName, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getDouble((IRecord)this, 0, arrayIndex);
    }

    public double getDouble(String fieldName, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getDouble((IRecord)this, 0, arrayIndex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IAnyField getField(String[] fieldNames) throws RecordFieldNotFoundException {
        IAnyField recField = null;
        int size = fieldNames.length;
        if (size == 0) {
            throw new RecordFieldNotFoundException();
        }
        recField = this.recordType_.fieldAt(fieldNames[0]);
        int i = 1;
        while (i < size) {
            IAnyComposedType type;
            if (recField instanceof INestedRecordField) {
                type = (IAnyDynamicRecordType)recField.getType();
                recField = type.fieldAt(fieldNames[i]);
            } else if (recField instanceof IOverlayField) {
                type = (IOverlayType)recField.getType();
                recField = type.fieldAt(fieldNames[i]);
            } else {
                if (!(recField instanceof IArrayField)) throw new RecordFieldNotFoundException(fieldNames[i]);
                type = (IArrayType)recField.getType();
                int[] dims = type.getDimensions();
                int[] index = new int[dims.length];
                if (i + dims.length > size - 1) {
                    throw new RecordFieldNotFoundException(fieldNames[i - 1]);
                }
                int j = 0;
                while (j < dims.length) {
                    index[j] = Integer.parseInt(fieldNames[i]);
                    ++i;
                    ++j;
                }
                IFixedLengthType rt = type.getBaseType();
                if (rt instanceof IAnyDynamicRecordType) {
                    recField = ((IAnyDynamicRecordType)((Object)rt)).fieldAt(fieldNames[i]);
                } else {
                    if (!(rt instanceof IOverlayType)) throw new RecordFieldNotFoundException(fieldNames[i]);
                    recField = ((IOverlayType)rt).fieldAt(fieldNames[i]);
                }
            }
            ++i;
        }
        return recField;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FieldData getFieldAndParentOffset(String[] fieldNames) throws RecordFieldNotFoundException {
        IAnyField recField = null;
        int size = fieldNames.length;
        int parentOffset = 0;
        if (size == 0) {
            throw new RecordFieldNotFoundException();
        }
        recField = this.recordType_.fieldAt(fieldNames[0]);
        int i = 1;
        while (i < size) {
            IAnyComposedType type;
            if (recField instanceof INestedRecordField) {
                type = (IAnyDynamicRecordType)recField.getType();
                parentOffset += recField.getRelativeOffset();
                recField = type.fieldAt(fieldNames[i]);
            } else if (recField instanceof IOverlayField) {
                type = (IOverlayType)recField.getType();
                parentOffset += recField.getRelativeOffset();
                recField = type.fieldAt(fieldNames[i]);
            } else {
                if (!(recField instanceof IArrayField)) throw new RecordFieldNotFoundException(fieldNames[i]);
                type = (IArrayType)recField.getType();
                parentOffset += recField.getRelativeOffset();
                int[] dims = type.getDimensions();
                int[] index = new int[dims.length];
                if (i + dims.length > size - 1) {
                    throw new RecordFieldNotFoundException(fieldNames[i - 1]);
                }
                int j = 0;
                while (j < dims.length) {
                    index[j] = Integer.parseInt(fieldNames[i]);
                    ++i;
                    ++j;
                }
                parentOffset += type.getElementOffset(index);
                IFixedLengthType rt = type.getBaseType();
                if (rt instanceof IAnyDynamicRecordType) {
                    recField = ((IAnyDynamicRecordType)((Object)rt)).fieldAt(fieldNames[i]);
                } else {
                    if (!(rt instanceof IOverlayType)) throw new RecordFieldNotFoundException(fieldNames[i]);
                    recField = ((IOverlayType)rt).fieldAt(fieldNames[i]);
                }
            }
            ++i;
        }
        return new FieldData(recField, parentOffset);
    }

    public float getFloat(String[] fieldNames) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return data.field_.getFloat(this, data.parentOffset_);
    }

    public float getFloat(String[] fieldNames, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getFloat((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public float getFloat(String[] fieldNames, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getFloat((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public float getFloat(String fieldName) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        return recField.getFloat(this, 0);
    }

    public float getFloat(String fieldName, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getFloat((IRecord)this, 0, arrayIndex);
    }

    public float getFloat(String fieldName, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getFloat((IRecord)this, 0, arrayIndex);
    }

    public int getInt(String[] fieldNames) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return data.field_.getInt(this, data.parentOffset_);
    }

    public int getInt(String[] fieldNames, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getInt((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public int getInt(String[] fieldNames, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getInt((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public int getInt(String fieldName) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        return recField.getInt(this, 0);
    }

    public int getInt(String fieldName, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getInt((IRecord)this, 0, arrayIndex);
    }

    public int getInt(String fieldName, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getInt((IRecord)this, 0, arrayIndex);
    }

    public long getLong(String[] fieldNames) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return data.field_.getLong(this, data.parentOffset_);
    }

    public long getLong(String[] fieldNames, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getLong((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public long getLong(String[] fieldNames, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getLong((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public long getLong(String fieldName) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        return recField.getLong(this, 0);
    }

    public long getLong(String fieldName, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getLong((IRecord)this, 0, arrayIndex);
    }

    public long getLong(String fieldName, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getLong((IRecord)this, 0, arrayIndex);
    }

    public Object getObject(String[] fieldNames) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return data.field_.getObject(this, data.parentOffset_);
    }

    public Object getObject(String[] fieldNames, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getObject((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public Object getObject(String[] fieldNames, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getObject((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public Object getObject(String fieldName) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        return recField.getObject(this, 0);
    }

    public Object getObject(String fieldName, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getObject((IRecord)this, 0, arrayIndex);
    }

    public Object getObject(String fieldName, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getObject((IRecord)this, 0, arrayIndex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getParentOffset(String[] fieldNames) throws RecordFieldNotFoundException {
        IAnyField recField = null;
        int size = fieldNames.length;
        int parentOffset = 0;
        if (size == 0) {
            throw new RecordFieldNotFoundException();
        }
        recField = this.recordType_.fieldAt(fieldNames[0]);
        int i = 1;
        while (i < size) {
            IAnyComposedType type;
            if (recField instanceof INestedRecordField) {
                type = (IAnyDynamicRecordType)recField.getType();
                parentOffset += recField.getRelativeOffset();
                recField = type.fieldAt(fieldNames[i]);
            } else if (recField instanceof IOverlayField) {
                type = (IOverlayType)recField.getType();
                parentOffset += recField.getRelativeOffset();
                recField = type.fieldAt(fieldNames[i]);
            } else {
                if (!(recField instanceof IArrayField)) throw new RecordFieldNotFoundException(fieldNames[i]);
                type = (IArrayType)recField.getType();
                parentOffset += recField.getRelativeOffset();
                int[] dims = type.getDimensions();
                int[] index = new int[dims.length];
                if (i + dims.length > size - 1) {
                    throw new RecordFieldNotFoundException(fieldNames[i - 1]);
                }
                int j = 0;
                while (j < dims.length) {
                    index[j] = Integer.parseInt(fieldNames[i]);
                    ++i;
                    ++j;
                }
                parentOffset += type.getElementOffset(index);
                IFixedLengthType rt = type.getBaseType();
                if (rt instanceof IAnyDynamicRecordType) {
                    recField = ((IAnyDynamicRecordType)((Object)rt)).fieldAt(fieldNames[i]);
                } else {
                    if (!(rt instanceof IOverlayType)) throw new RecordFieldNotFoundException(fieldNames[i]);
                    recField = ((IOverlayType)rt).fieldAt(fieldNames[i]);
                }
            }
            ++i;
        }
        return parentOffset;
    }

    public Object getPossibleValue(String[] fieldNames, String key) throws RecordFieldNotFoundException, RecordPossibleValueKeyNotFoundException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        Object[] values = data.field_.getPossibleValue(key);
        if (values == null) {
            throw new RecordPossibleValueKeyNotFoundException(key);
        }
        if (values[0] instanceof IRangeObject) {
            return ((IRangeObject)values[0]).getLowerRange();
        }
        return values[0];
    }

    public Object getPossibleValue(String fieldName, String key) throws RecordFieldNotFoundException, RecordPossibleValueKeyNotFoundException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        Object[] values = recField.getPossibleValue(key);
        if (values == null) {
            throw new RecordPossibleValueKeyNotFoundException(key);
        }
        if (values[0] instanceof IRangeObject) {
            return ((IRangeObject)values[0]).getLowerRange();
        }
        return values[0];
    }

    public Object[] getPossibleValues(String[] fieldNames, String key) throws RecordFieldNotFoundException, RecordPossibleValueKeyNotFoundException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        Object[] values = data.field_.getPossibleValue(key);
        if (values == null) {
            throw new RecordPossibleValueKeyNotFoundException(key);
        }
        return values;
    }

    public Object[] getPossibleValues(String fieldName, String key) throws RecordFieldNotFoundException, RecordPossibleValueKeyNotFoundException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        Object[] values = recField.getPossibleValue(key);
        if (values == null) {
            throw new RecordPossibleValueKeyNotFoundException(key);
        }
        return values;
    }

    public int getRecordKind() {
        return this.recordKind_;
    }

    public IRecordType getRecordType() {
        return this.recordType_;
    }

    public short getShort(String[] fieldNames) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return data.field_.getShort(this, data.parentOffset_);
    }

    public short getShort(String[] fieldNames, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getShort((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public short getShort(String[] fieldNames, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getShort((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public short getShort(String fieldName) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        return recField.getShort(this, 0);
    }

    public short getShort(String fieldName, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getShort((IRecord)this, 0, arrayIndex);
    }

    public short getShort(String fieldName, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getShort((IRecord)this, 0, arrayIndex);
    }

    public int getSize() {
        if (this.recordType_ == null) {
            return 0;
        }
        return this.recordType_.getSize() + this.startingOffset_;
    }

    public String getString(String[] fieldNames) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return data.field_.getString(this, data.parentOffset_);
    }

    public String getString(String[] fieldNames, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getString((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public String getString(String[] fieldNames, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return ((IArrayField)data.field_).getString((IRecord)this, data.parentOffset_, arrayIndex);
    }

    public String getString(String fieldName) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        return recField.getString(this, 0);
    }

    public String getString(String fieldName, int[] arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getString((IRecord)this, 0, arrayIndex);
    }

    public String getString(String fieldName, int arrayIndex) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        return recField.getString((IRecord)this, 0, arrayIndex);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean hasVariableSizedArray(IAnyDynamicRecordType recordType) {
        hasVarSizedArray = false;
        cursor = recordType.fields();
        while (cursor.hasMoreFields()) {
            field = cursor.nextField();
            if (field instanceof INestedRecordField || field instanceof IOverlayField) {
                recType = (IAnyDynamicRecordType)field.getType();
                if (!this.hasVariableSizedArray(recType)) continue;
                hasVarSizedArray = true;
                continue;
            }
            if (!(field instanceof IVariableSizeArrayDimensionField)) continue;
            varField = (IVariableSizeArrayDimensionField)field;
            arrayNames = varField.getArrayFieldNames();
            nameCursor = arrayNames.elements();
            while (nameCursor.hasMoreElements()) {
                arrayFieldName = (String[])nameCursor.nextElement();
                try {
                    (IArrayField)this.getField(arrayFieldName);
                    continue;
                }
                catch (RecordFieldNotFoundException exc) {
                    fieldName = exc.getMessage();
                    i = 0;
                    i = 0;
                    ** while (i < arrayFieldName.length)
                }
lbl-1000:
                // 1 sources

                {
                    if (fieldName.equals(arrayFieldName[i])) break;
                    ++i;
                    continue;
                }
lbl28:
                // 2 sources

                newName = new String[arrayFieldName.length - i - 1];
                j = 0;
                while (j < newName.length) {
                    newName[j] = arrayFieldName[j + i + 1];
                    ++j;
                }
                index = arrayNames.indexOf(arrayFieldName);
                arrayNames.setElementAt(newName, index);
            }
            hasVarSizedArray = true;
        }
        return hasVarSizedArray;
    }

    protected boolean hasVariableSubRecord(IAnyDynamicRecordType recordType) {
        IFieldEnumeration cursor = recordType.fields();
        while (cursor.hasMoreFields()) {
            IAnyField field = cursor.nextField();
            if (!(field instanceof INestedRecordField) && !(field instanceof IOverlayField)) continue;
            IAnyDynamicRecordType recType = (IAnyDynamicRecordType)field.getType();
            if (recType instanceof IVariableLengthRecordType) {
                return true;
            }
            if (!this.hasVariableSubRecord(recType)) continue;
            return true;
        }
        return false;
    }

    public boolean isPossibleValue(String[] fieldNames, String key, Object value) throws RecordFieldNotFoundException, RecordPossibleValueKeyNotFoundException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        return data.field_.isPossibleValue(key, value);
    }

    public boolean isPossibleValue(String fieldName, String key, Object value) throws RecordFieldNotFoundException, RecordPossibleValueKeyNotFoundException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        return recField.isPossibleValue(key, value);
    }

    private static void printNameOffset(IAnyDynamicRecordType recType, int indent, StringBuffer stream) {
        int i = 0;
        while (i < indent) {
            stream.append("   ");
            ++i;
        }
        stream.append("------------------------------");
        stream.append("\n");
        IFieldEnumeration cursor = recType.fields();
        while (cursor.hasMoreFields()) {
            IAnyField field = cursor.nextField();
            int i2 = 0;
            while (i2 < indent) {
                stream.append("   ");
                ++i2;
            }
            stream.append(String.valueOf(field.getName()) + ":  " + field.getRelativeOffset());
            stream.append("\n");
            if (!(field instanceof INestedRecordField) && !(field instanceof IOverlayField)) continue;
            IAnyDynamicRecordType type = (IAnyDynamicRecordType)field.getType();
            DynamicRecord.printNameOffset(type, ++indent, stream);
            --indent;
        }
        i = 0;
        while (i < indent) {
            stream.append("   ");
            ++i;
        }
        stream.append("------------------------------");
        stream.append("\n");
    }

    public void printTo(PrintStream stream) {
        StringBuffer strBuf = new StringBuffer();
        stream.println("==============================");
        DynamicRecord.printNameOffset(this.recordType_, 0, strBuf);
        stream.println(strBuf.toString());
        stream.println("==============================");
        stream.println();
        Record.dumpBytes(stream, (IRecord)this);
    }

    public void setArray(String[] fieldNames, Object value, Class componentType) throws RecordFieldNotFoundException, RecordConversionUnsupportedException, RecordConversionFailureException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setArray(this, data.parentOffset_, value, componentType);
    }

    public void setArray(String fieldName, Object value, Class componentType) throws RecordFieldNotFoundException, RecordConversionUnsupportedException, RecordConversionFailureException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setArray(this, 0, value, componentType);
    }

    public void setBigDecimal(String[] fieldNames, int[] arrayIndex, BigDecimal value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setBigDecimal((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setBigDecimal(String[] fieldNames, int arrayIndex, BigDecimal value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setBigDecimal((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setBigDecimal(String[] fieldNames, BigDecimal value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        data.field_.setBigDecimal(this, data.parentOffset_, value);
    }

    public void setBigDecimal(String fieldName, int[] arrayIndex, BigDecimal value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setBigDecimal((IRecord)this, 0, arrayIndex, value);
    }

    public void setBigDecimal(String fieldName, int arrayIndex, BigDecimal value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setBigDecimal((IRecord)this, 0, arrayIndex, value);
    }

    public void setBigDecimal(String fieldName, BigDecimal value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        recField.setBigDecimal(this, 0, value);
    }

    public void setBoolean(String[] fieldNames, int[] arrayIndex, boolean value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setBoolean((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setBoolean(String[] fieldNames, int arrayIndex, boolean value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setBoolean((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setBoolean(String[] fieldNames, boolean value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        data.field_.setBoolean(this, data.parentOffset_, value);
    }

    public void setBoolean(String fieldName, int[] arrayIndex, boolean value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setBoolean((IRecord)this, 0, arrayIndex, value);
    }

    public void setBoolean(String fieldName, int arrayIndex, boolean value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setBoolean((IRecord)this, 0, arrayIndex, value);
    }

    public void setBoolean(String fieldName, boolean value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        recField.setBoolean(this, 0, value);
    }

    public void setByte(String[] fieldNames, int[] arrayIndex, byte value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setByte((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setByte(String[] fieldNames, byte value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        data.field_.setByte(this, data.parentOffset_, value);
    }

    public void setByte(String[] fieldNames, int arrayIndex, byte value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setByte((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setByte(String fieldName, int[] arrayIndex, byte value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setByte((IRecord)this, 0, arrayIndex, value);
    }

    public void setByte(String fieldName, byte value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        recField.setByte(this, 0, value);
    }

    public void setByte(String fieldName, int arrayIndex, byte value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setByte((IRecord)this, 0, arrayIndex, value);
    }

    public void setChar(String[] fieldNames, int[] arrayIndex, char value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setChar((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setChar(String[] fieldNames, char value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        data.field_.setChar(this, data.parentOffset_, value);
    }

    public void setChar(String[] fieldNames, int arrayIndex, char value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setChar((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setChar(String fieldName, int[] arrayIndex, char value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setChar((IRecord)this, 0, arrayIndex, value);
    }

    public void setChar(String fieldName, char value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        recField.setChar(this, 0, value);
    }

    public void setChar(String fieldName, int arrayIndex, char value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setChar((IRecord)this, 0, arrayIndex, value);
    }

    public void setDouble(String[] fieldNames, int[] arrayIndex, double value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setDouble((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setDouble(String[] fieldNames, double value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        data.field_.setDouble(this, data.parentOffset_, value);
    }

    public void setDouble(String[] fieldNames, int arrayIndex, double value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setDouble((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setDouble(String fieldName, int[] arrayIndex, double value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setDouble((IRecord)this, 0, arrayIndex, value);
    }

    public void setDouble(String fieldName, double value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        recField.setDouble(this, 0, value);
    }

    public void setDouble(String fieldName, int arrayIndex, double value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setDouble((IRecord)this, 0, arrayIndex, value);
    }

    public void setFloat(String[] fieldNames, int[] arrayIndex, float value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setFloat((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setFloat(String[] fieldNames, float value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        data.field_.setFloat(this, data.parentOffset_, value);
    }

    public void setFloat(String[] fieldNames, int arrayIndex, float value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setFloat((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setFloat(String fieldName, int[] arrayIndex, float value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setFloat((IRecord)this, 0, arrayIndex, value);
    }

    public void setFloat(String fieldName, float value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        recField.setFloat(this, 0, value);
    }

    public void setFloat(String fieldName, int arrayIndex, float value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setFloat((IRecord)this, 0, arrayIndex, value);
    }

    public void setInitialValues() throws RecordConversionFailureException, RecordConversionUnsupportedException {
        if (this.getRecordKind() != 2 && this.bytes_ == null) {
            return;
        }
        IFieldEnumeration cursor = this.recordType_.fields();
        while (cursor.hasMoreFields()) {
            IAnyField field = cursor.nextField();
            field.setInitialValue(this, 0);
        }
    }

    public void setInt(String[] fieldNames, int[] arrayIndex, int value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setInt((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setInt(String[] fieldNames, int value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        data.field_.setInt(this, data.parentOffset_, value);
    }

    public void setInt(String[] fieldNames, int arrayIndex, int value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setInt((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setInt(String fieldName, int[] arrayIndex, int value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setInt((IRecord)this, 0, arrayIndex, value);
    }

    public void setInt(String fieldName, int value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        recField.setInt(this, 0, value);
    }

    public void setInt(String fieldName, int arrayIndex, int value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setInt((IRecord)this, 0, arrayIndex, value);
    }

    public void setLong(String[] fieldNames, int[] arrayIndex, long value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setLong((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setLong(String[] fieldNames, int arrayIndex, long value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setLong((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setLong(String[] fieldNames, long value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        data.field_.setLong(this, data.parentOffset_, value);
    }

    public void setLong(String fieldName, int[] arrayIndex, long value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setLong((IRecord)this, 0, arrayIndex, value);
    }

    public void setLong(String fieldName, int arrayIndex, long value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setLong((IRecord)this, 0, arrayIndex, value);
    }

    public void setLong(String fieldName, long value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        recField.setLong(this, 0, value);
    }

    public void setObject(String[] fieldNames, int[] arrayIndex, Object value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setObject((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setObject(String[] fieldNames, int arrayIndex, Object value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setObject((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setObject(String[] fieldNames, Object value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        data.field_.setObject(this, data.parentOffset_, value);
    }

    public void setObject(String fieldName, int[] arrayIndex, Object value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setObject((IRecord)this, 0, arrayIndex, value);
    }

    public void setObject(String fieldName, int arrayIndex, Object value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setObject((IRecord)this, 0, arrayIndex, value);
    }

    public void setObject(String fieldName, Object value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        recField.setObject(this, 0, value);
    }

    public void setRecordType(IRecordType recordType) throws IllegalArgumentException {
        if (recordType == null) {
            throw new IllegalArgumentException();
        }
        if (!(recordType instanceof IAnyDynamicRecordType)) {
            throw new IllegalArgumentException(recordType.getClass().getName());
        }
        this.recordType_ = (IAnyDynamicRecordType)recordType;
        if (this.recordType_ instanceof IVariableLengthRecordType) {
            this.recordKind_ = 2;
        } else {
            this.recordKind_ = 1;
            boolean hasVarSubRec = false;
            boolean hasVarSizeArray = false;
            hasVarSubRec = this.hasVariableSubRecord(this.recordType_);
            hasVarSizeArray = this.hasVariableSizedArray(this.recordType_);
            if (hasVarSubRec) {
                this.recordKind_ = 3;
            }
            if (hasVarSizeArray) {
                this.recordKind_ = hasVarSubRec ? 5 : 4;
            }
        }
        IRecordAttributes attributes = this.getRecordAttributes();
        if (attributes != null && !this.recordType_.getRecordAttributesClass().isInstance(attributes)) {
            throw new IllegalArgumentException();
        }
    }

    public void setShort(String[] fieldNames, int[] arrayIndex, short value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setShort((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setShort(String[] fieldNames, int arrayIndex, short value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setShort((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setShort(String[] fieldNames, short value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        data.field_.setShort(this, data.parentOffset_, value);
    }

    public void setShort(String fieldName, int[] arrayIndex, short value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setShort((IRecord)this, 0, arrayIndex, value);
    }

    public void setShort(String fieldName, int arrayIndex, short value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setShort((IRecord)this, 0, arrayIndex, value);
    }

    public void setShort(String fieldName, short value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        recField.setShort(this, 0, value);
    }

    public void setString(String[] fieldNames, int[] arrayIndex, String value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setString((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setString(String[] fieldNames, int arrayIndex, String value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        ((IArrayField)data.field_).setString((IRecord)this, data.parentOffset_, arrayIndex, value);
    }

    public void setString(String[] fieldNames, String value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        FieldData data = this.getFieldAndParentOffset(fieldNames);
        data.field_.setString(this, data.parentOffset_, value);
    }

    public void setString(String fieldName, int[] arrayIndex, String value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setString((IRecord)this, 0, arrayIndex, value);
    }

    public void setString(String fieldName, int arrayIndex, String value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IArrayField recField = (IArrayField)this.recordType_.fieldAt(fieldName);
        recField.setString((IRecord)this, 0, arrayIndex, value);
    }

    public void setString(String fieldName, String value) throws RecordFieldNotFoundException, RecordConversionFailureException, RecordConversionUnsupportedException {
        IAnyField recField = this.recordType_.fieldAt(fieldName);
        recField.setString(this, 0, value);
    }

    public String toString() {
        StringBuffer stream = new StringBuffer();
        stream.append(super.toString());
        stream.append("\n");
        stream.append("\n");
        stream.append("==============================");
        stream.append("\n");
        DynamicRecord.printNameOffset(this.recordType_, 0, stream);
        stream.append("==============================");
        stream.append("\n");
        stream.append("\n");
        Record.dumpBytes(stream, (IRecord)this);
        String s = stream.toString();
        return s;
    }
}

