/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.IRangeObject;

public class DoubleRange
implements IRangeObject {
    private static String copyright = "(c) Copyright IBM Corporation 1999.";
    static final long serialVersionUID = 3380398617924967024L;
    protected double lowerRange_;
    protected double upperRange_;

    public DoubleRange() {
        this.lowerRange_ = 0.0;
        this.upperRange_ = 0.0;
    }

    public DoubleRange(double lowerRange, double upperRange) throws IllegalArgumentException {
        if (upperRange < lowerRange) {
            throw new IllegalArgumentException(Double.toString(upperRange));
        }
        this.lowerRange_ = lowerRange;
        this.upperRange_ = upperRange;
    }

    public Object clone() {
        try {
            DoubleRange newType = (DoubleRange)super.clone();
            return newType;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleRange)) {
            return false;
        }
        DoubleRange tmpRange = (DoubleRange)obj;
        if (this.lowerRange_ != tmpRange.lowerRange_) {
            return false;
        }
        return this.upperRange_ == tmpRange.upperRange_;
    }

    public Object getLowerRange() {
        return new Double(this.lowerRange_);
    }

    public Object getUpperRange() {
        return new Double(this.upperRange_);
    }

    public static boolean isInRange(double lowerRange, double upperRange, double value) throws IllegalArgumentException {
        if (upperRange < lowerRange) {
            throw new IllegalArgumentException(Double.toString(upperRange));
        }
        return value >= lowerRange && value <= upperRange;
    }

    public boolean isInRange(Object value) {
        if (!(value instanceof Double)) {
            return false;
        }
        double doubleVal = (Double)value;
        return DoubleRange.isInRange(this.lowerRange_, this.upperRange_, doubleVal);
    }

    public void setLowerRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof Double)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.lowerRange_ = (Double)value;
    }

    public void setUpperRange(Object value) throws IllegalArgumentException {
        if (!(value instanceof Double)) {
            throw new IllegalArgumentException(value.toString());
        }
        this.upperRange_ = (Double)value;
    }
}

