/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.IRecordAttributes;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class BasicRecordAttributes
implements IRecordAttributes,
Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = 1246728733437566088L;
    protected String codePage_;
    protected int endian_;
    protected int floatingPointFormat_;
    protected transient PropertyChangeSupport changes_;
    private static byte[] resourceLock_ = new byte[1];

    public BasicRecordAttributes() {
        this.codePage_ = System.getProperty("file.encoding", "Cp1252");
        this.endian_ = 1;
        this.floatingPointFormat_ = 1;
        this.changes_ = null;
    }

    public BasicRecordAttributes(int endian, String codePage, int floatingPointFormat) throws IllegalArgumentException {
        this.changes_ = null;
        this.setCodePage(codePage);
        this.setEndian(endian);
        this.setFloatingPointFormat(floatingPointFormat);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        byte[] byArray = resourceLock_;
        synchronized (resourceLock_) {
            if (this.changes_ == null) {
                this.changes_ = new PropertyChangeSupport(this);
            }
            this.changes_.addPropertyChangeListener(listener);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Object clone() {
        try {
            BasicRecordAttributes newAttr = (BasicRecordAttributes)super.clone();
            return newAttr;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BasicRecordAttributes)) {
            return false;
        }
        BasicRecordAttributes tmpType = (BasicRecordAttributes)obj;
        if (!this.codePage_.equals(tmpType.codePage_)) {
            return false;
        }
        if (this.endian_ != tmpType.endian_) {
            return false;
        }
        return this.floatingPointFormat_ == tmpType.floatingPointFormat_;
    }

    public String getCodePage() {
        return this.codePage_;
    }

    public int getEndian() {
        return this.endian_;
    }

    public int getFloatingPointFormat() {
        return this.floatingPointFormat_;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        byte[] byArray = resourceLock_;
        synchronized (resourceLock_) {
            if (this.changes_ == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.changes_.removePropertyChangeListener(listener);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setCodePage(String codePage) throws IllegalArgumentException {
        try {
            byte[] byteArray = new byte[]{12, 34};
            new String(byteArray, codePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(codePage);
        }
        String oldCodePage = this.codePage_;
        this.codePage_ = codePage;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("codePage", oldCodePage, this.codePage_);
        }
    }

    public void setEndian(int endian) throws IllegalArgumentException {
        if (endian != 1 && endian != 0) {
            throw new IllegalArgumentException(Integer.toString(endian));
        }
        int oldEndian = this.endian_;
        this.endian_ = endian;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("endian", new Integer(oldEndian), new Integer(this.endian_));
        }
    }

    public void setFloatingPointFormat(int format) throws IllegalArgumentException {
        if (format != 1 && format != 0) {
            throw new IllegalArgumentException(Integer.toString(format));
        }
        int oldFormat = this.floatingPointFormat_;
        this.floatingPointFormat_ = format;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("floatingPointFormat", new Integer(oldFormat), new Integer(this.floatingPointFormat_));
        }
    }
}

