/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.AnyDynamicRecordType;
import com.ibm.record.IAnyField;
import com.ibm.record.IAnyFixedLengthRecordType;
import com.ibm.record.IFieldEnumeration;
import com.ibm.record.IRecord;
import com.ibm.record.RecordConversionFailureException;
import com.ibm.record.RecordConversionUnsupportedException;
import com.ibm.record.RecordFieldNameAlreadyExistsException;
import com.ibm.record.RecordFieldNameNotSetException;
import com.ibm.record.RecordFieldNotFoundException;
import com.ibm.record.RecordFieldTypeNotValidException;
import com.ibm.record.TypeData;
import java.io.Serializable;
import java.math.BigDecimal;

public abstract class AnyFixedLengthRecordType
extends AnyDynamicRecordType
implements IAnyFixedLengthRecordType,
Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = -6316739106157362513L;

    public AnyFixedLengthRecordType() {
    }

    public AnyFixedLengthRecordType(int packingHint) {
        super(packingHint);
    }

    public void addField(IAnyField field) throws RecordFieldTypeNotValidException, RecordFieldNameAlreadyExistsException, RecordFieldNameNotSetException {
        if (field.getFieldKind() == 1) {
            String name = field.getName();
            if (name == null) {
                throw new RecordFieldTypeNotValidException();
            }
            throw new RecordFieldTypeNotValidException(name);
        }
        super.addField(field);
    }

    public void addFieldAfter(IAnyField field, String fieldName) throws RecordFieldTypeNotValidException, RecordFieldNotFoundException, RecordFieldNameAlreadyExistsException, RecordFieldNameNotSetException {
        if (field.getFieldKind() == 1) {
            String name = field.getName();
            if (name == null) {
                throw new RecordFieldTypeNotValidException();
            }
            throw new RecordFieldTypeNotValidException(name);
        }
        super.addFieldAfter(field, fieldName);
    }

    public void addFieldAsFirst(IAnyField field) throws RecordFieldTypeNotValidException, RecordFieldNameAlreadyExistsException, RecordFieldNameNotSetException {
        if (field.getFieldKind() == 1) {
            String name = field.getName();
            if (name == null) {
                throw new RecordFieldTypeNotValidException();
            }
            throw new RecordFieldTypeNotValidException(name);
        }
        super.addFieldAsFirst(field);
    }

    public boolean checkConstantValue(IRecord record, int fieldOffset, Object constantValue) {
        return true;
    }

    public Object clone() {
        AnyFixedLengthRecordType newType = (AnyFixedLengthRecordType)super.clone();
        return newType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AnyFixedLengthRecordType)) {
            return false;
        }
        return super.equals(obj);
    }

    public int getAlignmentHint() {
        int alignmentHint = 1;
        IFieldEnumeration cursor = this.fields();
        while (cursor.hasMoreFields()) {
            IAnyField field = cursor.nextField();
            alignmentHint = Math.max(alignmentHint, field.getType().getAlignmentHint());
        }
        return alignmentHint;
    }

    public BigDecimal getBigDecimal(IRecord record, int fieldOffset) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public boolean getBoolean(IRecord record, int fieldOffset) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public byte getByte(IRecord record, int fieldOffset) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public char getChar(IRecord record, int fieldOffset) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public double getDouble(IRecord record, int fieldOffset) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public float getFloat(IRecord record, int fieldOffset) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public int getInt(IRecord record, int fieldOffset) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public long getLong(IRecord record, int fieldOffset) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public Object getObject(IRecord record, int fieldOffset) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public abstract Class getRecordAttributesClass();

    public short getShort(IRecord record, int fieldOffset) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public String getString(IRecord record, int fieldOffset) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public byte[] packageBytes(IRecord record, byte[] byteArray) {
        return byteArray;
    }

    public void replaceField(String name, IAnyField field) throws RecordFieldTypeNotValidException, RecordFieldNotFoundException {
        if (field.getFieldKind() == 1) {
            throw new RecordFieldTypeNotValidException(name);
        }
        super.replaceField(name, field);
    }

    public TypeData retrieveBytes(IRecord record, byte[] byteArray, int offset) {
        int length = this.getSize();
        byte[] bytes = new byte[length];
        System.arraycopy(byteArray, offset, bytes, 0, length);
        return new TypeData(bytes, length);
    }

    public void setBigDecimal(IRecord record, int fieldOffset, BigDecimal value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public void setBoolean(IRecord record, int fieldOffset, boolean value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public void setByte(IRecord record, int fieldOffset, byte value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public void setChar(IRecord record, int fieldOffset, char value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public void setDouble(IRecord record, int fieldOffset, double value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public void setFloat(IRecord record, int fieldOffset, float value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public void setInitialValue(IRecord record, int fieldOffset, Object initialValue) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public void setInt(IRecord record, int fieldOffset, int value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public void setLong(IRecord record, int fieldOffset, long value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public void setObject(IRecord record, int fieldOffset, Object value) throws RecordConversionFailureException, RecordConversionUnsupportedException {
        throw new RecordConversionUnsupportedException();
    }

    public void setShort(IRecord record, int fieldOffset, short value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }

    public void setString(IRecord record, int fieldOffset, String value) throws RecordConversionUnsupportedException, RecordConversionFailureException {
        throw new RecordConversionUnsupportedException();
    }
}

