/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.record;

import com.ibm.record.AnyComposedType;
import com.ibm.record.DynamicRecord;
import com.ibm.record.FieldEnumeration;
import com.ibm.record.IAnyDynamicRecordType;
import com.ibm.record.IAnyField;
import com.ibm.record.IBidiAttributesObject;
import com.ibm.record.IField;
import com.ibm.record.IFieldEnumeration;
import com.ibm.record.IRecord;
import com.ibm.record.IRecordAttributes;
import com.ibm.record.RecordException;
import com.ibm.record.RecordFieldNameAlreadyExistsException;
import com.ibm.record.RecordFieldNameNotSetException;
import com.ibm.record.RecordFieldNotFoundException;
import com.ibm.record.RecordFieldTypeNotValidException;
import com.ibm.record.util.OrderedDictionary;
import java.io.Serializable;

public abstract class AnyDynamicRecordType
extends AnyComposedType
implements IAnyDynamicRecordType,
Serializable {
    private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";
    static final long serialVersionUID = 7868855653050888746L;
    protected OrderedDictionary dict_ = new OrderedDictionary();
    protected IBidiAttributesObject bidiAttributes_ = null;

    public AnyDynamicRecordType() {
    }

    public AnyDynamicRecordType(int packingHint) {
        super(packingHint);
    }

    public void addField(IAnyField field) throws RecordFieldTypeNotValidException, RecordFieldNameAlreadyExistsException, RecordFieldNameNotSetException {
        String name = field.getName();
        if (name == null) {
            throw new RecordFieldNameNotSetException();
        }
        IAnyField aField = (IAnyField)this.dict_.get(name);
        if (aField != null) {
            throw new RecordFieldNameAlreadyExistsException(name);
        }
        this.dict_.put(name, field);
    }

    public void addFieldAfter(IAnyField field, String fieldName) throws RecordFieldTypeNotValidException, RecordFieldNotFoundException, RecordFieldNameAlreadyExistsException, RecordFieldNameNotSetException {
        String name = field.getName();
        if (name == null) {
            throw new RecordFieldNameNotSetException();
        }
        IAnyField aField = (IAnyField)this.dict_.get(name);
        if (aField != null) {
            throw new RecordFieldNameAlreadyExistsException(name);
        }
        aField = (IAnyField)this.dict_.get(fieldName);
        if (aField == null) {
            throw new RecordFieldNotFoundException(fieldName);
        }
        if (aField == this.dict_.lastElement()) {
            this.addField(field);
            return;
        }
        IFieldEnumeration cursor = this.fields();
        IAnyField nextField = cursor.locate(fieldName);
        cursor.setToNext();
        while (cursor.isValid()) {
            nextField = cursor.field();
            if (!(nextField instanceof IField) || !((IField)nextField).isPadding()) break;
            cursor.setToNext();
        }
        if (!cursor.isValid()) {
            this.addField(field);
        } else {
            int index = this.dict_.indexOf(nextField);
            this.dict_.insertElementAt(name, field, index);
        }
    }

    public void addFieldAsFirst(IAnyField field) throws RecordFieldTypeNotValidException, RecordFieldNameAlreadyExistsException, RecordFieldNameNotSetException {
        String name = field.getName();
        if (name == null) {
            throw new RecordFieldNameNotSetException();
        }
        if (this.dict_.isEmpty()) {
            this.addField(field);
            return;
        }
        IAnyField aField = (IAnyField)this.dict_.get(name);
        if (aField != null) {
            throw new RecordFieldNameAlreadyExistsException(name);
        }
        aField = (IAnyField)this.dict_.firstElement();
        this.dict_.insertElementAt(name, field, this.dict_.indexOf(aField));
    }

    public Object clone() {
        AnyDynamicRecordType newType = (AnyDynamicRecordType)super.clone();
        newType.dict_ = new OrderedDictionary();
        IFieldEnumeration cursor = this.fields();
        while (cursor.hasMoreFields()) {
            IAnyField newField = (IAnyField)cursor.nextField().clone();
            newType.dict_.put(newField.getName(), newField);
        }
        return newType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AnyDynamicRecordType)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AnyDynamicRecordType tmpObj = (AnyDynamicRecordType)obj;
        if (this.bidiAttributes_ == null ^ tmpObj.bidiAttributes_ == null) {
            return false;
        }
        if (this.bidiAttributes_ != null && !this.bidiAttributes_.equals(tmpObj.bidiAttributes_)) {
            return false;
        }
        if (this.dict_ == null ^ tmpObj.dict_ == null) {
            return false;
        }
        if (this.dict_ == null) {
            return true;
        }
        if (this.dict_.isEmpty() ^ tmpObj.dict_.isEmpty()) {
            return false;
        }
        if (this.dict_.isEmpty()) {
            return true;
        }
        if (this.dict_.size() != tmpObj.dict_.size()) {
            return false;
        }
        IFieldEnumeration myFields = null;
        IFieldEnumeration objFields = null;
        myFields = this.fields();
        objFields = tmpObj.fields();
        while (myFields.hasMoreFields()) {
            IAnyField field2;
            IAnyField field1 = myFields.nextField();
            if (field1.equals(field2 = objFields.nextField())) continue;
            return false;
        }
        return true;
    }

    public IAnyField fieldAt(String fieldName) throws RecordFieldNotFoundException {
        IAnyField field = (IAnyField)this.dict_.get(fieldName);
        if (field == null) {
            throw new RecordFieldNotFoundException(fieldName);
        }
        return field;
    }

    public IFieldEnumeration fields() {
        return new FieldEnumeration(this.dict_);
    }

    public IBidiAttributesObject getBidiAttributes() {
        return this.bidiAttributes_;
    }

    public abstract Class getRecordAttributesClass();

    public abstract int getSize();

    public IRecord newRecord() throws RecordException {
        this.pack(0);
        DynamicRecord record = new DynamicRecord(this);
        try {
            record.setRecordAttributes((IRecordAttributes)this.getRecordAttributesClass().newInstance());
        }
        catch (IllegalAccessException ex) {
            throw new InternalError(ex.getMessage());
        }
        catch (InstantiationException ex) {
            throw new InternalError(ex.getMessage());
        }
        return record;
    }

    public IRecord newRecord(IRecordAttributes attributes, int startingOffset, int alignmentOffset) throws RecordException {
        this.pack(alignmentOffset);
        return new DynamicRecord(this, attributes, startingOffset, alignmentOffset);
    }

    public IRecord newRecord(IRecordAttributes attributes, int startingOffset, int alignmentOffset, Object enclosingClass) throws RecordException {
        return this.newRecord(attributes, startingOffset, alignmentOffset);
    }

    public IRecord newRecord(Object enclosingClass) throws RecordException {
        return this.newRecord();
    }

    public IRecord newRecordWithBytes() throws RecordException {
        this.pack(0);
        byte[] bytes = new byte[this.getSize()];
        DynamicRecord record = new DynamicRecord(this);
        record.setRawBytes(bytes);
        try {
            record.setRecordAttributes((IRecordAttributes)this.getRecordAttributesClass().newInstance());
        }
        catch (IllegalAccessException ex) {
            throw new InternalError(ex.getMessage());
        }
        catch (InstantiationException ex) {
            throw new InternalError(ex.getMessage());
        }
        record.setInitialValues();
        return record;
    }

    public IRecord newRecordWithBytes(IRecordAttributes attributes, int startingOffset, int alignmentOffset) throws RecordException {
        this.pack(alignmentOffset);
        byte[] bytes = new byte[this.getSize() + startingOffset];
        DynamicRecord record = new DynamicRecord(this, attributes, startingOffset, alignmentOffset);
        record.setRawBytes(bytes);
        record.setInitialValues();
        return record;
    }

    public IRecord newRecordWithBytes(IRecordAttributes attributes, int startingOffset, int alignmentOffset, Object enclosingClass) throws RecordException {
        return this.newRecordWithBytes(attributes, startingOffset, alignmentOffset);
    }

    public IRecord newRecordWithBytes(Object enclosingClass) throws RecordException {
        return this.newRecordWithBytes();
    }

    public abstract void pack(int var1);

    public void removeField(String name) throws RecordFieldNotFoundException {
        Object removed = this.dict_.remove(name);
        if (removed == null) {
            throw new RecordFieldNotFoundException(name);
        }
    }

    public void renameField(String fieldName, String newName) throws RecordFieldNotFoundException, RecordFieldNameAlreadyExistsException {
        IAnyField field = (IAnyField)this.dict_.get(newName);
        if (field != null) {
            throw new RecordFieldNameAlreadyExistsException(newName);
        }
        field = (IAnyField)this.dict_.get(fieldName);
        if (field == null) {
            throw new RecordFieldNotFoundException(fieldName);
        }
        int index = this.dict_.indexOfKey(fieldName);
        field.setName(newName);
        this.dict_.setElementAt(newName, field, index);
    }

    public void replaceField(String name, IAnyField field) throws RecordFieldTypeNotValidException, RecordFieldNotFoundException {
        IAnyField aField = (IAnyField)this.dict_.get(name);
        if (aField == null) {
            throw new RecordFieldNotFoundException(name);
        }
        field.setName(name);
        this.dict_.put(name, field);
    }

    public void setBidiAttributes(IBidiAttributesObject bidiAttributes) {
        IBidiAttributesObject oldBidiAttributes = this.bidiAttributes_;
        this.bidiAttributes_ = bidiAttributes;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("bidiAttributes", oldBidiAttributes, this.bidiAttributes_);
        }
    }
}

