/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.logging.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.List;

public class LoggerThread {
    protected static final TraceComponent tc = Tr.register((Class)LoggerThread.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final int STATE_IDLE = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_DESTROYED = 2;
    protected static final int TIMEOUT = 10000;
    private File myFile = null;
    private FileChannel myChannel = null;
    private WorkerThread myWorker = null;
    private int state = 0;
    private int maxFileSize = -1;
    private int currentFileSize = 0;

    public LoggerThread(String string) throws FileNotFoundException {
        this.setFile(new File(string));
        this.setChannel(new FileOutputStream(this.getFile(), true).getChannel());
        this.setWorker(new WorkerThread());
    }

    protected final FileChannel getChannel() {
        return this.myChannel;
    }

    protected final void setChannel(FileChannel fileChannel) {
        this.myChannel = fileChannel;
    }

    protected final File getFile() {
        return this.myFile;
    }

    private void setFile(File file) {
        this.myFile = file;
    }

    protected final String getFileName() {
        if (null == this.getFile()) {
            return null;
        }
        try {
            return this.getFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private WorkerThread getWorker() {
        return this.myWorker;
    }

    private void setWorker(WorkerThread workerThread) {
        this.myWorker = workerThread;
    }

    private void setState(int n) {
        this.state = n;
    }

    public final boolean isIdle() {
        return 0 == this.state;
    }

    public final boolean isRunning() {
        return 1 == this.state;
    }

    public final boolean isDestroyed() {
        return 2 == this.state;
    }

    public boolean log(WsByteBuffer wsByteBuffer) {
        if (!this.isRunning() || null == wsByteBuffer) {
            return false;
        }
        return this.getWorker().enqueue(wsByteBuffer);
    }

    public boolean start() {
        if (!this.isIdle()) {
            return false;
        }
        if (null == this.getWorker()) {
            this.setWorker(new WorkerThread());
        }
        this.getWorker().start();
        this.setState(1);
        return true;
    }

    public boolean stop() {
        if (!this.isRunning()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Logger already stopped");
            }
            return true;
        }
        this.setState(0);
        this.getWorker().triggerStop();
        this.setWorker(null);
        return true;
    }

    public boolean destroy() {
        block2: {
            this.stop();
            try {
                this.getChannel().close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)(this.getClass().getName() + ".destroy"), (String)"124", (Object)this);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Failed to close the output file: " + this.getChannel()));
            }
        }
        this.setState(2);
        return true;
    }

    public final boolean setMaximumFileSize(int n) {
        if (-1 > n) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Invalid file size: " + n));
            }
            return false;
        }
        if (0 == n) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Input max-file-size is 0, using UNLIMITED");
            }
            this.maxFileSize = -1;
        } else {
            this.maxFileSize = n;
        }
        return true;
    }

    public final int getMaximumFileSize() {
        return this.maxFileSize;
    }

    protected final int getCurrentFileSize() {
        return this.currentFileSize;
    }

    protected final void resetCurrentFileSize() {
        this.currentFileSize = 0;
    }

    protected final void increaseCurrentFileSize(int n) {
        this.currentFileSize += n;
    }

    protected final boolean isOverFileLimit(int n) {
        if (-1 == this.getMaximumFileSize()) {
            return false;
        }
        if (this.getCurrentFileSize() + n > this.getMaximumFileSize()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Max file size exceeded.");
            }
            return true;
        }
        return false;
    }

    private class WorkerThread
    extends Thread {
        private boolean bStopping = false;
        private Object stopLock = new Object();
        private Object lock = new Object();
        private List queue = new LinkedList();

        protected WorkerThread() {
        }

        public void start() {
            super.start();
            this.setStopping(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean enqueue(WsByteBuffer wsByteBuffer) {
            if (this.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ignoring buffer during stop sequence");
                }
                wsByteBuffer.release();
                return false;
            }
            Object object = this.queue;
            synchronized (object) {
                this.queue.add(wsByteBuffer);
            }
            object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void triggerStop() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"triggerStop");
            }
            if (this.isStopping()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"triggerStop");
                }
                return;
            }
            this.setStopping(true);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
            try {
                object = this.stopLock;
                synchronized (object) {
                    this.stopLock.wait(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)(this.getClass().getName() + ".triggerStop"), (String)"201", (Object)this);
            }
            object = this.queue;
            synchronized (object) {
                if (!this.queue.isEmpty()) {
                    for (int i = this.queue.size(); i >= 0; ++i) {
                        ((WsByteBuffer)this.queue.remove(i)).release();
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"triggerStop");
            }
        }

        private synchronized void setStopping(boolean bl) {
            this.bStopping = bl;
        }

        private synchronized boolean isStopping() {
            return this.bStopping;
        }

        private void rotateLog() {
            block7: {
                boolean bl;
                block6: {
                    try {
                        LoggerThread.this.getChannel().close();
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)(this.getClass().getName() + ".rotateLog"), (String)"470", (Object)this);
                        if (!tc.isDebugEnabled()) break block6;
                        Tr.debug((TraceComponent)tc, (String)("Failed to close the output file: " + LoggerThread.this.getChannel()));
                    }
                }
                File file = LoggerThread.this.getFile();
                String string = file.getAbsolutePath();
                String string2 = string + ".1";
                File file2 = new File(string2);
                if (file2.exists()) {
                    file2.delete();
                }
                if (!(bl = file.renameTo(file2)) && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to create the backup log file.");
                }
                try {
                    LoggerThread.this.setChannel(new FileOutputStream(LoggerThread.this.getFile(), false).getChannel());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)"File not found exception in rotateLogs");
                }
            }
            LoggerThread.this.resetCurrentFileSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logData(WsByteBuffer wsByteBuffer) {
            int n = 0;
            int n2 = wsByteBuffer.remaining();
            if (LoggerThread.this.isOverFileLimit(n2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Rotating output log");
                }
                this.rotateLog();
            }
            try {
                while (n < n2) {
                    n += LoggerThread.this.getChannel().write(wsByteBuffer.getWrappedByteBuffer());
                }
                LoggerThread.this.increaseCurrentFileSize(n2);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)(this.getClass().getName() + ".logData"), (String)"235", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"IOException while writing to output log");
                }
            }
            finally {
                wsByteBuffer.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List list = new LinkedList();
            while (true) {
                Object object;
                if (!this.queue.isEmpty()) {
                    object = this.queue;
                    synchronized (object) {
                        LinkedList linkedList = list;
                        list = this.queue;
                        this.queue = linkedList;
                    }
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        this.logData((WsByteBuffer)list.get(i));
                    }
                    list.clear();
                }
                if (this.isStopping()) break;
                try {
                    object = this.lock;
                    synchronized (object) {
                        if (!this.queue.isEmpty()) {
                            continue;
                        }
                        this.lock.wait(10000L);
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)(this.getClass().getName() + ".run"), (String)"278", (Object)this);
                    continue;
                }
                break;
            }
            Object object = this.stopLock;
            synchronized (object) {
                this.stopLock.notify();
            }
        }
    }
}

