/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.logging.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.impl.HttpDateFormat;
import com.ibm.ws.http.logging.HTTPLoggingService;
import com.ibm.ws.http.logging.impl.LoggerThread;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.http.channel.HttpChannelUtils;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.values.HttpLogLevel;
import java.io.FileNotFoundException;

public class BaseLogger
implements HTTPLoggingService {
    private static final TraceComponent tc = Tr.register((Class)BaseLogger.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final byte[] CRLF = new byte[]{13, 10};
    private LoggerThread accessLogger = null;
    private LoggerThread errorLogger = null;
    private HttpLogLevel myLogLevel = HttpConstants.LOG_WARN;
    private boolean accessEnabled = false;
    private boolean errorEnabled = false;
    private int accessFormat = 0;

    public void createAccessLogger(String string) throws FileNotFoundException {
        this.accessLogger = new LoggerThread(string);
        this.accessEnabled = false;
    }

    public void createErrorLogger(String string, String string2) throws FileNotFoundException {
        this.errorLogger = new LoggerThread(string);
        this.errorEnabled = false;
        this.setLogLevel(string2);
    }

    public boolean enableAccessLogging() {
        if (null == this.getAccessLogger()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Enable: Access log not created yet.");
            }
            return false;
        }
        this.accessEnabled = true;
        return true;
    }

    public boolean enableErrorLogging() {
        if (null == this.getErrorLogger()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Enable: Error log not created yet.");
            }
            return false;
        }
        this.errorEnabled = true;
        return true;
    }

    public boolean disableAccessLogging() {
        if (!this.isAccessLoggingEnabled()) {
            return true;
        }
        this.accessEnabled = false;
        return this.getAccessLogger().stop();
    }

    public boolean disableErrorLogging() {
        if (!this.isErrorLoggingEnabled()) {
            return true;
        }
        this.errorEnabled = false;
        return this.getErrorLogger().stop();
    }

    public boolean startAccessLogging() {
        if (!this.isAccessLoggingEnabled()) {
            return false;
        }
        boolean bl = this.getAccessLogger().start();
        if (!bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Access logger did not start properly");
            }
            this.getAccessLogger().stop();
        }
        return bl;
    }

    public boolean startErrorLogging() {
        if (!this.isErrorLoggingEnabled()) {
            return false;
        }
        boolean bl = this.getErrorLogger().start();
        if (!bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error logger did not start properly");
            }
            this.getErrorLogger().stop();
        } else {
            this.logConfiguration();
        }
        return bl;
    }

    public boolean stopAccessLogging() {
        if (!this.isAccessLoggingEnabled()) {
            return true;
        }
        return this.getAccessLogger().stop();
    }

    public boolean stopErrorLogging() {
        if (!this.isErrorLoggingEnabled()) {
            return true;
        }
        return this.getErrorLogger().stop();
    }

    public boolean destroy() {
        this.errorEnabled = false;
        this.accessEnabled = false;
        boolean bl = this.getAccessLogger().destroy() & this.getErrorLogger().destroy();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Logger: destroy returning " + bl));
        }
        return bl;
    }

    public void log(HttpLogLevel httpLogLevel, String string, HttpServiceContext httpServiceContext) {
        if (null != string && this.isLoggingLevelEnabled(httpLogLevel)) {
            this.logMsg(httpLogLevel, HttpChannelUtils.getEnglishBytes(string), httpServiceContext);
        }
    }

    public void log(HttpLogLevel httpLogLevel, byte[] byArray, HttpServiceContext httpServiceContext) {
        if (null != byArray && this.isLoggingLevelEnabled(httpLogLevel)) {
            this.logMsg(httpLogLevel, byArray, httpServiceContext);
        }
    }

    private void logMsg(HttpLogLevel httpLogLevel, byte[] byArray, HttpServiceContext httpServiceContext) {
        block4: {
            try {
                StringBuffer stringBuffer = new StringBuffer(125);
                stringBuffer.append("[");
                stringBuffer.append(HttpDateFormat.getRef().getRFC1123Time());
                stringBuffer.append("] [");
                stringBuffer.append(httpLogLevel.getName());
                stringBuffer.append("] [");
                if (null == httpServiceContext) {
                    stringBuffer.append("-/-");
                } else {
                    stringBuffer.append(httpServiceContext.getRemoteAddr().getHostAddress());
                    stringBuffer.append(":");
                    stringBuffer.append(httpServiceContext.getRemotePort());
                    stringBuffer.append("/");
                    stringBuffer.append(httpServiceContext.getLocalAddr().getHostAddress());
                    stringBuffer.append(":");
                    stringBuffer.append(httpServiceContext.getLocalPort());
                }
                stringBuffer.append("] ");
                byte[] byArray2 = GenericUtils.getBytes(stringBuffer);
                WsByteBuffer wsByteBuffer = WsByteBufferPoolManagerImpl.getRef().allocateDirect(byArray2.length + byArray.length + 2);
                wsByteBuffer.put(byArray2);
                wsByteBuffer.put(byArray);
                wsByteBuffer.put(CRLF);
                wsByteBuffer.flip();
                this.getErrorLogger().log(wsByteBuffer);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".logMsg"), (String)"184", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Exception while writing log msg: " + exception.getMessage()));
            }
        }
    }

    public void logAccess(byte[] byArray, HttpServiceContext httpServiceContext) {
        block3: {
            if (null == byArray || !this.isAccessLoggingEnabled()) {
                return;
            }
            try {
                WsByteBuffer wsByteBuffer = WsByteBufferPoolManagerImpl.getRef().allocateDirect(byArray.length + 2);
                wsByteBuffer.put(byArray);
                wsByteBuffer.put(CRLF);
                wsByteBuffer.flip();
                this.getAccessLogger().log(wsByteBuffer);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".logAccess"), (String)"220", (Object)this);
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Exception while writing log msg: " + exception.getMessage()));
            }
        }
    }

    private final LoggerThread getAccessLogger() {
        return this.accessLogger;
    }

    public int getAccessFormat() {
        return this.accessFormat;
    }

    public boolean setAccessFormat(int n) {
        if (0 != n && 1 != n) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Ignoring invalid access format: " + n));
            }
            return false;
        }
        this.accessFormat = n;
        return true;
    }

    public boolean setAccessLogMaximumSize(int n) {
        boolean bl = this.getAccessLogger().setMaximumFileSize(n);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Logger setAccessLogMaximumSize(" + n + "): " + bl));
        }
        return bl;
    }

    private final LoggerThread getErrorLogger() {
        return this.errorLogger;
    }

    public boolean setErrorLogMaximumSize(int n) {
        boolean bl = this.getErrorLogger().setMaximumFileSize(n);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Logger setErrorLogMaximumSize(" + n + "): " + bl));
        }
        return bl;
    }

    public HttpLogLevel getLogLevel() {
        return this.myLogLevel;
    }

    private void setLogLevel(HttpLogLevel httpLogLevel) {
        this.myLogLevel = httpLogLevel;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Logger: Log level set to " + httpLogLevel.getName()));
        }
    }

    private void setLogLevel(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Input log level: " + string));
        }
        if (null == string || "".equals(string)) {
            this.setLogLevel(HttpConstants.LOG_DISABLED);
        } else if (HttpConstants.LOG_CRITICAL.getName().equalsIgnoreCase(string) || "CRITICAL".equalsIgnoreCase(string)) {
            this.setLogLevel(HttpConstants.LOG_CRITICAL);
        } else if (HttpConstants.LOG_ERROR.getName().equalsIgnoreCase(string)) {
            this.setLogLevel(HttpConstants.LOG_ERROR);
        } else if (HttpConstants.LOG_WARN.getName().equalsIgnoreCase(string) || "WARNING".equalsIgnoreCase(string)) {
            this.setLogLevel(HttpConstants.LOG_WARN);
        } else if (HttpConstants.LOG_INFO.getName().equalsIgnoreCase(string)) {
            this.setLogLevel(HttpConstants.LOG_INFO);
        } else if (HttpConstants.LOG_DEBUG.getName().equalsIgnoreCase(string)) {
            this.setLogLevel(HttpConstants.LOG_DEBUG);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unknown value found, disabling logger");
            }
            this.setLogLevel(HttpConstants.LOG_DISABLED);
        }
    }

    public boolean isAccessLoggingEnabled() {
        return this.accessEnabled;
    }

    public boolean isErrorLoggingEnabled() {
        return this.errorEnabled;
    }

    public boolean isLoggingLevelEnabled(HttpLogLevel httpLogLevel) {
        if (!this.isErrorLoggingEnabled() || null == httpLogLevel) {
            return false;
        }
        return 0 <= this.getLogLevel().compareTo(httpLogLevel);
    }

    private void logConfiguration() {
        if (!this.isLoggingLevelEnabled(HttpConstants.LOG_DEBUG)) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Logging configuration to error log file.");
        }
        this.logMsg(HttpConstants.LOG_DEBUG, HttpChannelUtils.getEnglishBytes("Configuration specifies a loglevel of " + this.getLogLevel().getName()), null);
        this.logMsg(HttpConstants.LOG_DEBUG, HttpChannelUtils.getEnglishBytes("Configuration has the error file name as : " + this.getErrorLogger().getFileName()), null);
        this.logMsg(HttpConstants.LOG_DEBUG, HttpChannelUtils.getEnglishBytes("Error log maximum file size is " + this.getErrorLogger().getMaximumFileSize()), null);
        if (this.isAccessLoggingEnabled()) {
            this.logMsg(HttpConstants.LOG_DEBUG, HttpChannelUtils.getEnglishBytes("Configuration has the access file name as : " + this.getAccessLogger().getFileName()), null);
            this.logMsg(HttpConstants.LOG_DEBUG, HttpChannelUtils.getEnglishBytes("Access log maximum file size is " + this.getAccessLogger().getMaximumFileSize()), null);
        } else {
            this.logMsg(HttpConstants.LOG_DEBUG, HttpChannelUtils.getEnglishBytes("Access log is disabled by configuration."), null);
        }
    }
}

