/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.impl.HttpBaseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.impl.HttpRequestMessageImpl;
import com.ibm.ws.http.channel.impl.HttpResponseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpServiceContextImpl;
import com.ibm.ws.http.channel.outbound.impl.HttpOSCBodyReadCallback;
import com.ibm.ws.http.channel.outbound.impl.HttpOSCReadAhead;
import com.ibm.ws.http.channel.outbound.impl.HttpOSCReadCallback;
import com.ibm.ws.http.channel.outbound.impl.HttpOSCWriteCallback;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundLink;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.BNFHeaders;
import com.ibm.wsspi.genericbnf.exception.IllegalRequestObjectException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.exception.BodyCompleteException;
import com.ibm.wsspi.http.channel.exception.ExpectationFailedException;
import com.ibm.wsspi.http.channel.exception.HttpInvalidMessageException;
import com.ibm.wsspi.http.channel.exception.IllegalHttpBodyException;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.io.IOException;

public class HttpOutboundServiceContextImpl
extends HttpServiceContextImpl
implements HttpOutboundServiceContext {
    private static final TraceComponent tc = Tr.register((Class)HttpOutboundServiceContextImpl.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    protected static final int CALLBACK_STATE_IDLE = 0;
    protected static final int CALLBACK_STATE_PENDING = 1;
    protected static final int CALLBACK_STATE_ERROR = 2;
    protected static final int CALLBACK_STATE_COMPLETE = 4;
    protected static final int READ_STATE_IDLE = 0;
    protected static final int READ_STATE_TIME_RESET = 1;
    protected static final int READ_STATE_SYNC = 3;
    protected static final int READ_STATE_ASYNC = 4;
    private HttpOutboundLink myLink = null;
    private int[] positionList = null;
    private int callback_state = 0;
    private int read_state = 0;
    private Object readAheadSyncer = new Object();
    protected Object stateSyncObject = new Object();
    private IOException readException = null;
    private boolean bReadAheadEnabled = false;
    private boolean bImmediateRead = false;
    private boolean bTempResponsesUsed = false;
    private int numResponsesReceived = 0;

    public HttpOutboundServiceContextImpl(TCPConnectionContext tCPConnectionContext, HttpOutboundLink httpOutboundLink, VirtualConnection virtualConnection, HttpChannelConfig httpChannelConfig) {
        this.init(tCPConnectionContext, httpOutboundLink, virtualConnection, httpChannelConfig);
        this.setBodyRC(HttpOSCBodyReadCallback.getRef());
        this.positionList = new int[this.getPendingBuffers().length];
    }

    public void init(TCPConnectionContext tCPConnectionContext, HttpOutboundLink httpOutboundLink, VirtualConnection virtualConnection, HttpChannelConfig httpChannelConfig) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Initializing OSC: " + this));
        }
        this.init(tCPConnectionContext, httpChannelConfig);
        this.setBodyRC(HttpOSCBodyReadCallback.getRef());
        this.setLink(httpOutboundLink);
        this.setVC(virtualConnection);
        this.getVC().getStateMap().put(CallbackIDs.CALLBACK_HTTPOSC, this);
    }

    public void destroy() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Destroying OSC: " + this));
        }
        super.destroy();
        this.setLink(null);
    }

    public void clear() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Clearing OSC: " + this));
        }
        if (null != this.getLink()) {
            this.getLink().clear();
        }
        super.clear();
        this.setReadBuffer(null);
        this.callback_state = 0;
        this.read_state = 0;
        this.readException = null;
        this.bReadAheadEnabled = false;
        this.bImmediateRead = false;
        this.bTempResponsesUsed = false;
        this.numResponsesReceived = 0;
    }

    protected void reConnect(VirtualConnection virtualConnection, IOException iOException) {
        if (this.getLink().isReconnectAllowed()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Attempting reconnect: " + this.getLink().getVirtualConnection()));
            }
            this.getLink().reConnectAsync(iOException);
        } else {
            this.callErrorCallback(virtualConnection, iOException);
        }
    }

    void callErrorCallback(VirtualConnection virtualConnection, IOException iOException) {
        this.setPersistent(false);
        if (null != this.getAppWriteCallback()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Calling error() on appside");
            }
            this.getAppWriteCallback().error(virtualConnection, (Throwable)iOException);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No appside, closing connection");
            }
            this.getLink().getDeviceLink().close(virtualConnection, (Exception)iOException);
        }
    }

    protected void reConnect(IOException iOException) throws IOException {
        if (this.getLink().isReconnectAllowed()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempting synchronous reconnect");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Reconnect sync not allowed");
            }
            this.setPersistent(false);
            throw iOException;
        }
        this.getLink().reConnectSync(iOException);
        this.nowReconnectedSync(iOException);
    }

    protected WsByteBuffer[] getBuffList() {
        int n;
        if (!this.getLink().isReconnectAllowed()) {
            return super.getBuffList();
        }
        int n2 = this.getPendingStop();
        int n3 = n2 - (n = this.getPendingStart());
        if (0 == n3) {
            return null;
        }
        WsByteBuffer[] wsByteBufferArray = this.getPendingBuffers();
        WsByteBuffer[] wsByteBufferArray2 = new WsByteBuffer[n3];
        if (this.positionList.length < wsByteBufferArray.length) {
            int[] nArray = new int[wsByteBufferArray.length];
            System.arraycopy(this.positionList, 0, nArray, 0, this.positionList.length);
            this.positionList = nArray;
        }
        int n4 = n;
        for (int i = 0; i < n3; ++i) {
            wsByteBufferArray2[i] = wsByteBufferArray[n4];
            this.positionList[n4] = wsByteBufferArray[n4].position();
            ++n4;
        }
        this.setPendingStart(n2);
        return wsByteBufferArray2;
    }

    private boolean resetWriteBuffers() {
        int n = this.getPendingStop();
        WsByteBuffer[] wsByteBufferArray = this.getPendingBuffers();
        if (null == this.positionList || null == wsByteBufferArray) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error in resetBuffers: posList: " + this.positionList + " list: " + wsByteBufferArray));
            }
            this.getWriteSC().setBuffer(null);
            return false;
        }
        for (int i = 0; i < n; ++i) {
            wsByteBufferArray[i].position(this.positionList[i]);
        }
        this.getWriteSC().setBuffers(wsByteBufferArray);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Reset positions on (" + n + ") write buffers"));
        }
        return true;
    }

    protected void nowReconnectedAsync() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Reconnected async for " + this));
        }
        if (!this.resetWriteBuffers()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Resetting buffers (async) failed");
            }
            IOException iOException = new IOException("Failed reconnect");
            if (null != this.getAppWriteCallback()) {
                this.getAppWriteCallback().error(this.getVC(), (Throwable)iOException);
            } else {
                this.getLink().getDeviceLink().close(this.getVC(), (Exception)iOException);
            }
            return;
        }
        this.setPersistent(true);
        this.updatePersistence(this.getRequestImpl());
        this.resetRead();
        VirtualConnection virtualConnection = this.getWriteSC().write(-1L, HttpOSCWriteCallback.getRef(), this.isForceAsync(), this.getWriteTimeout());
        if (null != virtualConnection) {
            if (!this.isMessageSent()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Calling callback.complete of app channel.");
                }
                this.getAppWriteCallback().complete(this.getLink().getVirtualConnection());
            } else {
                if (this.isReadAheadEnabled()) {
                    this.bReadAheadEnabled = false;
                }
                this.setupJITRead(this.getHttpConfig().getIncomingHdrBufferSize());
                this.getReadSC().read(1L, HttpOSCReadCallback.getRef(), true, this.getReadTimeout());
            }
        }
    }

    protected void nowReconnectedSync(IOException iOException) throws IOException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Reconnected sync for " + this));
        }
        if (!this.resetWriteBuffers()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Resetting buffers (sync) failed");
            }
            throw iOException;
        }
        this.setPersistent(true);
        this.updatePersistence(this.getRequestImpl());
        if (this.isReadAheadEnabled()) {
            this.bReadAheadEnabled = false;
        }
        try {
            this.getWriteSC().write(-1L, this.getWriteTimeout());
        }
        catch (IOException iOException2) {
            this.setPersistent(false);
            throw iOException2;
        }
    }

    public boolean disallowRewrites() {
        boolean bl = this.getLink().disallowRewrites();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Rewrites disabled: " + bl));
        }
        return bl;
    }

    public boolean allowRewrites() {
        boolean bl = this.getLink().allowRewrites();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Rewrites enabled: " + bl));
        }
        return bl;
    }

    public boolean isInboundConnection() {
        return false;
    }

    public VirtualConnection readNextResponse(InterChannelCallback interChannelCallback, boolean bl) {
        if (null == interChannelCallback) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"readNext: Invalid null callback as input.");
            }
            throw new NullPointerException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("App channel requesting next response on " + this.getVC()));
            Tr.debug((TraceComponent)tc, (String)("Async forcequeue flag is " + bl));
        }
        this.bTempResponsesUsed = true;
        this.getLink().disallowRewrites();
        this.setAppReadCallback(interChannelCallback);
        if (this.headersParsed() && !this.getResponseImpl().isTemporaryStatusCode()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"readNext: Final response already received.");
            }
            if (bl) {
                interChannelCallback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        if (this.headersParsed()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("readNext: Message exists, isOwner: " + this.isResponseOwner()));
            }
            this.resetMsgParsedState();
            if (!this.isResponseOwner()) {
                this.setMyResponse(null);
                this.getResponseImpl();
            } else {
                this.getResponseImpl().clear();
            }
        }
        VirtualConnection virtualConnection = this.parseResponseMessageAsync();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("readNext: return vc=" + virtualConnection));
        }
        if (null != virtualConnection && bl) {
            interChannelCallback.complete(this.getVC());
            return null;
        }
        return virtualConnection;
    }

    public void readAsyncResponse() {
        VirtualConnection virtualConnection = this.getVC();
        if (!this.setupReadBuffers(this.getHttpConfig().getIncomingHdrBufferSize(), false)) {
            virtualConnection = this.getReadSC().read(1L, HttpOSCReadCallback.getRef(), true, this.getReadTimeout());
        }
        if (null != virtualConnection && null != this.parseResponseMessageAsync()) {
            this.handleParsedMessage();
        }
    }

    public void readSyncResponse() throws IOException {
        do {
            this.parseResponseMessageSync();
            int n = this.getResponse().getStatusCodeAsInt();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("readSyncReponse: code is " + n));
            }
            if (this.isImmediateReadEnabled()) {
                return;
            }
            if (!this.getResponseImpl().isTemporaryStatusCode()) {
                return;
            }
            if (this.usingTempResponses()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"readSyncResponse: using temp response");
                }
                return;
            }
            if (this.getRequestImpl().isExpect100Continue()) {
                if (100 != n) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Expect 100-continue failed with " + n));
                    }
                    this.setPersistent(false);
                    throw new ExpectationFailedException(n + " " + this.getResponseImpl().getReasonPhrase());
                }
                if (1 == this.numberResponsesReceived() && this.isHeadersSentState()) {
                    this.resetRead();
                    return;
                }
            }
            this.resetRead();
        } while (this.numberResponsesReceived() <= this.getHttpConfig().getLimitOnNumberOfResponses());
        this.setPersistent(false);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("readSyncResponse: too many responses: " + this.numberResponsesReceived()));
        }
        throw new IOException("Max temp responses received: " + this.numberResponsesReceived());
    }

    public HttpRequestMessage getRequest() {
        return this.getRequestImpl();
    }

    private final HttpRequestMessageImpl getRequestImpl() {
        if (null == this.getMyRequest()) {
            this.setMyRequest(this.getObjectFactory().getRequest(this));
        }
        return this.getMyRequest();
    }

    public HttpResponseMessage getResponse() {
        return this.getResponseImpl();
    }

    private final HttpResponseMessageImpl getResponseImpl() {
        if (null == this.getMyResponse()) {
            this.setMyResponse(this.getObjectFactory().getResponse(this));
        }
        return this.getMyResponse();
    }

    public void setRequest(HttpRequestMessage httpRequestMessage) throws IllegalRequestObjectException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setRequest");
        }
        if (null == httpRequestMessage) {
            throw new IllegalRequestObjectException("Illegal null message");
        }
        HttpRequestMessageImpl httpRequestMessageImpl = null;
        try {
            httpRequestMessageImpl = (HttpRequestMessageImpl)httpRequestMessage;
        }
        catch (ClassCastException classCastException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Non msg impl passed to setRequest");
            }
            throw new IllegalRequestObjectException("Invalid message provided");
        }
        if (null != this.getMyRequest() && this.isRequestOwner()) {
            this.getMyRequest().destroy();
        }
        this.setMyRequest(httpRequestMessageImpl);
        this.getMyRequest().init(this);
        this.updatePersistence(this.getMyRequest());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setRequest");
        }
    }

    public void sendRequestHeaders() throws IOException, MessageSentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendRequestHeaders(sync)");
        }
        if (this.headersSent()) {
            throw new MessageSentException("Headers already sent");
        }
        this.getLink().setAllowReconnect(true);
        try {
            this.sendHeaders(this.getRequestImpl());
        }
        catch (IOException iOException) {
            this.reConnect(iOException);
        }
        if (this.shouldReadResponseImmediately()) {
            this.startResponseReadSync();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendRequestHeaders(sync)");
        }
    }

    public VirtualConnection sendRequestHeaders(InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendRequestHeaders(async)");
        }
        if (this.headersSent()) {
            throw new MessageSentException("Headers already sent");
        }
        this.getLink().setAllowReconnect(true);
        this.setForceAsync(bl);
        this.setAppWriteCallback(interChannelCallback);
        VirtualConnection virtualConnection = this.sendHeaders(this.getRequestImpl(), HttpOSCWriteCallback.getRef());
        if (null != virtualConnection && this.shouldReadResponseImmediately()) {
            virtualConnection = this.startResponseRead();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sendRequestHeaders(async): " + virtualConnection));
        }
        return virtualConnection;
    }

    public void sendRequestBody(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendRequestBody(sync)");
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting partial body true");
            }
            this.setPartialBody(true);
        }
        this.getLink().setAllowReconnect(true);
        try {
            this.sendOutgoing(wsByteBufferArray, this.getRequestImpl());
        }
        catch (IOException iOException) {
            this.reConnect(iOException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendRequestBody(sync)");
        }
    }

    public VirtualConnection sendRequestBody(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendRequestBody(async)");
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting partial body true");
            }
            this.setPartialBody(true);
        }
        this.getLink().setAllowReconnect(true);
        this.setForceAsync(bl);
        this.setAppWriteCallback(interChannelCallback);
        VirtualConnection virtualConnection = this.sendOutgoing(wsByteBufferArray, this.getRequestImpl(), HttpOSCWriteCallback.getRef());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sendRequestBody(async): " + virtualConnection));
        }
        return virtualConnection;
    }

    public void sendRawRequestBody(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendRawRequestBody(sync)");
        }
        this.setRawBody(true);
        this.sendRequestBody(wsByteBufferArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendRawRequestBody(sync)");
        }
    }

    public VirtualConnection sendRawRequestBody(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendRawRequestBody(async)");
        }
        this.setRawBody(true);
        VirtualConnection virtualConnection = this.sendRequestBody(wsByteBufferArray, interChannelCallback, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sendRawRequestBody(async): " + virtualConnection));
        }
        return virtualConnection;
    }

    public void finishRequestMessage(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finishRequestMessage(sync)");
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent() && !this.getRequestImpl().isChunkedEncodingSet()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting partial body false");
            }
            this.setPartialBody(false);
        }
        this.getLink().setAllowReconnect(true);
        try {
            this.sendFullOutgoing(wsByteBufferArray, this.getRequestImpl());
        }
        catch (IOException iOException) {
            this.reConnect(iOException);
        }
        if (this.headersParsed()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Response headers already parsed");
            }
            if (this.usingTempResponses() || !this.getResponseImpl().isTemporaryStatusCode()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"finishRequestMessage(sync): already parsed");
                }
                return;
            }
            this.resetRead();
            this.readSyncResponse();
        } else {
            this.startResponseReadSync();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finishRequestMessage(sync)");
        }
    }

    public VirtualConnection finishRequestMessage(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finishRequestMessage(async)");
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent() && !this.getRequestImpl().isChunkedEncodingSet()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Setting partial body false");
            }
            this.setPartialBody(false);
        }
        this.setForceAsync(bl);
        this.getLink().setAllowReconnect(true);
        this.setAppWriteCallback(interChannelCallback);
        VirtualConnection virtualConnection = this.sendFullOutgoing(wsByteBufferArray, this.getRequestImpl(), HttpOSCWriteCallback.getRef());
        if (null != virtualConnection) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Request write completed immediately.");
            }
            if (this.headersParsed()) {
                if (this.usingTempResponses() || !this.getResponseImpl().isTemporaryStatusCode()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"finishRequestMessage(async): already parsed");
                    }
                    return this.getVC();
                }
                this.resetRead();
                this.readAsyncResponse();
                virtualConnection = null;
            } else {
                virtualConnection = this.startResponseRead();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("finishRequestMessage(async): " + virtualConnection));
        }
        return virtualConnection;
    }

    public void finishRawRequestMessage(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finishRawRequestMessage(sync)");
        }
        this.setRawBody(true);
        this.finishRequestMessage(wsByteBufferArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finishRawRequestMessage(sync)");
        }
    }

    public VirtualConnection finishRawRequestMessage(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"finishRawRequestMessage(async)");
        }
        this.setRawBody(true);
        VirtualConnection virtualConnection = this.finishRequestMessage(wsByteBufferArray, interChannelCallback, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finishRawRequestMessage(async)");
        }
        return virtualConnection;
    }

    private HttpInvalidMessageException checkRequestValidity() {
        if (this.shouldReadResponseImmediately()) {
            return null;
        }
        int n = this.getRequest().getContentLength();
        int n2 = this.getNumBytesWritten();
        if (-1 != n && n2 != n) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Request had content-length of " + n + " but sent " + n2));
            }
            this.setPersistent(false);
            return new HttpInvalidMessageException("Request length " + n + " but sent " + n2);
        }
        return null;
    }

    protected void handleParsedMessage() {
        InterChannelCallback interChannelCallback = this.usingTempResponses() ? this.getAppReadCallback() : this.getAppWriteCallback();
        VirtualConnection virtualConnection = null;
        do {
            ++this.numResponsesReceived;
            if (!this.getResponseImpl().isTemporaryStatusCode()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Notifying app channel of final response.");
                }
                interChannelCallback.complete(this.getVC());
                return;
            }
            int n = this.getResponseImpl().getStatusCodeAsInt();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received response (#" + this.numberResponsesReceived() + "): " + n));
            }
            if (this.numberResponsesReceived() > this.getHttpConfig().getLimitOnNumberOfResponses()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Too many async temp responses received.");
                }
                interChannelCallback.error(this.getVC(), (Throwable)new IOException("Max temp responses received: " + this.numberResponsesReceived()));
                return;
            }
            if (this.usingTempResponses()) {
                interChannelCallback.complete(this.getVC());
                return;
            }
            if (this.getRequestImpl().isExpect100Continue()) {
                if (100 != n) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Expect 100-continue failed with " + n));
                    }
                    this.setPersistent(false);
                    interChannelCallback.error(this.getVC(), (Throwable)new ExpectationFailedException(n + " " + this.getResponseImpl().getReasonPhrase()));
                    return;
                }
                if (1 == this.numberResponsesReceived() && this.isHeadersSentState()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Notifying channel of first 100-continue");
                    }
                    this.resetRead();
                    interChannelCallback.complete(this.getVC());
                    return;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Ignoring temporary response...");
            }
            this.resetRead();
            virtualConnection = this.setupReadBuffers(this.getHttpConfig().getIncomingHdrBufferSize(), false) ? this.getVC() : this.getReadSC().read(1L, HttpOSCReadCallback.getRef(), false, this.getReadTimeout());
            if (null == virtualConnection) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempting a parse of response data.");
            }
            virtualConnection = this.parseResponseMessageAsync();
        } while (null != virtualConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VirtualConnection startResponseRead() {
        HttpInvalidMessageException httpInvalidMessageException;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startResponseRead");
        }
        if (null != (httpInvalidMessageException = this.checkRequestValidity())) {
            this.getAppWriteCallback().error(this.getVC(), (Throwable)httpInvalidMessageException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"startResponseRead: error");
            }
            return null;
        }
        if (this.isReadAheadEnabled() && 1 != this.getReadState()) {
            int n = 0;
            Object object = this.stateSyncObject;
            synchronized (object) {
                n = this.getCallbackState();
                this.setReadState(4);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Async response read, callback state: " + n));
            }
            switch (n) {
                case 4: {
                    this.readAsyncResponse();
                    break;
                }
                case 2: {
                    this.setPersistent(false);
                    this.reConnect(this.getVC(), this.readException);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unexpected state (" + n + ") during async readahead"));
                    }
                    this.setPersistent(false);
                    this.reConnect(this.getVC(), new IOException("Read-ahead state failure"));
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"startResponseRead: read-ahead");
            }
            return null;
        }
        if (this.usingTempResponses()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"startResponseRead: temp resp env");
            }
            this.getAppWriteCallback().complete(this.getVC());
            return null;
        }
        this.getResponseImpl();
        this.readAsyncResponse();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startResponseRead");
        }
        return null;
    }

    VirtualConnection parseResponseMessageAsync() {
        VirtualConnection virtualConnection = null;
        try {
            do {
                if (this.parseMessage()) {
                    return this.getVC();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Reading for more data to parse");
                }
                this.setupReadBuffers(this.getHttpConfig().getIncomingHdrBufferSize(), false);
            } while (null != (virtualConnection = this.getReadSC().read(1L, HttpOSCReadCallback.getRef(), false, this.getReadTimeout())));
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception while parsing response: " + exception));
            }
            this.setPersistent(false);
            if (this.usingTempResponses()) {
                this.getAppReadCallback().error(this.getVC(), (Throwable)exception);
            } else {
                this.getAppWriteCallback().error(this.getVC(), (Throwable)exception);
            }
            return null;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private void parseResponseMessageSync() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startResponseReadSync() throws IOException {
        HttpInvalidMessageException httpInvalidMessageException;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startResponseReadSync");
        }
        if (null != (httpInvalidMessageException = this.checkRequestValidity())) {
            throw httpInvalidMessageException;
        }
        if (this.isReadAheadEnabled() && 1 != this.getReadState()) {
            int n = 0;
            Object object = this.stateSyncObject;
            synchronized (object) {
                n = this.getCallbackState();
                this.setReadState(3);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Sync response read, callback state: " + n));
            }
            switch (n) {
                case 4: {
                    break;
                }
                case 2: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Read-ahead reports previous failure");
                    }
                    if (null == this.readException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Callback indicates error but no exception");
                        }
                        throw new IOException("Bad read-ahead state");
                    }
                    throw this.readException;
                }
                case 1: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Waiting for read-ahead to finish");
                    }
                    while (1 == this.getCallbackState()) {
                        try {
                            object = this.readAheadSyncer;
                            synchronized (object) {
                                this.readAheadSyncer.wait(2 * this.getHttpConfig().getReadTimeout());
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)"Read-ahead block wait timed out");
                        }
                    }
                    if (null == this.readException) break;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Read-ahead reports new failure");
                    }
                    throw this.readException;
                }
                default: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unexpected state (" + n + ") during sync readahead"));
                    }
                    throw new IOException("Read-ahead state failure: " + n);
                }
            }
        }
        this.getResponseImpl();
        this.readSyncResponse();
    }

    private boolean checkBodyValidity() throws IOException {
        if (this.isImmediateReadEnabled()) {
            if (!this.headersParsed()) {
                IOException iOException = new IOException("Request headers not sent yet");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Attempt to read response prior to sendRequest");
                }
                throw iOException;
            }
        } else if (!this.isMessageSent()) {
            IOException iOException = new IOException("Request not finished yet");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Attempt to read response prior to finishRequest");
            }
            throw iOException;
        }
        return this.isIncomingBodyValid();
    }

    public WsByteBuffer[] getResponseBodyBuffers() throws IOException, IllegalHttpBodyException {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getResponseBodyBuffers(sync)");
            }
            if (!this.checkBodyValidity()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffers(sync): No body allowed");
                }
                return null;
            }
            this.setMultiRead(true);
            if (!this.isBodyComplete()) {
                try {
                    this.readBodyBuffers(this.getResponseImpl(), false);
                }
                catch (BodyCompleteException bodyCompleteException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffers(sync): BodyCompleteException");
                    }
                    return null;
                }
                catch (IllegalHttpBodyException illegalHttpBodyException) {
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug((TraceComponent)tc, (String)("Unexpected exception: " + illegalHttpBodyException));
                }
            }
        }
        WsByteBuffer[] wsByteBufferArray = this.getAllStorageBuffers();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getResponseBodyBuffers(sync): " + (null == wsByteBufferArray ? 0 : wsByteBufferArray.length)));
        }
        return wsByteBufferArray;
    }

    public VirtualConnection getResponseBodyBuffers(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResponseBodyBuffers(async)");
        }
        try {
            if (!this.checkBodyValidity() || this.incomingBuffersReady()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffers(async): read not needed");
                }
                if (bl) {
                    interChannelCallback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IOException iOException) {
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getResponseBodyBuffers(async): error=" + iOException));
            }
            return null;
        }
        if (this.isBodyComplete()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffers(async): body complete");
            }
            if (bl) {
                interChannelCallback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        this.setAppReadCallback(interChannelCallback);
        this.setForceAsync(bl);
        this.setMultiRead(true);
        try {
            if (!this.readBodyBuffers(this.getResponseImpl(), true)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffers(async): read already");
                }
                if (bl) {
                    interChannelCallback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IllegalHttpBodyException illegalHttpBodyException) {
            interChannelCallback.error(this.getVC(), (Throwable)illegalHttpBodyException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResponseBodybuffers(async): illegal body");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffers(async): null");
        }
        return null;
    }

    public WsByteBuffer getResponseBodyBuffer() throws IOException, IllegalHttpBodyException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResponseBodyBuffer(sync)");
        }
        if (!this.checkBodyValidity()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffer(sync): No body allowed");
            }
            return null;
        }
        this.setMultiRead(false);
        WsByteBuffer wsByteBuffer = this.getNextBuffer();
        if (null == wsByteBuffer && !this.isBodyComplete()) {
            block9: {
                try {
                    this.readBodyBuffer(this.getResponseImpl(), false);
                }
                catch (BodyCompleteException bodyCompleteException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffer(sync): BodyCompleteException");
                    }
                    return null;
                }
                catch (IllegalHttpBodyException illegalHttpBodyException) {
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug((TraceComponent)tc, (String)("Unexpected exception: " + illegalHttpBodyException));
                }
            }
            wsByteBuffer = this.getNextBuffer();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getResponseBodyBuffer(sync): " + wsByteBuffer));
        }
        return wsByteBuffer;
    }

    public VirtualConnection getResponseBodyBuffer(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResponseBodyBuffer(async)");
        }
        try {
            if (!this.checkBodyValidity() || this.incomingBuffersReady()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffer(async): read not needed");
                }
                if (bl) {
                    interChannelCallback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IOException iOException) {
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getResponseBodyBuffer(async): error " + iOException));
            }
            return null;
        }
        if (this.isBodyComplete()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffer(async): body complete");
            }
            if (bl) {
                interChannelCallback.complete(this.getVC());
                return null;
            }
            return this.getVC();
        }
        this.setAppReadCallback(interChannelCallback);
        this.setForceAsync(bl);
        this.setMultiRead(false);
        try {
            if (!this.readBodyBuffer(this.getResponseImpl(), true)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffer(async): read finished");
                }
                if (bl) {
                    interChannelCallback.complete(this.getVC());
                    return null;
                }
                return this.getVC();
            }
        }
        catch (IllegalHttpBodyException illegalHttpBodyException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffer(async): illegal body");
            }
            interChannelCallback.error(this.getVC(), (Throwable)illegalHttpBodyException);
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResponseBodyBuffer(async): null");
        }
        return null;
    }

    public WsByteBuffer getRawResponseBodyBuffer() throws IOException, IllegalHttpBodyException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRawResponseBodyBuffer(sync)");
        }
        this.setRawBody(true);
        WsByteBuffer wsByteBuffer = this.getResponseBodyBuffer();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRawResponseBodyBuffer(sync): " + wsByteBuffer));
        }
        return wsByteBuffer;
    }

    public WsByteBuffer[] getRawResponseBodyBuffers() throws IOException, IllegalHttpBodyException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRawResponseBodyBuffers(sync)");
        }
        this.setRawBody(true);
        WsByteBuffer[] wsByteBufferArray = this.getResponseBodyBuffers();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRawResponseBodyBuffers(sync): " + wsByteBufferArray));
        }
        return wsByteBufferArray;
    }

    public VirtualConnection getRawResponseBodyBuffer(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRawResponseBodyBuffer(async)");
        }
        this.setRawBody(true);
        VirtualConnection virtualConnection = this.getResponseBodyBuffer(interChannelCallback, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRawResponseBodyBuffer(async): " + virtualConnection));
        }
        return virtualConnection;
    }

    public VirtualConnection getRawResponseBodyBuffers(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRawResponseBodyBuffers(async)");
        }
        this.setRawBody(true);
        VirtualConnection virtualConnection = this.getResponseBodyBuffers(interChannelCallback, bl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRawResponseBodyBuffers(async): " + virtualConnection));
        }
        return virtualConnection;
    }

    protected boolean readUntilEnd(boolean bl) throws IllegalHttpBodyException, BodyCompleteException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Called readUntilEnd");
        }
        if (!this.isReadDataAvailable()) {
            if (this.fillABuffer(1, bl)) {
                return true;
            }
            if (this.isBodyComplete()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"End of body found in new buffer");
                }
                return false;
            }
        }
        int n = this.getReadBuffer().position();
        int n2 = this.getReadBuffer().limit();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Current body buffer " + this.getReadBuffer()));
        }
        if (0 == n && n2 == this.getReadBuffer().capacity()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Return a full buffer");
            }
            this.storeTempBuffer(this.returnLastBuffer());
            this.setReadBuffer(null);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Slice the return buffer");
            }
            this.storeTempBuffer(this.getReadBuffer().slice());
            this.getReadBuffer().position(n2);
        }
        return false;
    }

    protected final HttpBaseMessageImpl getMessageBeingParsed() {
        return this.getResponseImpl();
    }

    protected final HttpBaseMessageImpl getMessageBeingSent() {
        return this.getRequestImpl();
    }

    public final HttpOutboundLink getLink() {
        return this.myLink;
    }

    private final void setLink(HttpOutboundLink httpOutboundLink) {
        this.myLink = httpOutboundLink;
    }

    protected boolean reconnectAllowed() {
        return this.getLink().isReconnectAllowed();
    }

    public HttpObjectFactory getObjectFactory() {
        return null == this.getLink() ? null : this.getLink().getObjectFactory();
    }

    protected WsByteBuffer createChunkHeader(byte[] byArray) {
        if (!this.getLink().isReconnectAllowed()) {
            return super.createChunkHeader(byArray);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"OSC creating chunk length buffer");
        }
        WsByteBuffer wsByteBuffer = this.allocateBuffer(32);
        wsByteBuffer.put(byArray);
        wsByteBuffer.put(BNFHeaders.EOL);
        wsByteBuffer.flip();
        return wsByteBuffer;
    }

    protected WsByteBuffer createChunkTrailer() {
        if (!this.getLink().isReconnectAllowed()) {
            return super.createChunkTrailer();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"OSC creating chunk trailer");
        }
        WsByteBuffer wsByteBuffer = this.allocateBuffer(32);
        wsByteBuffer.put(HttpServiceContextImpl.CHUNK_TRAILER_DATA);
        wsByteBuffer.flip();
        return wsByteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerReadAhead(InterChannelCallback interChannelCallback, int n) {
        int n2;
        int n3;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Read-ahead requested (timeout=" + n + ") " + this.getVC()));
        }
        if (-1 > n) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invalid timeout used by caller.");
            }
            return false;
        }
        Object object = this.stateSyncObject;
        synchronized (object) {
            n3 = this.getCallbackState();
            n2 = this.getReadState();
            this.setCallbackState(1, null);
        }
        if (0 != n3) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Callback state is invalid: " + n3));
            }
            return false;
        }
        if (0 != n2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Read for response state is invalid: " + n2));
            }
            return false;
        }
        this.bReadAheadEnabled = true;
        int n4 = -1 == n ? this.getReadTimeout() : n;
        this.setAppReadCallback(interChannelCallback);
        this.setupJITRead(this.getHttpConfig().getIncomingHdrBufferSize());
        this.getReadSC().read(1L, HttpOSCReadAhead.getRef(), true, n4);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("App channel called init: " + this));
        }
        int n = 0;
        int n2 = 0;
        if (this.isReadAheadEnabled()) {
            Object object = this.stateSyncObject;
            synchronized (object) {
                n = this.getCallbackState();
                n2 = this.getReadState();
                this.setReadState(1);
            }
        }
        if (0 == n) {
            return true;
        }
        if (1 != n) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Callback state indicates error: " + n));
            }
            return false;
        }
        if (0 != n2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Read for response state indicates error: " + n2));
            }
            return false;
        }
        this.getReadSC().read(1L, null, true, -2);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Canceled outstanding read call.");
        }
        return true;
    }

    protected int getCallbackState() {
        return this.callback_state;
    }

    protected void setCallbackState(int n, IOException iOException) {
        this.callback_state = n;
        this.readException = iOException;
    }

    protected int getReadState() {
        return this.read_state;
    }

    protected void setReadState(int n) {
        this.read_state = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakeupReadAhead() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Received synchronous read-ahead wake-up call.");
        }
        Object object = this.readAheadSyncer;
        synchronized (object) {
            this.readAheadSyncer.notify();
        }
    }

    private boolean usingTempResponses() {
        return this.bTempResponsesUsed;
    }

    private int numberResponsesReceived() {
        return this.numResponsesReceived;
    }

    private boolean isReadAheadEnabled() {
        return this.bReadAheadEnabled;
    }

    protected boolean isImmediateReadEnabled() {
        return this.bImmediateRead;
    }

    public boolean enableImmediateResponseRead() {
        if (this.headersSent()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Request hdrs already sent, too late for immediate read");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Immediate response read requested: " + this.getVC()));
        }
        this.bImmediateRead = true;
        return true;
    }

    protected boolean shouldReadResponseImmediately() {
        return this.isImmediateReadEnabled() || this.getRequestImpl().isExpect100Continue() || this.getRequestImpl().containsHeader(HttpConstants.HDR_UPGRADE);
    }
}

