/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;

public class HttpOSCReadCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register((Class)HttpOSCReadCallback.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static HttpOSCReadCallback myInstance = null;

    private HttpOSCReadCallback() {
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new HttpOSCReadCallback();
        }
    }

    public static final HttpOSCReadCallback getRef() {
        if (null == myInstance) {
            HttpOSCReadCallback.createSingleton();
        }
        return myInstance;
    }

    public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("complete() called: " + virtualConnection));
        }
        if (null == virtualConnection) {
            return;
        }
        Object v = virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        if (null == v) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR: null OSC in complete()");
            }
            return;
        }
        HttpOutboundServiceContextImpl httpOutboundServiceContextImpl = (HttpOutboundServiceContextImpl)v;
        VirtualConnection virtualConnection2 = null;
        try {
            do {
                if (httpOutboundServiceContextImpl.parseMessage()) {
                    httpOutboundServiceContextImpl.handleParsedMessage();
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Reading for more data");
                }
                httpOutboundServiceContextImpl.setupReadBuffers(httpOutboundServiceContextImpl.getHttpConfig().getIncomingHdrBufferSize(), false);
            } while (null != (virtualConnection2 = tCPReadRequestContext.read(1L, this, false, httpOutboundServiceContextImpl.getReadTimeout())));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".complete"), (String)"112", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception: " + exception.getMessage()));
            }
            httpOutboundServiceContextImpl.setPersistent(false);
            httpOutboundServiceContextImpl.getAppWriteCallback().error(virtualConnection, (Throwable)exception);
        }
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error() called: " + virtualConnection));
        }
        if (null == virtualConnection) {
            return;
        }
        Object v = virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        if (null == v) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ERROR: null OSC in error()");
            }
            return;
        }
        HttpOutboundServiceContextImpl httpOutboundServiceContextImpl = (HttpOutboundServiceContextImpl)v;
        httpOutboundServiceContextImpl.setPersistent(false);
        httpOutboundServiceContextImpl.reConnect(virtualConnection, iOException);
    }
}

