/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.matcher.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.QuickCaseInsensitiveMatcher;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.values.TransferEncodingValues;
import java.util.Iterator;

public class TransferEncodingMatcher
extends QuickCaseInsensitiveMatcher {
    private static final TraceComponent tc = Tr.register((Class)TransferEncodingMatcher.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static TransferEncodingMatcher myInstance = null;

    private TransferEncodingMatcher() {
        super(true);
        this.init();
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new TransferEncodingMatcher();
        }
    }

    public static final TransferEncodingMatcher getRef() {
        if (null == myInstance) {
            TransferEncodingMatcher.createSingleton();
        }
        return myInstance;
    }

    public TransferEncodingValues matchTransferEncoding(String string) {
        return (TransferEncodingValues)super.match(string);
    }

    public TransferEncodingValues matchTransferEncoding(StringBuffer stringBuffer) {
        return (TransferEncodingValues)super.match(stringBuffer);
    }

    public TransferEncodingValues matchTransferEncoding(byte[] byArray) {
        return (TransferEncodingValues)super.match(byArray);
    }

    public void init() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Intializing the Transfer-Encoding matcher");
        }
        TransferEncodingValues transferEncodingValues = HttpConstants.TRANSFER_ENCODING_CHUNKED;
        Iterator iterator = TransferEncodingValues.getAllKeys().iterator();
        while (iterator.hasNext()) {
            transferEncodingValues = (TransferEncodingValues)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Matcher storing " + transferEncodingValues));
            }
            super.add(transferEncodingValues);
        }
        super.init();
    }

    public static void main(String[] stringArray) {
        System.out.println("Started");
        TransferEncodingMatcher transferEncodingMatcher = TransferEncodingMatcher.getRef();
        System.out.println("matching...");
        System.out.println();
        System.out.println("Following should find matches...");
        System.out.println("Matching (String) gzip " + transferEncodingMatcher.matchTransferEncoding("gzip"));
        String string = "CHunkED";
        System.out.println("Matching (String) " + string + " " + transferEncodingMatcher.matchTransferEncoding(string));
        string = "ideNTITY";
        System.out.println("Matching (byte[]) " + string + " " + transferEncodingMatcher.matchTransferEncoding(string.getBytes()));
        System.out.println();
        System.out.println("Following should return null responses...");
        string = "super-content";
        System.out.println("Matching (StringBuffer) " + string + " " + transferEncodingMatcher.matchTransferEncoding(new StringBuffer(string)));
        string = "chunkified";
        System.out.println("Matching (String) " + string + " " + transferEncodingMatcher.matchTransferEncoding(string));
    }
}

