/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.matcher.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.QuickCaseInsensitiveMatcher;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.values.ContentEncodingValues;
import java.util.Iterator;

public class ContentEncodingMatcher
extends QuickCaseInsensitiveMatcher {
    private static final TraceComponent tc = Tr.register((Class)ContentEncodingMatcher.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static ContentEncodingMatcher myInstance = null;

    private ContentEncodingMatcher() {
        super(true);
        this.init();
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new ContentEncodingMatcher();
        }
    }

    public static final ContentEncodingMatcher getRef() {
        if (null == myInstance) {
            ContentEncodingMatcher.createSingleton();
        }
        return myInstance;
    }

    public ContentEncodingValues matchContentEncoding(String string) {
        return (ContentEncodingValues)super.match(string);
    }

    public ContentEncodingValues matchContentEncoding(StringBuffer stringBuffer) {
        return (ContentEncodingValues)super.match(stringBuffer);
    }

    public ContentEncodingValues matchContentEncoding(byte[] byArray) {
        return (ContentEncodingValues)super.match(byArray);
    }

    public void init() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Initializing the Content-Encoding matcher");
        }
        ContentEncodingValues contentEncodingValues = HttpConstants.CONTENT_ENCODING_COMPRESS;
        Iterator iterator = ContentEncodingValues.getAllKeys().iterator();
        while (iterator.hasNext()) {
            contentEncodingValues = (ContentEncodingValues)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Matcher storing " + contentEncodingValues));
            }
            super.add(contentEncodingValues);
        }
        super.init();
    }

    public static void main(String[] stringArray) {
        System.out.println("Started");
        ContentEncodingMatcher contentEncodingMatcher = ContentEncodingMatcher.getRef();
        System.out.println("matching...");
        System.out.println();
        System.out.println("Following should find matches...");
        System.out.println("Matching (String) gzip " + contentEncodingMatcher.matchContentEncoding("gzip"));
        String string = "x-compress";
        System.out.println("Matching (String) " + string + " " + contentEncodingMatcher.matchContentEncoding(string));
        string = "ideNTITY";
        System.out.println("Matching (byte[]) " + string + " " + contentEncodingMatcher.matchContentEncoding(string.getBytes()));
        string = "compress, x-gzip";
        System.out.println("Matching: " + contentEncodingMatcher.match(string.getBytes(), 10, 6));
        System.out.println();
        System.out.println("Following should return null responses...");
        string = "super-content";
        System.out.println("Matching (StringBuffer) " + string + " " + contentEncodingMatcher.matchContentEncoding(new StringBuffer(string)));
    }
}

