/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.matcher.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.QuickCaseInsensitiveMatcher;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.values.ConnectionValues;
import java.util.Iterator;

public class ConnectionMatcher
extends QuickCaseInsensitiveMatcher {
    private static final TraceComponent tc = Tr.register((Class)ConnectionMatcher.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static ConnectionMatcher myInstance = null;

    private ConnectionMatcher() {
        super(true);
        this.init();
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new ConnectionMatcher();
        }
    }

    public static final ConnectionMatcher getRef() {
        if (null == myInstance) {
            ConnectionMatcher.createSingleton();
        }
        return myInstance;
    }

    public ConnectionValues matchConnection(String string) {
        return (ConnectionValues)super.match(string);
    }

    public ConnectionValues matchConnection(StringBuffer stringBuffer) {
        return (ConnectionValues)super.match(stringBuffer);
    }

    public ConnectionValues matchConnection(byte[] byArray) {
        return (ConnectionValues)super.match(byArray);
    }

    public void init() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Initializing the Connection matcher");
        }
        ConnectionValues connectionValues = HttpConstants.CONN_NOTSET;
        Iterator iterator = ConnectionValues.getAllKeys().iterator();
        while (iterator.hasNext()) {
            connectionValues = (ConnectionValues)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Matcher storing " + connectionValues));
            }
            super.add(connectionValues);
        }
        super.init();
    }

    public static void main(String[] stringArray) {
        System.out.println("Started");
        ConnectionMatcher connectionMatcher = ConnectionMatcher.getRef();
        System.out.println("matching...");
        System.out.println();
        System.out.println("Following should find matches...");
        System.out.println("Matching (String) Close " + connectionMatcher.matchConnection("Close"));
        String string = "KEEP-alive";
        System.out.println("Matching (String) " + string + " " + connectionMatcher.matchConnection(string));
        string = "Keep-ALIVE";
        System.out.println("Matching (byte[]) " + string + " " + connectionMatcher.matchConnection(string.getBytes()));
        System.out.println();
        System.out.println("Following should return null responses...");
        string = "Staying-Alive";
        System.out.println("Matching (StringBuffer) " + string + " " + connectionMatcher.matchConnection(new StringBuffer(string)));
    }
}

