/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.websphere.models.config.channelservice.InboundTransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.websphere.models.config.channelservice.channels.HTTPInboundChannel;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundChannel;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundChannelFactory;
import com.ibm.ws.http.channel.inbound.impl.WSHttpOutboundDefinition;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.WSChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import com.ibm.wsspi.channel.framework.exception.InvalidChannelFactoryException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class WSHttpInboundChannelFactory
extends HttpInboundChannelFactory
implements WSChannelFactory {
    private static final String ZOS_DEFAULT_MESSAGE_SIZE = "10000000";
    private static final String ZOS_DEFAULT_LARGE_MESSAGE_SIZE = "100000000";

    public Channel createChannel(ChannelData channelData) {
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        if (platformHelper.isZOS()) {
            channelData.getPropertyBag().put("RunningOnZOS", "true");
            if (platformHelper.isBaseServantJvm()) {
                channelData.getPropertyBag().put("ServantRegion", "true");
                channelData.getPropertyBag().put("MaxKeepAliveRequests", "-1");
            }
        }
        return new HttpInboundChannel(channelData, this, this.getObjectFactory());
    }

    public Map createFactoryConfigurationMap(TransportChannelFactory transportChannelFactory, ChannelFrameworkService channelFrameworkService) {
        EList eList;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        if (platformHelper.isZOS()) {
            hashMap.put("MessageSizeLimit", ZOS_DEFAULT_MESSAGE_SIZE);
            hashMap.put("LargeMessageSize", ZOS_DEFAULT_LARGE_MESSAGE_SIZE);
        }
        if (null != (eList = transportChannelFactory.getProperties())) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                hashMap.put(property.getName(), property.getValue());
            }
        }
        return hashMap;
    }

    public Map createChannelConfigurationMap(TransportChannel transportChannel, ChannelFrameworkService channelFrameworkService) {
        EList eList;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HTTPInboundChannel hTTPInboundChannel = (HTTPInboundChannel)transportChannel;
        if (hTTPInboundChannel.isSetMaximumPersistentRequests()) {
            hashMap.put("MaxKeepAliveRequests", String.valueOf(hTTPInboundChannel.getMaximumPersistentRequests()));
        }
        if (hTTPInboundChannel.isSetKeepAlive()) {
            hashMap.put("defaultToOutgoingKeepAlive", String.valueOf(hTTPInboundChannel.isKeepAlive()));
        }
        if (hTTPInboundChannel.isSetPersistentTimeout()) {
            hashMap.put("persistTimeout", String.valueOf(hTTPInboundChannel.getPersistentTimeout()));
        }
        if (hTTPInboundChannel.isSetReadTimeout()) {
            hashMap.put("readTimeout", String.valueOf(hTTPInboundChannel.getReadTimeout()));
        }
        if (hTTPInboundChannel.isSetWriteTimeout()) {
            hashMap.put("writeTimeout", String.valueOf(hTTPInboundChannel.getWriteTimeout()));
        }
        if (hTTPInboundChannel.isSetEnableLogging()) {
            hashMap.put("loggingDisable", String.valueOf(!hTTPInboundChannel.isEnableLogging()));
        }
        if (null != (eList = hTTPInboundChannel.getProperties())) {
            VariableMap variableMap = (VariableMap)channelFrameworkService.lookupService(VariableMap.class);
            Iterator iterator = eList.iterator();
            Property property = null;
            while (iterator.hasNext()) {
                property = (Property)iterator.next();
                property = this.checkVarExpansion(property, variableMap);
                hashMap.put(property.getName(), property.getValue());
            }
        }
        return hashMap;
    }

    private Property checkVarExpansion(Property property, VariableMap variableMap) {
        if (null == variableMap) {
            return property;
        }
        String string = property.getName();
        try {
            if ("accessLogFileName".equals(string) || "errorLogFileName".equals(string)) {
                property.setValue(variableMap.expand(property.getValue()));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)(((Object)((Object)this)).getClass().getName() + ".checkVarExpansion"), (String)"155");
        }
        return property;
    }

    public OutboundChannelDefinition getOutboundChannelDefinition(Map map) {
        return new WSHttpOutboundDefinition(map);
    }

    public String determineAcceptorID(InboundTransportChannel inboundTransportChannel) {
        return null;
    }
}

