/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.Map;

public class HttpFactoryConfig {
    private static final TraceComponent tc = Tr.register((Class)HttpFactoryConfig.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    private int msgSizeLimit = 0;
    private int msgSizeLargeBuffer = 0;

    public HttpFactoryConfig(Map map) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Parsing config for factory");
        }
        if (null == map) {
            return;
        }
        this.parseMsgSize(map);
        this.parseMsgLargeBuffer(map);
    }

    private void parseMsgSize(Map map) {
        block4: {
            String string = (String)map.get("MessageSizeLimit");
            if (null != string) {
                try {
                    this.msgSizeLimit = Integer.parseInt(string);
                    if (0 > this.getMessageSize() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Config: Invalid size, setting to unlimited: " + this.getMessageSize()));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, (String)(this.getClass().getName() + ".parseMsgSize"), (String)"72", (Object)this);
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)("Config: Maximum message size of [" + string + "] is incorrect"));
                }
            }
        }
    }

    public int getMessageSize() {
        return this.msgSizeLimit;
    }

    public boolean areMessagesLimited() {
        return 0 != this.getMessageSize();
    }

    private void parseMsgLargeBuffer(Map map) {
        block6: {
            if (!this.areMessagesLimited()) {
                return;
            }
            String string = (String)map.get("LargeMessageSize");
            if (null != string) {
                try {
                    this.msgSizeLargeBuffer = Integer.parseInt(string);
                    if (this.getLargerBufferSize() < this.getMessageSize()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Config: large buffer size is too small: " + this.getLargerBufferSize()));
                        }
                        this.msgSizeLargeBuffer = this.getMessageSize();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, (String)(this.getClass().getName() + ".parseMsgLargeBuffer"), (String)"98", (Object)this);
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)("Config: Large buffer size of [" + string + "] is incorrect"));
                }
            }
        }
    }

    public int getLargerBufferSize() {
        return this.msgSizeLargeBuffer;
    }
}

