/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.channel.impl.HttpLocalFormat;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.ws.util.WSThreadLocal;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;

public class HttpDateFormat {
    private static final TraceComponent tc = Tr.register((Class)HttpDateFormat.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    private WSThreadLocal threadStorage = new WSThreadLocal();
    private static HttpDateFormat myInstance = null;

    private HttpDateFormat() {
        this.getStorage().set((Object)new HttpLocalFormat());
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new HttpDateFormat();
        }
    }

    public static final HttpDateFormat getRef() {
        if (null == myInstance) {
            HttpDateFormat.createSingleton();
        }
        return myInstance;
    }

    private WSThreadLocal getStorage() {
        return this.threadStorage;
    }

    private HttpLocalFormat getFormat() {
        HttpLocalFormat httpLocalFormat = (HttpLocalFormat)this.getStorage().get();
        if (null == httpLocalFormat) {
            httpLocalFormat = new HttpLocalFormat();
            this.getStorage().set((Object)httpLocalFormat);
        }
        return httpLocalFormat;
    }

    public String getRFC1123Time(Date date) {
        return this.getFormat().get1123Format().format(date);
    }

    public String getRFC1036Time(Date date) {
        return this.getFormat().get1036Format().format(date);
    }

    public String getASCIITime(Date date) {
        return this.getFormat().getAsciiFormat().format(date);
    }

    public String getNCSATime(Date date) {
        return this.getFormat().getNCSAFormat().format(date);
    }

    public String getRFC1123Time() {
        return this.getRFC1123Time(new Date(QuickApproxTime.getRef().getApproxTime()));
    }

    public String getRFC1036Time() {
        return this.getRFC1036Time(new Date(QuickApproxTime.getRef().getApproxTime()));
    }

    public String getASCIITime() {
        return this.getASCIITime(new Date(QuickApproxTime.getRef().getApproxTime()));
    }

    public String getNCSATime() {
        return this.getNCSATime(new Date(QuickApproxTime.getRef().getApproxTime()));
    }

    private Date attemptParseRFC1123(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = this.getFormat().get1123Format().parse(string, parsePosition);
        if (0 == parsePosition.getIndex() || parsePosition.getIndex() != string.length()) {
            return null;
        }
        return date;
    }

    public Date parseRFC1123Time(String string) throws ParseException {
        Date date;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("rfc1123 parsing [" + string + "]"));
        }
        if (null == (date = this.attemptParseRFC1123(string))) {
            throw new ParseException("Unparseable [" + string + "]", 0);
        }
        return date;
    }

    private Date attemptParseRFC1036(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = this.getFormat().get1036Format().parse(string, parsePosition);
        if (0 == parsePosition.getIndex() || parsePosition.getIndex() != string.length()) {
            return null;
        }
        return date;
    }

    public Date parseRFC1036Time(String string) throws ParseException {
        Date date;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("rfc1036 parsing [" + string + "]"));
        }
        if (null == (date = this.attemptParseRFC1036(string))) {
            throw new ParseException("Unparseable [" + string + "]", 0);
        }
        return date;
    }

    private Date attemptParseASCII(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = this.getFormat().getAsciiFormat().parse(string, parsePosition);
        if (0 == parsePosition.getIndex() || parsePosition.getIndex() != string.length()) {
            return null;
        }
        return date;
    }

    public Date parseASCIITime(String string) throws ParseException {
        Date date;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ascii parsing [" + string + "]"));
        }
        if (null == (date = this.attemptParseASCII(string))) {
            throw new ParseException("Unparseable [" + string + "]", 0);
        }
        return date;
    }

    public Date parseTime(String string) throws ParseException {
        Date date;
        String string2;
        int n;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parseTime parsing [" + string + "]"));
        }
        if (-1 != (n = (string2 = string).indexOf(59, 0))) {
            char c;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Ignoring excess data following semi-colon in date");
            }
            while (n > 20 && (' ' == (c = string2.charAt(n - 1)) || '\t' == c)) {
                --n;
            }
            if (20 >= n) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Not enough data left to make a valid date");
                }
                throw new ParseException("Invalid date [" + string + "]", 0);
            }
            string2 = string.substring(0, n);
        }
        if (null == (date = this.attemptParseRFC1123(string2)) && null == (date = this.attemptParseRFC1036(string2)) && null == (date = this.attemptParseASCII(string2))) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Time does not match supported formats");
            }
            throw new ParseException("Unparseable [" + string2 + "]", 0);
        }
        return date;
    }

    public Date parseTime(byte[] byArray) throws ParseException {
        return this.parseTime(GenericUtils.getEnglishString(byArray));
    }
}

