/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.http.logging.HTTPLoggingService;
import com.ibm.ws.http.logging.impl.BaseLogger;
import com.ibm.ws.http.logging.impl.DisabledHTTPLogger;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.values.VersionValues;
import java.io.FileNotFoundException;
import java.util.Map;

public class HttpChannelConfig {
    private static final TraceComponent tc = Tr.register((Class)HttpChannelConfig.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final int TIMEOUT_MODIFIER = 1000;
    private static final boolean DEF_KEEP_ALIVE_ENABLED = true;
    private static final int DEF_MAX_PERSIST_REQ = 100;
    private static final int DEF_BYTE_CACHE_SIZE = 512;
    private static final int DEF_OUTGOING_HDR_BUFF_SIZE = 1024;
    private static final int DEF_INCOMING_HDR_BUFF_SIZE = 8192;
    private static final int DEF_INCOMING_BODY_BUFF_SIZE = 32768;
    private static final int DEF_PERSIST_TIMEOUT = 30000;
    private static final int DEF_READ_TIMEOUT = 60000;
    private static final int DEF_WRITE_TIMEOUT = 60000;
    private static final int DEF_LIMIT_NUM_RESPONSES = 10;
    private int maxPersistRequest = 100;
    private VersionValues outgoingHttpVersion = HttpConstants.HTTP_VERSION_11;
    private boolean bDirectBuffers = true;
    private boolean bKeepAliveEnabled = true;
    private int outgoingHdrBuffSize = 1024;
    private int incomingHdrBuffSize = 8192;
    private int incomingBodyBuffSize = 32768;
    private int persistTimeout = 30000;
    private int readTimeout = 60000;
    private int writeTimeout = 60000;
    private int byteCacheSize = 512;
    private boolean bExtractValue = true;
    private boolean bBinaryTransport = false;
    private HTTPLoggingService httpLogger = DisabledHTTPLogger.getRef();
    private int limitFieldSize = 32768;
    private int limitNumHeaders = 500;
    private int limitNumResponses = 10;
    private boolean bKeepThread = false;
    private boolean bAllowRetries = true;
    private boolean bServantRegion = false;
    private boolean bRunningOnZOS = false;
    private boolean bHeaderValidation = true;
    private boolean bJITOnlyReads = false;
    private boolean bStrictURLFormat = false;
    private boolean bRemoveServerHeader = false;
    private byte[] baServerHeaderValue = null;

    public HttpChannelConfig(ChannelData channelData) {
        this.parseConfig(channelData);
    }

    private void parseConfig(ChannelData channelData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("parseConfig: " + channelData.getName()));
        }
        Map map = channelData.getPropertyBag();
        this.parseZOSInfo(map);
        this.parsePersistence(map);
        this.parseOutgoingVersion(map);
        this.parseBufferType(map);
        this.parseOutgoingBufferSize(map);
        this.parseIncomingHdrBufferSize(map);
        this.parseIncomingBodyBufferSize(map);
        this.parsePersistTimeout(map);
        this.parseReadTimeout(map);
        this.parseWriteTimeout(map);
        this.parseByteCacheSize(map);
        this.parseDelayedExtract(map);
        this.parseBinaryTransport(map);
        this.parseLimitFieldSize(map);
        this.parseLimitNumberHeaders(map);
        this.parseLimitNumberResponses(map);
        this.parseKeepThread(map);
        this.parseAllowRetries(map);
        this.parseLoggingInfo(map, channelData);
        this.parseHeaderValidation(map);
        this.parseStrictURLFormat(map);
        this.parseServerHeader(map);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseConfig");
        }
    }

    private void parsePersistence(Map map) {
        this.parseKeepAliveEnabled(map);
        if (this.isKeepAliveEnabled()) {
            this.parseMaxPersist(map);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Config: KeepAlives disabled, ignoring MaxKeepAliveRequests");
        }
    }

    private void parseKeepAliveEnabled(Map map) {
        boolean bl = true;
        String string = (String)map.get("defaultToOutgoingKeepAlive");
        if (null != string) {
            bl = this.convertBoolean(string);
        }
        if (null != (string = (String)map.get("KeepAliveEnabled"))) {
            bl &= this.convertBoolean(string);
        }
        this.setKeepAliveEnabled(bl);
    }

    private void parseMaxPersist(Map map) {
        block3: {
            String string = (String)map.get("MaxKeepAliveRequests");
            if (null != string) {
                try {
                    this.setMaximumPersistentRequests(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, (String)(this.getClass().getName() + ".parseMaxPersist"), (String)"128", (Object)this);
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Config: Maximum persistent requests of " + string + " is incorrect"));
                }
            }
        }
    }

    private void parseOutgoingVersion(Map map) {
        String string = (String)map.get("outgoingVersion");
        if ("1.0".equals(string)) {
            this.setOutgoingVersion(HttpConstants.HTTP_VERSION_10);
        }
    }

    private void parseBufferType(Map map) {
        String string = (String)map.get("useDirectBuffers");
        if (null != string) {
            this.setDirectBufferType(this.convertBoolean(string));
        }
    }

    private void parseOutgoingBufferSize(Map map) {
        block3: {
            String string = (String)map.get("outgoingHdrBufferSize");
            if (null != string) {
                try {
                    this.setOutgoingHdrBufferSize(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, (String)(this.getClass().getName() + ".parseOutgoingBufferSize"), (String)"166", (Object)this);
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Config: Outgoing header buffer size of " + string + " is incorrect"));
                }
            }
        }
    }

    private void parseIncomingHdrBufferSize(Map map) {
        block3: {
            String string = (String)map.get("incomingHdrBufferSize");
            if (null != string) {
                try {
                    this.setIncomingHdrBufferSize(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, (String)(this.getClass().getName() + ".parseIncomingHdrBufferSize"), (String)"184", (Object)this);
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Config: Incoming header buffer size of " + string + " is incorrect"));
                }
            }
        }
    }

    private void parseIncomingBodyBufferSize(Map map) {
        block3: {
            String string = (String)map.get("incomingBodyBufferSize");
            if (null != string) {
                try {
                    this.setIncomingBodyBufferSize(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, (String)(this.getClass().getName() + ".parseIncomingBodyBufferSize"), (String)"202", (Object)this);
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Config: Incoming body buffer size of " + string + " is incorrect"));
                }
            }
        }
    }

    private void parsePersistTimeout(Map map) {
        block3: {
            String string = (String)map.get("persistTimeout");
            if (null != string) {
                try {
                    this.setPersistTimeout(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, (String)(this.getClass().getName() + ".parsePersistTimeout"), (String)"220", (Object)this);
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Config: Persist timeout of " + string + " is incorrect"));
                }
            }
        }
    }

    private void parseReadTimeout(Map map) {
        block3: {
            String string = (String)map.get("readTimeout");
            if (null != string) {
                try {
                    this.setReadTimeout(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, (String)(this.getClass().getName() + ".parseReadTimeout"), (String)"237", (Object)this);
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Config: Read timeout of " + string + " is incorrect"));
                }
            }
        }
    }

    private void parseWriteTimeout(Map map) {
        block3: {
            String string = (String)map.get("writeTimeout");
            if (null != string) {
                try {
                    this.setWriteTimeout(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, (String)(this.getClass().getName() + ".parseWriteTimeout"), (String)"254", (Object)this);
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Config: Writetimeout of " + string + " is incorrect"));
                }
            }
        }
    }

    private void parseByteCacheSize(Map map) {
        block3: {
            String string = (String)map.get("byteCacheSize");
            if (null != string) {
                try {
                    this.setByteCacheSize(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, (String)(this.getClass().getName() + ".parseByteCacheSize"), (String)"271", (Object)this);
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Config: Bytecache setting of " + string + " is invalid."));
                }
            }
        }
    }

    private void parseDelayedExtract(Map map) {
        String string = (String)map.get("extractValue");
        if (null != string) {
            this.setExtractValue(this.convertBoolean(string));
        }
    }

    private void parseBinaryTransport(Map map) {
        String string = (String)map.get("enableBinaryTransport");
        if (null != string) {
            this.setBinaryTransport(this.convertBoolean(string));
        }
    }

    private void parseLimitFieldSize(Map map) {
        block3: {
            String string = (String)map.get("limitFieldSize");
            if (null != string) {
                try {
                    this.setLimitOfFieldSize(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Config: Max field size setting of " + string + " is invalid."));
                }
            }
        }
    }

    private void parseLimitNumberHeaders(Map map) {
        block3: {
            String string = (String)map.get("limitNumHeaders");
            if (null != string) {
                try {
                    this.setLimitOnNumberOfHeaders(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Config: Max number of headers setting of " + string + " is invalid."));
                }
            }
        }
    }

    private void parseLimitNumberResponses(Map map) {
        block3: {
            String string = (String)map.get("LimitNumberResponses");
            if (null != string) {
                try {
                    this.setLimitOnNumberOfResponses(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Config: Max number of responses setting of " + string + " is invalid."));
                }
            }
        }
    }

    private void parseKeepThread(Map map) {
        String string = (String)map.get("keepThread");
        if (null != string) {
            this.setKeepThread(this.convertBoolean(string));
        }
    }

    private void parseLoggingInfo(Map map, ChannelData channelData) {
        if (this.isServantRegion()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Config: logging disabled on servant region");
            }
            return;
        }
        String string = (String)map.get("loggingDisable");
        if (null != string) {
            if (this.convertBoolean(string)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Config: logging is disabled");
                }
                this.setHttpLogger(DisabledHTTPLogger.getRef());
            } else {
                this.parseLoggingParams(map, channelData);
            }
        }
    }

    private void parseLoggingParams(Map map, ChannelData channelData) {
        String string = (String)map.get("accessLogFileName");
        String string2 = (String)map.get("errorLogFileName");
        if (null == string && null == string2) {
            Object object = channelData.getChannelFramework().lookupService(HTTPLoggingService.class);
            if (null != object) {
                this.setHttpLogger((HTTPLoggingService)object);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Config: using logger service");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Config: Svc lookup failed, disabling logging.");
                }
                this.setHttpLogger(DisabledHTTPLogger.getRef());
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Config: Creating custom logger");
            }
            BaseLogger baseLogger = new BaseLogger();
            this.setHttpLogger(baseLogger);
            this.parseAccessLog(baseLogger, channelData, map, string);
            this.parseErrorLog(baseLogger, map, string2);
        }
    }

    private void parseAccessLog(BaseLogger baseLogger, ChannelData channelData, Map map, String string) {
        if (null != string) {
            try {
                baseLogger.createAccessLogger(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Config: Filename failed: " + string));
                }
                return;
            }
            this.parseAccessMaxSize(map);
            this.parseNCSAFormat(map, channelData);
            baseLogger.enableAccessLogging();
            baseLogger.startAccessLogging();
        }
    }

    private void parseErrorLog(BaseLogger baseLogger, Map map, String string) {
        if (null != string) {
            String string2 = (String)map.get("loggingLevel");
            if (null == string2) {
                string2 = HttpConstants.LOG_WARN.getName();
            }
            try {
                baseLogger.createErrorLogger(string, string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Config: Filename failed: " + string));
                }
                return;
            }
            this.parseErrorMaxSize(map);
            baseLogger.enableErrorLogging();
            baseLogger.startErrorLogging();
        }
    }

    private void parseAccessMaxSize(Map map) {
        block3: {
            String string = (String)map.get("accessLogMaximumSize");
            if (null != string) {
                try {
                    this.getHttpLogger().setAccessLogMaximumSize(Integer.parseInt(string) * 1000000);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Config: invalid access size: " + string));
                }
            }
        }
    }

    private void parseErrorMaxSize(Map map) {
        block3: {
            String string = (String)map.get("errorLogMaximumSize");
            if (null != string) {
                try {
                    this.getHttpLogger().setErrorLogMaximumSize(Integer.parseInt(string) * 1000000);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Config: invalid error size: " + string));
                }
            }
        }
    }

    private void parseNCSAFormat(Map map, ChannelData channelData) {
        boolean bl;
        String string = (String)map.get("loggingFormatCombined");
        if (null != string && (bl = this.convertBoolean(string))) {
            this.getHttpLogger().setAccessFormat(1);
        }
        this.getHttpLogger().log(HttpConstants.LOG_DEBUG, this.isNCSACombinedFormat() ? "Configuration specifies the NCSA combined format for " + channelData.getName() : "Configuration specifies the NCSA common format for " + channelData.getName(), null);
    }

    private void parseAllowRetries(Map map) {
        String string = (String)map.get("allowRetries");
        if (null != string) {
            this.setAllowRetries(this.convertBoolean(string));
        } else if (this.runningOnZOS() && !this.isServantRegion()) {
            this.setAllowRetries(false);
        }
    }

    private void parseZOSInfo(Map map) {
        String string = (String)map.get("RunningOnZOS");
        if (null != string) {
            this.setRunningOnZOS(this.convertBoolean(string));
        }
        if (null != (string = (String)map.get("ServantRegion")) && this.convertBoolean(string)) {
            this.setServantRegionFlag(true);
            if (!this.runningOnZOS()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Config: SR detection setting z/OS flag to true.");
                }
                this.bRunningOnZOS = true;
            }
            this.bJITOnlyReads = true;
        }
        this.parseJITOnlyReads(map);
    }

    private void parseHeaderValidation(Map map) {
        String string = (String)map.get("splitResponseProtection");
        if (null != string && !this.convertBoolean(string)) {
            this.setHeaderValidation(false);
        }
    }

    private void parseJITOnlyReads(Map map) {
        String string = (String)map.get("JITOnlyReads");
        if (null != string) {
            this.setJITOnlyReads(this.convertBoolean(string));
        }
    }

    private void parseStrictURLFormat(Map map) {
        String string = (String)map.get("StrictURLFormat");
        if (null != string) {
            this.setStrictURLFormat(this.convertBoolean(string));
        }
    }

    private void parseServerHeader(Map map) {
        String string = (String)map.get("ServerHeaderValue");
        if (null != string && !"".equals(string)) {
            this.setServerHeaderValue(string);
        } else {
            this.setServerHeaderValue("WebSphere Application Server/6.0");
        }
        string = (String)map.get("RemoveServerHeader");
        if (null != string) {
            this.setRemoveServerHeader(this.convertBoolean(string));
        }
    }

    private boolean convertBoolean(String string) {
        return "true".equalsIgnoreCase(string);
    }

    private int rangeLimit(int n, int n2, int n3) {
        if (n < n2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Config: " + n + " too small"));
            }
            return n2;
        }
        if (n > n3) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Config: " + n + " too large"));
            }
            return n3;
        }
        return n;
    }

    private int minLimit(int n, int n2) {
        if (n < n2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Config: " + n + " too small."));
            }
            return n2;
        }
        return n;
    }

    public final int getMaximumPersistentRequests() {
        return this.maxPersistRequest;
    }

    private void setMaximumPersistentRequests(int n) {
        this.maxPersistRequest = this.minLimit(n, -1);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: set the maximum persistent requests to " + this.getMaximumPersistentRequests()));
        }
    }

    public final VersionValues getOutgoingVersion() {
        return this.outgoingHttpVersion;
    }

    private void setOutgoingVersion(VersionValues versionValues) {
        this.outgoingHttpVersion = versionValues;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: set the Http Version to " + this.getOutgoingVersion().getName()));
        }
    }

    public final boolean isDirectBufferType() {
        return this.bDirectBuffers;
    }

    private void setDirectBufferType(boolean bl) {
        this.bDirectBuffers = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: use directBuffers set to " + this.isDirectBufferType()));
        }
    }

    public final boolean isKeepAliveEnabled() {
        return this.bKeepAliveEnabled;
    }

    private void setKeepAliveEnabled(boolean bl) {
        this.bKeepAliveEnabled = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: KeepAliveEnabled set to " + this.isKeepAliveEnabled()));
        }
    }

    public final int getOutgoingHdrBufferSize() {
        return this.outgoingHdrBuffSize;
    }

    private void setOutgoingHdrBufferSize(int n) {
        this.outgoingHdrBuffSize = this.rangeLimit(n, 1024, 0x100000);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: Outgoing hdr buffer size set to " + this.getOutgoingHdrBufferSize()));
        }
    }

    public final int getIncomingHdrBufferSize() {
        return this.incomingHdrBuffSize;
    }

    private void setIncomingHdrBufferSize(int n) {
        this.incomingHdrBuffSize = this.rangeLimit(n, 1024, 0x100000);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: Incoming hdr buffer size set to " + this.getIncomingHdrBufferSize()));
        }
    }

    public final int getIncomingBodyBufferSize() {
        return this.incomingBodyBuffSize;
    }

    private void setIncomingBodyBufferSize(int n) {
        this.incomingBodyBuffSize = this.rangeLimit(n, 1024, 0x100000);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: Incoming body buffer size set to " + this.getIncomingBodyBufferSize()));
        }
    }

    public final int getPersistTimeout() {
        return this.persistTimeout;
    }

    private void setPersistTimeout(int n) {
        this.persistTimeout = this.minLimit(n, 0) * 1000;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: Persist timeout set to " + this.getPersistTimeout()));
        }
    }

    public final int getReadTimeout() {
        return this.readTimeout;
    }

    private void setReadTimeout(int n) {
        this.readTimeout = this.minLimit(n, 0) * 1000;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: Read timeout set to " + this.getReadTimeout()));
        }
    }

    public final int getWriteTimeout() {
        return this.writeTimeout;
    }

    private void setWriteTimeout(int n) {
        this.writeTimeout = this.minLimit(n, 0) * 1000;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: Write timeout set to " + this.getWriteTimeout()));
        }
    }

    public final int getByteCacheSize() {
        return this.byteCacheSize;
    }

    private void setByteCacheSize(int n) {
        this.byteCacheSize = this.rangeLimit(n, 256, 2048);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: set the byte cache size to " + this.getByteCacheSize()));
        }
    }

    public final boolean shouldExtractValue() {
        return this.bExtractValue;
    }

    private void setExtractValue(boolean bl) {
        this.bExtractValue = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: set the value extraction to " + this.shouldExtractValue()));
        }
    }

    public final boolean isBinaryTransportEnabled() {
        return this.bBinaryTransport;
    }

    private void setBinaryTransport(boolean bl) {
        this.bBinaryTransport = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: set the binary transport flag to " + this.isBinaryTransportEnabled()));
        }
    }

    public final HTTPLoggingService getHttpLogger() {
        return this.httpLogger;
    }

    public void setHttpLogger(HTTPLoggingService hTTPLoggingService) {
        this.httpLogger = hTTPLoggingService;
    }

    public final boolean isAccessLoggingEnabled() {
        return this.getHttpLogger().isAccessLoggingEnabled();
    }

    public final boolean isErrorLoggingEnabled() {
        return this.getHttpLogger().isErrorLoggingEnabled();
    }

    public final boolean isErrorLoggingEnabledAtDebug() {
        return this.getHttpLogger().isLoggingLevelEnabled(HttpConstants.LOG_DEBUG);
    }

    public final boolean isNCSACombinedFormat() {
        return 1 == this.getHttpLogger().getAccessFormat();
    }

    public final int getLimitOfFieldSize() {
        return this.limitFieldSize;
    }

    private void setLimitOfFieldSize(int n) {
        this.limitFieldSize = this.rangeLimit(n, 50, 32768);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: set the limit on field size to " + this.getLimitOfFieldSize()));
        }
    }

    public final int getLimitOnNumberOfHeaders() {
        return this.limitNumHeaders;
    }

    private void setLimitOnNumberOfHeaders(int n) {
        this.limitNumHeaders = this.rangeLimit(n, 50, 500);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: set the limit on number of headers to " + this.getLimitOnNumberOfHeaders()));
        }
    }

    public final int getLimitOnNumberOfResponses() {
        return this.limitNumResponses;
    }

    private void setLimitOnNumberOfResponses(int n) {
        this.limitNumResponses = -1 == n ? 50 : this.rangeLimit(n, 1, 50);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: set the limit on number of responses to " + this.getLimitOnNumberOfResponses()));
        }
    }

    public final boolean isKeepThread() {
        return this.bKeepThread;
    }

    private void setKeepThread(boolean bl) {
        this.bKeepThread = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: set the keepthread flag to " + this.isKeepThread()));
        }
    }

    public final boolean allowsRetries() {
        return this.bAllowRetries;
    }

    private void setAllowRetries(boolean bl) {
        this.bAllowRetries = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: set the allow retries flag to " + this.allowsRetries()));
        }
    }

    public final boolean isServantRegion() {
        return this.bServantRegion;
    }

    private void setServantRegionFlag(boolean bl) {
        this.bServantRegion = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: set the Z servant region flag to " + bl));
        }
    }

    public final boolean runningOnZOS() {
        return this.bRunningOnZOS;
    }

    private void setRunningOnZOS(boolean bl) {
        this.bRunningOnZOS = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: running on z/OS is " + bl));
        }
    }

    public final boolean isHeaderValidationEnabled() {
        return this.bHeaderValidation;
    }

    private void setHeaderValidation(boolean bl) {
        this.bHeaderValidation = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: header validation is " + this.bHeaderValidation));
        }
    }

    public final boolean isJITOnlyReads() {
        return this.bJITOnlyReads;
    }

    private void setJITOnlyReads(boolean bl) {
        this.bJITOnlyReads = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: JIT only reads set to " + bl));
        }
    }

    public final boolean isStrictURLFormat() {
        return this.bStrictURLFormat;
    }

    private void setStrictURLFormat(boolean bl) {
        this.bStrictURLFormat = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: Strict URL formatting set to " + bl));
        }
    }

    public byte[] getServerHeaderValue() {
        return this.baServerHeaderValue;
    }

    private void setServerHeaderValue(String string) {
        this.baServerHeaderValue = GenericUtils.getEnglishBytes(string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: server header value set to " + string));
        }
    }

    public boolean removeServerHeader() {
        return this.bRemoveServerHeader;
    }

    private void setRemoveServerHeader(boolean bl) {
        this.bRemoveServerHeader = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Config: remove server header set to" + bl));
        }
    }
}

