/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.BNFHeadersImpl;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.IllegalObjectReplacementException;
import java.nio.BufferUnderflowException;

public class HeaderElement
implements Comparable {
    private static final TraceComponent tc = Tr.register((Class)HeaderElement.class, (String)"GenericBNF", (String)"com.ibm.ws.genericbnf.resources.genericbnfMessages");
    private static final int initHash = 629;
    HeaderElement nextInstance = null;
    HeaderElement prevInstance = null;
    HeaderElement nextSequence = null;
    HeaderElement prevSequence = null;
    private HeaderKeys keyName = null;
    private String stringName = null;
    private int buffIndex = -1;
    private int buffPosition = 0;
    private int valueLength = 0;
    private byte[] bValue = null;
    private String sValue = null;
    private BNFHeadersImpl myOwner = null;
    private boolean inUse = false;
    private int myID = -1;
    private int myHashCode = -1;

    HeaderElement(HeaderKeys headerKeys, BNFHeadersImpl bNFHeadersImpl, int n) {
        this.keyName = headerKeys;
        this.myOwner = bNFHeadersImpl;
        this.myID = n;
        this.inUse = true;
    }

    HeaderElement(String string, BNFHeadersImpl bNFHeadersImpl, int n) {
        this.stringName = string;
        this.myOwner = bNFHeadersImpl;
        this.myID = n;
        this.inUse = true;
    }

    public final HeaderKeys getHeaderKey() {
        return this.keyName;
    }

    public final String getHeaderString() {
        return this.stringName;
    }

    public final void setParseInformation(int n, int n2) {
        this.buffIndex = n;
        this.buffPosition = n2;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Set parse information " + this.buffIndex + " " + this.buffPosition));
        }
    }

    public final void setValueLength(int n) {
        this.valueLength = n;
    }

    private boolean extractInitialValue() {
        if (-1 == this.buffIndex) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Extract: -1 index");
            }
            return false;
        }
        this.bValue = new byte[this.valueLength];
        WsByteBuffer wsByteBuffer = this.myOwner.getMyBuffer(this.buffIndex);
        int n = wsByteBuffer.position();
        try {
            wsByteBuffer.position(this.buffPosition);
            wsByteBuffer.get(this.bValue, 0, this.valueLength);
            wsByteBuffer.position(n);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Header value straddled buffers");
            }
            int n2 = this.valueLength;
            int n3 = 0;
            wsByteBuffer.position(this.buffPosition);
            int n4 = wsByteBuffer.remaining();
            int n5 = this.buffIndex + 1;
            while (null != wsByteBuffer) {
                if (n2 <= n4) {
                    wsByteBuffer.get(this.bValue, n3, n2);
                    wsByteBuffer.position(n);
                    break;
                }
                wsByteBuffer.get(this.bValue, n3, n4);
                wsByteBuffer.position(n);
                n2 -= n4;
                n3 += n4;
                wsByteBuffer = this.myOwner.getMyBuffer(n5);
                ++n5;
                if (null == wsByteBuffer && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Ran out of space in buffer list!");
                }
                n = wsByteBuffer.position();
                wsByteBuffer.position(0);
                n4 = wsByteBuffer.limit();
            }
        }
        if (tc.isDebugEnabled()) {
            this.sValue = GenericUtils.getEnglishString(this.bValue);
            Tr.debug((TraceComponent)tc, (String)("extractInitialValue parsed [" + this.sValue + "]"));
        }
        return true;
    }

    public final byte[] getByteArrayValue() {
        if (null == this.bValue) {
            if (null != this.sValue) {
                this.bValue = GenericUtils.getEnglishBytes(this.sValue);
            } else if (!this.extractInitialValue() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"byte[] value requested from empty structure");
            }
        }
        return this.bValue;
    }

    public final String getStringValue() {
        if (null == this.sValue) {
            if (null == this.bValue && !this.extractInitialValue()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"String value requested from empty structure");
                }
                return null;
            }
            this.sValue = GenericUtils.getEnglishString(this.bValue);
        }
        return this.sValue;
    }

    public final void setByteArrayValue(byte[] byArray) {
        this.sValue = null;
        this.bValue = byArray;
    }

    public final void setStringValue(String string) {
        this.bValue = null;
        this.sValue = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HeaderElement)) {
            return false;
        }
        HeaderElement headerElement = (HeaderElement)object;
        if (null != this.keyName && null != headerElement.getHeaderKey()) {
            return this.keyName.equals(headerElement.getHeaderKey());
        }
        if (null != this.stringName && null != headerElement.getHeaderString()) {
            return this.stringName.equalsIgnoreCase(headerElement.getHeaderString());
        }
        return false;
    }

    public boolean equals(HeaderElement headerElement) {
        return null == headerElement ? false : this.myID == headerElement.myID;
    }

    public int hashCode() {
        if (-1 == this.myHashCode) {
            int n = 629;
            n = null == this.stringName ? (n += this.keyName.hashCode()) : (n += this.stringName.toLowerCase().hashCode());
            this.myHashCode = n;
        }
        return this.myHashCode;
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        return this.myID - ((HeaderElement)object).myID;
    }

    public String getName() {
        return null != this.keyName ? this.keyName.getName() : this.stringName;
    }

    public void destroy() {
        this.inUse = false;
        this.myOwner.addElement(this);
    }

    public void init(HeaderKeys headerKeys) throws IllegalObjectReplacementException {
        if (this.inUse) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Element already in use: " + this));
            }
            throw new IllegalObjectReplacementException("Element in use");
        }
        this.inUse = true;
        this.keyName = headerKeys;
        this.stringName = null;
        this.bValue = null;
        this.sValue = null;
        this.nextInstance = null;
        this.prevInstance = null;
        this.nextSequence = null;
        this.prevSequence = null;
        this.buffIndex = -1;
        this.buffPosition = 0;
        this.valueLength = 0;
        this.myHashCode = -1;
    }

    public void init(String string) throws IllegalObjectReplacementException {
        if (this.inUse) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Element already in use: " + this));
            }
            throw new IllegalObjectReplacementException("Element in use");
        }
        this.inUse = true;
        this.stringName = string;
        this.keyName = null;
        this.bValue = null;
        this.sValue = null;
        this.nextInstance = null;
        this.prevInstance = null;
        this.nextSequence = null;
        this.prevSequence = null;
        this.buffIndex = -1;
        this.buffPosition = 0;
        this.valueLength = 0;
        this.myHashCode = -1;
    }
}

