/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.AsciiTreeNode;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.wsspi.genericbnf.GenericKeys;

public abstract class GenericMatcher {
    private static final TraceComponent tc = Tr.register((Class)GenericMatcher.class, (String)"GenericBNF", (String)"com.ibm.ws.genericbnf.resources.genericbnfMessages");
    private static final int MIN_BYTE_LIMIT = 32;
    private static final int MAX_BYTE_LIMIT = 126;
    private static final int LOWERCASE_A = 97;
    private static final int LOWERCASE_Z = 122;
    private static final int UPPERCASE_A = 65;
    private static final int UPPERCASE_Z = 90;
    private static final int SHIFT_VALUE = 32;
    protected AsciiTreeNode root = null;
    private boolean bCaseSensitive = false;

    public final AsciiTreeNode getRoot() {
        return this.root;
    }

    public GenericKeys match(String string) {
        AsciiTreeNode asciiTreeNode = this.getRoot();
        int n = string.length();
        for (int i = 0; i < n && null != asciiTreeNode; ++i) {
            asciiTreeNode = this.match(string.charAt(i), asciiTreeNode);
        }
        GenericKeys genericKeys = null;
        if (null != asciiTreeNode && null != asciiTreeNode.getTarget()) {
            genericKeys = asciiTreeNode.getTarget();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("match(String) of [" + string + "] returning: " + genericKeys));
        }
        return genericKeys;
    }

    public GenericKeys match(StringBuffer stringBuffer) {
        AsciiTreeNode asciiTreeNode = this.getRoot();
        int n = stringBuffer.length();
        for (int i = 0; i < n && null != asciiTreeNode; ++i) {
            asciiTreeNode = this.match(stringBuffer.charAt(i), asciiTreeNode);
        }
        GenericKeys genericKeys = null;
        if (null != asciiTreeNode && null != asciiTreeNode.getTarget()) {
            genericKeys = asciiTreeNode.getTarget();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("match(sb) of [" + stringBuffer.toString() + "] returning: " + genericKeys));
        }
        return genericKeys;
    }

    public GenericKeys match(byte[] byArray) {
        AsciiTreeNode asciiTreeNode = this.getRoot();
        int n = byArray.length;
        for (int i = 0; i < n && null != asciiTreeNode; ++i) {
            asciiTreeNode = this.match(byArray[i], asciiTreeNode);
        }
        GenericKeys genericKeys = null;
        if (null != asciiTreeNode && null != asciiTreeNode.getTarget()) {
            genericKeys = asciiTreeNode.getTarget();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("match(byte[]) of [" + GenericUtils.getEnglishString(byArray) + "] returning: " + genericKeys));
        }
        return genericKeys;
    }

    public AsciiTreeNode match(byte by, AsciiTreeNode asciiTreeNode) {
        return asciiTreeNode.traverse(by);
    }

    public AsciiTreeNode match(char c, AsciiTreeNode asciiTreeNode) {
        return asciiTreeNode.traverse(c);
    }

    private boolean isUpperAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private boolean isLowerAlpha(char c) {
        return c >= 'a' && c <= 'z';
    }

    protected boolean isCaseSensitive() {
        return this.bCaseSensitive;
    }

    protected String put(GenericKeys genericKeys) {
        char c;
        if (null == this.getRoot() || null == genericKeys || 0 == genericKeys.getName().length()) {
            return null;
        }
        String string = genericKeys.getName();
        int n = this.getRoot().getMinByteLimit();
        int n2 = this.getRoot().getMaxByteLimit();
        AsciiTreeNode asciiTreeNode = null;
        AsciiTreeNode asciiTreeNode2 = this.getRoot();
        int n3 = string.length() - 1;
        for (int i = 0; i < n3; ++i) {
            asciiTreeNode = new AsciiTreeNode(null, n, n2);
            c = string.charAt(i);
            asciiTreeNode = asciiTreeNode2.addNode(asciiTreeNode, c);
            if (!this.isCaseSensitive()) {
                if (this.isUpperAlpha(c)) {
                    asciiTreeNode = asciiTreeNode2.addNode(asciiTreeNode, c + 32);
                } else if (this.isLowerAlpha(c)) {
                    asciiTreeNode = asciiTreeNode2.addNode(asciiTreeNode, c - 32);
                }
            }
            asciiTreeNode2 = asciiTreeNode;
        }
        asciiTreeNode = new AsciiTreeNode(genericKeys, n, n2);
        c = string.charAt(n3);
        asciiTreeNode2.addNode(asciiTreeNode, c);
        if (!this.isCaseSensitive()) {
            if (this.isUpperAlpha(c)) {
                asciiTreeNode2.addNode(asciiTreeNode, c + 32);
            } else if (this.isLowerAlpha(c)) {
                asciiTreeNode2.addNode(asciiTreeNode, c - 32);
            }
        }
        return null;
    }

    protected String remove(String string) {
        this.getRoot().remove(string, string.length());
        return string;
    }

    protected void debug() {
        this.getRoot().print();
    }

    protected void init() {
        this.root = new AsciiTreeNode(null, 32, 126);
    }

    protected void init(boolean bl) {
        this.bCaseSensitive = bl;
        this.root = new AsciiTreeNode(null, 32, 126);
    }

    protected void init(boolean bl, int n, int n2) {
        this.bCaseSensitive = bl;
        this.root = new AsciiTreeNode(null, n, n2);
    }

    public void addNewKey(GenericKeys genericKeys) {
        if (null != genericKeys) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("storing key: " + genericKeys));
            }
            this.put(genericKeys);
        }
    }
}

