/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.impl.FastNonSynchHashTable;
import com.ibm.ws.genericbnf.impl.GenericConstants;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.genericbnf.impl.HeaderElement;
import com.ibm.ws.genericbnf.impl.Normalizer;
import com.ibm.ws.genericbnf.impl.QuickHeaderMatcher;
import com.ibm.ws.genericbnf.impl.TokenCodes;
import com.ibm.ws.http.channel.impl.HttpDateFormat;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.genericbnf.BNFHeaders;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.IllegalObjectReplacementException;
import com.ibm.wsspi.genericbnf.exception.MalformedMessageException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.ParseException;
import java.util.Date;
import java.util.Vector;

public abstract class BNFHeadersImpl
implements BNFHeaders,
Externalizable {
    private static final TraceComponent tc = Tr.register((Class)BNFHeadersImpl.class, (String)"GenericBNF", (String)"com.ibm.ws.genericbnf.resources.genericbnfMessages");
    private static final int PARSING_HEADER = 0;
    private static final int PARSING_VALUE = 1;
    private static final int PARSING_CRLF = 2;
    private static final int DEFAULT_BUFFERSIZE = 1024;
    private static final int DEFAULT_CACHESIZE = 512;
    private static final int DEFAULT_LIMIT_TOKENSIZE = 16384;
    private static final int DEFAULT_LIMIT_NUMHEADERS = 500;
    private static final int BUFFERS_INITIAL_SIZE = 10;
    private static final int BUFFERS_MIN_GROWTH = 5;
    private static final boolean FILTER_YES = true;
    private static final boolean FILTER_NO = false;
    private static final int DEFAULT_EOHPOSITION = -1;
    private transient HeaderElement[] headerValues;
    private transient FastNonSynchHashTable otherHeaders = new FastNonSynchHashTable(32);
    private transient int[] knownSequence = null;
    private transient int knownSequenceIndex = 0;
    private transient HeaderElement hdrSequence = null;
    private transient HeaderElement lastHdrInSequence = null;
    private transient QuickHeaderMatcher myHM = null;
    private transient HeaderElement headerElements = null;
    private transient int elementID = 1;
    private transient WsByteBuffer[] myBuffers = new WsByteBuffer[10];
    private transient int myBuffersIndex = -1;
    private transient WsByteBuffer[] myCreatedBuffers = new WsByteBuffer[10];
    private transient int createdIndex = -1;
    private transient int numberOfHeaders = 0;
    private transient boolean bHeaderValidation = true;
    private transient int limitTokenSize = 16384;
    private transient int limitNumHeaders = 500;
    private transient int eohPosition = -1;
    private transient WsByteBuffer currentReadBB = null;
    private transient boolean useDirectBuffer = true;
    private transient int outgoingHdrBufferSize = 1024;
    private transient int incomingBufferSize = 1024;
    private transient int byteCacheSize = 512;
    private transient byte[] parsedToken = null;
    private transient int parsedTokenLength = 0;
    private transient byte[] byteCache = new byte[this.byteCacheSize];
    private transient byte[] originalByteCache = this.byteCache;
    private transient int bytePosition = 0;
    private transient int byteLimit = 0;
    private transient boolean isByteBufferArray = false;
    private transient int stateOfParsing = 2;
    private transient int binaryParsingState = 1;
    private transient HeaderElement currentElem = null;
    private transient HeaderElement lastElem = null;
    private transient boolean bIsMultiLine = false;
    private transient int numCRLFs = 0;
    private transient Object debugContext = this;

    public BNFHeadersImpl(QuickHeaderMatcher quickHeaderMatcher, int n) {
        this.headerValues = new HeaderElement[n];
        this.knownSequence = new int[n];
        this.setHeaderMatcher(quickHeaderMatcher);
    }

    protected void init(boolean bl, int n, int n2, int n3) {
        this.useDirectBuffer = bl;
        this.outgoingHdrBufferSize = n;
        this.incomingBufferSize = n2;
        if (n3 > this.byteCacheSize) {
            this.byteCacheSize = n3;
            this.byteCache = new byte[n3];
            this.originalByteCache = this.byteCache;
        }
    }

    public void addParseBuffer(WsByteBuffer wsByteBuffer) {
        int n;
        if ((n = ++this.myBuffersIndex) == this.myBuffers.length) {
            int n2 = n + 5;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Increasing parse buffer array size to " + n2));
            }
            WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[n2];
            System.arraycopy(this.myBuffers, 0, wsByteBufferArray, 0, n);
            this.myBuffers = wsByteBufferArray;
        }
        this.myBuffers[n] = wsByteBuffer;
    }

    public void addToCreatedBuffer(WsByteBuffer wsByteBuffer) {
        int n;
        if ((n = ++this.createdIndex) == this.myCreatedBuffers.length) {
            int n2 = n + 5;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Increasing created buffer array size to " + n2));
            }
            WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[n2];
            System.arraycopy(this.myCreatedBuffers, 0, wsByteBufferArray, 0, n);
            this.myCreatedBuffers = wsByteBufferArray;
        }
        this.myCreatedBuffers[n] = wsByteBuffer;
    }

    public void appendHeader(String string, byte[] byArray) {
        HeaderKeys headerKeys;
        if (null == string || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("appendHeader(s,b): " + string));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray);
        }
        if ((headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            HeaderElement headerElement = this.getNewElement(string);
            headerElement.setByteArrayValue(byArray);
            this.addUnknownHeader(string, headerElement, true);
        } else {
            HeaderElement headerElement = this.getNewElement(headerKeys);
            headerElement.setByteArrayValue(byArray);
            this.addKnownHeader(headerKeys, headerElement, true, true);
        }
    }

    public void appendHeader(byte[] byArray, byte[] byArray2) {
        HeaderKeys headerKeys;
        if (null == byArray || null == byArray2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("appendHeader(b,b): " + GenericUtils.getEnglishString(byArray)));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray2);
        }
        if ((headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            String string = GenericUtils.getEnglishString(byArray);
            HeaderElement headerElement = this.getNewElement(string);
            headerElement.setByteArrayValue(byArray2);
            this.addUnknownHeader(string, headerElement, true);
        } else {
            HeaderElement headerElement = this.getNewElement(headerKeys);
            headerElement.setByteArrayValue(byArray2);
            this.addKnownHeader(headerKeys, headerElement, true, true);
        }
    }

    public void appendHeader(HeaderKeys headerKeys, byte[] byArray) {
        if (null == headerKeys || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("appendHeader(h,b): " + headerKeys.getName()));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray);
        }
        if (!HeaderKeys.isLegal(headerKeys)) {
            throw new IllegalArgumentException("ErrorHeaderKey not allowed");
        }
        HeaderElement headerElement = this.getNewElement(headerKeys);
        headerElement.setByteArrayValue(byArray);
        this.addKnownHeader(headerKeys, headerElement, true, true);
    }

    public void appendHeader(String string, String string2) {
        HeaderKeys headerKeys;
        if (null == string || null == string2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("appendHeader(s,s): " + string));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(string2);
        }
        if ((headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            HeaderElement headerElement = this.getNewElement(string);
            headerElement.setStringValue(string2);
            this.addUnknownHeader(string, headerElement, true);
        } else {
            HeaderElement headerElement = this.getNewElement(headerKeys);
            headerElement.setStringValue(string2);
            this.addKnownHeader(headerKeys, headerElement, true, true);
        }
    }

    public void appendHeader(byte[] byArray, String string) {
        HeaderKeys headerKeys;
        if (null == byArray || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("appendHeader(b,s): " + GenericUtils.getEnglishString(byArray)));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(string);
        }
        if ((headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            String string2 = GenericUtils.getEnglishString(byArray);
            HeaderElement headerElement = this.getNewElement(string2);
            headerElement.setStringValue(string);
            this.addUnknownHeader(string2, headerElement, true);
        } else {
            HeaderElement headerElement = this.getNewElement(headerKeys);
            headerElement.setStringValue(string);
            this.addKnownHeader(headerKeys, headerElement, true, true);
        }
    }

    public void appendHeader(HeaderKeys headerKeys, String string) {
        if (null == headerKeys || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("appendHeader(h,s): " + headerKeys.getName()));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(string);
        }
        if (!HeaderKeys.isLegal(headerKeys)) {
            throw new IllegalArgumentException("ErrorHeaderKey not allowed");
        }
        HeaderElement headerElement = this.getNewElement(headerKeys);
        headerElement.setStringValue(string);
        this.addKnownHeader(headerKeys, headerElement, true, true);
    }

    public void clear() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"clear");
        }
        if (0 < this.numberOfHeaders) {
            this.removeAllHeaders();
        }
        this.eohPosition = -1;
        this.lastElem = null;
        this.currentElem = null;
        this.stateOfParsing = 2;
        this.binaryParsingState = 1;
        this.parsedToken = null;
        this.parsedTokenLength = 0;
        this.bytePosition = 0;
        this.byteLimit = 0;
        this.currentReadBB = null;
        this.clearMyBuffers();
        this.knownSequenceIndex = 0;
        this.debugContext = this;
        this.numCRLFs = 0;
        this.bIsMultiLine = false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clear");
        }
    }

    private void clearMyBuffers() {
        int n;
        for (n = 0; n <= this.myBuffersIndex; ++n) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Removing reference to parse buffer: " + this.myBuffers[n]));
            }
            this.myBuffers[n] = null;
        }
        this.myBuffersIndex = -1;
        for (n = 0; n <= this.createdIndex; ++n) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Releasing marshall buffer: " + this.myCreatedBuffers[n]));
            }
            this.myCreatedBuffers[n].release();
            this.myCreatedBuffers[n] = null;
        }
        this.createdIndex = -1;
    }

    public int compareValue(HeaderKeys headerKeys, byte[] byArray) {
        if (null == headerKeys || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.compareByteArrays(this.findHeader(headerKeys, 0), byArray);
    }

    public int compareValue(String string, byte[] byArray) {
        if (null == string || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.compareByteArrays(this.findHeader(string, 0), byArray);
    }

    public int compareValue(byte[] byArray, byte[] byArray2) {
        if (null == byArray || null == byArray2) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.compareByteArrays(this.findHeader(byArray, 0), byArray2);
    }

    public int compareValue(HeaderKeys headerKeys, String string) {
        if (null == headerKeys || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.compareStrings(this.findHeader(headerKeys, 0), string);
    }

    public int compareValue(String string, String string2) {
        if (null == string || null == string2) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.compareStrings(this.findHeader(string, 0), string2);
    }

    public int compareValue(byte[] byArray, String string) {
        if (null == byArray || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.compareStrings(this.findHeader(byArray, 0), string);
    }

    public void debug() {
        if (tc.isDebugEnabled()) {
            HeaderElement headerElement;
            Tr.debug((TraceComponent)tc, (String)"*** Begin Header Debug ***");
            for (int i = 0; i < this.knownSequenceIndex; ++i) {
                headerElement = this.headerValues[this.knownSequence[i]];
                if (null == headerElement) {
                    Tr.debug((TraceComponent)tc, (String)("Empty spot: " + i + " " + this.knownSequence[i]));
                    continue;
                }
                this.debugPrintHeader(headerElement);
            }
            headerElement = this.hdrSequence;
            while (null != headerElement) {
                this.debugPrintHeader(headerElement);
                headerElement = headerElement.nextSequence;
            }
            Tr.debug((TraceComponent)tc, (String)"*** End Header Debug ***");
        }
    }

    private void debugPrintHeader(HeaderElement headerElement) {
        HeaderElement headerElement2 = headerElement;
        while (null != headerElement2) {
            Tr.debug((TraceComponent)tc, (String)("debug: " + headerElement2.getName() + ": " + headerElement2.getStringValue()));
            headerElement2 = headerElement2.nextInstance;
        }
    }

    protected void destroy() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Destroying these headers: " + this));
        }
        this.clear();
        this.byteCacheSize = 512;
        this.incomingBufferSize = 1024;
        this.outgoingHdrBufferSize = 1024;
        this.useDirectBuffer = true;
        this.limitNumHeaders = 500;
        this.limitTokenSize = 16384;
    }

    public void duplicate(BNFHeaders bNFHeaders) {
        this.duplicate((BNFHeadersImpl)bNFHeaders);
    }

    protected void duplicate(BNFHeadersImpl bNFHeadersImpl) {
        if (null == bNFHeadersImpl) {
            throw new NullPointerException("Null object passed to duplicate");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Duplicating the headers");
        }
        HeaderElement headerElement = null;
        for (int i = 0; i < this.knownSequenceIndex; ++i) {
            headerElement = this.headerValues[this.knownSequence[i]];
            while (null != headerElement) {
                bNFHeadersImpl.appendHeader(headerElement.getHeaderKey(), headerElement.getByteArrayValue());
                headerElement = headerElement.nextInstance;
            }
        }
        headerElement = this.hdrSequence;
        while (null != headerElement) {
            HeaderElement headerElement2 = headerElement;
            while (null != headerElement2) {
                bNFHeadersImpl.appendHeader(headerElement.getHeaderString(), headerElement.getByteArrayValue());
                headerElement2 = headerElement2.nextInstance;
            }
            headerElement = headerElement.nextSequence;
        }
        bNFHeadersImpl.init(this.useDirectBuffer, this.outgoingHdrBufferSize, this.incomingBufferSize, this.byteCacheSize);
        bNFHeadersImpl.setDebugContext(this.debugContext);
        bNFHeadersImpl.setHeaderMatcher(this.getMatcher());
        bNFHeadersImpl.setHeaderValidation(this.bHeaderValidation);
        bNFHeadersImpl.setLimitOfTokenSize(this.limitTokenSize);
        bNFHeadersImpl.setLimitOnNumberOfHeaders(this.limitNumHeaders);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (null == this.getMatcher()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Missing matcher class, subclass should set first");
            }
            throw new IOException("Unable to deserialize without matcher.");
        }
        int n = objectInput.readInt();
        this.headerValues = new HeaderElement[n];
        this.knownSequence = new int[n];
        int n2 = objectInput.readInt();
        for (int i = 0; i < n2; ++i) {
            String string = (String)objectInput.readObject();
            String string2 = (String)objectInput.readObject();
            this.appendHeader(string, string2);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        HeaderElement headerElement;
        objectOutput.writeInt(this.headerValues.length);
        objectOutput.writeInt(this.numberOfHeaders);
        int n = 0;
        for (int i = 0; i < this.knownSequenceIndex; ++i) {
            headerElement = this.headerValues[this.knownSequence[i]];
            while (null != headerElement) {
                ++n;
                objectOutput.writeObject(headerElement.getHeaderKey().getName());
                objectOutput.writeObject(headerElement.getStringValue());
                headerElement = headerElement.nextInstance;
            }
        }
        HeaderElement headerElement2 = this.hdrSequence;
        while (null != headerElement2) {
            headerElement = headerElement2;
            while (null != headerElement) {
                ++n;
                objectOutput.writeObject(headerElement.getHeaderString());
                objectOutput.writeObject(headerElement.getStringValue());
                headerElement = headerElement.nextInstance;
            }
            headerElement2 = headerElement2.nextSequence;
        }
        if (n != this.numberOfHeaders) {
            throw new IOException("Expected " + this.numberOfHeaders + " headers but wrote " + n);
        }
    }

    public boolean isEOHFound() {
        return -1 != this.eohPosition;
    }

    public Vector getAllHeaders() {
        HeaderElement headerElement;
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.knownSequenceIndex; ++i) {
            headerElement = this.headerValues[this.knownSequence[i]];
            if (null == headerElement) continue;
            vector.add(headerElement.getName());
        }
        headerElement = this.hdrSequence;
        while (null != headerElement) {
            vector.add(headerElement.getName());
            headerElement = headerElement.nextSequence;
        }
        return vector;
    }

    public byte[] getHeaderAsByteArray(HeaderKeys headerKeys) {
        return this.getHeaderAsByteArray(headerKeys, 0);
    }

    public byte[] getHeaderAsByteArray(String string) {
        return this.getHeaderAsByteArray(string, 0);
    }

    public byte[] getHeaderAsByteArray(byte[] byArray) {
        return this.getHeaderAsByteArray(byArray, 0);
    }

    public byte[] getHeaderAsByteArray(HeaderKeys headerKeys, int n) {
        byte[] byArray;
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(headerKeys, n);
        byte[] byArray2 = byArray = null != headerElement ? headerElement.getByteArrayValue() : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderAsByteArray(h,i): " + headerKeys.getName() + " " + n + " [" + byArray + "]"));
        }
        return byArray;
    }

    public byte[] getHeaderAsByteArray(String string, int n) {
        byte[] byArray;
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(string, n);
        byte[] byArray2 = byArray = null != headerElement ? headerElement.getByteArrayValue() : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderAsByteArray(s,i): " + string + " " + n + " [" + byArray + "]"));
        }
        return byArray;
    }

    public byte[] getHeaderAsByteArray(byte[] byArray, int n) {
        byte[] byArray2;
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(byArray, n);
        byte[] byArray3 = byArray2 = null != headerElement ? headerElement.getByteArrayValue() : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderAsByteArray(b,i): " + GenericUtils.getEnglishString(byArray) + " " + n + " [" + byArray2 + "]"));
        }
        return byArray2;
    }

    public Date getHeaderAsDate(byte[] byArray) throws ParseException {
        return this.getHeaderAsDate(byArray, 0);
    }

    public Date getHeaderAsDate(byte[] byArray, int n) throws ParseException {
        Date date;
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(byArray, n);
        Date date2 = date = null != headerElement ? HttpDateFormat.getRef().parseTime(headerElement.getStringValue()) : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderAsDate(b,i): " + GenericUtils.getEnglishString(byArray) + " " + n + " [" + date + "]"));
        }
        return date;
    }

    public Date getHeaderAsDate(HeaderKeys headerKeys) throws ParseException {
        return this.getHeaderAsDate(headerKeys, 0);
    }

    public Date getHeaderAsDate(HeaderKeys headerKeys, int n) throws ParseException {
        Date date;
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(headerKeys, n);
        Date date2 = date = null != headerElement ? HttpDateFormat.getRef().parseTime(headerElement.getStringValue()) : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderAsDate(h,i): " + headerKeys.getName() + " " + n + " [" + date + "]"));
        }
        return date;
    }

    public Date getHeaderAsDate(String string) throws ParseException {
        return this.getHeaderAsDate(string, 0);
    }

    public Date getHeaderAsDate(String string, int n) throws ParseException {
        Date date;
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(string, n);
        Date date2 = date = null != headerElement ? HttpDateFormat.getRef().parseTime(headerElement.getStringValue()) : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderAsDate(s,i): " + string + " " + n + " [" + date + "]"));
        }
        return date;
    }

    private Vector getHeaderDateValues(HeaderElement headerElement) throws ParseException {
        Vector<Date> vector = new Vector<Date>();
        while (null != headerElement) {
            vector.add(HttpDateFormat.getRef().parseTime(headerElement.getStringValue()));
            headerElement = headerElement.nextInstance;
        }
        return vector;
    }

    public Vector getHeaderDateValues(byte[] byArray) throws ParseException {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderDateValues(b): " + GenericUtils.getEnglishString(byArray)));
        }
        return this.getHeaderDateValues(this.findHeader(byArray, 0));
    }

    public Vector getHeaderDateValues(HeaderKeys headerKeys) throws ParseException {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderDateValues(h): " + headerKeys.getName()));
        }
        return this.getHeaderDateValues(this.findHeader(headerKeys, 0));
    }

    public Vector getHeaderDateValues(String string) throws ParseException {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderDateValues(s): " + string));
        }
        return this.getHeaderDateValues(this.findHeader(string, 0));
    }

    public Integer getHeaderAsInteger(byte[] byArray) throws NumberFormatException {
        return this.getHeaderAsInteger(byArray, 0);
    }

    public Integer getHeaderAsInteger(byte[] byArray, int n) throws NumberFormatException {
        Integer n2;
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(byArray, n);
        Integer n3 = n2 = null != headerElement ? new Integer(headerElement.getStringValue()) : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderAsInteger(b,i): " + GenericUtils.getEnglishString(byArray) + " " + n + " [" + n2 + "]"));
        }
        return n2;
    }

    public Integer getHeaderAsInteger(HeaderKeys headerKeys) throws NumberFormatException {
        return this.getHeaderAsInteger(headerKeys, 0);
    }

    public Integer getHeaderAsInteger(HeaderKeys headerKeys, int n) throws NumberFormatException {
        Integer n2;
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(headerKeys, n);
        Integer n3 = n2 = null != headerElement ? new Integer(headerElement.getStringValue()) : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderAsInteger(h,i): " + headerKeys.getName() + " " + n + " [" + n2 + "]"));
        }
        return n2;
    }

    public Integer getHeaderAsInteger(String string) throws NumberFormatException {
        return this.getHeaderAsInteger(string, 0);
    }

    public Integer getHeaderAsInteger(String string, int n) throws NumberFormatException {
        Integer n2;
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(string, n);
        Integer n3 = n2 = null != headerElement ? new Integer(headerElement.getStringValue()) : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderAsInteger(s,i): " + string + " " + n + " [" + n2 + "]"));
        }
        return n2;
    }

    private Vector getHeaderIntegerValues(HeaderElement headerElement) throws NumberFormatException {
        Vector<Integer> vector = new Vector<Integer>();
        while (null != headerElement) {
            vector.add(new Integer(headerElement.getStringValue()));
            headerElement = headerElement.nextInstance;
        }
        return vector;
    }

    public Vector getHeaderIntegerValues(byte[] byArray) throws NumberFormatException {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderIntegerValues(b): " + GenericUtils.getEnglishString(byArray)));
        }
        return this.getHeaderIntegerValues(this.findHeader(byArray, 0));
    }

    public Vector getHeaderIntegerValues(HeaderKeys headerKeys) throws NumberFormatException {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderIntegerValues(h): " + headerKeys.getName()));
        }
        return this.getHeaderIntegerValues(this.findHeader(headerKeys, 0));
    }

    public Vector getHeaderIntegerValues(String string) throws NumberFormatException {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderIntegerValues(s): " + string));
        }
        return this.getHeaderIntegerValues(this.findHeader(string, 0));
    }

    public String getHeaderAsString(HeaderKeys headerKeys) {
        return this.getHeaderAsString(headerKeys, 0);
    }

    public String getHeaderAsString(String string) {
        return this.getHeaderAsString(string, 0);
    }

    public String getHeaderAsString(byte[] byArray) {
        return this.getHeaderAsString(byArray, 0);
    }

    public String getHeaderAsString(HeaderKeys headerKeys, int n) {
        String string;
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(headerKeys, n);
        String string2 = string = null != headerElement ? headerElement.getStringValue() : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderAsString(h,i): " + headerKeys.getName() + " " + n + " [" + string + "]"));
        }
        return string;
    }

    public String getHeaderAsString(String string, int n) {
        String string2;
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(string, n);
        String string3 = string2 = null != headerElement ? headerElement.getStringValue() : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderAsString(s,i): " + string + " " + n + " [" + string2 + "]"));
        }
        return string2;
    }

    public String getHeaderAsString(byte[] byArray, int n) {
        String string;
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderElement headerElement = this.findHeader(byArray, n);
        String string2 = string = null != headerElement ? headerElement.getStringValue() : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderAsString(b,i): " + GenericUtils.getEnglishString(byArray) + " " + n + " [" + string + "]"));
        }
        return string;
    }

    private Vector getHeaderByteArrayValues(HeaderElement headerElement) {
        Vector<byte[]> vector = new Vector<byte[]>();
        while (null != headerElement) {
            vector.add(headerElement.getByteArrayValue());
            headerElement = headerElement.nextInstance;
        }
        return vector;
    }

    public Vector getHeaderByteArrayValues(HeaderKeys headerKeys) {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderByteArrayValues(h): " + headerKeys.getName()));
        }
        return this.getHeaderByteArrayValues(this.findHeader(headerKeys, 0));
    }

    public Vector getHeaderByteArrayValues(String string) {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderByteArrayValues(s): " + string));
        }
        return this.getHeaderByteArrayValues(this.findHeader(string, 0));
    }

    public Vector getHeaderByteArrayValues(byte[] byArray) {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderByteArrayValues(b): " + GenericUtils.getEnglishString(byArray)));
        }
        return this.getHeaderByteArrayValues(this.findHeader(byArray, 0));
    }

    private Vector getHeaderStringValues(HeaderElement headerElement) {
        Vector<String> vector = new Vector<String>();
        while (null != headerElement) {
            vector.add(headerElement.getStringValue());
            headerElement = headerElement.nextInstance;
        }
        return vector;
    }

    public Vector getHeaderStringValues(HeaderKeys headerKeys) {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderStringValues(h): " + headerKeys.getName()));
        }
        return this.getHeaderStringValues(this.findHeader(headerKeys, 0));
    }

    public Vector getHeaderStringValues(String string) {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderStringValues(s): " + string));
        }
        return this.getHeaderStringValues(this.findHeader(string, 0));
    }

    public Vector getHeaderStringValues(byte[] byArray) {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderStringValues(b): " + GenericUtils.getEnglishString(byArray)));
        }
        return this.getHeaderStringValues(this.findHeader(byArray, 0));
    }

    public Vector getHeaderTokens(HeaderKeys headerKeys, byte by) {
        return this.getHeaderTokens(headerKeys, by, 0);
    }

    public Vector getHeaderTokens(String string, byte by) {
        return this.getHeaderTokens(string, by, 0);
    }

    public Vector getHeaderTokens(byte[] byArray, byte by) {
        return this.getHeaderTokens(byArray, by, 0);
    }

    private Vector getHeaderTokens(HeaderElement headerElement, byte by) {
        if (null != headerElement) {
            return GenericUtils.byteArrayTokenize(headerElement.getByteArrayValue(), by);
        }
        return new Vector();
    }

    public Vector getHeaderTokens(HeaderKeys headerKeys, byte by, int n) {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderTokens(h,d,i): " + headerKeys.getName() + " " + (char)by + " " + n));
        }
        return this.getHeaderTokens(this.findHeader(headerKeys, n), by);
    }

    public Vector getHeaderTokens(String string, byte by, int n) {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderTokens(s,d,i): " + string + " " + (char)by + " " + n));
        }
        return this.getHeaderTokens(this.findHeader(string, n), by);
    }

    public Vector getHeaderTokens(byte[] byArray, byte by, int n) {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderTokens(b,d,i): " + GenericUtils.getEnglishString(byArray) + " " + (char)by + " " + n));
        }
        return this.getHeaderTokens(this.findHeader(byArray, n), by);
    }

    public int getPositionOfHeader(HeaderKeys headerKeys) {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.findSequencePosition(this.findHeader(headerKeys, 0));
    }

    public int getPositionOfHeader(String string) {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.findSequencePosition(this.findHeader(string, 0));
    }

    public int getPositionOfHeader(byte[] byArray) {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.findSequencePosition(this.findHeader(byArray, 0));
    }

    public int getNumberOfHeaderInstances(String string) {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.countInstances(this.findHeader(string, 0));
    }

    public int getNumberOfHeaderInstances(byte[] byArray) {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.countInstances(this.findHeader(byArray, 0));
    }

    public int getNumberOfHeaderInstances(HeaderKeys headerKeys) {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        return this.countInstances(this.findHeader(headerKeys, 0));
    }

    public boolean containsHeader(String string) {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        return null != this.findHeader(string, 0);
    }

    public boolean containsHeader(byte[] byArray) {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        return null != this.findHeader(byArray, 0);
    }

    public boolean containsHeader(HeaderKeys headerKeys) {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        return null != this.findHeader(headerKeys, 0);
    }

    public WsByteBuffer[] marshallBinaryHeaders(WsByteBuffer[] wsByteBufferArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"marshallBinaryHeaders");
        }
        this.preMarshallHeaders();
        WsByteBuffer[] wsByteBufferArray2 = wsByteBufferArray;
        if (null == wsByteBufferArray2) {
            wsByteBufferArray2 = new WsByteBuffer[]{this.allocateBuffer(this.outgoingHdrBufferSize)};
            this.bytePosition = 0;
        }
        for (int i = 0; i < this.knownSequenceIndex; ++i) {
            wsByteBufferArray2 = this.marshallKnownBinaryHeader(wsByteBufferArray2, this.headerValues[this.knownSequence[i]]);
        }
        HeaderElement headerElement = this.hdrSequence;
        while (null != headerElement) {
            wsByteBufferArray2 = this.marshallUnknownBinaryHeader(wsByteBufferArray2, headerElement);
            headerElement = headerElement.nextSequence;
        }
        wsByteBufferArray2 = this.putInt(0, wsByteBufferArray2);
        wsByteBufferArray2 = this.flushCache(wsByteBufferArray2);
        wsByteBufferArray2[wsByteBufferArray2.length - 1].flip();
        this.postMarshallHeaders();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"marshallBinaryHeaders");
        }
        return wsByteBufferArray2;
    }

    public WsByteBuffer[] marshallHeaders(WsByteBuffer[] wsByteBufferArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"marshallHeaders");
        }
        this.preMarshallHeaders();
        WsByteBuffer[] wsByteBufferArray2 = wsByteBufferArray;
        if (null == wsByteBufferArray2) {
            wsByteBufferArray2 = new WsByteBuffer[]{this.allocateBuffer(this.outgoingHdrBufferSize)};
            this.bytePosition = 0;
        }
        for (int i = 0; i < this.knownSequenceIndex; ++i) {
            wsByteBufferArray2 = this.marshallKnownHeader(wsByteBufferArray2, this.headerValues[this.knownSequence[i]]);
        }
        HeaderElement headerElement = this.hdrSequence;
        while (null != headerElement) {
            wsByteBufferArray2 = this.marshallUnknownHeader(wsByteBufferArray2, headerElement);
            headerElement = headerElement.nextSequence;
        }
        wsByteBufferArray2 = this.putBytes(BNFHeaders.EOL, wsByteBufferArray2);
        wsByteBufferArray2 = this.flushCache(wsByteBufferArray2);
        wsByteBufferArray2[wsByteBufferArray2.length - 1].flip();
        this.postMarshallHeaders();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"marshallHeaders");
        }
        return wsByteBufferArray2;
    }

    private boolean moveHeader(HeaderElement headerElement, int n) {
        if (null != headerElement) {
            this.updatePosition(headerElement, n);
            return true;
        }
        return false;
    }

    public boolean moveHeader(HeaderKeys headerKeys, int n) {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("moveHeader(h,i): " + headerKeys.getName() + " to " + n));
        }
        return this.moveHeader(this.findHeader(headerKeys, 0), n);
    }

    public boolean moveHeader(String string, int n) {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("moveHeader(s,i): " + string + " to " + n));
        }
        return this.moveHeader(this.findHeader(string, 0), n);
    }

    public boolean moveHeader(byte[] byArray, int n) {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("moveHeader(b,i): " + GenericUtils.getEnglishString(byArray) + " to " + n));
        }
        return this.moveHeader(this.findHeader(byArray, 0), n);
    }

    public boolean parseBinaryHeaders(WsByteBuffer wsByteBuffer, HeaderKeys headerKeys) throws MalformedMessageException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parsing binary headers with input buff: " + wsByteBuffer));
        }
        if (null == this.parsedToken) {
            this.createCacheToken(4);
        }
        boolean bl = false;
        block8: while (!bl) {
            if (!this.fillCacheToken(wsByteBuffer)) {
                return false;
            }
            switch (this.binaryParsingState) {
                case 1: {
                    int n = GenericUtils.asInt(this.parsedToken);
                    if (0 == n) {
                        bl = true;
                        continue block8;
                    }
                    if (1 == n) {
                        this.binaryParsingState = 2;
                        this.resetCacheToken(4);
                        continue block8;
                    }
                    if (2 != n) continue block8;
                    this.binaryParsingState = 3;
                    this.resetCacheToken(4);
                    continue block8;
                }
                case 2: {
                    this.currentElem = this.getNewElement((HeaderKeys)headerKeys.getEnumByOrdinal(GenericUtils.asInt(this.parsedToken)));
                    this.binaryParsingState = 5;
                    this.resetCacheToken(4);
                    continue block8;
                }
                case 3: {
                    this.binaryParsingState = 4;
                    this.resetCacheToken(GenericUtils.asInt(this.parsedToken));
                    continue block8;
                }
                case 4: {
                    this.currentElem = this.getNewElement(GenericUtils.getEnglishString(this.parsedToken));
                    this.binaryParsingState = 5;
                    this.resetCacheToken(4);
                    continue block8;
                }
                case 5: {
                    this.binaryParsingState = 6;
                    this.resetCacheToken(GenericUtils.asInt(this.parsedToken));
                    continue block8;
                }
                case 6: {
                    this.setHeaderValue();
                    this.binaryParsingState = 1;
                    this.createCacheToken(4);
                    continue block8;
                }
            }
            throw new MalformedMessageException("Invalid state in headers: " + this.binaryParsingState);
        }
        this.resetUnused(wsByteBuffer);
        this.resetByteCache();
        this.clearCacheToken();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("End of binary headers at pos: " + this.eohPosition));
        }
        return true;
    }

    public boolean parseHeaders(WsByteBuffer wsByteBuffer, boolean bl) throws MalformedMessageException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parsing headers with input buff: " + wsByteBuffer));
        }
        boolean bl2 = false;
        while (-1 == this.eohPosition) {
            switch (this.stateOfParsing) {
                case 0: {
                    bl2 = this.parseHeaderName(wsByteBuffer);
                    break;
                }
                case 1: {
                    bl2 = bl || this.bIsMultiLine ? this.parseHeaderValueExtract(wsByteBuffer) : this.parseHeaderValueNonExtract(wsByteBuffer);
                    break;
                }
                case 2: {
                    bl2 = this.parseCRLFs(wsByteBuffer);
                    break;
                }
                default: {
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)("Found invalid parsing ID of " + this.stateOfParsing));
                }
            }
            if (bl2) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Need more data");
            }
            return false;
        }
        this.resetByteCache();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("End of headers found at position " + this.eohPosition));
        }
        return true;
    }

    public void postMarshallHeaders() {
    }

    public void preMarshallHeaders() {
    }

    public void prependHeader(HeaderKeys headerKeys, byte[] byArray) {
        if (null == headerKeys || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("prependHeader(h,b): " + headerKeys.getName()));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray);
        }
        if (!HeaderKeys.isLegal(headerKeys)) {
            throw new IllegalArgumentException("ErrorHeaderKey not allowed");
        }
        HeaderElement headerElement = this.getNewElement(headerKeys);
        headerElement.setByteArrayValue(byArray);
        this.addKnownHeader(headerKeys, headerElement, false, true);
    }

    public void prependHeader(HeaderKeys headerKeys, String string) {
        if (null == headerKeys || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("prependHeader(h,s): " + headerKeys.getName()));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(string);
        }
        if (!HeaderKeys.isLegal(headerKeys)) {
            throw new IllegalArgumentException("ErrorHeaderKey not allowed");
        }
        HeaderElement headerElement = this.getNewElement(headerKeys);
        headerElement.setStringValue(string);
        this.addKnownHeader(headerKeys, headerElement, false, true);
    }

    public void prependHeader(String string, byte[] byArray) {
        HeaderKeys headerKeys;
        if (null == string || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("prependHeader(s,b): " + string));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray);
        }
        if ((headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            HeaderElement headerElement = this.getNewElement(string);
            headerElement.setByteArrayValue(byArray);
            this.addUnknownHeader(string, headerElement, false);
        } else {
            HeaderElement headerElement = this.getNewElement(headerKeys);
            headerElement.setByteArrayValue(byArray);
            this.addKnownHeader(headerKeys, headerElement, false, true);
        }
    }

    public void prependHeader(byte[] byArray, byte[] byArray2) {
        HeaderKeys headerKeys;
        if (null == byArray || null == byArray2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("prependHeader(b,b): " + GenericUtils.getEnglishString(byArray)));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray2);
        }
        if ((headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            String string = GenericUtils.getEnglishString(byArray);
            HeaderElement headerElement = this.getNewElement(string);
            headerElement.setByteArrayValue(byArray2);
            this.addUnknownHeader(string, headerElement, false);
        } else {
            HeaderElement headerElement = this.getNewElement(headerKeys);
            headerElement.setByteArrayValue(byArray2);
            this.addKnownHeader(headerKeys, headerElement, false, true);
        }
    }

    public void prependHeader(String string, String string2) {
        HeaderKeys headerKeys;
        if (null == string || null == string2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("prependHeader(s,s): " + string));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(string2);
        }
        if ((headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            HeaderElement headerElement = this.getNewElement(string);
            headerElement.setStringValue(string2);
            this.addUnknownHeader(string, headerElement, false);
        } else {
            HeaderElement headerElement = this.getNewElement(headerKeys);
            headerElement.setStringValue(string2);
            this.addKnownHeader(headerKeys, headerElement, false, true);
        }
    }

    public void prependHeader(byte[] byArray, String string) {
        HeaderKeys headerKeys;
        if (null == byArray || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("prependHeader(b,s): " + GenericUtils.getEnglishString(byArray)));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(string);
        }
        if ((headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            String string2 = GenericUtils.getEnglishString(byArray);
            HeaderElement headerElement = this.getNewElement(string2);
            headerElement.setStringValue(string);
            this.addUnknownHeader(string2, headerElement, false);
        } else {
            HeaderElement headerElement = this.getNewElement(headerKeys);
            headerElement.setStringValue(string);
            this.addKnownHeader(headerKeys, headerElement, false, true);
        }
    }

    public void removeAllHeaders() {
        HeaderElement headerElement;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeAllHeaders()");
        }
        for (int i = 0; i < this.knownSequenceIndex; ++i) {
            headerElement = this.headerValues[this.knownSequence[i]];
            if (null == headerElement) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("removing (key) " + headerElement.getName()));
            }
            this.removeKnownHeaderElements(headerElement.getHeaderKey());
        }
        this.knownSequenceIndex = 0;
        headerElement = this.hdrSequence;
        while (null != headerElement) {
            HeaderElement headerElement2 = headerElement.nextSequence;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("removing (name) " + headerElement.getHeaderString()));
            }
            this.removeUnknownHeaderElements(headerElement.getHeaderString());
            headerElement = headerElement2;
        }
        this.hdrSequence = null;
        this.numberOfHeaders = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeAllHeaders()");
        }
    }

    public void removeHeader(HeaderKeys headerKeys) {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (HeaderKeys.isLegal(headerKeys)) {
            this.removeKnownHeader(headerKeys, true);
        }
    }

    public void removeHeader(String string) {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys headerKeys = this.getMatcher().matchHeader(string);
        if (headerKeys.equals(GenericConstants.NO_MATCH)) {
            this.removeUnknownHeader(string);
        } else if (HeaderKeys.isLegal(headerKeys)) {
            this.removeKnownHeader(headerKeys, true);
        }
    }

    public void removeHeader(byte[] byArray) {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys headerKeys = this.getMatcher().matchHeader(byArray);
        if (headerKeys.equals(GenericConstants.NO_MATCH)) {
            this.removeUnknownHeader(GenericUtils.getEnglishString(byArray));
        } else if (HeaderKeys.isLegal(headerKeys)) {
            this.removeKnownHeader(headerKeys, true);
        }
    }

    public void removeHeader(HeaderKeys headerKeys, int n) {
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (HeaderKeys.isLegal(headerKeys)) {
            this.removeKnownHeader(headerKeys, n);
        }
    }

    public void removeHeader(String string, int n) {
        if (null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys headerKeys = this.getMatcher().matchHeader(string);
        if (headerKeys.equals(GenericConstants.NO_MATCH)) {
            this.removeUnknownHeader(string, n);
        } else if (HeaderKeys.isLegal(headerKeys)) {
            this.removeKnownHeader(headerKeys, n);
        }
    }

    public void removeHeader(byte[] byArray, int n) {
        if (null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        HeaderKeys headerKeys = this.getMatcher().matchHeader(byArray);
        if (headerKeys.equals(GenericConstants.NO_MATCH)) {
            this.removeUnknownHeader(GenericUtils.getEnglishString(byArray), n);
        } else if (HeaderKeys.isLegal(headerKeys)) {
            this.removeKnownHeader(headerKeys, n);
        }
    }

    public void removeSpecialHeader(HeaderKeys headerKeys) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeSpecialHeader(h): " + headerKeys.getName()));
        }
        this.removeKnownHeader(headerKeys, false);
    }

    public void replaceHeader(HeaderKeys headerKeys, int n, byte[] byArray) {
        if (null == headerKeys || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray);
        }
        if (!HeaderKeys.isLegal(headerKeys)) {
            throw new IllegalArgumentException("ErrorHeaderKey not allowed");
        }
        this.replaceKnownHeader(headerKeys, byArray, n);
    }

    public void replaceHeader(HeaderKeys headerKeys, int n, String string) {
        if (null == headerKeys || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(string);
        }
        if (!HeaderKeys.isLegal(headerKeys)) {
            throw new IllegalArgumentException("ErrorHeaderKey not allowed");
        }
        this.replaceKnownHeader(headerKeys, string, n);
    }

    public void replaceHeader(String string, int n, byte[] byArray) {
        HeaderKeys headerKeys;
        if (null == string || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray);
        }
        if ((headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            this.replaceUnknownHeader(string, byArray, n);
        } else {
            this.replaceKnownHeader(headerKeys, byArray, n);
        }
    }

    public void replaceHeader(byte[] byArray, int n, byte[] byArray2) {
        HeaderKeys headerKeys;
        if (null == byArray || null == byArray2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray2);
        }
        if ((headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            this.replaceUnknownHeader(GenericUtils.getEnglishString(byArray), byArray2, n);
        } else {
            this.replaceKnownHeader(headerKeys, byArray2, n);
        }
    }

    public void replaceHeader(String string, int n, String string2) {
        HeaderKeys headerKeys;
        if (null == string || null == string2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(string2);
        }
        if ((headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            this.replaceUnknownHeader(string, string2, n);
        } else {
            this.replaceKnownHeader(headerKeys, string2, n);
        }
    }

    public void replaceHeader(byte[] byArray, int n, String string) {
        HeaderKeys headerKeys;
        if (null == byArray || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(string);
        }
        if ((headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            this.replaceUnknownHeader(GenericUtils.getEnglishString(byArray), string, n);
        } else {
            this.replaceKnownHeader(headerKeys, string, n);
        }
    }

    public WsByteBuffer returnCurrentBuffer() {
        if (-1 != this.myBuffersIndex) {
            WsByteBuffer wsByteBuffer = this.myBuffers[this.myBuffersIndex];
            --this.myBuffersIndex;
            return wsByteBuffer;
        }
        return null;
    }

    public void setHeader(String string, byte[] byArray) {
        HeaderKeys headerKeys;
        if (null == string || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setHeader(s,b): " + string));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray);
        }
        if (!(headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            this.setHeader(headerKeys, byArray);
        } else {
            this.createSingleHeader(string, byArray);
        }
    }

    public void setHeader(byte[] byArray, byte[] byArray2) {
        HeaderKeys headerKeys;
        if (null == byArray || null == byArray2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setHeader(b,b): " + GenericUtils.getEnglishString(byArray)));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray2);
        }
        if (!(headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            this.setHeader(headerKeys, byArray2);
        } else {
            this.createSingleHeader(GenericUtils.getEnglishString(byArray), byArray2);
        }
    }

    public void setHeader(HeaderKeys headerKeys, byte[] byArray) {
        if (null == headerKeys || null == byArray) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setHeader(h,b): " + headerKeys.getName()));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(byArray);
        }
        if (!HeaderKeys.isLegal(headerKeys)) {
            throw new IllegalArgumentException("ErrorHeaderKey not allowed");
        }
        if (headerKeys.useFilters()) {
            HeaderElement headerElement = this.findHeader(headerKeys, 0);
            if (null != headerElement) {
                headerKeys.filterRemHeader(this, null);
            }
            if (!headerKeys.filterAddHeader(this, byArray)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("New value disallowed: " + GenericUtils.getEnglishString(byArray)));
                }
                this.removeKnownHeader(headerKeys, false);
                return;
            }
        }
        this.createSingleHeader(headerKeys, byArray);
    }

    public void setHeader(HeaderKeys headerKeys, String string) {
        if (null == headerKeys || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setHeader(h,s): " + headerKeys.getName()));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(string);
        }
        if (!HeaderKeys.isLegal(headerKeys)) {
            throw new IllegalArgumentException("ErrorHeaderKey not allowed");
        }
        if (headerKeys.useFilters()) {
            HeaderElement headerElement = this.findHeader(headerKeys, 0);
            if (null != headerElement) {
                headerKeys.filterRemHeader(this, null);
            }
            if (!headerKeys.filterAddHeader(this, GenericUtils.getEnglishBytes(string))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("New value disallowed: " + string));
                }
                this.removeKnownHeader(headerKeys, false);
                return;
            }
        }
        this.createSingleHeader(headerKeys, string);
    }

    public void setHeader(String string, String string2) {
        HeaderKeys headerKeys;
        if (null == string || null == string2) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setHeader(s,s): " + string));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(string2);
        }
        if (!(headerKeys = this.getMatcher().matchHeader(string)).equals(GenericConstants.NO_MATCH)) {
            this.setHeader(headerKeys, string2);
        } else {
            this.createSingleHeader(string, string2);
        }
    }

    public void setHeader(byte[] byArray, String string) {
        HeaderKeys headerKeys;
        if (null == byArray || null == string) {
            throw new IllegalArgumentException("Null input provided");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setHeader(b,s): " + GenericUtils.getEnglishString(byArray)));
        }
        if (this.bHeaderValidation) {
            this.checkHeaderValue(string);
        }
        if (!(headerKeys = this.getMatcher().matchHeader(byArray)).equals(GenericConstants.NO_MATCH)) {
            this.setHeader(headerKeys, string);
        } else {
            this.createSingleHeader(GenericUtils.getEnglishString(byArray), string);
        }
    }

    protected void setHeaderMatcher(QuickHeaderMatcher quickHeaderMatcher) {
        this.myHM = quickHeaderMatcher;
    }

    private QuickHeaderMatcher getMatcher() {
        return this.myHM;
    }

    private void createSingleHeader(HeaderKeys headerKeys, byte[] byArray) {
        HeaderElement headerElement = this.findHeader(headerKeys, 0);
        if (null == headerElement) {
            headerElement = this.getNewElement(headerKeys);
            headerElement.setByteArrayValue(byArray);
            this.addKnownHeader(headerKeys, headerElement, false, false);
        } else {
            if (null != headerElement.nextInstance) {
                this.removeSecondaryInstances(headerElement);
            }
            headerElement.setByteArrayValue(byArray);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Replacing known header " + headerKeys.getName() + " with [" + headerElement.getStringValue() + "]"));
            }
        }
    }

    private void createSingleHeader(HeaderKeys headerKeys, String string) {
        HeaderElement headerElement = this.findHeader(headerKeys, 0);
        if (null == headerElement) {
            headerElement = this.getNewElement(headerKeys);
            headerElement.setStringValue(string);
            this.addKnownHeader(headerKeys, headerElement, false, false);
        } else {
            if (null != headerElement.nextInstance) {
                this.removeSecondaryInstances(headerElement);
            }
            headerElement.setStringValue(string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Replacing known header " + headerKeys.getName() + " with [" + string + "]"));
            }
        }
    }

    private void addToKnownSequenceList(int n) {
        int n2 = this.knownSequence.length;
        if (this.knownSequenceIndex == n2) {
            int[] nArray = new int[n2 + 10];
            System.arraycopy(this.knownSequence, 0, nArray, 0, n2);
            this.knownSequence = nArray;
        }
        this.knownSequence[this.knownSequenceIndex] = n;
        ++this.knownSequenceIndex;
    }

    private void removeFromKnownSequenceList(int n) {
        for (int i = 0; i < this.knownSequenceIndex; ++i) {
            if (this.knownSequence[i] != n) continue;
            int n2 = i;
            while (n2 < this.knownSequenceIndex) {
                int n3 = n2 + 1;
                this.knownSequence[n2] = this.knownSequence[n3];
                n2 = n3;
            }
            --this.knownSequenceIndex;
            return;
        }
    }

    private void addKnownHeader(HeaderKeys headerKeys, HeaderElement headerElement, boolean bl, boolean bl2) {
        boolean bl3;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Adding known header " + headerKeys.getName() + " with value [" + headerElement.getStringValue() + "]"));
        }
        if (bl2 && headerKeys.useFilters() && !headerKeys.filterAddHeader(this, headerElement.getByteArrayValue())) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("filter disallowed: " + headerElement.getStringValue()));
            }
            throw new IllegalArgumentException("Header value not allowed");
        }
        this.incrementHeaderCounter();
        boolean bl4 = bl3 = bl ? this.addInstanceOfElement(this.headerValues[headerKeys.getOrdinal()], headerElement) : this.addLeadingInstanceOfElement(this.headerValues[headerKeys.getOrdinal()], headerElement);
        if (bl3) {
            this.headerValues[headerKeys.getOrdinal()] = headerElement;
        }
    }

    private HeaderElement getNewElement(HeaderKeys headerKeys) {
        HeaderElement headerElement = this.getElement();
        if (null == headerElement) {
            headerElement = new HeaderElement(headerKeys, this, this.elementID++);
        } else {
            try {
                headerElement.init(headerKeys);
            }
            catch (IllegalObjectReplacementException illegalObjectReplacementException) {
                headerElement = new HeaderElement(headerKeys, this, this.elementID++);
            }
        }
        return headerElement;
    }

    private HeaderElement findHeader(HeaderKeys headerKeys, int n) {
        HeaderElement headerElement = null;
        if (HeaderKeys.isLegal(headerKeys)) {
            headerElement = this.headerValues[headerKeys.getOrdinal()];
            if (0 < n) {
                for (int i = 0; i < n && null != headerElement; ++i) {
                    headerElement = headerElement.nextInstance;
                }
            }
        }
        return headerElement;
    }

    private void removeKnownHeader(HeaderKeys headerKeys, int n) {
        HeaderElement headerElement = this.headerValues[headerKeys.getOrdinal()];
        for (int i = 0; i < n && null != headerElement; ++i) {
            headerElement = headerElement.nextInstance;
        }
        if (null != headerElement) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Removing " + headerElement.getName() + " (" + n + ") [" + headerElement.getStringValue() + "]"));
            }
            this.decrementHeaderCounter();
            HeaderElement headerElement2 = headerElement.prevInstance;
            HeaderElement headerElement3 = headerElement.nextInstance;
            if (null == headerElement2 && null == headerElement3) {
                this.headerValues[headerKeys.getOrdinal()] = null;
                if (headerKeys.useFilters()) {
                    headerKeys.filterRemHeader(this, null);
                }
                this.removeFromKnownSequenceList(headerKeys.getOrdinal());
            } else {
                if (null != headerElement2 && null != headerElement3) {
                    headerElement2.nextInstance = headerElement3;
                    headerElement3.prevInstance = headerElement2;
                } else if (null != headerElement3) {
                    headerElement3.prevInstance = null;
                    this.headerValues[headerKeys.getOrdinal()] = headerElement3;
                } else if (null != headerElement2) {
                    headerElement2.nextInstance = null;
                }
                if (headerKeys.useFilters()) {
                    headerKeys.filterRemHeader(this, headerElement.getByteArrayValue());
                }
            }
            headerElement.destroy();
        }
    }

    private void removeKnownHeader(HeaderKeys headerKeys, boolean bl) {
        int n = headerKeys.getOrdinal();
        HeaderElement headerElement = this.headerValues[n];
        if (null != headerElement) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Removing known header [" + headerElement.getName() + "]"));
            }
            if (bl && headerKeys.useFilters()) {
                headerKeys.filterRemHeader(this, null);
            }
            while (null != headerElement) {
                this.decrementHeaderCounter();
                HeaderElement headerElement2 = headerElement.nextInstance;
                headerElement.destroy();
                headerElement = headerElement2;
            }
            this.headerValues[n] = null;
            this.removeFromKnownSequenceList(n);
        }
    }

    private void removeKnownHeaderElements(HeaderKeys headerKeys) {
        int n = headerKeys.getOrdinal();
        HeaderElement headerElement = this.headerValues[n];
        if (headerKeys.useFilters()) {
            headerKeys.filterRemHeader(this, null);
        }
        while (null != headerElement) {
            this.decrementHeaderCounter();
            HeaderElement headerElement2 = headerElement.nextInstance;
            headerElement.destroy();
            headerElement = headerElement2;
        }
        this.headerValues[n] = null;
    }

    private void replaceKnownHeader(HeaderKeys headerKeys, byte[] byArray, int n) {
        HeaderElement headerElement;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Replacing known header " + headerKeys.getName() + " (" + n + ") with [" + GenericUtils.getEnglishString(byArray) + "]"));
        }
        if (null != (headerElement = this.findHeader(headerKeys, n))) {
            if (headerKeys.useFilters()) {
                byte[] byArray2 = headerElement.getByteArrayValue();
                headerKeys.filterRemHeader(this, byArray2);
                if (!headerKeys.filterAddHeader(this, byArray)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("replaceHeader failed filterAdd: " + GenericUtils.getEnglishString(byArray)));
                    }
                    headerKeys.filterAddHeader(this, byArray2);
                    throw new IllegalArgumentException("Header value not allowed");
                }
            }
            headerElement.setByteArrayValue(byArray);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Instance not found");
        }
    }

    private void replaceKnownHeader(HeaderKeys headerKeys, String string, int n) {
        HeaderElement headerElement;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Replacing known header " + headerKeys.getName() + " (" + n + ") with [" + string + "]"));
        }
        if (null != (headerElement = this.findHeader(headerKeys, n))) {
            if (headerKeys.useFilters()) {
                byte[] byArray = headerElement.getByteArrayValue();
                headerKeys.filterRemHeader(this, byArray);
                if (!headerKeys.filterAddHeader(this, GenericUtils.getEnglishBytes(string))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("replaceHeader failed filterAdd: " + string));
                    }
                    headerKeys.filterAddHeader(this, byArray);
                    throw new IllegalArgumentException("Header value not allowed");
                }
            }
            headerElement.setStringValue(string);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Instance not found");
        }
    }

    protected void setSpecialHeader(HeaderKeys headerKeys, byte[] byArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setSpecialHeader(h,b[]): " + headerKeys.getName()));
        }
        this.createSingleHeader(headerKeys, byArray);
    }

    protected void setSpecialHeader(HeaderKeys headerKeys, String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setSpecialHeader(h,s): " + headerKeys.getName()));
        }
        this.createSingleHeader(headerKeys, string);
    }

    protected WsByteBuffer[] marshallKnownHeader(WsByteBuffer[] wsByteBufferArray, HeaderElement headerElement) {
        while (null != headerElement) {
            byte[] byArray = headerElement.getByteArrayValue();
            if (null != byArray) {
                wsByteBufferArray = this.putBytes(headerElement.getHeaderKey().getMarshalledByteArray(), wsByteBufferArray);
                wsByteBufferArray = this.putBytes(byArray, wsByteBufferArray);
                wsByteBufferArray = this.putBytes(BNFHeaders.EOL, wsByteBufferArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Marshalling known: " + headerElement.getHeaderKey() + " [" + headerElement.getStringValue() + "]"));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error: no value for " + headerElement.getHeaderKey()));
            }
            headerElement = headerElement.nextInstance;
        }
        return wsByteBufferArray;
    }

    protected WsByteBuffer[] marshallKnownBinaryHeader(WsByteBuffer[] wsByteBufferArray, HeaderElement headerElement) {
        while (null != headerElement) {
            byte[] byArray = headerElement.getByteArrayValue();
            if (null != byArray) {
                wsByteBufferArray = this.putInt(1, wsByteBufferArray);
                wsByteBufferArray = this.putInt(headerElement.getHeaderKey().getOrdinal(), wsByteBufferArray);
                wsByteBufferArray = this.putInt(byArray.length, wsByteBufferArray);
                wsByteBufferArray = this.putBytes(byArray, wsByteBufferArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Marshalling known: " + headerElement.getName() + " [" + headerElement.getStringValue() + "]"));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error: no values for " + headerElement.getName()));
            }
            headerElement = headerElement.nextInstance;
        }
        return wsByteBufferArray;
    }

    private void createSingleHeader(String string, byte[] byArray) {
        HeaderElement headerElement = this.getUnknownHeader(string);
        if (null == headerElement) {
            headerElement = this.getNewElement(string);
            headerElement.setByteArrayValue(byArray);
            this.addUnknownHeader(string, headerElement, true);
        } else {
            if (null != headerElement.nextInstance) {
                this.removeSecondaryInstances(headerElement);
            }
            headerElement.setByteArrayValue(byArray);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Replacing unknown header " + string + " with [" + headerElement.getStringValue() + "]"));
            }
        }
    }

    private void createSingleHeader(String string, String string2) {
        HeaderElement headerElement = this.getUnknownHeader(string);
        if (null == headerElement) {
            headerElement = this.getNewElement(string);
            headerElement.setStringValue(string2);
            this.addUnknownHeader(string, headerElement, true);
        } else {
            if (null != headerElement.nextInstance) {
                this.removeSecondaryInstances(headerElement);
            }
            headerElement.setStringValue(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Replacing unknown header " + string + " with [" + string2 + "]"));
            }
        }
    }

    private void addUnknownHeader(String string, HeaderElement headerElement, boolean bl) {
        boolean bl2;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Adding unknown header " + string + " with value [" + headerElement.getStringValue() + "]"));
        }
        this.incrementHeaderCounter();
        HeaderElement headerElement2 = this.getUnknownHeader(string);
        boolean bl3 = bl2 = bl ? this.addInstanceOfElement(headerElement2, headerElement) : this.addLeadingInstanceOfElement(headerElement2, headerElement);
        if (bl2) {
            this.putUnknownHeader(string, headerElement);
        }
    }

    protected void appendHeaderNoMatch(String string, byte[] byArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("appendHeaderNoMatch: " + string));
        }
        HeaderElement headerElement = this.getNewElement(string);
        headerElement.setByteArrayValue(byArray);
        this.addUnknownHeader(string, headerElement, true);
    }

    private HeaderElement deleteUnknownHeader(String string) {
        String string2 = Normalizer.normalize(string, 2);
        return (HeaderElement)this.otherHeaders.remove(string2);
    }

    private HeaderElement getNewElement(String string) {
        HeaderElement headerElement = this.getElement();
        if (null == headerElement) {
            headerElement = new HeaderElement(string, this, this.elementID++);
        } else {
            try {
                headerElement.init(string);
            }
            catch (IllegalObjectReplacementException illegalObjectReplacementException) {
                headerElement = new HeaderElement(string, this, this.elementID++);
            }
        }
        return headerElement;
    }

    private HeaderElement getUnknownHeader(String string) {
        String string2 = Normalizer.normalize(string, 2);
        return (HeaderElement)this.otherHeaders.get(string2);
    }

    private HeaderElement findHeader(String string, int n) {
        HeaderElement headerElement;
        HeaderKeys headerKeys = this.getMatcher().matchHeader(string);
        HeaderElement headerElement2 = headerElement = headerKeys.equals(GenericConstants.NO_MATCH) ? this.getUnknownHeader(string) : this.headerValues[headerKeys.getOrdinal()];
        if (0 < n) {
            for (int i = 0; i < n && null != headerElement; ++i) {
                headerElement = headerElement.nextInstance;
            }
        }
        return headerElement;
    }

    private HeaderElement findHeader(byte[] byArray, int n) {
        HeaderElement headerElement;
        HeaderKeys headerKeys = this.getMatcher().matchHeader(byArray);
        HeaderElement headerElement2 = headerElement = headerKeys.equals(GenericConstants.NO_MATCH) ? this.getUnknownHeader(GenericUtils.getEnglishString(byArray)) : this.headerValues[headerKeys.getOrdinal()];
        if (0 < n) {
            for (int i = 0; i < n && null != headerElement; ++i) {
                headerElement = headerElement.nextInstance;
            }
        }
        return headerElement;
    }

    private void putUnknownHeader(String string, HeaderElement headerElement) {
        String string2 = Normalizer.normalize(string, 2);
        this.otherHeaders.put(string2, headerElement);
    }

    private void removeUnknownHeader(String string, int n) {
        HeaderElement headerElement = this.getUnknownHeader(string);
        for (int i = 0; i < n && null != headerElement; ++i) {
            headerElement = headerElement.nextInstance;
        }
        if (null != headerElement) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Removing unknown " + string + " (" + n + ") [" + headerElement.getStringValue() + "]"));
            }
            this.decrementHeaderCounter();
            HeaderElement headerElement2 = headerElement.prevInstance;
            HeaderElement headerElement3 = headerElement.nextInstance;
            if (null != headerElement2 && null != headerElement3) {
                headerElement2.nextInstance = headerElement3;
                headerElement3.prevInstance = headerElement2;
            } else if (null != headerElement3) {
                headerElement3.prevInstance = null;
                this.deleteUnknownHeader(string);
                this.putUnknownHeader(string, headerElement3);
                this.replaceHeaderInSequence(headerElement);
            } else if (null != headerElement2) {
                headerElement2.nextInstance = null;
            } else {
                this.deleteUnknownHeader(string);
                this.removeHeaderFromSequence(headerElement);
            }
            headerElement.destroy();
        }
    }

    private void removeUnknownHeader(String string) {
        HeaderElement headerElement = this.deleteUnknownHeader(string);
        if (null == headerElement) {
            return;
        }
        this.removeHeaderFromSequence(headerElement);
        HeaderElement headerElement2 = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Removing unknown header [" + string + "]"));
        }
        while (null != headerElement) {
            this.decrementHeaderCounter();
            headerElement2 = headerElement.nextInstance;
            headerElement.destroy();
            headerElement = headerElement2;
        }
    }

    private void removeUnknownHeaderElements(String string) {
        HeaderElement headerElement = this.deleteUnknownHeader(string);
        while (null != headerElement) {
            this.decrementHeaderCounter();
            HeaderElement headerElement2 = headerElement.nextInstance;
            headerElement.destroy();
            headerElement = headerElement2;
        }
    }

    private void replaceUnknownHeader(String string, byte[] byArray, int n) {
        HeaderElement headerElement;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Replacing unknown header " + string + " (" + n + ") with [" + GenericUtils.getEnglishString(byArray) + "]"));
        }
        if (null != (headerElement = this.findHeader(string, n))) {
            headerElement.setByteArrayValue(byArray);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Instance not found");
        }
    }

    private void replaceUnknownHeader(String string, String string2, int n) {
        HeaderElement headerElement;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Replacing unknown header " + string + " (" + n + ") with [" + string2 + "]"));
        }
        if (null != (headerElement = this.findHeader(string, n))) {
            headerElement.setStringValue(string2);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Instance not found");
        }
    }

    protected WsByteBuffer[] marshallUnknownHeader(WsByteBuffer[] wsByteBufferArray, HeaderElement headerElement) {
        while (null != headerElement) {
            String string = headerElement.getHeaderString();
            byte[] byArray = headerElement.getByteArrayValue();
            if (null != byArray) {
                wsByteBufferArray = this.putBytes(GenericUtils.getEnglishBytes(string), wsByteBufferArray);
                wsByteBufferArray = this.putBytes(KEY_VALUE_SEPARATOR, wsByteBufferArray);
                wsByteBufferArray = this.putBytes(byArray, wsByteBufferArray);
                wsByteBufferArray = this.putBytes(EOL, wsByteBufferArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Marshalling unknown: " + string + " [" + headerElement.getStringValue() + "]"));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error: no value for " + string));
            }
            headerElement = headerElement.nextInstance;
        }
        return wsByteBufferArray;
    }

    protected WsByteBuffer[] marshallUnknownBinaryHeader(WsByteBuffer[] wsByteBufferArray, HeaderElement headerElement) {
        while (null != headerElement) {
            byte[] byArray = GenericUtils.getEnglishBytes(headerElement.getHeaderString());
            byte[] byArray2 = headerElement.getByteArrayValue();
            if (null != byArray2) {
                wsByteBufferArray = this.putInt(2, wsByteBufferArray);
                wsByteBufferArray = this.putInt(byArray.length, wsByteBufferArray);
                wsByteBufferArray = this.putBytes(byArray, wsByteBufferArray);
                wsByteBufferArray = this.putInt(byArray2.length, wsByteBufferArray);
                wsByteBufferArray = this.putBytes(byArray2, wsByteBufferArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Marshalling unknown: " + headerElement.getHeaderString() + " [" + headerElement.getStringValue() + "]"));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error: no values for " + headerElement.getHeaderString()));
            }
            headerElement = headerElement.nextInstance;
        }
        return wsByteBufferArray;
    }

    protected final int getBinaryParseState() {
        return this.binaryParsingState;
    }

    protected final void setBinaryParseState(int n) {
        this.binaryParsingState = n;
    }

    void addElement(HeaderElement headerElement) {
        headerElement.nextInstance = this.headerElements;
        this.headerElements = headerElement;
    }

    public WsByteBuffer allocateBuffer(int n) {
        WsByteBuffer wsByteBuffer = this.useDirectBuffer ? WsByteBufferPoolManagerImpl.getRef().allocateDirect(n) : WsByteBufferPoolManagerImpl.getRef().allocate(n);
        this.addToCreatedBuffer(wsByteBuffer);
        return wsByteBuffer;
    }

    public final WsByteBuffer getCurrentBuffer() {
        return this.currentReadBB;
    }

    public final void setCurrentBuffer(WsByteBuffer wsByteBuffer) {
        this.currentReadBB = wsByteBuffer;
    }

    public void setDebugContext(Object object) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("debugContext set to " + object + " for " + this));
        }
        if (null != object) {
            this.debugContext = object;
        }
    }

    protected final Object getDebugContext() {
        return this.debugContext;
    }

    protected final int getIncomingBufferSize() {
        return this.incomingBufferSize;
    }

    protected final int getOutgoingBufferSize() {
        return this.outgoingHdrBufferSize;
    }

    protected final boolean shouldAllocateDirectBuffer() {
        return this.useDirectBuffer;
    }

    protected final void setParsedToken(byte[] byArray) {
        this.parsedToken = byArray;
    }

    protected final byte[] getParsedToken() {
        return this.parsedToken;
    }

    protected final int getByteCacheSize() {
        return this.byteCacheSize;
    }

    protected WsByteBuffer getMyBuffer(int n) {
        if (0 > n || n >= this.myBuffers.length) {
            return null;
        }
        return this.myBuffers[n];
    }

    public final int getBuffersIndex() {
        return this.myBuffersIndex;
    }

    public void setLimitOfTokenSize(int n) {
        if (0 >= n) {
            throw new IllegalArgumentException("Invalid limit on token size: " + n);
        }
        this.limitTokenSize = n;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Limit on token size now: " + this.limitTokenSize));
        }
    }

    public final int getLimitOfTokenSize() {
        return this.limitTokenSize;
    }

    public final int getNumberOfHeaders() {
        return this.numberOfHeaders;
    }

    private void incrementHeaderCounter() {
        ++this.numberOfHeaders;
        if (this.limitNumHeaders < this.numberOfHeaders) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Too many headers in storage: " + this.numberOfHeaders));
            }
            throw new IllegalArgumentException("Too many headers in storage: " + this.numberOfHeaders);
        }
    }

    private void decrementHeaderCounter() {
        --this.numberOfHeaders;
        if (0 > this.numberOfHeaders) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Number of headers counter went negative");
            }
            this.numberOfHeaders = 0;
        }
    }

    public final void setLimitOnNumberOfHeaders(int n) {
        if (0 >= n) {
            throw new IllegalArgumentException("Invalid limit on number headers: " + n);
        }
        this.limitNumHeaders = n;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Limit on number of headers now: " + this.limitNumHeaders));
        }
    }

    public final int getLimitOnNumberOfHeaders() {
        return this.limitNumHeaders;
    }

    protected final void setHeaderValidation(boolean bl) {
        this.bHeaderValidation = bl;
    }

    private void checkHeaderValue(byte[] byArray) {
        int n = byArray.length - 1;
        if (n < 0) {
            return;
        }
        if (10 == byArray[n] || 13 == byArray[n]) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Illegal trailing EOL");
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)(this.getClass().getName() + ".checkHeaderValue"), (String)"1", (Object)this);
            throw illegalArgumentException;
        }
        for (int i = 0; i < n; ++i) {
            if (10 != byArray[i] || 10 != byArray[++i] && 13 != byArray[i]) continue;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Illegal EOLs in value");
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)(this.getClass().getName() + ".checkHeaderValue"), (String)"2", (Object)this);
            throw illegalArgumentException;
        }
    }

    private void checkHeaderValue(String string) {
        int n = string.length() - 1;
        if (n < 0) {
            return;
        }
        char c = string.charAt(n);
        if ('\n' == c || '\r' == c) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Illegal trailing EOL");
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)(this.getClass().getName() + ".checkHeaderValue"), (String)"1", (Object)this);
            throw illegalArgumentException;
        }
        for (int i = 0; i < n; ++i) {
            if ('\n' != string.charAt(i) || '\n' != (c = string.charAt(++i)) && '\r' != c) continue;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Illegal EOLs in value");
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)(this.getClass().getName() + ".checkHeaderValue"), (String)"2", (Object)this);
            throw illegalArgumentException;
        }
    }

    private int countInstances(HeaderElement headerElement) {
        int n = 0;
        while (null != headerElement) {
            ++n;
            headerElement = headerElement.nextInstance;
        }
        return n;
    }

    private int compareByteArrays(HeaderElement headerElement, byte[] byArray) {
        if (null == headerElement) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Compare failed against nonexistant header");
            }
            return -1;
        }
        if (null != headerElement) {
            HeaderElement headerElement2 = headerElement;
            while (null != headerElement2) {
                int n;
                byte[] byArray2 = headerElement2.getByteArrayValue();
                if (byArray2.length != byArray.length) {
                    headerElement2 = headerElement2.nextInstance;
                    continue;
                }
                for (n = 0; n < byArray2.length && byArray2[n] == byArray[n]; ++n) {
                }
                if (n == byArray2.length) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Compare found a match");
                    }
                    return 1;
                }
                headerElement2 = headerElement2.nextInstance;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Compare did not find a match");
        }
        return 0;
    }

    private int compareStrings(HeaderElement headerElement, String string) {
        if (null == headerElement) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Compare against missing header: ");
            }
            return -1;
        }
        if (null != headerElement) {
            HeaderElement headerElement2 = headerElement;
            while (null != headerElement2) {
                if (headerElement2.getStringValue().equals(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Compare found a match");
                    }
                    return 1;
                }
                headerElement2 = headerElement2.nextInstance;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Compare did not find a match");
        }
        return 0;
    }

    private HeaderElement getElement() {
        HeaderElement headerElement = this.headerElements;
        if (null != headerElement) {
            this.headerElements = headerElement.nextInstance;
            headerElement.nextInstance = null;
        }
        return headerElement;
    }

    private int findSequencePosition(HeaderElement headerElement) {
        if (null != headerElement) {
            HeaderElement headerElement2;
            int n;
            for (n = 0; n < this.knownSequenceIndex; ++n) {
                headerElement2 = this.headerValues[this.knownSequence[n]];
                if (null == headerElement2 || !headerElement2.equals(headerElement)) continue;
                return n;
            }
            headerElement2 = this.hdrSequence;
            while (null != headerElement2) {
                if (headerElement2.equals(headerElement)) {
                    return n;
                }
                headerElement2 = headerElement2.nextSequence;
                ++n;
            }
        }
        return -1;
    }

    private boolean skipWhiteSpace(WsByteBuffer wsByteBuffer) {
        byte by;
        do {
            if (this.bytePosition < this.byteLimit || this.fillByteCache(wsByteBuffer)) continue;
            return false;
        } while (32 == (by = this.byteCache[this.bytePosition++]) || 9 == by);
        --this.bytePosition;
        return true;
    }

    private void removeSecondaryInstances(HeaderElement headerElement) {
        HeaderElement headerElement2 = headerElement.nextInstance;
        headerElement.nextInstance = null;
        while (null != headerElement2) {
            this.decrementHeaderCounter();
            HeaderElement headerElement3 = headerElement2.nextInstance;
            headerElement2.destroy();
            headerElement2 = headerElement3;
        }
    }

    private boolean addInstanceOfElement(HeaderElement headerElement, HeaderElement headerElement2) {
        if (null == headerElement) {
            HeaderKeys headerKeys = headerElement2.getHeaderKey();
            if (null != headerKeys) {
                this.addToKnownSequenceList(headerKeys.getOrdinal());
            } else {
                this.addToSequenceList(headerElement2);
            }
            return true;
        }
        while (null != headerElement.nextInstance) {
            if (headerElement.equals(headerElement2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"addInstanceOfElement: Header already existed");
                }
                return false;
            }
            headerElement = headerElement.nextInstance;
        }
        headerElement.nextInstance = headerElement2;
        headerElement2.prevInstance = headerElement;
        return false;
    }

    private boolean addLeadingInstanceOfElement(HeaderElement headerElement, HeaderElement headerElement2) {
        if (null == headerElement) {
            HeaderKeys headerKeys = headerElement2.getHeaderKey();
            if (null != headerKeys) {
                this.addToKnownSequenceList(headerKeys.getOrdinal());
            } else {
                this.addToSequenceList(headerElement2);
            }
        } else {
            headerElement.prevInstance = headerElement2;
            headerElement2.nextInstance = headerElement;
            if (null == headerElement2.getHeaderKey()) {
                this.replaceLeadingHeaderInSequence(headerElement, headerElement2);
            }
        }
        return true;
    }

    private void addToSequenceList(int n, HeaderElement headerElement) {
        if (null == this.hdrSequence) {
            this.hdrSequence = headerElement;
            this.lastHdrInSequence = headerElement;
        } else if (0 == n) {
            headerElement.nextSequence = this.hdrSequence;
            this.hdrSequence.prevSequence = headerElement;
            this.hdrSequence = headerElement;
        } else if (-1 == n) {
            this.lastHdrInSequence.nextSequence = headerElement;
            headerElement.prevSequence = this.lastHdrInSequence;
            this.lastHdrInSequence = headerElement;
        } else {
            HeaderElement headerElement2 = this.hdrSequence;
            HeaderElement headerElement3 = null;
            for (int i = 0; i < n && null != headerElement2; ++i) {
                headerElement3 = headerElement2;
                headerElement2 = headerElement2.nextSequence;
            }
            headerElement3.nextSequence = headerElement;
            headerElement.prevSequence = headerElement3;
            headerElement.nextSequence = headerElement2;
            if (null != headerElement2) {
                headerElement2.prevSequence = headerElement;
            } else {
                this.lastHdrInSequence = headerElement;
            }
        }
    }

    private void addToSequenceList(HeaderElement headerElement) {
        if (null == this.hdrSequence) {
            this.hdrSequence = headerElement;
            this.lastHdrInSequence = headerElement;
        } else {
            this.lastHdrInSequence.nextSequence = headerElement;
            headerElement.prevSequence = this.lastHdrInSequence;
            this.lastHdrInSequence = headerElement;
        }
    }

    private HeaderElement removeElemFromList(HeaderElement headerElement, HeaderElement headerElement2) {
        HeaderElement headerElement3 = headerElement2.prevSequence;
        HeaderElement headerElement4 = headerElement2.nextSequence;
        if (null != headerElement3 && null != headerElement4) {
            headerElement3.nextSequence = headerElement4;
            headerElement4.prevSequence = headerElement3;
        } else if (null != headerElement4) {
            headerElement4.prevSequence = null;
            headerElement = headerElement4;
        } else if (null != headerElement3) {
            headerElement3.nextSequence = null;
            this.lastHdrInSequence = headerElement3;
        } else {
            headerElement = null;
            this.lastHdrInSequence = null;
        }
        headerElement2.nextSequence = null;
        headerElement2.prevSequence = null;
        return headerElement;
    }

    private void replaceHeaderInSequence(HeaderElement headerElement) {
        HeaderElement headerElement2 = headerElement.nextInstance;
        HeaderElement headerElement3 = headerElement.nextSequence;
        HeaderElement headerElement4 = headerElement.prevSequence;
        if (null != headerElement4) {
            headerElement4.nextSequence = headerElement2;
        } else {
            this.hdrSequence = headerElement2;
        }
        if (null != headerElement3) {
            headerElement3.prevSequence = headerElement2;
        } else {
            this.lastHdrInSequence = headerElement2;
        }
        headerElement2.prevSequence = headerElement4;
        headerElement2.nextSequence = headerElement3;
    }

    private void replaceLeadingHeaderInSequence(HeaderElement headerElement, HeaderElement headerElement2) {
        HeaderElement headerElement3 = headerElement.nextSequence;
        HeaderElement headerElement4 = headerElement.prevSequence;
        if (null != headerElement4) {
            headerElement4.nextSequence = headerElement2;
        } else {
            this.hdrSequence = headerElement2;
        }
        if (null != headerElement3) {
            headerElement3.prevSequence = headerElement2;
        } else {
            this.lastHdrInSequence = headerElement2;
        }
        headerElement2.prevSequence = headerElement4;
        headerElement2.nextSequence = headerElement3;
    }

    private void removeHeaderFromSequence(HeaderElement headerElement) {
        HeaderElement headerElement2 = headerElement.nextSequence;
        HeaderElement headerElement3 = headerElement.prevSequence;
        if (null != headerElement3) {
            headerElement3.nextSequence = headerElement2;
        } else {
            this.hdrSequence = headerElement2;
        }
        if (null != headerElement.nextSequence) {
            headerElement2.prevSequence = headerElement3;
        } else {
            this.lastHdrInSequence = headerElement3;
        }
    }

    private void updatePosition(HeaderElement headerElement, int n) {
        HeaderKeys headerKeys = headerElement.getHeaderKey();
        if (null != headerKeys) {
            int n2;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Moving " + headerKeys.getName() + " to " + n + " : last index is " + this.knownSequenceIndex));
            }
            if (n == -1 || n > this.knownSequenceIndex) {
                n = this.knownSequenceIndex - 1;
            }
            int n3 = -1;
            int n4 = headerKeys.getOrdinal();
            for (n2 = 0; n2 < this.knownSequenceIndex; ++n2) {
                if (n4 != this.knownSequence[n2]) continue;
                n3 = n2;
                break;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Current position is " + n3));
            }
            if (-1 == n3) {
                int[] nArray = new int[this.knownSequence.length];
                if (0 < n) {
                    System.arraycopy(this.knownSequence, 0, nArray, 0, n);
                }
                nArray[n] = headerKeys.getOrdinal();
                n4 = this.knownSequenceIndex - n;
                if (0 < n4) {
                    System.arraycopy(this.knownSequence, n, nArray, n + 1, n4);
                }
                this.knownSequence = nArray;
            } else {
                if (n < n3) {
                    for (n2 = n3; n2 > n; --n2) {
                        this.knownSequence[n2] = this.knownSequence[n2 - 1];
                    }
                } else if (n > n3) {
                    for (n2 = n3; n2 < n; ++n2) {
                        this.knownSequence[n2] = this.knownSequence[n2 + 1];
                    }
                }
                this.knownSequence[n] = headerKeys.getOrdinal();
            }
        } else {
            this.hdrSequence = this.removeElemFromList(this.hdrSequence, headerElement);
            if (-1 == n) {
                this.addToSequenceList(n, headerElement);
            } else {
                n = n < this.knownSequenceIndex ? 0 : (n -= this.knownSequenceIndex);
                this.addToSequenceList(n, headerElement);
            }
        }
    }

    protected WsByteBuffer[] putInt(int n, WsByteBuffer[] wsByteBufferArray) {
        return this.putBytes(GenericUtils.asBytes(n), wsByteBufferArray);
    }

    protected WsByteBuffer[] putByte(byte by, WsByteBuffer[] wsByteBufferArray) {
        this.byteCache[this.bytePosition] = by;
        ++this.bytePosition;
        if (this.bytePosition >= this.byteCacheSize) {
            wsByteBufferArray = this.flushFullCache(wsByteBufferArray);
        }
        return wsByteBufferArray;
    }

    protected WsByteBuffer[] putBytes(byte[] byArray, WsByteBuffer[] wsByteBufferArray) {
        int n = this.byteCacheSize - this.bytePosition;
        if (byArray.length <= n) {
            System.arraycopy(byArray, 0, this.byteCache, this.bytePosition, byArray.length);
            this.bytePosition += byArray.length;
        } else {
            wsByteBufferArray = this.flushCache(wsByteBufferArray);
            return GenericUtils.putByteArray(wsByteBufferArray, byArray, this);
        }
        if (this.bytePosition == this.byteCacheSize) {
            wsByteBufferArray = this.flushFullCache(wsByteBufferArray);
        }
        return wsByteBufferArray;
    }

    protected WsByteBuffer[] flushFullCache(WsByteBuffer[] wsByteBufferArray) {
        this.bytePosition = 0;
        return GenericUtils.putByteArray(wsByteBufferArray, this.byteCache, 0, this.byteCacheSize, this);
    }

    protected WsByteBuffer[] flushCache(WsByteBuffer[] wsByteBufferArray) {
        int n = this.bytePosition;
        if (0 == n) {
            return wsByteBufferArray;
        }
        this.bytePosition = 0;
        return GenericUtils.putByteArray(wsByteBufferArray, this.byteCache, 0, n, this);
    }

    protected final void resetByteCache() {
        if (this.isByteBufferArray) {
            this.byteCache = this.originalByteCache;
            this.isByteBufferArray = false;
        }
        this.bytePosition = 0;
        this.byteLimit = 0;
    }

    protected final void setBytePosition(int n) {
        this.bytePosition = n;
    }

    protected final void decrementBytePosition() {
        --this.bytePosition;
        if (0 > this.bytePosition && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Negative byteposition: " + this.bytePosition));
        }
    }

    protected final void decrementBytePositionIgnoringLFs() {
        --this.bytePosition;
        if (10 == this.byteCache[this.bytePosition]) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"decrementILF found an LF character");
            }
            ++this.bytePosition;
        }
    }

    protected final int getBytePosition() {
        return this.bytePosition;
    }

    protected final int getByteLimit() {
        return this.byteLimit;
    }

    protected final void clearCacheToken() {
        this.parsedToken = null;
        this.parsedTokenLength = 0;
    }

    protected final void createCacheToken(int n) {
        this.parsedToken = new byte[n];
        this.parsedTokenLength = 0;
    }

    protected final void resetCacheToken(int n) {
        if (null == this.parsedToken || n != this.parsedToken.length) {
            this.parsedToken = new byte[n];
        }
        this.parsedTokenLength = 0;
    }

    protected final boolean fillCacheToken(WsByteBuffer wsByteBuffer) {
        int n;
        int n2 = this.parsedTokenLength;
        int n3 = n = this.parsedToken.length - n2;
        while (0 < n) {
            if (this.bytePosition >= this.byteLimit && !this.fillByteCache(wsByteBuffer)) {
                this.parsedTokenLength = n2;
                return false;
            }
            int n4 = this.byteLimit - this.bytePosition;
            n3 = n4 < n ? n4 : n;
            System.arraycopy(this.byteCache, this.bytePosition, this.parsedToken, n2, n3);
            n -= n3;
            n2 += n3;
            this.bytePosition += n3;
        }
        return true;
    }

    protected boolean fillByteCache(WsByteBuffer wsByteBuffer) {
        if (this.bytePosition < this.byteLimit) {
            return false;
        }
        if (wsByteBuffer.hasArray()) {
            this.bytePosition = wsByteBuffer.position();
            this.byteLimit = wsByteBuffer.limit();
            if (this.bytePosition == this.byteLimit) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Already parsed entire indirect buffer");
                }
                return false;
            }
            wsByteBuffer.position(this.byteLimit);
            this.byteCache = wsByteBuffer.array();
            this.isByteBufferArray = true;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Grabbed a Heap buffer's array");
            }
        } else {
            int n;
            if (this.isByteBufferArray) {
                this.byteCache = this.originalByteCache;
                this.isByteBufferArray = false;
            }
            if ((n = wsByteBuffer.remaining()) > this.byteCacheSize) {
                n = this.byteCacheSize;
            }
            this.bytePosition = 0;
            this.byteLimit = n;
            if (0 == this.byteLimit) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"fillByteCache: no data");
                }
                return false;
            }
            wsByteBuffer.get(this.byteCache, this.bytePosition, this.byteLimit);
        }
        return true;
    }

    private void resetUnused(WsByteBuffer wsByteBuffer) {
        int n;
        this.eohPosition = n = wsByteBuffer.position() - (this.byteLimit - this.bytePosition);
        wsByteBuffer.position(n);
    }

    protected TokenCodes findCRLFTokenLength(WsByteBuffer wsByteBuffer) throws MalformedMessageException {
        TokenCodes tokenCodes = TokenCodes.TOKEN_RC_MOREDATA;
        if (null == wsByteBuffer) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Null buffer provided");
            }
            return tokenCodes;
        }
        int n = this.parsedTokenLength;
        while (this.bytePosition < this.byteLimit || this.fillByteCache(wsByteBuffer)) {
            byte by;
            if (13 == (by = this.byteCache[this.bytePosition++])) {
                tokenCodes = TokenCodes.TOKEN_RC_DELIM;
                break;
            }
            if (10 == by) {
                tokenCodes = TokenCodes.TOKEN_RC_DELIM;
                this.numCRLFs = 1;
                break;
            }
            if (++n <= this.limitTokenSize) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("findCRLFTokenLength: length is too big: " + n));
            }
            throw new MalformedMessageException("Token length: " + n);
        }
        this.parsedTokenLength = n;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("findCRLFTokenLength returning " + tokenCodes.getName()));
        }
        return tokenCodes;
    }

    protected TokenCodes findTokenLength(WsByteBuffer wsByteBuffer, byte by, boolean bl) throws MalformedMessageException {
        TokenCodes tokenCodes = TokenCodes.TOKEN_RC_MOREDATA;
        if (null == wsByteBuffer) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"findTokenLength: null buffer provided");
            }
            return tokenCodes;
        }
        int n = this.parsedTokenLength;
        while (this.bytePosition < this.byteLimit || this.fillByteCache(wsByteBuffer)) {
            byte by2;
            if (by == (by2 = this.byteCache[this.bytePosition++])) {
                tokenCodes = TokenCodes.TOKEN_RC_DELIM;
                break;
            }
            if (13 == by2 || 10 == by2) {
                if (bl) {
                    tokenCodes = TokenCodes.TOKEN_RC_CRLF;
                    if (10 != by2) break;
                    this.numCRLFs = 1;
                    break;
                }
                throw new MalformedMessageException("Invalid CRLF found in token");
            }
            if (++n <= this.limitTokenSize) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("findTokenLength: length is too big: " + n));
            }
            throw new MalformedMessageException("Token length: " + n);
        }
        this.parsedTokenLength = n;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("findTokenLength: [" + (char)by + "] " + tokenCodes.getName()));
        }
        return tokenCodes;
    }

    protected TokenCodes skipCRLFs(WsByteBuffer wsByteBuffer) {
        int n = 33;
        if (this.bytePosition >= this.byteLimit && !this.fillByteCache(wsByteBuffer)) {
            return TokenCodes.TOKEN_RC_MOREDATA;
        }
        byte by = this.byteCache[this.bytePosition++];
        for (int i = 0; i < n; ++i) {
            if (-1 == by) {
                return TokenCodes.TOKEN_RC_MOREDATA;
            }
            if (13 != by && 10 != by) {
                this.decrementBytePosition();
                return TokenCodes.TOKEN_RC_DELIM;
            }
            if (this.bytePosition >= this.byteLimit) {
                return TokenCodes.TOKEN_RC_MOREDATA;
            }
            by = this.byteCache[this.bytePosition++];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Too many leading CRLFs found");
        }
        return TokenCodes.TOKEN_RC_CRLF;
    }

    private boolean parseCRLFs(WsByteBuffer wsByteBuffer) throws MalformedMessageException {
        for (int i = 0; i < 4; ++i) {
            byte by;
            if (this.bytePosition >= this.byteLimit && !this.fillByteCache(wsByteBuffer)) {
                return false;
            }
            if (13 == (by = this.byteCache[this.bytePosition++])) continue;
            if (10 == by) {
                ++this.numCRLFs;
            } else {
                if (32 == by || 9 == by) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Multiline header follows");
                    }
                    this.bIsMultiLine = true;
                    if (null == this.lastElem) {
                        throw new MalformedMessageException("Incorrect multiline header value");
                    }
                    this.currentElem = this.lastElem;
                    this.stateOfParsing = 1;
                    this.numCRLFs = 0;
                    return true;
                }
                this.decrementBytePosition();
                break;
            }
            if (2 > this.numCRLFs) continue;
            this.resetUnused(wsByteBuffer);
            break;
        }
        this.bIsMultiLine = false;
        this.stateOfParsing = 0;
        this.numCRLFs = 0;
        return true;
    }

    protected TokenCodes parseCRLFTokenExtract(WsByteBuffer wsByteBuffer) throws MalformedMessageException {
        if (null == this.parsedToken && !this.skipWhiteSpace(wsByteBuffer)) {
            return TokenCodes.TOKEN_RC_MOREDATA;
        }
        int n = wsByteBuffer.position() - (this.byteLimit - this.bytePosition);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parseCRLFTokenExtract: start:" + n + " lim:" + this.byteLimit + " pos:" + this.bytePosition));
        }
        TokenCodes tokenCodes = this.findCRLFTokenLength(wsByteBuffer);
        this.saveParsedToken(wsByteBuffer, n, TokenCodes.TOKEN_RC_DELIM.equals(tokenCodes));
        return tokenCodes;
    }

    protected int parseCRLFTokenNonExtract(WsByteBuffer wsByteBuffer) throws MalformedMessageException {
        this.findCRLFTokenLength(wsByteBuffer);
        return this.parsedTokenLength;
    }

    protected TokenCodes findHeaderLength(WsByteBuffer wsByteBuffer) throws MalformedMessageException {
        TokenCodes tokenCodes = TokenCodes.TOKEN_RC_MOREDATA;
        if (null == wsByteBuffer) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"findHeaderLength: null buffer provided");
            }
            return tokenCodes;
        }
        int n = 0;
        int n2 = this.parsedTokenLength;
        while (this.bytePosition < this.byteLimit || this.fillByteCache(wsByteBuffer)) {
            byte by;
            if (58 == (by = this.byteCache[this.bytePosition++])) {
                n2 -= n;
                tokenCodes = TokenCodes.TOKEN_RC_DELIM;
                break;
            }
            n = 32 == by || 9 == by ? ++n : 0;
            if (13 == by || 10 == by) {
                throw new MalformedMessageException("Invalid CRLF found in header name");
            }
            if (++n2 <= this.limitTokenSize) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("findTokenLength: length is too big: " + n2));
            }
            throw new MalformedMessageException("Token length: " + n2);
        }
        this.parsedTokenLength = n2;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("findHeaderLength: " + tokenCodes.getName()));
        }
        return tokenCodes;
    }

    private boolean parseHeaderName(WsByteBuffer wsByteBuffer) throws MalformedMessageException {
        byte[] byArray;
        if (null == this.parsedToken && !this.skipWhiteSpace(wsByteBuffer)) {
            return false;
        }
        int n = wsByteBuffer.position() - (this.byteLimit - this.bytePosition);
        int n2 = this.bytePosition;
        TokenCodes tokenCodes = this.findHeaderLength(wsByteBuffer);
        if (TokenCodes.TOKEN_RC_MOREDATA.equals(tokenCodes)) {
            this.saveParsedToken(wsByteBuffer, n, false);
            return false;
        }
        int n3 = this.parsedTokenLength;
        if (null == this.parsedToken && n3 < this.bytePosition) {
            byArray = this.byteCache;
            n = n2;
        } else {
            this.saveParsedToken(wsByteBuffer, n, true);
            byArray = this.parsedToken;
            n = 0;
            n3 = byArray.length;
        }
        Object object = this.getMatcher().match(byArray, n, n3);
        if (null == object) {
            if (null == this.parsedToken) {
                this.saveParsedToken(wsByteBuffer, n, true);
            }
            this.currentElem = this.getNewElement(GenericUtils.getEnglishString(this.parsedToken));
        } else {
            this.currentElem = this.getNewElement((HeaderKeys)object);
        }
        this.stateOfParsing = 1;
        this.parsedToken = null;
        this.parsedTokenLength = 0;
        return true;
    }

    private boolean parseHeaderValueExtract(WsByteBuffer wsByteBuffer) throws MalformedMessageException {
        TokenCodes tokenCodes = this.parseCRLFTokenExtract(wsByteBuffer);
        if (!tokenCodes.equals(TokenCodes.TOKEN_RC_MOREDATA)) {
            this.setHeaderValue();
            this.parsedToken = null;
            this.lastElem = this.currentElem;
            this.currentElem = null;
            this.stateOfParsing = 2;
            return true;
        }
        return false;
    }

    private boolean parseHeaderValueNonExtract(WsByteBuffer wsByteBuffer) throws MalformedMessageException {
        if (0 == this.parsedTokenLength) {
            if (!this.skipWhiteSpace(wsByteBuffer)) {
                return false;
            }
            this.currentElem.setParseInformation(this.getBuffersIndex(), wsByteBuffer.position() - (this.byteLimit - this.bytePosition));
        }
        if (TokenCodes.TOKEN_RC_MOREDATA.equals(this.findCRLFTokenLength(wsByteBuffer))) {
            return false;
        }
        HeaderElement headerElement = this.currentElem;
        headerElement.setValueLength(this.parsedTokenLength);
        if (null != headerElement.getHeaderKey()) {
            this.addKnownHeader(headerElement.getHeaderKey(), headerElement, true, true);
        } else {
            this.addUnknownHeader(headerElement.getHeaderString(), headerElement, true);
        }
        this.parsedTokenLength = 0;
        this.lastElem = headerElement;
        this.currentElem = null;
        this.stateOfParsing = 2;
        return true;
    }

    protected TokenCodes parseTokenExtract(WsByteBuffer wsByteBuffer, byte by, boolean bl) throws MalformedMessageException {
        TokenCodes tokenCodes;
        if (null == this.parsedToken && !this.skipWhiteSpace(wsByteBuffer)) {
            return TokenCodes.TOKEN_RC_MOREDATA;
        }
        int n = wsByteBuffer.position() - (this.byteLimit - this.bytePosition);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parseTokenExtract: start:" + n + " lim:" + this.byteLimit + " pos:" + this.bytePosition));
        }
        this.saveParsedToken(wsByteBuffer, n, !TokenCodes.TOKEN_RC_MOREDATA.equals(tokenCodes = this.findTokenLength(wsByteBuffer, by, bl)));
        return tokenCodes;
    }

    protected int parseTokenNonExtract(WsByteBuffer wsByteBuffer, byte by, boolean bl) throws MalformedMessageException {
        TokenCodes tokenCodes = this.findTokenLength(wsByteBuffer, by, bl);
        return TokenCodes.TOKEN_RC_MOREDATA.equals(tokenCodes) ? -1 : this.parsedTokenLength;
    }

    protected void setHeaderValue() throws MalformedMessageException {
        if (null == this.parsedToken) {
            this.parsedToken = new byte[]{32};
        }
        HeaderElement headerElement = this.currentElem;
        if (this.bIsMultiLine) {
            byte[] byArray = headerElement.getByteArrayValue();
            int n = byArray.length + this.parsedToken.length + 1;
            if (n > this.limitTokenSize) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Multiline header value too large: " + n));
                }
                throw new MalformedMessageException("Multiline value length: " + n);
            }
            byte[] byArray2 = new byte[byArray.length + this.parsedToken.length + 1];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray2[byArray.length] = 32;
            System.arraycopy(this.parsedToken, 0, byArray2, byArray.length + 1, this.parsedToken.length);
            headerElement.setByteArrayValue(byArray2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Saved multiline header value [" + headerElement.getStringValue() + "]"));
            }
        } else {
            headerElement.setByteArrayValue(this.parsedToken);
            if (null != headerElement.getHeaderKey()) {
                this.addKnownHeader(headerElement.getHeaderKey(), headerElement, true, true);
            } else {
                this.addUnknownHeader(headerElement.getHeaderString(), headerElement, true);
            }
        }
    }

    private void saveParsedToken(WsByteBuffer wsByteBuffer, int n, boolean bl) {
        byte[] byArray;
        int n2;
        int n3 = this.parsedTokenLength;
        this.parsedTokenLength = 0;
        if (0 > n3) {
            throw new IllegalArgumentException("Negative token length: " + n3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Saving token: " + GenericUtils.getEnglishString(this.parsedToken) + " len:" + n3 + " start:" + n + " pos:" + this.bytePosition + " delim:" + bl));
        }
        if (null != this.parsedToken) {
            n2 = this.parsedToken.length;
            byArray = new byte[n2 + n3];
            System.arraycopy(this.parsedToken, 0, byArray, 0, n2);
        } else {
            n2 = 0;
            byArray = new byte[n3];
        }
        if (this.bytePosition > n3) {
            int n4 = this.bytePosition - n3;
            if (bl) {
                --n4;
            }
            System.arraycopy(this.byteCache, n4, byArray, n2, n3);
        } else {
            int n5 = wsByteBuffer.position();
            wsByteBuffer.position(n);
            wsByteBuffer.get(byArray, n2, n3);
            wsByteBuffer.position(n5);
        }
        this.parsedToken = byArray;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Saved token [" + GenericUtils.getEnglishString(this.parsedToken) + "]"));
        }
    }
}

