/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.engines.jacl;

import com.ibm.bsf.BSFDeclaredBean;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.engines.jacl.BSFCommand;
import com.ibm.bsf.util.BSFEngineImpl;
import java.util.Vector;
import tcl.lang.Command;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class JaclEngine
extends BSFEngineImpl {
    private Interp interp;

    public Object call(Object object, String string, Object[] objectArray) throws BSFException {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(" ");
                stringBuffer.append(objectArray[i].toString());
            }
        }
        return this.eval("<function call>", 0, 0, stringBuffer.toString());
    }

    public void declareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        String string = "set " + bSFDeclaredBean.name + " [bsf lookupBean \"" + bSFDeclaredBean.name + "\"]";
        this.eval("<declare bean>", 0, 0, string);
    }

    public Object eval(String string, int n, int n2, Object object) throws BSFException {
        String string2 = object.toString();
        try {
            this.interp.eval(string2);
            TclObject tclObject = this.interp.getResult();
            InternalRep internalRep = tclObject.getInternalRep();
            if (internalRep instanceof ReflectObject) {
                return ReflectObject.get((Interp)this.interp, (TclObject)tclObject);
            }
            if (internalRep instanceof TclString) {
                return tclObject.toString();
            }
            if (internalRep instanceof TclDouble) {
                return new Double(TclDouble.get((Interp)this.interp, (TclObject)tclObject));
            }
            if (internalRep instanceof TclInteger) {
                return new Integer(TclInteger.get((Interp)this.interp, (TclObject)tclObject));
            }
            return tclObject;
        }
        catch (TclException tclException) {
            TclObject tclObject = null;
            try {
                tclObject = this.interp.getVar("errorInfo", null, 1);
            }
            catch (TclException tclException2) {
                tclObject = null;
            }
            String string3 = tclObject == null ? "No error reported." : tclObject.toString();
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "error while eval'ing Jacl expression:\n" + string3, tclException);
        }
    }

    public void initialize(BSFManager bSFManager, String string, Vector vector) throws BSFException {
        super.initialize(bSFManager, string, vector);
        this.interp = new Interp();
        this.interp.createCommand("bsf", (Command)new BSFCommand(bSFManager, this));
        try {
            this.interp.eval("jaclloadjava");
        }
        catch (TclException tclException) {
            TclObject tclObject = null;
            try {
                tclObject = this.interp.getVar("errorInfo", null, 1);
            }
            catch (TclException tclException2) {
                tclObject = null;
            }
            String string2 = tclObject == null ? "No error reported." : tclObject.toString();
            throw new BSFException(BSFException.REASON_OTHER_ERROR, "error while loading java package:\n" + string2, tclException);
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.declareBean((BSFDeclaredBean)vector.elementAt(i));
        }
    }

    public void undeclareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        this.eval("<undeclare bean>", 0, 0, "set " + bSFDeclaredBean.name + " \"\"");
    }
}

