/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.SecureRandom;
import com.ibm.crypto.pkcs11impl.provider.Signature;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

public final class PKCS11SSLHashingwithRSA
extends SignatureSpi {
    private Signature sig = new Signature(1);
    private byte[] hashData = new byte[128];
    private int count = 0;

    protected void engineSetParameter(String string, Object object) {
    }

    protected Object engineGetParameter(String string) {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitSign(privateKey);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitVerify(publicKey);
    }

    protected void engineInitVerify(PublicKey publicKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.count = 0;
        this.sig.engineInitVerify(publicKey);
    }

    protected void engineUpdate(byte by) {
        if (this.count + 1 > this.hashData.length) {
            byte[] byArray = new byte[this.hashData.length + 128];
            System.arraycopy(this.hashData, 0, byArray, 0, this.hashData.length);
            this.hashData = byArray;
        }
        this.hashData[this.count] = by;
        ++this.count;
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (this.count + (n2 - n) > this.hashData.length) {
            byte[] byArray2 = new byte[this.hashData.length + 128 + (n2 - n)];
            System.arraycopy(this.hashData, 0, byArray2, 0, this.hashData.length);
            this.hashData = byArray2;
        }
        System.arraycopy(byArray, n, this.hashData, this.count, n2 - n);
        this.count += n2 - n;
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = this.sig.engineSign(this.hashData, this.count);
        this.count = 0;
        return byArray;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        boolean bl = this.sig.engineVerify(byArray, this.hashData, this.count);
        this.count = 0;
        return bl;
    }
}

