/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DESKey;
import com.ibm.crypto.pkcs11impl.provider.DESedeKey;
import com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11Key;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

public final class PKCS11KeyStore
extends KeyStoreSpi {
    private static Debug debug1 = Debug.getInstance((String)"pkcs11impl");
    private static Debug debug2 = Debug.getInstance((String)"pkcs11keystore");
    private static Debug debug = debug1 == null ? debug2 : debug1;
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11KeyStore";
    private static Date returnDate = new Date(0L);
    private PKCS11Session session = null;
    private Hashtable entries = new Hashtable();

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Object v = this.entries.get(string.toLowerCase());
        if (v != null) {
            if (v instanceof PrivateKeyEntry) {
                return ((PrivateKeyEntry)v).key;
            }
            if (v instanceof SecretKeyEntry) {
                return ((SecretKeyEntry)v).key;
            }
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Certificate[] certificateArray = null;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && v instanceof PrivateKeyEntry && ((PrivateKeyEntry)v).chain != null) {
            certificateArray = (Certificate[])((PrivateKeyEntry)v).chain.clone();
        }
        return certificateArray;
    }

    public Certificate engineGetCertificate(String string) {
        Certificate certificate = null;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null) {
            if (v instanceof TrustedCertEntry) {
                certificate = ((TrustedCertEntry)v).cert;
            } else if (v instanceof PrivateKeyEntry && ((PrivateKeyEntry)v).chain != null) {
                certificate = ((PrivateKeyEntry)v).chain[0];
            }
        }
        return certificate;
    }

    public Date engineGetCreationDate(String string) {
        return returnDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object object = null;
            if (this.engineIsCertificateEntry(string)) {
                throw new KeyStoreException("Alias exists for a certificate entry");
            }
            if (key instanceof PKCS11PrivateKey) {
                PrivateKeyEntry privateKeyEntry = new PrivateKeyEntry();
                privateKeyEntry.key = key;
                privateKeyEntry.keyObject = ((PKCS11PrivateKey)key).getObject();
                privateKeyEntry.chain = certificateArray != null ? (Certificate[])certificateArray.clone() : null;
                object = privateKeyEntry;
            } else if (key instanceof PKCS11SecretKey) {
                SecretKeyEntry secretKeyEntry = new SecretKeyEntry();
                secretKeyEntry.key = key;
                secretKeyEntry.keyObject = ((PKCS11SecretKey)key).getObject();
                object = secretKeyEntry;
            } else if (key instanceof PrivateKey) {
                PKCS11PrivateKey pKCS11PrivateKey;
                block20: {
                    String string2 = key.getAlgorithm();
                    pKCS11PrivateKey = null;
                    KeyFactory keyFactory = null;
                    try {
                        if (string2.equalsIgnoreCase("DSA")) {
                            keyFactory = KeyFactory.getInstance("DSA", "IBMPKCS11Impl");
                            pKCS11PrivateKey = (PKCS11PrivateKey)keyFactory.translateKey(key);
                            break block20;
                        }
                        if (string2.equalsIgnoreCase("RSA")) {
                            keyFactory = KeyFactory.getInstance("RSA", "IBMPKCS11Impl");
                            pKCS11PrivateKey = (PKCS11PrivateKey)keyFactory.translateKey(key);
                            break block20;
                        }
                        throw new KeyStoreException("Keystore can not handle this key algorithm: " + string2);
                    }
                    catch (Exception exception) {
                        throw new KeyStoreException("Keystore can not handle this key: " + exception.getMessage());
                    }
                }
                PrivateKeyEntry privateKeyEntry = new PrivateKeyEntry();
                privateKeyEntry.key = pKCS11PrivateKey;
                privateKeyEntry.keyObject = pKCS11PrivateKey.getObject();
                privateKeyEntry.chain = certificateArray != null ? (Certificate[])certificateArray.clone() : null;
                object = privateKeyEntry;
            } else if (key instanceof SecretKey) {
                PKCS11SecretKey pKCS11SecretKey;
                block21: {
                    String string3 = key.getAlgorithm();
                    pKCS11SecretKey = null;
                    SecretKeyFactory secretKeyFactory = null;
                    try {
                        if (string3.equalsIgnoreCase("DES")) {
                            secretKeyFactory = SecretKeyFactory.getInstance("DES", "IBMPKCS11Impl");
                            pKCS11SecretKey = (PKCS11SecretKey)secretKeyFactory.translateKey((SecretKey)key);
                            break block21;
                        }
                        if (string3.equalsIgnoreCase("3DES") || string3.equalsIgnoreCase("DESede") || string3.equalsIgnoreCase("TripleDES")) {
                            secretKeyFactory = SecretKeyFactory.getInstance("DESede", "IBMPKCS11Impl");
                            pKCS11SecretKey = (PKCS11SecretKey)secretKeyFactory.translateKey((SecretKey)key);
                            break block21;
                        }
                        throw new KeyStoreException("Keystore can not handle this key algorithm: " + string3);
                    }
                    catch (Exception exception) {
                        throw new KeyStoreException("Keystore can not handle this key: " + exception.getMessage());
                    }
                }
                SecretKeyEntry secretKeyEntry = new SecretKeyEntry();
                secretKeyEntry.key = pKCS11SecretKey;
                secretKeyEntry.keyObject = pKCS11SecretKey.getObject();
                object = secretKeyEntry;
            } else {
                throw new KeyStoreException("Invalid key type");
            }
            this.entries.put(string.toLowerCase(), object);
        }
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("This method is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object object;
            Object v = this.entries.get(string.toLowerCase());
            if (v != null && (v instanceof PrivateKeyEntry || v instanceof SecretKeyEntry)) {
                throw new KeyStoreException("Cannot overwrite key entry");
            }
            PKCS11Object pKCS11Object = null;
            if (certificate instanceof X509Certificate) {
                Object object2;
                object = null;
                byte[] byArray = null;
                try {
                    byArray = string.getBytes("8859_1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byArray = string.getBytes();
                }
                byte[] byArray2 = null;
                BigInteger bigInteger = null;
                DerOutputStream derOutputStream = null;
                if (byArray.length > 20) {
                    object2 = new byte[20];
                    System.arraycopy(byArray, 0, object2, 0, 20);
                    byArray = object2;
                }
                try {
                    object2 = CertificateFactory.getInstance("X509", "IBMPKCS11Impl");
                    if (certificate instanceof X509CertImpl) {
                        X509CertImpl x509CertImpl = (X509CertImpl)certificate;
                        derOutputStream = new DerOutputStream();
                        ((X500Name)x509CertImpl.getSubjectDN()).encode(derOutputStream);
                        object = derOutputStream.toByteArray();
                        derOutputStream = new DerOutputStream();
                        ((X500Name)x509CertImpl.getIssuerDN()).encode(derOutputStream);
                        byArray2 = derOutputStream.toByteArray();
                        bigInteger = x509CertImpl.getSerialNumber();
                        pKCS11Object = this.createCertObject(string, x509CertImpl.getEncoded(), (byte[])object, byArray, byArray2, bigInteger);
                    }
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certificate.getEncoded());
                    X509CertImpl x509CertImpl = (X509CertImpl)((CertificateFactory)object2).generateCertificate(byteArrayInputStream);
                    derOutputStream = new DerOutputStream();
                    ((X500Name)x509CertImpl.getSubjectDN()).encode(derOutputStream);
                    object = derOutputStream.toByteArray();
                    derOutputStream = new DerOutputStream();
                    ((X500Name)x509CertImpl.getIssuerDN()).encode(derOutputStream);
                    bigInteger = x509CertImpl.getSerialNumber();
                    pKCS11Object = this.createCertObject(string, x509CertImpl.getEncoded(), (byte[])object, byArray, byArray2, bigInteger);
                }
                catch (Exception exception) {
                    throw new KeyStoreException("Cannot store certificate :" + exception.getMessage());
                }
            } else {
                throw new KeyStoreException("Unsupported certificate type. Only X509 certificate is supported");
            }
            object = new TrustedCertEntry();
            object.cert = certificate;
            object.certObject = pKCS11Object;
            this.entries.put(string.toLowerCase(), object);
        }
    }

    private PKCS11Object createCertObject(String string, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, BigInteger bigInteger) throws KeyStoreException {
        int[] nArray = new int[]{0, 1, 2, 3, 128, 258, 257, 130, 17, 129};
        Object[] objectArray = new Object[]{PKCS11Object.CERTIFICATE, Boolean.FALSE, Boolean.FALSE, string, PKCS11Object.X_509, byArray3, byArray2, bigInteger.toByteArray(), byArray, byArray4};
        PKCS11Object pKCS11Object = null;
        try {
            pKCS11Object = this.session.createObject(nArray, objectArray);
        }
        catch (Exception exception) {
            throw new KeyStoreException("Cannot store certificate: " + exception.getMessage());
        }
        return pKCS11Object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineDeleteEntry(String string) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            if (this.engineIsKeyEntry(string)) {
                Object v = this.entries.get(string.toLowerCase());
                if (v instanceof PrivateKeyEntry) {
                    PrivateKeyEntry privateKeyEntry = (PrivateKeyEntry)v;
                    ((PKCS11Key)privateKeyEntry.key).getObject().destroy();
                } else {
                    SecretKeyEntry secretKeyEntry = (SecretKeyEntry)v;
                    ((PKCS11Key)secretKeyEntry.key).getObject().destroy();
                }
            } else if (this.engineIsCertificateEntry(string)) {
                TrustedCertEntry trustedCertEntry = (TrustedCertEntry)this.entries.get(string.toLowerCase());
                trustedCertEntry.certObject.destroy();
            }
            this.entries.remove(string.toLowerCase());
        }
    }

    public Enumeration engineAliases() {
        return this.entries.keys();
    }

    public boolean engineContainsAlias(String string) {
        return this.entries.containsKey(string.toLowerCase());
    }

    public int engineSize() {
        return this.entries.size();
    }

    public boolean engineIsKeyEntry(String string) {
        boolean bl = false;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && (v instanceof PrivateKeyEntry || v instanceof SecretKeyEntry)) {
            bl = true;
        }
        return bl;
    }

    public boolean engineIsCertificateEntry(String string) {
        boolean bl = false;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && v instanceof TrustedCertEntry) {
            bl = true;
        }
        return bl;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration enumeration = this.entries.keys();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2;
            String string = (String)enumeration.nextElement();
            Object v = this.entries.get(string);
            if (v instanceof TrustedCertEntry) {
                certificate2 = ((TrustedCertEntry)v).cert;
            } else {
                if (!(v instanceof PrivateKeyEntry) || ((PrivateKeyEntry)v).chain == null) continue;
                certificate2 = ((PrivateKeyEntry)v).chain[0];
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new IOException("This method is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineLoad");
        }
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            String string;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            int n;
            Object object6;
            int n2;
            int n3;
            Vector<PKCS11Object> vector;
            CertificateFactory certificateFactory;
            block133: {
                String string2;
                Object object7;
                PKCS11Object pKCS11Object;
                block123: {
                    this.entries.clear();
                    pKCS11Object = null;
                    object7 = null;
                    certificateFactory = null;
                    try {
                        certificateFactory = CertificateFactory.getInstance("X509", "IBMPKCS11Impl");
                    }
                    catch (Exception exception) {
                        if (debug == null) break block123;
                        exception.printStackTrace();
                        if (debug != null) {
                            debug.exit(16384L, (Object)className, "engineLoad");
                        }
                        System.exit(1);
                    }
                }
                Vector<PKCS11Object> vector2 = new Vector<PKCS11Object>();
                Vector<PKCS11Object> vector3 = new Vector<PKCS11Object>();
                vector = new Vector<PKCS11Object>();
                this.session = IBMPKCS11Impl.session;
                this.session.findObjectsInit(null, null);
                while ((pKCS11Object = this.session.findObject()) != null) {
                    object7 = this.getValue(pKCS11Object, 0);
                    if (object7 != null && ((Integer)object7).equals(PKCS11Object.PRIVATE_KEY)) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "found PRIVATE KEY");
                        }
                        vector2.add(pKCS11Object);
                        continue;
                    }
                    if (object7 != null && ((Integer)object7).equals(PKCS11Object.CERTIFICATE)) {
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "found CERTIFICATE");
                        }
                        vector.add(pKCS11Object);
                        continue;
                    }
                    if (object7 == null || !((Integer)object7).equals(PKCS11Object.SECRET_KEY)) continue;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "found CERTIFICATE");
                    }
                    vector3.add(pKCS11Object);
                }
                if (debug != null) {
                    debug.text(16384L, (Object)className, "engineLoad", "# privkeys=" + vector2.size() + " # certs=" + vector.size() + " # secret keys=" + vector3.size());
                }
                String string3 = "privateKey";
                n3 = 0;
                n2 = 0;
                if (vector2.size() > 0) {
                    object6 = vector2.elements();
                    n = 0;
                    if (debug != null) {
                        debug.text(16384L, (Object)className, "engineLoad", "now find key and certs");
                    }
                    while (object6.hasMoreElements()) {
                        Object object8;
                        Object object9;
                        X509Certificate[] x509CertificateArray;
                        PrivateKeyInfo privateKeyInfo;
                        block126: {
                            Object object10;
                            Object object11;
                            Object object12;
                            Object object13;
                            Object object14;
                            block124: {
                                object5 = (PKCS11Object)object6.nextElement();
                                string2 = (String)this.getValue((PKCS11Object)object5, 3);
                                object4 = (byte[])this.getValue((PKCS11Object)object5, 258);
                                object3 = (byte[])this.getValue((PKCS11Object)object5, 257);
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "within the private key loop");
                                }
                                object2 = "e";
                                if (object4 == null) continue;
                                object = (Integer)this.getValue((PKCS11Object)object5, 256);
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "Key Type=" + ((Integer)object).toString());
                                }
                                privateKeyInfo = null;
                                if (((Integer)object).equals(PKCS11Object.RSA)) {
                                    try {
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad", "Constructure RSA(...) clear");
                                        }
                                        privateKeyInfo = new RSAPrivateKey((PKCS11Object)object5, (byte[])this.getValue((PKCS11Object)object5, 258), (byte[])this.getValue((PKCS11Object)object5, 257), (String)this.getValue((PKCS11Object)object5, 3), (Boolean)this.getValue((PKCS11Object)object5, 1), (Boolean)this.getValue((PKCS11Object)object5, 259), (Boolean)this.getValue((PKCS11Object)object5, 264), (Boolean)this.getValue((PKCS11Object)object5, 261), (Boolean)this.getValue((PKCS11Object)object5, 263), (Boolean)this.getValue((PKCS11Object)object5, 354), (BigInteger)this.getValue((PKCS11Object)object5, 288), (BigInteger)this.getValue((PKCS11Object)object5, 290), (BigInteger)this.getValue((PKCS11Object)object5, 291), (BigInteger)this.getValue((PKCS11Object)object5, 292), (BigInteger)this.getValue((PKCS11Object)object5, 293), (BigInteger)this.getValue((PKCS11Object)object5, 294), (BigInteger)this.getValue((PKCS11Object)object5, 295), (BigInteger)this.getValue((PKCS11Object)object5, 296));
                                    }
                                    catch (Exception exception) {
                                        try {
                                            if (debug != null) {
                                                debug.text(16384L, (Object)className, "engineLoad", "Constructure RSA() hardware");
                                            }
                                            privateKeyInfo = new RSAPrivateKey((PKCS11Object)object5, (byte[])this.getValue((PKCS11Object)object5, 258), (byte[])this.getValue((PKCS11Object)object5, 257), (String)this.getValue((PKCS11Object)object5, 3), (Boolean)this.getValue((PKCS11Object)object5, 1), (Boolean)this.getValue((PKCS11Object)object5, 259), (Boolean)this.getValue((PKCS11Object)object5, 264), (Boolean)this.getValue((PKCS11Object)object5, 261), (Boolean)this.getValue((PKCS11Object)object5, 263), (Boolean)this.getValue((PKCS11Object)object5, 354), (BigInteger)this.getValue((PKCS11Object)object5, 288), (BigInteger)this.getValue((PKCS11Object)object5, 290));
                                            break block124;
                                        }
                                        catch (InvalidKeyException invalidKeyException) {
                                            if (debug != null) {
                                                debug.exception(16384L, (Object)className, "engineLoad_2", (Throwable)invalidKeyException);
                                            }
                                            break block124;
                                        }
                                    }
                                }
                                if (!((Integer)object).equals(PKCS11Object.DSA)) continue;
                                try {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "Constructure DSA(...) clear");
                                    }
                                    privateKeyInfo = new DSAPrivateKey((PKCS11Object)object5, (String)this.getValue((PKCS11Object)object5, 3), (byte[])this.getValue((PKCS11Object)object5, 258), (byte[])this.getValue((PKCS11Object)object5, 257), (Boolean)this.getValue((PKCS11Object)object5, 1), (Boolean)this.getValue((PKCS11Object)object5, 259), (Boolean)this.getValue((PKCS11Object)object5, 354), (BigInteger)this.getValue((PKCS11Object)object5, 304), (BigInteger)this.getValue((PKCS11Object)object5, 305), (BigInteger)this.getValue((PKCS11Object)object5, 306), new BigInteger(1, (byte[])this.getValue((PKCS11Object)object5, 17)));
                                }
                                catch (Exception exception) {
                                    try {
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad", "Constructure DSA() hardware");
                                        }
                                        privateKeyInfo = new DSAPrivateKey((PKCS11Object)object5, (String)this.getValue((PKCS11Object)object5, 3), (byte[])this.getValue((PKCS11Object)object5, 258), (byte[])this.getValue((PKCS11Object)object5, 257), (Boolean)this.getValue((PKCS11Object)object5, 1), (Boolean)this.getValue((PKCS11Object)object5, 259), (Boolean)this.getValue((PKCS11Object)object5, 354));
                                    }
                                    catch (InvalidKeyException invalidKeyException) {
                                        if (debug == null) break block124;
                                        debug.exception(16384L, (Object)className, "engineLoad_3", (Throwable)invalidKeyException);
                                    }
                                }
                            }
                            int n4 = vector.size();
                            Enumeration enumeration = vector.elements();
                            string = null;
                            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
                            HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
                            X509Certificate x509Certificate = null;
                            X509Certificate x509Certificate2 = null;
                            x509CertificateArray = null;
                            byte[] byArray = "testmessage_a very long test message".getBytes();
                            int n5 = 0;
                            while (n5 < n4) {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "going through cert objects");
                                }
                                string = (PKCS11Object)enumeration.nextElement();
                                object9 = (byte[])this.getValue((PKCS11Object)string, 258);
                                object14 = (byte[])this.getValue((PKCS11Object)string, 257);
                                object8 = (byte[])this.getValue((PKCS11Object)string, 17);
                                object13 = new ByteArrayInputStream((byte[])object8);
                                x509Certificate2 = (X509Certificate)certificateFactory.generateCertificate((InputStream)object13);
                                if (object9 != null && this.bytesEquals((byte[])object4, (byte[])object9)) {
                                    block125: {
                                        object12 = x509Certificate2.getPublicKey();
                                        try {
                                            object11 = Signature.getInstance(privateKeyInfo.getAlgorithm(), "IBMPKCS11Impl");
                                            ((Signature)object11).initSign((PrivateKey)privateKeyInfo);
                                            ((Signature)object11).update(byArray);
                                            object10 = ((Signature)object11).sign();
                                            ((Signature)object11).initVerify((PublicKey)object12);
                                            ((Signature)object11).update(byArray);
                                            if (((Signature)object11).verify((byte[])object10)) {
                                                x509Certificate = x509Certificate2;
                                            }
                                        }
                                        catch (Exception exception) {
                                            if (debug == null) break block125;
                                            debug.text(16384L, (Object)className, "engineLoad", "Error checking signature: " + exception.getMessage());
                                        }
                                    }
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "found cert at pos" + n5 + " # of certs now = " + arrayList.size());
                                        debug.text(16384L, (Object)className, "engineLoad", "found cert = " + x509Certificate);
                                    }
                                }
                                arrayList.add(x509Certificate2);
                                hashSet.add(new TrustAnchor(x509Certificate2, null));
                                ++n5;
                            }
                            if (x509Certificate != null) {
                                try {
                                    object9 = CertPathBuilder.getInstance("PKIX", "IBMCertPath");
                                    object14 = new X509CertSelector();
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "building certpath");
                                    }
                                    object8 = x509Certificate.getSubjectDN().toString();
                                    ((X509CertSelector)object14).setSubject((String)object8);
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "Subject = " + (String)object8);
                                    }
                                    object13 = new PKIXBuilderParameters(hashSet, (CertSelector)object14);
                                    ((PKIXParameters)object13).setRevocationEnabled(false);
                                    ((PKIXBuilderParameters)object13).setMaxPathLength(-1);
                                    object12 = new CollectionCertStoreParameters(arrayList);
                                    object11 = CertStore.getInstance("Collection", (CertStoreParameters)object12, "IBMCertPath");
                                    ((PKIXParameters)object13).addCertStore((CertStore)object11);
                                    try {
                                        object10 = (PKIXCertPathBuilderResult)((CertPathBuilder)object9).build((CertPathParameters)object13);
                                        CertPath certPath = ((PKIXCertPathBuilderResult)object10).getCertPath();
                                        if (certPath != null) {
                                            List<? extends Certificate> list = certPath.getCertificates();
                                            int n6 = 0;
                                            x509CertificateArray = new X509Certificate[list.size() + 1];
                                            Iterator<? extends Certificate> iterator = list.iterator();
                                            while (iterator.hasNext()) {
                                                x509CertificateArray[n6++] = (X509Certificate)iterator.next();
                                            }
                                            x509CertificateArray[n6] = ((PKIXCertPathValidatorResult)object10).getTrustAnchor().getTrustedCert();
                                        }
                                    }
                                    catch (CertPathBuilderException certPathBuilderException) {
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad_0", "could not build CertPath for certificate " + certPathBuilderException.getMessage());
                                        }
                                        x509CertificateArray = null;
                                    }
                                }
                                catch (Exception exception) {
                                    if (debug == null) break block126;
                                    debug.exception(16384L, (Object)className, "engineLoad_1", (Throwable)exception);
                                }
                            }
                        }
                        object9 = new PrivateKeyEntry();
                        ((PrivateKeyEntry)object9).key = privateKeyInfo;
                        ((PrivateKeyEntry)object9).keyObject = object5;
                        ((PrivateKeyEntry)object9).chain = x509CertificateArray;
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "Entry: \n key =" + privateKeyInfo.toString() + "\nkeyObject =" + object5 + "\nchain = " + x509CertificateArray + "\nLabel = " + string2);
                        }
                        if (string2 != null && string2.length() != 0) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label != null");
                            }
                            if (!this.entries.containsKey(string2.toLowerCase())) {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "label empty");
                                }
                                this.entries.put(string2.toLowerCase(), object9);
                                if (debug == null) continue;
                                System.out.println("PKCS11IMPLKS: put key entry[" + string2.toLowerCase() + "] to entries");
                                continue;
                            }
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                            }
                            boolean bl = false;
                            while (!bl) {
                                object8 = string2 + "key" + n2;
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "finding label: " + (String)object8);
                                }
                                if (this.entries.get(((String)object8).toLowerCase()) == null) {
                                    this.entries.put(((String)object8).toLowerCase(), object9);
                                    if (debug != null) {
                                        System.out.println("PKCS11IMPLKS: put key entry[" + ((String)object8).toLowerCase() + "] to entries");
                                    }
                                    bl = true;
                                    continue;
                                }
                                ++n2;
                            }
                            continue;
                        }
                        boolean bl = false;
                        while (!bl) {
                            object8 = string3 + n3;
                            if (!this.entries.containsKey(((String)object8).toLowerCase())) {
                                this.entries.put(((String)object8).toLowerCase(), object9);
                                if (debug != null) {
                                    System.out.println("PKCS11IMPLKS: put key entry[" + ((String)object8).toLowerCase() + "] to entries");
                                }
                                bl = true;
                                continue;
                            }
                            ++n3;
                        }
                    }
                    vector2.removeAllElements();
                }
                string3 = "secretKey";
                n3 = 0;
                n2 = 0;
                if (vector3.size() <= 0) break block133;
                int n7 = vector3.size();
                Enumeration enumeration = vector3.elements();
                int n8 = 0;
                while (n8 < n7) {
                    block128: {
                        block129: {
                            block127: {
                                string2 = null;
                                object4 = null;
                                try {
                                    string2 = (PKCS11Object)enumeration.nextElement();
                                    object4 = (String)this.getValue((PKCS11Object)string2, 3);
                                    if (debug == null) break block127;
                                    debug.text(16384L, (Object)className, "engineLoad", "sobj: " + string2);
                                }
                                catch (NoSuchElementException noSuchElementException) {
                                    n8 = n7;
                                    break block128;
                                }
                            }
                            object3 = (Integer)this.getValue((PKCS11Object)string2, 256);
                            object2 = null;
                            if (((Integer)object3).equals(PKCS11Object.DES)) {
                                try {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "Constructure DES(...) clear");
                                    }
                                    object2 = new DESKey((PKCS11Object)string2, (byte[])this.getValue((PKCS11Object)string2, 258), (String)this.getValue((PKCS11Object)string2, 3), (Boolean)this.getValue((PKCS11Object)string2, 1), (Boolean)this.getValue((PKCS11Object)string2, 259), (Boolean)this.getValue((PKCS11Object)string2, 260), (Boolean)this.getValue((PKCS11Object)string2, 262), (Boolean)this.getValue((PKCS11Object)string2, 354), (byte[])this.getValue((PKCS11Object)string2, 17));
                                }
                                catch (Exception exception) {
                                    try {
                                        if (debug != null) {
                                            debug.text(16384L, (Object)className, "engineLoad", "Constructure DES() hardware");
                                        }
                                        object2 = new DESKey((PKCS11Object)string2, (byte[])this.getValue((PKCS11Object)string2, 258), (String)this.getValue((PKCS11Object)string2, 3), (Boolean)this.getValue((PKCS11Object)string2, 1), (Boolean)this.getValue((PKCS11Object)string2, 259), (Boolean)this.getValue((PKCS11Object)string2, 260), (Boolean)this.getValue((PKCS11Object)string2, 262), (Boolean)this.getValue((PKCS11Object)string2, 354));
                                        break block129;
                                    }
                                    catch (InvalidKeyException invalidKeyException) {
                                        if (debug != null) {
                                            debug.exception(16384L, (Object)className, "engineLoad_4", (Throwable)invalidKeyException);
                                        }
                                        break block129;
                                    }
                                }
                            }
                            if (!((Integer)object3).equals(PKCS11Object.DES3)) break block128;
                            try {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "Constructure DESede(...) clear");
                                }
                                object2 = new DESedeKey((PKCS11Object)string2, (byte[])this.getValue((PKCS11Object)string2, 258), (String)this.getValue((PKCS11Object)string2, 3), (Boolean)this.getValue((PKCS11Object)string2, 1), (Boolean)this.getValue((PKCS11Object)string2, 259), (Boolean)this.getValue((PKCS11Object)string2, 260), (Boolean)this.getValue((PKCS11Object)string2, 262), (Boolean)this.getValue((PKCS11Object)string2, 354), (byte[])this.getValue((PKCS11Object)string2, 17));
                            }
                            catch (Exception exception) {
                                try {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "Constructure DESede() hardware");
                                    }
                                    object2 = new DESedeKey((PKCS11Object)string2, (byte[])this.getValue((PKCS11Object)string2, 258), (String)this.getValue((PKCS11Object)string2, 3), (Boolean)this.getValue((PKCS11Object)string2, 1), (Boolean)this.getValue((PKCS11Object)string2, 259), (Boolean)this.getValue((PKCS11Object)string2, 260), (Boolean)this.getValue((PKCS11Object)string2, 262), (Boolean)this.getValue((PKCS11Object)string2, 354));
                                }
                                catch (InvalidKeyException invalidKeyException) {
                                    if (debug == null) break block129;
                                    exception.printStackTrace();
                                    debug.exception(16384L, (Object)className, "engineLoad_5", (Throwable)invalidKeyException);
                                }
                            }
                        }
                        object = new SecretKeyEntry();
                        ((SecretKeyEntry)object).key = object2;
                        ((SecretKeyEntry)object).keyObject = string2;
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "Secret Entry: \n key =" + object2.toString() + "\nkeyObject =" + string2 + "\nLabel = " + (String)object4);
                        }
                        if (object4 != null && ((String)object4).length() != 0) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label != null");
                            }
                            if (this.entries.get(((String)object4).toLowerCase()) == null) {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "label empty");
                                }
                                this.entries.put(((String)object4).toLowerCase(), object);
                                if (debug != null) {
                                    System.out.println("PKCS11IMPLKS: put secret key entry[" + ((String)object4).toLowerCase() + "] to entries");
                                }
                            } else {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                                }
                                boolean bl = false;
                                while (!bl) {
                                    String string4;
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "finding label");
                                    }
                                    if (this.entries.get((string4 = (String)object4 + "sec" + n2).toLowerCase()) == null) {
                                        this.entries.put(string4.toLowerCase(), object);
                                        if (debug != null) {
                                            System.out.println("PKCS11IMPLKS: put secret key entry[" + string4.toLowerCase() + "] to entries");
                                        }
                                        bl = true;
                                        continue;
                                    }
                                    ++n2;
                                }
                            }
                        } else {
                            boolean bl = false;
                            while (!bl) {
                                String string5 = string3 + n3;
                                if (!this.entries.containsKey(string5.toLowerCase())) {
                                    this.entries.put(string5.toLowerCase(), object);
                                    if (debug != null) {
                                        System.out.println("PKCS11IMPLKS: put secret key entry[" + string5.toLowerCase() + "] to entries");
                                    }
                                    bl = true;
                                    continue;
                                }
                                ++n3;
                            }
                        }
                    }
                    ++n8;
                }
                vector3.removeAllElements();
            }
            object6 = "cert";
            n3 = 0;
            if (vector.size() > 0) {
                n = vector.size();
                object5 = vector.elements();
                int n9 = 0;
                while (n9 < n) {
                    block131: {
                        block132: {
                            block130: {
                                object4 = null;
                                try {
                                    object4 = (PKCS11Object)object5.nextElement();
                                    if (debug == null) break block130;
                                    debug.text(16384L, (Object)className, "engineLoad", "cobj: " + object4);
                                }
                                catch (NoSuchElementException noSuchElementException) {
                                    n9 = n;
                                    break block131;
                                }
                            }
                            object3 = (String)this.getValue((PKCS11Object)object4, 3);
                            object2 = (byte[])this.getValue((PKCS11Object)object4, 258);
                            object = null;
                            try {
                                object = (byte[])this.getValue((PKCS11Object)object4, 17);
                            }
                            catch (Exception exception) {
                                if (debug == null) break block132;
                                debug.text(16384L, (Object)className, "engineLoad", "tries to get cert value2");
                                exception.printStackTrace();
                            }
                        }
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                        TrustedCertEntry trustedCertEntry = new TrustedCertEntry();
                        trustedCertEntry.cert = certificateFactory.generateCertificate(byteArrayInputStream);
                        trustedCertEntry.certObject = (PKCS11Object)object4;
                        if (debug != null) {
                            debug.text(16384L, (Object)className, "engineLoad", "Trusted Cert Entry: \n cert =" + trustedCertEntry.cert.toString() + "\n CertObject =" + object4 + "\nLabel = " + (String)object3);
                        }
                        if (object3 != null && ((String)object3).length() != 0) {
                            if (debug != null) {
                                debug.text(16384L, (Object)className, "engineLoad", "label != null");
                            }
                            if (this.entries.get(((String)object3).toLowerCase()) == null) {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "label empty");
                                }
                                this.entries.put(((String)object3).toLowerCase(), trustedCertEntry);
                                if (debug != null) {
                                    System.out.println("PKCS11IMPLKS: put cert entry[" + ((String)object3).toLowerCase() + "] to entries");
                                }
                            } else {
                                if (debug != null) {
                                    debug.text(16384L, (Object)className, "engineLoad", "label not empty");
                                }
                                boolean bl = false;
                                while (!bl) {
                                    if (debug != null) {
                                        debug.text(16384L, (Object)className, "engineLoad", "finding label");
                                    }
                                    if (this.entries.get((string = (String)object3 + "cert" + n2).toLowerCase()) == null) {
                                        this.entries.put(string.toLowerCase(), trustedCertEntry);
                                        if (debug != null) {
                                            System.out.println("PKCS11IMPLKS: put cert entry[" + string.toLowerCase() + "] to entries");
                                        }
                                        bl = true;
                                        continue;
                                    }
                                    ++n2;
                                }
                            }
                        } else {
                            boolean bl = false;
                            while (!bl) {
                                string = (String)object6 + n3;
                                if (!this.entries.containsKey(string.toLowerCase())) {
                                    this.entries.put(string.toLowerCase(), trustedCertEntry);
                                    if (debug != null) {
                                        System.out.println("PKCS11IMPLKS: put cert entry[" + string.toLowerCase() + "] to entries");
                                    }
                                    bl = true;
                                    continue;
                                }
                                ++n3;
                            }
                        }
                    }
                    ++n9;
                }
                vector.removeAllElements();
            }
            try {
                this.session.findObjectsFinal();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineLoad");
        }
    }

    private Object getValue(PKCS11Object pKCS11Object, int n) {
        Object object = null;
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            return null;
        }
        return object;
    }

    private Object[] getAttributes(PKCS11Object pKCS11Object) {
        return null;
    }

    private boolean bytesEquals(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void finalize() {
    }

    class TrustedCertEntry {
        Certificate cert;
        PKCS11Object certObject;

        TrustedCertEntry() {
        }
    }

    class SecretKeyEntry {
        Key key;
        PKCS11Object keyObject;

        SecretKeyEntry() {
        }
    }

    class PrivateKeyEntry {
        Key key;
        PKCS11Object keyObject;
        Certificate[] chain;

        PrivateKeyEntry() {
        }
    }
}

