/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPublicKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Date;

public final class DSAPublicKey
extends X509Key
implements PKCS11DSAPublicKey,
Serializable {
    private PKCS11Object object = null;
    static final long serialVersionUID = 4996119436080850303L;
    private Boolean isToken = null;
    private Boolean isPrivate = null;
    private String label = null;
    private Boolean isModifiable = null;
    private Integer keyType = PKCS11Object.DSA;
    private byte[] ID = null;
    private Date startDate = null;
    private Date endDate = null;
    private Boolean isDerive = null;
    private Boolean isLocal = null;
    private byte[] subject = null;
    private Boolean isEncrypt = null;
    private Boolean isVerify = null;
    private Boolean isVerifyRecover = null;
    private Boolean isWrap = null;
    private BigInteger prime = null;
    private BigInteger subprime = null;
    private BigInteger base = null;
    private BigInteger value = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DSAPublicKey";
    static /* synthetic */ Class class$java$security$spec$DSAParameterSpec;

    DSAPublicKey(PKCS11Object pKCS11Object, byte[] byArray, byte[] byArray2, String string, Boolean bl) throws InvalidKeyException {
        this.object = pKCS11Object;
        this.label = string != null ? string : (String)this.getAttrValue(this.object, 3);
        if (byArray != null) {
            this.ID = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.ID, 0, byArray.length);
        } else {
            this.ID = (byte[])this.getAttrValue(this.object, 258);
        }
        if (byArray2 != null) {
            this.subject = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.subject, 0, byArray2.length);
        } else {
            this.subject = (byte[])this.getAttrValue(this.object, 257);
        }
        this.isToken = bl != null ? new Boolean(bl) : (Boolean)this.getAttrValue(this.object, 1);
        this.isPrivate = (Boolean)this.getAttrValue(this.object, 2);
        this.isModifiable = (Boolean)this.getAttrValue(this.object, 368);
        this.startDate = (Date)this.getAttrValue(this.object, 272);
        this.endDate = (Date)this.getAttrValue(this.object, 273);
        this.isDerive = (Boolean)this.getAttrValue(this.object, 268);
        this.isLocal = (Boolean)this.getAttrValue(this.object, 355);
        this.isEncrypt = (Boolean)this.getAttrValue(this.object, 260);
        this.isVerifyRecover = (Boolean)this.getAttrValue(this.object, 267);
        this.isVerify = (Boolean)this.getAttrValue(this.object, 266);
        this.isWrap = (Boolean)this.getAttrValue(this.object, 262);
    }

    public DSAPublicKey(PKCS11Object pKCS11Object, byte[] byArray, byte[] byArray2, String string, Boolean bl, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        this(pKCS11Object, byArray, byArray2, string, bl);
        if (bigInteger != null) {
            this.prime = new BigInteger(bigInteger.toByteArray());
        }
        if (bigInteger2 != null) {
            this.subprime = new BigInteger(bigInteger2.toByteArray());
        }
        if (bigInteger3 != null) {
            this.base = new BigInteger(bigInteger3.toByteArray());
        }
        if (bigInteger4 != null) {
            this.value = new BigInteger(bigInteger4.toByteArray());
        }
        this.algid = new AlgIdDSA(bigInteger, bigInteger2, bigInteger3);
        if (this.value != null) {
            try {
                this.key = new DerValue(2, this.value.toByteArray()).toByteArray();
                this.encode();
            }
            catch (IOException iOException) {
                throw new InvalidKeyException("could not DER encode y: " + iOException.getMessage());
            }
        }
    }

    DSAPublicKey(byte[] byArray) throws InvalidKeyException {
        Object[] objectArray;
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DSAPublicKey", (Object)byArray);
        }
        this.decode(byArray);
        try {
            if (this.algid instanceof DSAParams) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "DSAPublicKey", (Object)this.algid);
                }
                object = (DSAParams)this.algid;
                this.prime = ((DSAParameterSpec)object).getP();
                this.subprime = ((DSAParameterSpec)object).getQ();
                this.base = ((DSAParameterSpec)object).getG();
            } else {
                objectArray = this.algid.getAlgParameters();
                if (objectArray == null) {
                    if (debug != null) {
                        debug.exit(16384L, (Object)className, "DSAPublicKey", null);
                    }
                    throw new InvalidKeyException("A key could not be create from encoding");
                }
                object = (DSAParameterSpec)objectArray.getParameterSpec(class$java$security$spec$DSAParameterSpec == null ? (class$java$security$spec$DSAParameterSpec = DSAPublicKey.class$("java.security.spec.DSAParameterSpec")) : class$java$security$spec$DSAParameterSpec);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "DSAPublicKey", object);
                }
                this.prime = ((DSAParameterSpec)object).getP();
                this.subprime = ((DSAParameterSpec)object).getQ();
                this.base = ((DSAParameterSpec)object).getG();
            }
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "DSAPublicKey", (Throwable)invalidParameterSpecException);
                debug.exit(16384L, (Object)className, "DSAPublicKey", null);
            }
            throw new InvalidKeyException(invalidParameterSpecException.getMessage());
        }
        this.label = this.genLabel();
        object = new int[]{0, 256, 3, 1, 266, 304, 305, 306, 17};
        objectArray = new Object[]{PKCS11Object.PUBLIC_KEY, PKCS11Object.DSA, this.label, Boolean.FALSE, Boolean.TRUE, this.prime, this.subprime, this.base, this.value.toByteArray()};
        PKCS11Session pKCS11Session = IBMPKCS11Impl.session;
        this.object = pKCS11Session.createObject((int[])object, objectArray);
        this.ID = (byte[])this.getAttrValue(this.object, 258);
        this.subject = (byte[])this.getAttrValue(this.object, 257);
        this.isToken = (Boolean)this.getAttrValue(this.object, 1);
        this.isPrivate = (Boolean)this.getAttrValue(this.object, 2);
        this.isModifiable = (Boolean)this.getAttrValue(this.object, 368);
        this.startDate = (Date)this.getAttrValue(this.object, 272);
        this.endDate = (Date)this.getAttrValue(this.object, 273);
        this.isDerive = (Boolean)this.getAttrValue(this.object, 268);
        this.isLocal = (Boolean)this.getAttrValue(this.object, 355);
        this.isEncrypt = (Boolean)this.getAttrValue(this.object, 260);
        this.isVerifyRecover = (Boolean)this.getAttrValue(this.object, 267);
        this.isVerify = (Boolean)this.getAttrValue(this.object, 266);
        this.isWrap = (Boolean)this.getAttrValue(this.object, 262);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DSAPublicKey");
        }
    }

    protected void parseKeyBits() throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "parseKeyBits");
        }
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.value = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "parseKeyBits", "Invalid key value");
            }
            throw new InvalidKeyException("Invalid key value\n" + iOException.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "parseKeyBits");
        }
    }

    public PKCS11Object getObject() {
        return this.object;
    }

    public Boolean getToken() {
        return new Boolean(this.isToken);
    }

    public Boolean getPrivate() {
        return new Boolean(this.isPrivate);
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getModifiable() {
        return new Boolean(this.isModifiable);
    }

    public Integer getKeyType() {
        return this.keyType;
    }

    public byte[] getID() {
        return (byte[])this.ID.clone();
    }

    public Date getStartDate() {
        return (Date)this.startDate.clone();
    }

    public Date getEndDate() {
        return (Date)this.endDate.clone();
    }

    public Boolean getDerive() {
        return new Boolean(this.isDerive);
    }

    public Boolean getLocal() {
        return new Boolean(this.isLocal);
    }

    public byte[] getSubject() {
        return (byte[])this.subject.clone();
    }

    public Boolean getEncrypt() {
        return new Boolean(this.isEncrypt);
    }

    public Boolean getVerify() {
        return new Boolean(this.isVerify);
    }

    public Boolean getVerifyRecover() {
        return new Boolean(this.isVerifyRecover);
    }

    public Boolean getWrap() {
        return new Boolean(this.isWrap);
    }

    public BigInteger getPrime() {
        return this.prime;
    }

    public BigInteger getSubprime() {
        return this.subprime;
    }

    public BigInteger getBase() {
        return this.base;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public BigInteger getY() {
        return this.value;
    }

    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)this.algid;
            }
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            if (algorithmParameters == null) {
                return null;
            }
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameters.getParameterSpec(class$java$security$spec$DSAParameterSpec == null ? (class$java$security$spec$DSAParameterSpec = DSAPublicKey.class$("java.security.spec.DSAParameterSpec")) : class$java$security$spec$DSAParameterSpec);
            return dSAParameterSpec;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    public String toString() {
        String string = "IBMPKCS11Impl";
        String string2 = string + " DSA Public Key: ";
        if (this.isToken != null) {
            string2 = string2 + "\n Token: " + this.isToken;
        }
        if (this.isPrivate != null) {
            string2 = string2 + "\n Private: " + this.isPrivate;
        }
        if (this.label != null) {
            string2 = string2 + "\n Label: " + this.label;
        }
        if (this.isModifiable != null) {
            string2 = string2 + "\n Modifiable: " + this.isModifiable;
        }
        string2 = string2 + "\n KeyType: " + this.keyType.toString();
        if (this.ID != null) {
            string2 = string2 + "\n ID: " + new String(this.ID);
        }
        if (this.startDate != null) {
            string2 = string2 + "\n Start Date: " + this.startDate.toString();
        }
        if (this.endDate != null) {
            string2 = string2 + "\n End Date: " + this.endDate.toString();
        }
        if (this.isDerive != null) {
            string2 = string2 + "\n Derive: " + this.isDerive;
        }
        if (this.isLocal != null) {
            string2 = string2 + "\n Local: " + this.isLocal;
        }
        if (this.subject != null) {
            string2 = string2 + "\n Subject: " + new String(this.subject);
        }
        if (this.isEncrypt != null) {
            string2 = string2 + "\n Encrypt: " + this.isEncrypt;
        }
        if (this.isVerify != null) {
            string2 = string2 + "\n Verify: " + this.isVerify;
        }
        if (this.isVerifyRecover != null) {
            string2 = string2 + "\n VerifyRecover: " + this.isVerifyRecover;
        }
        if (this.isWrap != null) {
            string2 = string2 + "\n Wrap: " + this.isWrap;
        }
        if (this.prime != null) {
            string2 = string2 + "\n prime: " + this.prime.toString();
        }
        if (this.subprime != null) {
            string2 = string2 + "\n subprime: " + this.subprime.toString();
        }
        if (this.base != null) {
            string2 = string2 + "\n base: " + this.base.toString();
        }
        if (this.value != null) {
            string2 = string2 + "\n value: " + this.value.toString();
        }
        return string2;
    }

    private Object getAttrValue(PKCS11Object pKCS11Object, int n) {
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pKCS11Object, (Object)new Integer(n));
        }
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", exception.getMessage());
            }
            object = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return object;
    }

    public String getFormat() {
        return "PKCS#11";
    }

    public String getAlgorithm() {
        return "DSA";
    }

    private String genLabel() {
        Serializable serializable;
        byte[] byArray = new byte[33];
        byte[] byArray2 = new byte[24];
        byte[] byArray3 = null;
        int n = 0;
        try {
            serializable = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
            ((SecureRandom)serializable).nextBytes(byArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializable = new BigInteger(1, byArray2);
        try {
            byArray3 = ((BigInteger)serializable).toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("Can not convert string");
        }
        n = ((BigInteger)serializable).toString().length();
        if (n > 24) {
            n = 24;
        }
        System.arraycopy(byArray3, 0, byArray, 9, n);
        byArray[0] = 73;
        byArray[1] = 66;
        byArray[2] = 77;
        byArray[3] = 80;
        byArray[4] = 75;
        byArray[5] = 67;
        byArray[6] = 83;
        byArray[7] = 49;
        byArray[8] = 49;
        String string = null;
        try {
            string = new String(byArray, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray);
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

