/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPrivateKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Date;

public final class DSAPrivateKey
extends PrivateKeyInfo
implements PKCS11DSAPrivateKey,
Serializable {
    private PKCS11Object object = null;
    static final long serialVersionUID = 5036993835514453788L;
    private Boolean isToken = null;
    private Boolean isPrivate = null;
    private String label = null;
    private Boolean isModifiable = null;
    private Integer keyType = PKCS11Object.DSA;
    private byte[] ID = null;
    private Date startDate = null;
    private Date endDate = null;
    private Boolean isDerive = null;
    private Boolean isLocal = null;
    private byte[] subject = null;
    private Boolean isSensitive = null;
    private Boolean isSecondaryAuth = null;
    private Integer authPinFlags = null;
    private Boolean isDecrypt = null;
    private Boolean isSign = null;
    private Boolean isSignRecover = null;
    private Boolean isUnwrap = null;
    private Boolean isExtractable = null;
    private Boolean isAlwaysSensitive = null;
    private Boolean isNeverExtractable = null;
    private BigInteger prime = null;
    private BigInteger subprime = null;
    private BigInteger base = null;
    private BigInteger value = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey";
    static /* synthetic */ Class class$java$security$spec$DSAParameterSpec;

    DSAPrivateKey(PKCS11Object pKCS11Object, String string, byte[] byArray, byte[] byArray2, Boolean bl, Boolean bl2, Boolean bl3) throws InvalidKeyException {
        this.object = pKCS11Object;
        this.label = string != null ? string : (String)this.getAttrValue(this.object, 3);
        if (byArray != null) {
            this.ID = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.ID, 0, byArray.length);
        } else {
            this.ID = (byte[])this.getAttrValue(this.object, 258);
        }
        if (byArray2 != null) {
            this.subject = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.subject, 0, byArray2.length);
        } else {
            this.subject = (byte[])this.getAttrValue(this.object, 257);
        }
        this.isToken = bl != null ? new Boolean(bl) : (Boolean)this.getAttrValue(this.object, 1);
        this.isSensitive = bl2 != null ? new Boolean(bl2) : (Boolean)this.getAttrValue(this.object, 259);
        this.isExtractable = bl3 != null ? new Boolean(bl3) : (Boolean)this.getAttrValue(this.object, 354);
        this.isPrivate = (Boolean)this.getAttrValue(this.object, 2);
        this.isModifiable = (Boolean)this.getAttrValue(this.object, 368);
        this.startDate = (Date)this.getAttrValue(this.object, 272);
        this.endDate = (Date)this.getAttrValue(this.object, 273);
        this.isDerive = (Boolean)this.getAttrValue(this.object, 268);
        this.isLocal = (Boolean)this.getAttrValue(this.object, 355);
        this.isSecondaryAuth = (Boolean)this.getAttrValue(this.object, 512);
        this.authPinFlags = (Integer)this.getAttrValue(this.object, 513);
        this.isDecrypt = (Boolean)this.getAttrValue(this.object, 261);
        this.isSign = (Boolean)this.getAttrValue(this.object, 264);
        this.isSignRecover = (Boolean)this.getAttrValue(this.object, 265);
        this.isUnwrap = (Boolean)this.getAttrValue(this.object, 263);
        this.isAlwaysSensitive = (Boolean)this.getAttrValue(this.object, 357);
        this.isNeverExtractable = (Boolean)this.getAttrValue(this.object, 356);
    }

    public DSAPrivateKey(PKCS11Object pKCS11Object, String string, byte[] byArray, byte[] byArray2, Boolean bl, Boolean bl2, Boolean bl3, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        this(pKCS11Object, string, byArray, byArray2, bl, bl2, bl3);
        if (bigInteger != null) {
            this.prime = new BigInteger(bigInteger.toByteArray());
        }
        if (bigInteger2 != null) {
            this.subprime = new BigInteger(bigInteger2.toByteArray());
        }
        if (bigInteger3 != null) {
            this.base = new BigInteger(bigInteger3.toByteArray());
        }
        if (bigInteger4 != null) {
            this.value = new BigInteger(bigInteger4.toByteArray());
        }
        this.algid = new AlgIdDSA(bigInteger, bigInteger2, bigInteger3);
        if (this.value != null) {
            try {
                this.key = new DerValue(2, this.value.toByteArray()).toByteArray();
                this.encode();
            }
            catch (IOException iOException) {
                throw new InvalidKeyException("could not DER encode x: " + iOException.getMessage());
            }
        }
    }

    public PKCS11Object getObject() {
        return this.object;
    }

    public Boolean getToken() {
        return new Boolean(this.isToken);
    }

    public Boolean getPrivate() {
        return new Boolean(this.isPrivate);
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getModifiable() {
        return new Boolean(this.isModifiable);
    }

    public Integer getKeyType() {
        return this.keyType;
    }

    public byte[] getID() {
        return (byte[])this.ID.clone();
    }

    public Date getStartDate() {
        return (Date)this.startDate.clone();
    }

    public Date getEndDate() {
        return (Date)this.endDate.clone();
    }

    public Boolean getDerive() {
        return new Boolean(this.isDerive);
    }

    public Boolean getLocal() {
        return new Boolean(this.isLocal);
    }

    public byte[] getSubject() {
        if (this.subject == null) {
            return null;
        }
        return (byte[])this.subject.clone();
    }

    public Boolean getSensitive() {
        return new Boolean(this.isSensitive);
    }

    public Boolean getSecondaryAuth() {
        return new Boolean(this.isSecondaryAuth);
    }

    public Integer getAuthPinFlags() {
        return this.authPinFlags;
    }

    public Boolean getDecrypt() {
        return new Boolean(this.isDecrypt);
    }

    public Boolean getSign() {
        return new Boolean(this.isSign);
    }

    public Boolean getSignRecover() {
        return new Boolean(this.isSignRecover);
    }

    public Boolean getUnwrap() {
        return new Boolean(this.isUnwrap);
    }

    public Boolean getExtractable() {
        return new Boolean(this.isExtractable);
    }

    public Boolean getAlwaysSensitive() {
        return new Boolean(this.isAlwaysSensitive);
    }

    public Boolean getNeverExtractable() {
        return new Boolean(this.isNeverExtractable);
    }

    public BigInteger getPrime() {
        return this.prime;
    }

    public BigInteger getSubprime() {
        return this.subprime;
    }

    public BigInteger getBase() {
        return this.base;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public BigInteger getX() {
        return this.value;
    }

    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)this.algid;
            }
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            if (algorithmParameters == null) {
                return null;
            }
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameters.getParameterSpec(class$java$security$spec$DSAParameterSpec == null ? (class$java$security$spec$DSAParameterSpec = DSAPrivateKey.class$("java.security.spec.DSAParameterSpec")) : class$java$security$spec$DSAParameterSpec);
            return dSAParameterSpec;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    public String toString() {
        String string = "IBMPKCS11Impl";
        String string2 = string + " DSA Private Key: ";
        if (this.isToken != null) {
            string2 = string2 + "\n Token: " + this.isToken;
        }
        if (this.isPrivate != null) {
            string2 = string2 + "\n Private: " + this.isPrivate;
        }
        if (this.label != null) {
            string2 = string2 + "\n Label: " + this.label;
        }
        if (this.isModifiable != null) {
            string2 = string2 + "\n Modifiable: " + this.isModifiable;
        }
        string2 = string2 + "\n KeyType: " + this.keyType.toString();
        if (this.ID != null) {
            string2 = string2 + "\n ID: " + new String(this.ID);
        }
        if (this.startDate != null) {
            string2 = string2 + "\n Start Date: " + this.startDate.toString();
        }
        if (this.endDate != null) {
            string2 = string2 + "\n End Date: " + this.endDate.toString();
        }
        if (this.isDerive != null) {
            string2 = string2 + "\n Derive: " + this.isDerive;
        }
        if (this.isLocal != null) {
            string2 = string2 + "\n Local: " + this.isLocal;
        }
        if (this.subject != null) {
            string2 = string2 + "\n Subject: " + new String(this.subject);
        }
        if (this.isSensitive != null) {
            string2 = string2 + "\n Sensitive: " + this.isSensitive;
        }
        if (this.isSecondaryAuth != null) {
            string2 = string2 + "\n SecondaryAuth: " + this.isSecondaryAuth;
        }
        if (this.authPinFlags != null) {
            string2 = string2 + "\n AuthPinFlags: " + Integer.toBinaryString(this.authPinFlags);
        }
        if (this.isDecrypt != null) {
            string2 = string2 + "\n Decrypt: " + this.isDecrypt;
        }
        if (this.isSign != null) {
            string2 = string2 + "\n sign: " + this.isSign;
        }
        if (this.isSignRecover != null) {
            string2 = string2 + "\n SignRecover: " + this.isSignRecover;
        }
        if (this.isExtractable != null) {
            string2 = string2 + "\n Extractable: " + this.isExtractable;
        }
        if (this.isAlwaysSensitive != null) {
            string2 = string2 + "\n Always Sensitive: " + this.isAlwaysSensitive;
        }
        if (this.isNeverExtractable != null) {
            string2 = string2 + "\n Never Sensitive: " + this.isNeverExtractable;
        }
        if (this.prime != null) {
            string2 = string2 + "\n prime: " + this.prime.toString();
        }
        if (this.subprime != null) {
            string2 = string2 + "\n subprime: " + this.subprime.toString();
        }
        if (this.base != null) {
            string2 = string2 + "\n base: " + this.base.toString();
        }
        if (this.value != null) {
            string2 = string2 + "\n value: " + this.value.toString();
        }
        return string2;
    }

    public String getFormat() {
        return "PKCS#11";
    }

    public String getAlgorithm() {
        return "DSA";
    }

    private Object getAttrValue(PKCS11Object pKCS11Object, int n) {
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pKCS11Object, (Object)new Integer(n));
        }
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", exception.getMessage());
            }
            object = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

