/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DSAParameterGenerator;
import com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAKeyPairParameterSpec;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class DSAPKCS11KeyPairGenerator
extends KeyPairGeneratorSpi {
    private int keySize = 512;
    private PKCS11Session session = null;
    private byte[] id = null;
    private byte[] subject = null;
    private String label = null;
    private Boolean isToken = new Boolean(false);
    private Boolean isSensitive = new Boolean(false);
    private Boolean extractable = null;
    private DSAParameterSpec dsaparams = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DSAPKCS11KeyPairGenerator";
    static /* synthetic */ Class class$java$security$spec$DSAParameterSpec;

    public DSAPKCS11KeyPairGenerator() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DSAPKCS11KeyPairGenerator");
        }
        this.session = IBMPKCS11Impl.session;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DSAPKCS11KeyPairGenerator");
        }
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)algorithmParameterSpec, (Object)secureRandom);
        }
        if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PKCS11DSAKeyPairParameterSpec)) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "initialize", "PKCS11 DSA KeyPair Parameters must be specified");
            }
            throw new InvalidAlgorithmParameterException("PKCS11 DSA KeyPair Parameters must be specified");
        }
        PKCS11DSAKeyPairParameterSpec pKCS11DSAKeyPairParameterSpec = (PKCS11DSAKeyPairParameterSpec)algorithmParameterSpec;
        this.keySize = pKCS11DSAKeyPairParameterSpec.getKeySize();
        if (pKCS11DSAKeyPairParameterSpec.getKeyID() != null) {
            try {
                this.id = pKCS11DSAKeyPairParameterSpec.getKeyID().getBytes("8859_1");
            }
            catch (Exception exception) {
                this.id = pKCS11DSAKeyPairParameterSpec.getKeyID().getBytes();
            }
        }
        if (pKCS11DSAKeyPairParameterSpec.getSubject() != null) {
            try {
                this.subject = pKCS11DSAKeyPairParameterSpec.getSubject().getBytes("8859_1");
            }
            catch (Exception exception) {
                this.subject = pKCS11DSAKeyPairParameterSpec.getSubject().getBytes();
            }
        }
        this.label = pKCS11DSAKeyPairParameterSpec.getLabel();
        this.isSensitive = pKCS11DSAKeyPairParameterSpec.getSensitive();
        this.isToken = pKCS11DSAKeyPairParameterSpec.getToken();
        this.extractable = pKCS11DSAKeyPairParameterSpec.getExtractable();
        this.dsaparams = (DSAParameterSpec)pKCS11DSAKeyPairParameterSpec.getParams();
        if (this.dsaparams == null) {
            this.generateParameters();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "initialize");
        }
    }

    public void initialize(int n, SecureRandom secureRandom) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)(" " + n), (Object)secureRandom);
            debug.exit(16384L, (Object)className, "initialize");
        }
        throw new UnsupportedOperationException("Parameters must be specified");
    }

    public void initialize(int n) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)(" " + n));
            debug.exit(16384L, (Object)className, "initialize");
        }
        throw new UnsupportedOperationException("Parameters must be specified");
    }

    public KeyPair generateKeyPair() {
        KeyPair keyPair;
        block19: {
            if (debug != null) {
                debug.entry(16384L, (Object)className, "generateKeyPair");
            }
            PKCS11Object[] pKCS11ObjectArray = null;
            keyPair = null;
            DSAPublicKey dSAPublicKey = null;
            DSAPrivateKey dSAPrivateKey = null;
            int n = 8;
            int n2 = 7;
            int n3 = 0;
            if (this.dsaparams == null) {
                this.generateParameters();
            }
            if (this.isSensitive == null) {
                --n2;
            }
            if (this.isToken == null) {
                --n2;
                --n;
            }
            if (this.extractable == null) {
                --n2;
            }
            int[] nArray = new int[n];
            Object[] objectArray = new Object[n];
            if (this.isToken != null) {
                nArray[n3] = 1;
                objectArray[n3++] = this.isToken;
            }
            nArray[n3] = 258;
            objectArray[n3++] = this.id;
            nArray[n3] = 257;
            objectArray[n3++] = this.subject;
            nArray[n3] = 3;
            objectArray[n3++] = this.label;
            nArray[n3] = 266;
            objectArray[n3++] = Boolean.TRUE;
            nArray[n3] = 304;
            objectArray[n3++] = this.dsaparams.getP();
            nArray[n3] = 305;
            objectArray[n3++] = this.dsaparams.getQ();
            nArray[n3] = 306;
            objectArray[n3] = this.dsaparams.getG();
            int[] nArray2 = new int[n2];
            Object[] objectArray2 = new Object[n2];
            n3 = 0;
            if (this.isToken != null) {
                nArray2[n3] = 1;
                objectArray2[n3++] = this.isToken;
            }
            nArray2[n3] = 258;
            objectArray2[n3++] = this.id;
            nArray2[n3] = 257;
            objectArray2[n3++] = this.subject;
            nArray2[n3] = 3;
            objectArray2[n3++] = this.label;
            nArray2[n3] = 264;
            objectArray2[n3++] = Boolean.TRUE;
            if (this.isSensitive != null) {
                nArray2[n3] = 259;
                objectArray2[n3++] = this.isSensitive;
            }
            if (this.extractable != null) {
                nArray2[n3] = 354;
                objectArray2[n3] = this.extractable;
            }
            try {
                pKCS11ObjectArray = this.session.generateKeyPair(16, null, nArray, objectArray, nArray2, objectArray2);
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "generateKeyPair_1", (Throwable)exception);
                }
                throw new RuntimeException(exception.getMessage());
            }
            PKCS11Object[] pKCS11ObjectArray2 = this.orderObjects(pKCS11ObjectArray);
            PKCS11Object pKCS11Object = pKCS11ObjectArray2[0];
            PKCS11Object pKCS11Object2 = pKCS11ObjectArray2[1];
            try {
                dSAPublicKey = new DSAPublicKey(pKCS11Object, this.id, this.subject, this.label, this.isToken, (BigInteger)this.getValue(pKCS11Object, 304), (BigInteger)this.getValue(pKCS11Object, 305), (BigInteger)this.getValue(pKCS11Object, 306), new BigInteger(1, (byte[])this.getValue(pKCS11Object, 17)));
                if (this.isSensitive.booleanValue()) {
                    dSAPrivateKey = new DSAPrivateKey(pKCS11Object2, this.label, this.id, this.subject, this.isToken, this.isSensitive, this.extractable);
                } else {
                    try {
                        dSAPrivateKey = new DSAPrivateKey(pKCS11Object2, this.label, this.id, this.subject, this.isToken, this.isSensitive, this.extractable, (BigInteger)this.getValue(pKCS11Object2, 304), (BigInteger)this.getValue(pKCS11Object2, 305), (BigInteger)this.getValue(pKCS11Object2, 306), new BigInteger(1, (byte[])this.getValue(pKCS11Object2, 17)));
                    }
                    catch (Exception exception) {
                        dSAPrivateKey = new DSAPrivateKey(pKCS11Object2, this.label, this.id, this.subject, this.isToken, this.isSensitive, this.extractable);
                    }
                }
                keyPair = new KeyPair(dSAPublicKey, dSAPrivateKey);
            }
            catch (Exception exception) {
                keyPair = null;
                if (debug == null) break block19;
                debug.exception(16384L, (Object)className, "generateKeyPair_2", (Throwable)exception);
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "generateKeyPair");
        }
        return keyPair;
    }

    private void generateParameters() {
        SecureRandom secureRandom;
        AlgorithmParameterGenerator algorithmParameterGenerator;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "generateParameters");
        }
        switch (this.keySize) {
            case 512: {
                this.dsaparams = new DSAParameterSpec(DSAParameterGenerator.p_512, DSAParameterGenerator.q_512, DSAParameterGenerator.g_512);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "generateParameters", (Object)this.dsaparams);
                }
                return;
            }
            case 768: {
                this.dsaparams = new DSAParameterSpec(DSAParameterGenerator.p_768, DSAParameterGenerator.q_768, DSAParameterGenerator.g_768);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "generateParameters", (Object)this.dsaparams);
                }
                return;
            }
            case 1024: {
                this.dsaparams = new DSAParameterSpec(DSAParameterGenerator.p_1024, DSAParameterGenerator.q_1024, DSAParameterGenerator.g_1024);
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "generateParameters", (Object)this.dsaparams);
                }
                return;
            }
        }
        try {
            algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("DSA", "IBMPKCS11Impl");
            secureRandom = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateParameters_1", (Throwable)noSuchAlgorithmException);
            }
            throw new RuntimeException(noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateParameters_2", (Throwable)noSuchProviderException);
            }
            throw new RuntimeException(noSuchProviderException.getMessage());
        }
        algorithmParameterGenerator.init(this.keySize, secureRandom);
        AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
        try {
            this.dsaparams = (DSAParameterSpec)algorithmParameters.getParameterSpec(class$java$security$spec$DSAParameterSpec == null ? (class$java$security$spec$DSAParameterSpec = DSAPKCS11KeyPairGenerator.class$("java.security.spec.DSAParameterSpec")) : class$java$security$spec$DSAParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateParameters_3", (Throwable)invalidParameterSpecException);
            }
            throw new Error();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "generateParameters");
        }
    }

    private PKCS11Object[] orderObjects(PKCS11Object[] pKCS11ObjectArray) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "orderObjects");
        }
        Integer n = (Integer)this.getValue(pKCS11ObjectArray[0], 0);
        Integer n2 = (Integer)this.getValue(pKCS11ObjectArray[1], 0);
        PKCS11Object pKCS11Object = null;
        PKCS11Object pKCS11Object2 = null;
        if (n.equals(PKCS11Object.PUBLIC_KEY) && n2.equals(PKCS11Object.PRIVATE_KEY)) {
            pKCS11Object2 = pKCS11ObjectArray[0];
            pKCS11Object = pKCS11ObjectArray[1];
        } else if (n.equals(PKCS11Object.PRIVATE_KEY) && n2.equals(PKCS11Object.PUBLIC_KEY)) {
            pKCS11Object2 = pKCS11ObjectArray[1];
            pKCS11Object = pKCS11ObjectArray[0];
        } else {
            if (debug != null) {
                debug.text(16384L, (Object)className, "orderObjects", "Token returns invalid objects");
            }
            throw new RuntimeException("Token returns invalid objects");
        }
        pKCS11ObjectArray[0] = pKCS11Object2;
        pKCS11ObjectArray[1] = pKCS11Object;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "orderObjects");
        }
        return pKCS11ObjectArray;
    }

    private Object getValue(PKCS11Object pKCS11Object, int n) {
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pKCS11Object, (Object)new Integer(n));
        }
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", exception.getMessage());
            }
            object = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

