/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DESKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKeyParameterSpec;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public final class DESPKCS11KeyGenerator
extends KeyGeneratorSpi {
    private Integer keyType = PKCS11Object.DES;
    private PKCS11Session session = null;
    private byte[] id = null;
    private String label = null;
    private Boolean isToken = new Boolean(false);
    private Boolean isSensitive = new Boolean(false);
    private Boolean encrypt = new Boolean(true);
    private Boolean wrapping = new Boolean(true);
    private Boolean extractable = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DESPKCS11KeyGenerator";

    public DESPKCS11KeyGenerator() {
        IBMPKCS11Impl.verifyJceJar();
        this.session = IBMPKCS11Impl.session;
    }

    protected void engineInit(SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Parameters must be specified");
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PKCS11SecretKeyParameterSpec)) {
            throw new InvalidAlgorithmParameterException("PKCS11 Secret Key Parameters must be specified");
        }
        PKCS11SecretKeyParameterSpec pKCS11SecretKeyParameterSpec = (PKCS11SecretKeyParameterSpec)algorithmParameterSpec;
        if (pKCS11SecretKeyParameterSpec.getKeyType().equals(PKCS11Object.DES)) {
            try {
                this.id = pKCS11SecretKeyParameterSpec.getKeyID().getBytes("8859_1");
            }
            catch (Exception exception) {
                this.id = pKCS11SecretKeyParameterSpec.getKeyID().getBytes();
            }
        } else {
            throw new InvalidAlgorithmParameterException("The Secret Key type must be DES.");
        }
        this.label = pKCS11SecretKeyParameterSpec.getLabel();
        this.isToken = pKCS11SecretKeyParameterSpec.getToken();
        this.isSensitive = pKCS11SecretKeyParameterSpec.getSensitive();
        this.encrypt = pKCS11SecretKeyParameterSpec.getEncrypt();
        this.wrapping = pKCS11SecretKeyParameterSpec.getWrap();
        this.extractable = pKCS11SecretKeyParameterSpec.getExtractable();
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Parameters must be specified");
    }

    protected SecretKey engineGenerateKey() {
        DESKey dESKey;
        block20: {
            dESKey = null;
            PKCS11Object pKCS11Object = null;
            int n = 9;
            int n2 = 0;
            if (this.id == null) {
                --n;
            }
            if (this.label == null) {
                --n;
            }
            if (this.isToken == null) {
                --n;
            }
            if (this.isSensitive == null) {
                --n;
            }
            if (this.encrypt == null) {
                --n;
                --n;
            }
            if (this.wrapping == null) {
                --n;
                --n;
            }
            if (this.extractable == null) {
                --n;
            }
            int[] nArray = new int[n];
            Object[] objectArray = new Object[n];
            if (this.id != null) {
                nArray[n2] = 258;
                objectArray[n2++] = this.id;
            }
            if (this.label != null) {
                nArray[n2] = 3;
                objectArray[n2++] = this.label;
            }
            if (this.isToken != null) {
                nArray[n2] = 1;
                objectArray[n2++] = this.isToken;
            }
            if (this.isSensitive != null) {
                nArray[n2] = 259;
                objectArray[n2++] = this.isSensitive;
            }
            if (this.encrypt != null) {
                nArray[n2] = 260;
                objectArray[n2++] = this.encrypt;
                nArray[n2] = 261;
                objectArray[n2++] = new Boolean(this.encrypt);
            }
            if (this.wrapping != null) {
                nArray[n2] = 262;
                objectArray[n2++] = this.wrapping;
                nArray[n2] = 263;
                objectArray[n2++] = new Boolean(this.wrapping);
            }
            if (this.extractable != null) {
                nArray[n2] = 354;
                objectArray[n2++] = this.extractable;
            }
            try {
                pKCS11Object = this.session.generateKey(288, null, nArray, objectArray);
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineGenerateKey_1", (Throwable)exception);
                }
                throw new RuntimeException(exception.getMessage());
            }
            try {
                if (this.isSensitive != null && this.isSensitive.booleanValue()) {
                    dESKey = new DESKey(pKCS11Object, this.id, this.label, this.isToken, this.isSensitive, this.encrypt, this.wrapping, this.extractable);
                    break block20;
                }
                dESKey = new DESKey(pKCS11Object, this.id, this.label, this.isToken, this.isSensitive, this.encrypt, this.wrapping, this.extractable, (byte[])this.getValue(pKCS11Object, 17));
            }
            catch (Exception exception) {
                dESKey = null;
            }
        }
        return dESKey;
    }

    private Object getValue(PKCS11Object pKCS11Object, int n) {
        Object object;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pKCS11Object, (Object)new Integer(n));
        }
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", exception.getMessage());
            }
            object = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return object;
    }
}

