/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.PKCS11KeySpec;
import com.ibm.pkcs11.PKCS11Object;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

final class ConstructKeys {
    ConstructKeys() {
    }

    static final Object[] constructPublicKeyAttrs(String string) {
        Object[] objectArray = new Object[2];
        if (string.equalsIgnoreCase("DSA")) {
            int[] nArray = new int[]{0, 256, 266};
            Object[] objectArray2 = new Object[]{PKCS11Object.PUBLIC_KEY, PKCS11Object.DSA, Boolean.TRUE};
            objectArray[0] = nArray;
            objectArray[1] = objectArray2;
        } else if (string.equalsIgnoreCase("RSA")) {
            int[] nArray = new int[]{0, 256, 266, 260, 262};
            Object[] objectArray3 = new Object[]{PKCS11Object.PUBLIC_KEY, PKCS11Object.RSA, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE};
            objectArray[0] = nArray;
            objectArray[1] = objectArray3;
        }
        return objectArray;
    }

    static final PublicKey constructPublicKey(PKCS11Object pKCS11Object, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        PublicKey publicKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string, "IBMPKCS11Impl");
            PKCS11KeySpec pKCS11KeySpec = new PKCS11KeySpec(pKCS11Object);
            publicKey = keyFactory.generatePublic(pKCS11KeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("The IBMPKCS11Impl providers can not create keys for the " + string + "algorithm");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
        }
        return publicKey;
    }

    static final Object[] constructPrivateKeyAttrs(String string) {
        Object[] objectArray = new Object[2];
        if (string.equalsIgnoreCase("DSA")) {
            int[] nArray = new int[]{0, 256, 264};
            Object[] objectArray2 = new Object[]{PKCS11Object.PRIVATE_KEY, PKCS11Object.DSA, Boolean.TRUE};
            objectArray[0] = nArray;
            objectArray[1] = objectArray2;
        } else if (string.equalsIgnoreCase("RSA")) {
            int[] nArray = new int[]{0, 256, 264, 261, 263};
            Object[] objectArray3 = new Object[]{PKCS11Object.PRIVATE_KEY, PKCS11Object.RSA, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE};
            objectArray[0] = nArray;
            objectArray[1] = objectArray3;
        }
        return objectArray;
    }

    static final PrivateKey constructPrivateKey(PKCS11Object pKCS11Object, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        PrivateKey privateKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(string, "IBMPKCS11Impl");
            PKCS11KeySpec pKCS11KeySpec = new PKCS11KeySpec(pKCS11Object);
            return keyFactory.generatePrivate(pKCS11KeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("The IBMPKCS11Impl providers can not create keys for the " + string + "algorithm");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
        }
        return privateKey;
    }

    static final Object[] constructSecretKeyAttrs(String string) {
        Object[] objectArray = new Object[2];
        if (string.equalsIgnoreCase("DES")) {
            int[] nArray = new int[]{0, 256, 260, 261, 262, 263};
            Object[] objectArray2 = new Object[]{PKCS11Object.SECRET_KEY, PKCS11Object.DES, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE};
            objectArray[0] = nArray;
            objectArray[1] = objectArray2;
        } else if (string.equalsIgnoreCase("3DES") || string.equalsIgnoreCase("DESede") || string.equalsIgnoreCase("TripleDES")) {
            int[] nArray = new int[]{0, 256, 260, 261, 262, 263};
            Object[] objectArray3 = new Object[]{PKCS11Object.SECRET_KEY, PKCS11Object.DES3, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE};
            objectArray[0] = nArray;
            objectArray[1] = objectArray3;
        }
        return objectArray;
    }

    static final SecretKey constructSecretKey(PKCS11Object pKCS11Object, String string) throws InvalidKeyException, NoSuchAlgorithmException {
        SecretKey secretKey = null;
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, "IBMPKCS11Impl");
            PKCS11KeySpec pKCS11KeySpec = new PKCS11KeySpec(pKCS11Object);
            return secretKeyFactory.generateSecret(pKCS11KeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("The IBMPKCS11Impl providers can not create keys for the " + string + "algorithm");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            invalidKeySpecException.printStackTrace();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace();
        }
        return secretKey;
    }
}

