/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.util.PortConflictResolverException;
import com.ibm.ws.management.util.PortConflictResolverNoTrace;
import java.io.File;

public class PortConflictResolver
extends PortConflictResolverNoTrace {
    private static TraceComponent tc = Tr.register((Class)PortConflictResolver.class, (String)"Admin", null);

    public PortConflictResolver() throws PortConflictResolverException {
    }

    public PortConflictResolver(String[] stringArray) throws PortConflictResolverException {
        super(stringArray);
    }

    public synchronized int getPort(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getPort " + n));
        }
        int n2 = super.getPort(n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getPort " + n2));
        }
        return n2;
    }

    protected boolean reservePortInternal(String string) {
        boolean bl = super.reservePortInternal(string);
        if (tc.isDebugEnabled()) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)(string + " successfully reserved."));
            } else {
                Tr.debug((TraceComponent)tc, (String)(string + " already in use"));
            }
        }
        return bl;
    }

    public boolean unreservePort(int n) {
        boolean bl = super.unreservePort(n);
        if (tc.isDebugEnabled()) {
            String string = Integer.toString(n);
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)(string + " successfully unreserved."));
            } else {
                Tr.debug((TraceComponent)tc, (String)(string + " was not previously reserved."));
            }
        }
        return bl;
    }

    protected void readPortsFromAllConfigRoots() throws PortConflictResolverException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Reading ports from", (Object)this.getConfigRoots());
        }
        super.readPortsFromAllConfigRoots();
    }

    protected void readPortsFromConfigRoot(String string) throws PortConflictResolverException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readPortsFromConfigRoot", (Object)string);
        }
        super.readPortsFromConfigRoot(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readPortsFromConfigRoot");
        }
    }

    protected void readPorts(String string, String string2, String[] stringArray) throws PortConflictResolverException {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[ ");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i + 1 >= stringArray.length) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" ]");
            Tr.entry((TraceComponent)tc, (String)"readPorts", (Object)new String[]{string, string2, stringBuffer.toString()});
        }
        super.readPorts(string, string2, stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readPorts");
        }
    }

    protected void parseServerIndex(File file) throws PortConflictResolverException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseServerIndex", (Object)file);
        }
        super.parseServerIndex(file);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseServerIndex");
        }
    }
}

