/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.status;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.status.AbstractStatusReport;
import com.ibm.ws.management.status.ExecutionState;
import com.ibm.ws.management.status.NodeAgentStatusReport;
import com.ibm.ws.management.status.StatusReport;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DeploymentManagerStatusReport
extends AbstractStatusReport
implements Serializable {
    private static final long serialVersionUID = 31678516957423592L;
    protected Map node_states;
    protected Map node_reports;
    protected Map cluster_states;
    protected static final TraceComponent tc = Tr.register((String)DeploymentManagerStatusReport.class.getName(), null, null);

    public DeploymentManagerStatusReport(Map map, Map map2, Map map3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"DeploymentManagerStatusReport", (Object)new Object[]{map, map2, map3});
        }
        this.type = 2;
        this.node_states = new Hashtable(map);
        this.node_reports = new Hashtable(map2);
        this.cluster_states = new Hashtable(map3);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Building list of backlevel nodes for use by app_state", (Object)map);
        }
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Node: ", (Object)string);
            }
            String string2 = ExecutionState.transition((String)entry.getValue());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"State for Node: ", (Object)string2);
            }
            Object v = map2.get(string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Report for Node: ", v);
            }
            if (!"ExecutionState.STARTED".equals(string2) || v != null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Node: " + string + " + is backlevel"));
            }
            this.node_states.put(entry.getKey(), "BACK_LEVEL");
            this._back_level_nodes.add(entry.getKey());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"DeploymentManagerStatusReport", (Object)new Object[]{this.timestamp});
        }
    }

    public String getClusterState(String string) {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getClusterState", (Object)new Object[]{string});
        }
        if ("ExecutionState.UNKNOWN".equals(string2 = ExecutionState.transition((String)this.cluster_states.get(string)))) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getClusterState", (Object)"ExecutionState.UNAVAILABLE");
            }
            return "ExecutionState.UNAVAILABLE";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getClusterState", (Object)string2);
        }
        return string2;
    }

    public String getApplicationState(String string, String string2, String string3) {
        String string4;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getApplicationState", (Object)new Object[]{string, string2, string3});
        }
        if ("BACK_LEVEL".equals(string4 = ExecutionState.transition((String)this.node_states.get(string2)))) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Node is backlevel", (Object)string2);
            }
            StringBuffer stringBuffer = new StringBuffer("WebSphere:type=Application");
            stringBuffer.append(",name=");
            stringBuffer.append(string);
            stringBuffer.append(",node=");
            stringBuffer.append(string2);
            stringBuffer.append(",process=");
            stringBuffer.append(string3);
            stringBuffer.append(",*");
            ObjectName objectName = this.getMBean(stringBuffer.toString());
            if (objectName != null) {
                return "ExecutionState.STARTED";
            }
            return "ExecutionState.STOPPED";
        }
        NodeAgentStatusReport nodeAgentStatusReport = (NodeAgentStatusReport)this.node_reports.get(string2);
        if (nodeAgentStatusReport == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getApplicationState", (Object)new Object[]{"ExecutionState.UNAVAILABLE"});
            }
            return "ExecutionState.UNAVAILABLE";
        }
        String string5 = nodeAgentStatusReport.getApplicationState(string, string2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getApplicationState", (Object)new Object[]{string5});
        }
        return string5;
    }

    public String getMessageListenerState(String string, String string2, String string3) {
        String string4;
        block11: {
            String string5;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getMessageListenerState", (Object)new Object[]{string, string2, string3});
            }
            if ("BACK_LEVEL".equals(string5 = ExecutionState.transition((String)this.node_states.get(string2)))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Node is backlevel", (Object)string2);
                }
                StringBuffer stringBuffer = new StringBuffer("WebSphere:type=ListenerPort,node=");
                stringBuffer.append(string2);
                stringBuffer.append(",name=");
                stringBuffer.append(string);
                stringBuffer.append(",process=");
                stringBuffer.append(string3);
                stringBuffer.append(",*");
                ObjectName objectName = this.getMBean(stringBuffer.toString());
                if (objectName != null) {
                    return "ExecutionState.STARTED";
                }
                return "ExecutionState.STOPPED";
            }
            NodeAgentStatusReport nodeAgentStatusReport = (NodeAgentStatusReport)this.node_reports.get(string2);
            if (nodeAgentStatusReport == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getMessageListenerState", (Object)new Object[]{"ExecutionState.UNAVAILABLE"});
                }
                return "ExecutionState.UNAVAILABLE";
            }
            string4 = null;
            try {
                string4 = nodeAgentStatusReport.getMessageListenerState(string, string2, string3);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.status.DeploymentManagerStatusReport.getMessageListenerState", (String)"176", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception was thrown found", (Object)exception);
                }
            }
            catch (Error error) {
                FFDCFilter.processException((Throwable)error, (String)"com.ibm.ws.management.status.DeploymentManagerStatusReport.getMessageListenerState", (String)"181", (Object)this);
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug((TraceComponent)tc, (String)"Error occured", (Object)error);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMessageListenerState", (Object)new Object[]{string4});
        }
        return string4;
    }

    public String getServerType(String string, String string2) {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerType", (Object)new Object[]{string, string2});
        }
        if ("BACK_LEVEL".equals(string3 = ExecutionState.transition((String)this.node_states.get(string)))) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Back Level node - returning  " + string3), (Object)string);
            }
            return string3;
        }
        NodeAgentStatusReport nodeAgentStatusReport = (NodeAgentStatusReport)this.node_reports.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"NodeAgentStatusReport", (Object)nodeAgentStatusReport);
        }
        if (nodeAgentStatusReport == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getServerType", null);
            }
            return null;
        }
        String string4 = nodeAgentStatusReport.getServerType(string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerType", (Object)string4);
        }
        return string4;
    }

    public String getServerState(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerState", (Object)new Object[]{string, string2});
        }
        if (string2.equals("nodeagent")) {
            return this.getNodeState(string);
        }
        String string3 = ExecutionState.transition((String)this.node_states.get(string));
        if ("BACK_LEVEL".equals(string3)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Node is backlevel", (Object)string);
            }
            StringBuffer stringBuffer = new StringBuffer("WebSphere:type=Server");
            stringBuffer.append(",process=" + string2);
            stringBuffer.append(",node=" + string);
            stringBuffer.append(",*");
            ObjectName objectName = this.getMBean(stringBuffer.toString());
            Tr.debug((TraceComponent)tc, (String)"ServerON", (Object)objectName);
            if (objectName != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getServerState", (Object)new Object[]{"ExecutionState.STARTED"});
                }
                return "ExecutionState.STARTED";
            }
            String string4 = this.getNodeState(string);
            if ("ExecutionState.STARTED".equals(string4)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getServerState", (Object)new Object[]{"ExecutionState.STOPPED"});
                }
                return "ExecutionState.STOPPED";
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getServerState", (Object)new Object[]{"ExecutionState.UNAVAILABLE"});
            }
            return "ExecutionState.UNAVAILABLE";
        }
        NodeAgentStatusReport nodeAgentStatusReport = (NodeAgentStatusReport)this.node_reports.get(string);
        if (nodeAgentStatusReport == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getServerState", (Object)new Object[]{"ExecutionState.UNAVAILABLE"});
            }
            return "ExecutionState.UNAVAILABLE";
        }
        String string5 = nodeAgentStatusReport.getServerState(string, string2);
        if (string5 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getServerState", (Object)new Object[]{"ExecutionState.STOPPED"});
            }
            return "ExecutionState.STOPPED";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerState", (Object)new Object[]{string3});
        }
        return string5;
    }

    public String print() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Deployment Manager: ");
        stringBuffer.append("\n");
        stringBuffer.append("---------------------\n");
        Set set = this.cluster_states.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            stringBuffer.append("App: ");
            stringBuffer.append(object.getKey());
            stringBuffer.append("\nState: ");
            stringBuffer.append(object.getValue());
            stringBuffer.append("\n");
            stringBuffer.append("\n");
        }
        object = this.node_states.entrySet();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator2.next();
            stringBuffer.append("\nNode: ");
            stringBuffer.append(entry.getKey());
            stringBuffer.append("\nState: ");
            stringBuffer.append(entry.getValue());
            stringBuffer.append("\nReport: ");
            stringBuffer.append(this.node_reports.get(entry.getKey()));
            if (this.node_reports.get(entry.getKey()) != null) {
                stringBuffer.append(((StatusReport)this.node_reports.get(entry.getKey())).print());
            }
            stringBuffer.append("\n");
            stringBuffer.append("\n");
        }
        stringBuffer.append("END OF DUMP");
        return stringBuffer.toString();
    }

    public String getNodeState(String string) {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNodeState", (Object)new Object[]{string});
        }
        if ("BACK_LEVEL".equals(string2 = ExecutionState.transition((String)this.node_states.get(string)))) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Node is backlevel", (Object)string);
            }
            StringBuffer stringBuffer = new StringBuffer("WebSphere:type=Server");
            stringBuffer.append(",process=nodeagent");
            stringBuffer.append(",node=" + string);
            stringBuffer.append(",*");
            ObjectName objectName = this.getMBean(stringBuffer.toString());
            if (objectName != null) {
                return "ExecutionState.STARTED";
            }
            return "ExecutionState.STOPPED";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getNodeState", (Object)new Object[]{string2});
        }
        return string2;
    }

    public String[] getNodes() {
        String[] stringArray = this.node_states.keySet().toArray(new String[0]);
        return stringArray;
    }

    public String[] getServers(String string) {
        NodeAgentStatusReport nodeAgentStatusReport = (NodeAgentStatusReport)this.node_reports.get(string);
        return nodeAgentStatusReport.getServers(string);
    }

    public ObjectName getMBean(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMBean", (Object)new Object[]{string});
        }
        try {
            ObjectName objectName = new ObjectName(string);
            Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
            if (iterator.hasNext()) {
                ObjectName objectName2 = (ObjectName)iterator.next();
                if (iterator.hasNext() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Multiple MBeans found when only one was expected");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getMBean", (Object)new Object[]{objectName2});
                }
                return objectName2;
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.ws.management.status.DeploymentManagerStatusReport.getMBean", (String)"371", (Object)this);
            Tr.error((TraceComponent)tc, (String)("Invalid MBean filter passed to getMBean: " + string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMBean - null");
        }
        return null;
    }
}

